/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.selfmodification;

import de.geolykt.starloader.deobf.access.AccessTransformInfo;
import de.geolykt.starloader.deobf.access.AccessWidenerReader;
import de.geolykt.starloader.launcher.Utils;
import de.geolykt.starloader.transformers.ASMTransformer;
import de.geolykt.starloader.transformers.RawClassData;
import de.geolykt.starloader.transformers.TransformableClassloader;
import de.geolykt.starloader.util.JavaInterop;
import de.geolykt.starloader.util.OrderedCollection;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minestom.server.extras.selfmodification.HierarchyClassLoader;
import net.minestom.server.extras.selfmodification.MinestomExtensionClassLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stianloader.sll.transform.CodeTransformer;

public class MinestomRootClassLoader
extends HierarchyClassLoader
implements TransformableClassloader {
    @ApiStatus.Internal
    public static final boolean DEBUG = Boolean.getBoolean("classloader.debug");
    private static final boolean DUMP = DEBUG || Boolean.getBoolean("classloader.dump");
    private static MinestomRootClassLoader INSTANCE;
    @NotNull
    @ApiStatus.Internal
    @ApiStatus.AvailableSince(value="4.0.0-a20240730")
    private static final ThreadLocal<Boolean> LOG_CLASSLOADING_FAILURES;
    private static final Logger LOGGER;
    private final URLClassLoader asmClassLoader;
    @NotNull
    private final Map<String, URI> classCodeSourceURIs = new ConcurrentHashMap<String, URI>();
    @NotNull
    private final Collection<ASMTransformer> modifiers = new OrderedCollection<ASMTransformer>();
    private final Set<String> protectedClasses = ConcurrentHashMap.newKeySet();
    public final Set<String> protectedPackages = ConcurrentHashMap.newKeySet();
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    private AccessTransformInfo widener = new AccessTransformInfo();

    private MinestomRootClassLoader(ClassLoader parent) {
        super("Starloader Root ClassLoader", new URL[0], parent);
        this.protectedClasses.add("de.geolykt.starloader.Starloader");
        this.protectedClasses.add("de.geolykt.starloader.UnlikelyEventException");
        this.protectedPackages.add("org.objectweb.asm");
        this.protectedPackages.add("org.slf4j");
        this.protectedPackages.add("org.json");
        this.protectedPackages.add("net.minestom.server.extras.selfmodification");
        this.protectedPackages.add("de.geolykt.starloader.transformers");
        this.protectedPackages.add("de.geolykt.starloader.launcher");
        this.protectedPackages.add("de.geolykt.starloader.deobf.access");
        this.protectedPackages.add("de.geolykt.starloader.mod");
        this.protectedPackages.add("de.geolykt.starloader.util");
        this.protectedPackages.add("ch.qos.logback");
        this.protectedPackages.add("org.stianloader.micromixin.annotations");
        this.protectedPackages.add("org.stianloader.micromixin.backports");
        this.asmClassLoader = this.newChild(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MinestomRootClassLoader getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<MinestomRootClassLoader> clazz = MinestomRootClassLoader.class;
        synchronized (MinestomRootClassLoader.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new MinestomRootClassLoader(MinestomRootClassLoader.class.getClassLoader());
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    @NotNull
    public Class<?> loadClass(@NotNull String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(Objects.requireNonNull(name, "name must not be null"));
        if (loadedClass != null) {
            return loadedClass;
        }
        boolean skippedPlatformCL = false;
        ClassLoader platformClassLoader = JavaInterop.getPlatformClassLoader();
        try {
            if (platformClassLoader != null) {
                Class<?> systemClass = platformClassLoader.loadClass(name);
                if (systemClass.getClassLoader() != platformClassLoader) {
                    skippedPlatformCL = true;
                    throw new ClassNotFoundException("When loading the class with a platform classloader returned by a Java 9 " + (JavaInterop.isJava9() ? "capable " : "incapable") + " JavaInterop implementation, the class was loaded by a different classloader. Presuming the class to be on the boot module layer - ignoring it.");
                }
                LOGGER.trace("Loading system class: {}", (Object)systemClass);
                return systemClass;
            }
            throw new ClassNotFoundException("Java 9 " + (JavaInterop.isJava9() ? "capable " : "incapable") + " JavaInterop implementation refused to return the platform classloader.");
        }
        catch (ClassNotFoundException cnfe1) {
            try {
                if (this.isProtected(name)) {
                    LOGGER.trace("Protected: {}", (Object)name);
                    return super.loadClass(name, resolve);
                }
                return this.define(name, resolve);
            }
            catch (Throwable ex1) {
                if (ex1 instanceof ThreadDeath) {
                    throw (ThreadDeath)ex1;
                }
                LOGGER.trace("Failed to load class \"{}\", resorting to parent loader. Code modifications forbidden.", (Object)name, (Object)ex1);
                try {
                    return super.loadClass(name, resolve);
                }
                catch (ClassNotFoundException cnfe2) {
                    if (skippedPlatformCL) {
                        try {
                            return Objects.requireNonNull(platformClassLoader).loadClass(name);
                        }
                        catch (ClassNotFoundException ex2) {
                            cnfe2.addSuppressed(ex2);
                        }
                    }
                    cnfe2.addSuppressed(cnfe1);
                    cnfe2.addSuppressed(ex1);
                    throw cnfe2;
                }
            }
        }
    }

    @Contract(pure=true)
    @ApiStatus.AvailableSince(value="4.0.0-a20241104.1")
    public boolean isProtected(String name) {
        if (!this.protectedClasses.contains(name)) {
            for (String start : this.protectedPackages) {
                if (!name.startsWith(start)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    @Contract(pure=true)
    @ApiStatus.AvailableSince(value="4.0.0-a20240730")
    public boolean isThreadLoggingClassloadingFailures() {
        return LOG_CLASSLOADING_FAILURES.get();
    }

    @NotNull
    private Class<?> define(String name, boolean resolve) throws IOException, ClassNotFoundException {
        try {
            Class<?> defined;
            RawClassData rawClass;
            try {
                rawClass = this.loadClassBytes(name, true);
            }
            catch (Throwable t) {
                throw new ClassNotFoundException("Unable to load bytes", t);
            }
            byte[] bytes = rawClass.getBytes();
            URL jarURL = rawClass.getSource();
            if (jarURL == null) {
                defined = this.defineClass(name, bytes, 0, bytes.length);
            } else {
                String path = jarURL.getPath();
                int seperatorIndex = path.lastIndexOf(33);
                if (seperatorIndex != -1) {
                    jarURL = new URL(path.substring(0, seperatorIndex));
                }
                defined = this.defineClass(name, bytes, 0, bytes.length, new CodeSource(jarURL, (CodeSigner[])null));
            }
            LOGGER.trace("Loaded with code modifiers: {}", (Object)name);
            if (resolve) {
                this.resolveClass(defined);
            }
            return defined;
        }
        catch (LinkageError e) {
            throw new ClassNotFoundException("Invalid bytecode for class " + name, e);
        }
        catch (ClassNotFoundException e) {
            Class<?> defined = null;
            for (MinestomExtensionClassLoader subloader : this.children) {
                try {
                    defined = subloader.loadClassAsChild(name, resolve);
                    LOGGER.trace("Loaded from child {}: {}", (Object)subloader, (Object)name);
                    return defined;
                }
                catch (ClassNotFoundException e1) {
                    e.addSuppressed(e1);
                }
            }
            throw e;
        }
    }

    public RawClassData loadClassBytes(String name, boolean transform) throws IOException, ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException("Name may not be null.");
        }
        String path = name.replace(".", "/") + ".class";
        URL url = this.findResource(path);
        InputStream input = url == null ? this.getResourceAsStream(name) : url.openStream();
        if (input == null) {
            throw new ClassNotFoundException("Could not find resource " + path);
        }
        byte @NotNull [] originalBytes = JavaInterop.readAllBytes(input);
        input.close();
        byte @NotNull [] transformedBytes = transform ? this.transformBytes(originalBytes, name, Utils.toCodeSourceURI(url, name)) : originalBytes;
        if (DUMP) {
            Path parent = Paths.get("classes", path).getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.write(Paths.get("classes", path), transformedBytes, new OpenOption[0]);
        }
        return new RawClassData(url, transformedBytes);
    }

    @Deprecated
    public byte[] loadBytesWithChildren(String name, boolean transform) throws IOException, ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException();
        }
        String path = name.replace(".", "/") + ".class";
        InputStream input = this.getResourceAsStreamWithChildren(path);
        if (input == null) {
            throw new ClassNotFoundException("Could not find resource " + path);
        }
        byte[] originalBytes = JavaInterop.readAllBytes(input);
        input.close();
        if (transform) {
            return this.transformBytes(originalBytes, name, null);
        }
        return originalBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized byte @NotNull [] transformBytes(byte @NotNull [] classBytecode, @NotNull String qualifiedName, @Nullable URI codeSourceURI) {
        if (!this.isProtected(qualifiedName)) {
            ClassReader reader = new ClassReader(classBytecode);
            ClassNode node = new ClassNode();
            boolean modified = false;
            reader.accept(node, 0);
            if (codeSourceURI != null) {
                this.classCodeSourceURIs.putIfAbsent(node.name, codeSourceURI);
            }
            try {
                boolean hack;
                modified = hack = this.widener.apply(node, true);
                Collection<ASMTransformer> collection = this.modifiers;
                synchronized (collection) {
                    Iterator<ASMTransformer> transformers = this.modifiers.iterator();
                    while (transformers.hasNext()) {
                        ASMTransformer transformer = transformers.next();
                        String internalName = node.name;
                        if (internalName == null) {
                            throw new NullPointerException();
                        }
                        if (DEBUG) {
                            LOGGER.info("{} could be able to transform {}", (Object)transformer.getClass().getSimpleName(), (Object)internalName);
                        }
                        if (!(transformer instanceof CodeTransformer ? ((CodeTransformer)((Object)transformer)).isValidTarget(internalName, codeSourceURI) && ((CodeTransformer)((Object)transformer)).transformClass(node, codeSourceURI) : transformer.isValidTarget(internalName) && transformer.accept(node))) continue;
                        if (DEBUG) {
                            LOGGER.info("{} was transformed by a {}", (Object)internalName, (Object)transformer.getClass().getSimpleName());
                        }
                        if (!transformer.isValid()) {
                            transformers.remove();
                        }
                        modified = true;
                    }
                }
            }
            catch (Throwable t) {
                if (this.isThreadLoggingClassloadingFailures()) {
                    LOGGER.error("Error within ASM transforming process. CLASS {} WILL NOT BE MODIFIED - THIS MAY BE LETHAL.", (Object)qualifiedName, (Object)t);
                }
                throw new RuntimeException("Error within ASM transforming process for class " + qualifiedName, t);
            }
            try {
                if (modified) {
                    ClassWriter writer = new ClassWriter(2){

                        @Override
                        protected ClassLoader getClassLoader() {
                            return MinestomRootClassLoader.this.asmClassLoader;
                        }
                    };
                    node.accept(writer);
                    classBytecode = Objects.requireNonNull(writer.toByteArray());
                }
            }
            catch (Throwable t) {
                try {
                    StringWriter disassembledClass = new StringWriter();
                    TraceClassVisitor traceVisitor = new TraceClassVisitor(new PrintWriter(disassembledClass));
                    CheckClassAdapter checkAdapter = new CheckClassAdapter(589824, traceVisitor, true){

                        @Override
                        public void visitInnerClass(String name, String outerName, String innerName, int access) {
                            super.visitInnerClass(name, outerName, innerName, access & 0xFFFFFFDF);
                        }
                    };
                    node.accept(checkAdapter);
                    throw new RuntimeException("The class seems to be intact, but ASM does not like it anyways. In order to help on your debugging journey, take this:\n" + disassembledClass.toString());
                }
                catch (Throwable t0) {
                    if (t0 instanceof ThreadDeath) {
                        throw (ThreadDeath)t0;
                    }
                    if (t0 instanceof OutOfMemoryError) {
                        throw (OutOfMemoryError)t0;
                    }
                    t.addSuppressed(t0);
                    if (this.isThreadLoggingClassloadingFailures()) {
                        LOGGER.error("Unable to write ASM Classnode to bytecode for class '{}' (bork transformer?)", (Object)qualifiedName, (Object)t);
                    }
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    if (t instanceof OutOfMemoryError) {
                        throw (OutOfMemoryError)t;
                    }
                    throw new RuntimeException("Unable to write ASM Classnode to bytecode for class " + qualifiedName, t);
                }
            }
        }
        return classBytecode;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    @NotNull
    @ApiStatus.Internal
    public URLClassLoader newChild(URL ... urls) {
        return Objects.requireNonNull(URLClassLoader.newInstance(urls, this));
    }

    @ApiStatus.Internal
    public void loadModifier(ClassLoader modifierLoader, @NotNull String codeModifierClass) {
        try {
            Class<?> modifierClass = modifierLoader.loadClass(codeModifierClass);
            if (ASMTransformer.class.isAssignableFrom(modifierClass)) {
                this.addTransformer((ASMTransformer)modifierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public synchronized void addTransformer(ASMTransformer transformer) {
        this.addASMTransformer(Objects.requireNonNull(transformer));
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public synchronized List<ASMTransformer> getTransformers() {
        Collection<ASMTransformer> collection = this.modifiers;
        synchronized (collection) {
            return new ArrayList<ASMTransformer>(this.modifiers);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public void readAccessWidener(@NotNull InputStream in) throws IOException {
        try (AccessWidenerReader accessReader = new AccessWidenerReader(this.widener, in, true);){
            accessReader.readHeader();
            while (accessReader.readLn()) {
            }
        }
    }

    @Override
    @Contract(pure=false, value="_ -> this")
    @ApiStatus.AvailableSince(value="4.0.0-a20240730")
    public MinestomRootClassLoader setThreadLoggingClassloadingFailures(boolean logFailures) {
        LOG_CLASSLOADING_FAILURES.set(logFailures);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Contract(pure=false, mutates="this")
    @ApiStatus.AvailableSince(value="4.0.0-a20231223")
    public void addASMTransformer(@NotNull ASMTransformer transformer) {
        Collection<ASMTransformer> collection = this.modifiers;
        synchronized (collection) {
            if (DEBUG) {
                LOGGER.info("Adding transformer {}", (Object)transformer.getClass().getName());
            }
            this.modifiers.add(transformer);
            if (DEBUG) {
                LOGGER.info("Currently registered transformers: ");
                for (ASMTransformer x : this.modifiers) {
                    LOGGER.info("  - {}", (Object)x.getClass().getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @Contract(pure=true, value="-> new")
    @ApiStatus.AvailableSince(value="4.0.0-a20231223")
    public @NotNull @Unmodifiable Collection<@NotNull ASMTransformer> getASMTransformers() {
        Collection<ASMTransformer> collection = this.modifiers;
        synchronized (collection) {
            return Collections.unmodifiableCollection(new ArrayList<ASMTransformer>(this.modifiers));
        }
    }

    @Nullable
    @Contract(pure=true)
    @ApiStatus.AvailableSince(value="4.0.0-a20250819")
    @ApiStatus.Experimental
    public URI getClassCodeSourceURI(@NotNull String internalName) {
        return this.classCodeSourceURIs.get(internalName);
    }

    @Override
    @NotNull
    @Contract(pure=false)
    @CheckReturnValue
    @ApiStatus.AvailableSince(value="4.0.0-a20231223")
    public Class<?> transformAndDefineClass(@NotNull String className, @NotNull RawClassData data) {
        URI jarURI;
        if (DEBUG) {
            LOGGER.info("Forcefully defining class '{}'", (Object)className);
        }
        URL jarURL = data.getSource();
        try {
            jarURI = jarURL == null ? null : jarURL.toURI();
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger(MinestomRootClassLoader.class).debug("Cannot convert URL {} to a URI.", (Object)jarURL, (Object)e);
            jarURI = null;
        }
        byte[] transformed = this.transformBytes(data.getBytes(), className, jarURI);
        if (DUMP) {
            try {
                Path parent = Paths.get("classes", className.replace('.', '/')).getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.write(Paths.get("classes", className.replace('.', '/') + ".class"), transformed, new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.info("Unable to dump forcefully defined class '{}'", (Object)className, (Object)e);
            }
        }
        if (jarURL == null) {
            return super.defineClass(className, transformed, 0, transformed.length);
        }
        String path = jarURL.getPath();
        int seperatorIndex = path.lastIndexOf(33);
        if (seperatorIndex != -1) {
            try {
                jarURL = new URL(path.substring(0, seperatorIndex));
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Bumped into a MalformedURLException while forcefully defining a class", e);
            }
        }
        return super.defineClass(className, transformed, 0, transformed.length, new CodeSource(jarURL, (Certificate[])null));
    }

    static {
        LOG_CLASSLOADING_FAILURES = Objects.requireNonNull(ThreadLocal.withInitial(() -> true));
        LOGGER = LoggerFactory.getLogger(MinestomRootClassLoader.class);
    }
}

