/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.picoresolve.DependencyContainerNode;
import org.stianloader.picoresolve.DependencyLayer;
import org.stianloader.picoresolve.DependencyManagementTree;
import org.stianloader.picoresolve.GAV;
import org.stianloader.picoresolve.Scope;
import org.stianloader.picoresolve.VersionlessDependency;
import org.stianloader.picoresolve.exclusion.Exclusion;
import org.stianloader.picoresolve.exclusion.ExclusionContainer;
import org.stianloader.picoresolve.internal.ConcurrencyUtil;
import org.stianloader.picoresolve.internal.JavaInterop;
import org.stianloader.picoresolve.internal.StronglyMultiCompletableFuture;
import org.stianloader.picoresolve.internal.XMLUtil;
import org.stianloader.picoresolve.internal.meta.VersionCatalogue;
import org.stianloader.picoresolve.logging.LoggingAdapter;
import org.stianloader.picoresolve.repo.MavenLocalRepositoryNegotiator;
import org.stianloader.picoresolve.repo.MavenRepository;
import org.stianloader.picoresolve.repo.RepositoryAttachedValue;
import org.stianloader.picoresolve.repo.RepositoryNegotiatior;
import org.stianloader.picoresolve.version.MavenVersion;
import org.stianloader.picoresolve.version.VersionRange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MavenResolver {
    private final RepositoryNegotiatior negotiator;
    private final ConcurrentMap<GAV, DependencyContainerNode> depdenencyCache = new ConcurrentHashMap<GAV, DependencyContainerNode>();
    @NotNull
    private LoggingAdapter logger = LoggingAdapter.getDefaultLogger();
    public boolean ignoreTestDependencies = true;
    public boolean ignoreOptionalDependencies = true;

    public MavenResolver(@NotNull Path mavenLocal) {
        this(mavenLocal, null);
    }

    public MavenResolver(@NotNull Path mavenLocal, @Nullable Collection<@NotNull MavenRepository> repos) {
        this(new MavenLocalRepositoryNegotiator(mavenLocal));
        if (repos != null) {
            this.addRepositories(repos);
        }
    }

    public MavenResolver(@NotNull RepositoryNegotiatior negotiator) {
        this.negotiator = negotiator;
    }

    public MavenResolver addRepositories(@NotNull @NotNull Collection<@NotNull MavenRepository> repos) {
        repos.forEach(this::addRepository);
        return this;
    }

    public MavenResolver addRepository(@NotNull MavenRepository repo) {
        this.negotiator.addRepository(repo);
        return this;
    }

    public MavenResolver addRepositories(MavenRepository ... repos) {
        for (MavenRepository mr : repos) {
            this.addRepository(mr);
        }
        return this;
    }

    public CompletableFuture<RepositoryAttachedValue<Path>> download(@NotNull GAV gav, @Nullable String classifier, @NotNull String extension, @NotNull Executor executor) {
        CompletableFuture<RepositoryAttachedValue<Path>> resource = gav.version().getOriginText().toLowerCase(Locale.ROOT).endsWith("-snapshot") ? this.downloadSnapshot(gav, classifier, extension, executor) : ConcurrencyUtil.configureFallback(this.downloadSimple(gav, classifier, extension, executor), () -> this.downloadSnapshot(gav, classifier, extension, executor));
        return resource;
    }

    @NotNull
    private static String applyPlaceholders(@NotNull String string, int startIndex, @NotNull Map<String, String> placeholders) {
        int indexStart = string.indexOf("${", startIndex);
        if (indexStart == -1) {
            return string;
        }
        int indexEnd = string.indexOf(125, indexStart);
        String property = string.substring(indexStart + 2, indexEnd);
        String replacement = placeholders.get(property);
        if (replacement == null) {
            return MavenResolver.applyPlaceholders(string, indexEnd, placeholders);
        }
        string = string.substring(0, indexStart) + replacement + string.substring(indexEnd + 1);
        return MavenResolver.applyPlaceholders(string, indexStart, placeholders);
    }

    @Nullable
    private static String applyPlaceholders(@Nullable String string, @NotNull Map<String, String> placeholders) {
        if (string == null) {
            return null;
        }
        return MavenResolver.applyPlaceholders(string, 0, placeholders);
    }

    private static void extractProperties(@NotNull Document project, @NotNull GAV gav, Map<String, String> out) {
        for (Element elem : new XMLUtil.ChildElementIterable(project.getDocumentElement())) {
            if (elem.hasChildNodes()) continue;
            out.put("project." + elem.getTagName(), elem.getTextContent());
            out.put("pom." + elem.getTagName(), elem.getTextContent());
            out.put(elem.getTagName(), elem.getTextContent());
        }
        Element properties = XMLUtil.optElement(project.getDocumentElement(), "properties");
        if (properties != null) {
            for (Element prop : new XMLUtil.ChildElementIterable(properties)) {
                out.put(prop.getTagName(), prop.getTextContent());
            }
        }
    }

    @NotNull
    private CompletableFuture<Document> downloadPom(@NotNull GAV gav, @NotNull Executor executor) {
        return this.download(gav, null, "pom", executor).thenApply(pathRAV -> {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Document xmlDoc = factory.newDocumentBuilder().parse(Files.newInputStream((Path)pathRAV.getValue(), new OpenOption[0]));
                return xmlDoc;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @NotNull
    private CompletableFuture<RepositoryAttachedValue<Path>> downloadSimple(@NotNull GAV gav, @Nullable String classifier, @NotNull String extension, @NotNull Executor executor) {
        String basePath = gav.group().replace('.', '/') + '/' + gav.artifact() + '/' + gav.version().getOriginText() + '/';
        String path = basePath + gav.artifact() + '-' + gav.version().getOriginText();
        if (classifier != null) {
            path = path + '-' + classifier;
        }
        path = path + '.' + extension;
        return this.negotiator.resolveStandard(path, executor);
    }

    private CompletableFuture<RepositoryAttachedValue<Path>> downloadSnapshot(@NotNull GAV gav, @Nullable String classifier, @NotNull String extension, @NotNull Executor executor) {
        String basePath = gav.group().replace('.', '/') + '/' + gav.artifact() + '/' + gav.version().getOriginText() + '/';
        return ConcurrencyUtil.configureFallback(this.negotiator.resolveMavenMeta(basePath + "maven-metadata.xml", executor).thenCompose(item -> {
            String path;
            ArrayList<VersionCatalogue> catalogues = new ArrayList<VersionCatalogue>();
            for (RepositoryAttachedValue rav : item) {
                try {
                    InputStream is = Files.newInputStream((Path)rav.getValue(), new OpenOption[0]);
                    try {
                        VersionCatalogue catalogue = new VersionCatalogue(is);
                        catalogues.add(catalogue);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            VersionCatalogue merged = VersionCatalogue.merge(catalogues);
            for (VersionCatalogue.SnapshotVersion snapshot : merged.snapshotVersions) {
                if (!snapshot.extension().equals(extension) || snapshot.classifier() != null && !snapshot.classifier().equals(classifier) || snapshot.classifier() == null && classifier != null) continue;
                String path2 = basePath + gav.artifact() + '-' + snapshot.version();
                if (classifier != null) {
                    path2 = path2 + '-' + classifier;
                }
                path2 = path2 + '.' + extension;
                return this.negotiator.resolveStandard(path2, executor);
            }
            if (merged.fallbackSnapshotVersion != null) {
                path = basePath + gav.artifact() + '-' + merged.fallbackSnapshotVersion;
                if (classifier != null) {
                    path = path + '-' + classifier;
                }
                path = path + '.' + extension;
                return this.negotiator.resolveStandard(path, executor);
            }
            if (merged.localCopy) {
                path = basePath + gav.artifact() + '-' + gav.version().getOriginText();
                if (classifier != null) {
                    path = path + '-' + classifier;
                }
                path = path + '.' + extension;
                return this.negotiator.resolveStandard(path, executor);
            }
            throw new IllegalStateException("Unable to find snapshot version");
        }), () -> this.downloadSimple(gav, classifier, extension, executor));
    }

    private CompletableFuture<DependencyLayer> resolveChildLayer(@NotNull DependencyLayer layer, @NotNull Executor executor, @NotNull Map<VersionlessDependency, DependencyLayer.DependencyLayerElement> resolveCache) {
        if (layer.getChild() != null) {
            throw new IllegalStateException("Child layer already resolved");
        }
        class ChildResolutionContext {
            @NotNull
            VersionRange range = VersionRange.FREE_RANGE;
            Scope scope;
            @NotNull
            final List<DependencyLayer.DependencyEdge> declaringEdges = new ArrayList<DependencyLayer.DependencyEdge>();
            @NotNull
            final ExclusionContainer<ExclusionContainer<?>> effectiveExclusions = new ExclusionContainer(ExclusionContainer.ExclusionMode.ALL);

            ChildResolutionContext() {
            }
        }
        HashMap<VersionlessDependency, ChildResolutionContext> resolveChildren = new HashMap<VersionlessDependency, ChildResolutionContext>();
        for (DependencyLayer.DependencyLayerElement dependencyLayerElement : layer.elements) {
            for (DependencyLayer.DependencyEdge edge : dependencyLayerElement.outgoingEdges) {
                VersionlessDependency dep = new VersionlessDependency(edge.group, edge.artifact, edge.classifier, edge.type);
                if (resolveCache.containsKey(dep)) {
                    DependencyLayer.DependencyLayerElement cache = resolveCache.get(dep);
                    if (cache == null || edge.isResolved()) continue;
                    edge.resolve(cache);
                    continue;
                }
                ChildResolutionContext ctx = (ChildResolutionContext)resolveChildren.get(dep);
                if (ctx == null) {
                    ctx = new ChildResolutionContext();
                    resolveChildren.put(dep, ctx);
                }
                ctx.range = ctx.range.intersect(edge.requestedVersion);
                if (ctx.scope == null) {
                    ctx.scope = edge.scope;
                } else if (edge.scope == Scope.COMPILE) {
                    ctx.scope = Scope.COMPILE;
                } else if (ctx.scope == Scope.TEST) {
                    ctx.scope = edge.scope;
                } else if (edge.scope == Scope.PROVIDED && ctx.scope == Scope.RUNTIME) {
                    ctx.scope = Scope.PROVIDED;
                }
                ctx.effectiveExclusions.addChild(new ExclusionContainer<ExclusionContainer>(ExclusionContainer.ExclusionMode.ANY, Arrays.asList(dependencyLayerElement.parentExclusions, edge.edgeExclusion), false));
                ctx.declaringEdges.add(edge);
            }
        }
        ArrayList futures = new ArrayList();
        for (Map.Entry entry : resolveChildren.entrySet()) {
            VersionlessDependency coordinates = (VersionlessDependency)entry.getKey();
            ChildResolutionContext resolveContext = (ChildResolutionContext)entry.getValue();
            futures.add(((CompletableFuture)((CompletableFuture)this.getVersions(coordinates.group(), coordinates.artifact(), executor).exceptionally(ex -> {
                this.logger.debug(MavenResolver.class, "Failed to obtain versions for artifact '{}:{}'", coordinates.group(), coordinates.artifact(), ex);
                this.logger.warn(MavenResolver.class, "Unable to obtain the versions available for artifact '{}:{}'. It is likely that the relevant maven-metadata.xml file is missing. This may hamper resolution stability (especially when version ranges are being used) as the available versions will be guessed instead. See debug log output for the full relevant stacktrace.", coordinates.group(), coordinates.artifact());
                return VersionCatalogue.synthesize(resolveContext.range.getRecommendedVersions());
            })).thenCompose(catalogue -> {
                MavenVersion selected = resolveContext.range.selectFrom(catalogue.releaseVersions, catalogue.releaseVersion);
                if (selected == null) {
                    throw new IllegalStateException("Unable to resolve a sensical version for range " + resolveContext.range + " for coordinates " + coordinates);
                }
                GAV gav = new GAV(coordinates.group(), coordinates.artifact(), selected);
                return this.getNode(gav, coordinates.classifier(), coordinates.getType("jar"), executor);
            })).thenApply(node -> {
                DependencyLayer.DependencyLayerElement element = node.toLayerElement(coordinates.classifier(), coordinates.type(), resolveContext.effectiveExclusions);
                for (DependencyLayer.DependencyEdge edge : resolveContext.declaringEdges) {
                    edge.resolve(element);
                }
                return element;
            }));
        }
        if (futures.size() == 0) {
            return CompletableFuture.completedFuture(null);
        }
        StronglyMultiCompletableFuture stronglyMultiCompletableFuture = new StronglyMultiCompletableFuture(futures);
        return stronglyMultiCompletableFuture.thenApply(elements -> {
            combinedFuture.throwExceptionIfCompletedUncleanly();
            return new DependencyLayer(layer, Collections.unmodifiableList(elements));
        });
    }

    private CompletableFuture<Void> resolveAllChildren0(@NotNull DependencyLayer layer, @NotNull Executor executor, @NotNull Map<VersionlessDependency, DependencyLayer.DependencyLayerElement> resolveCache) {
        return this.resolveChildLayer(layer, executor, resolveCache).thenCompose(child -> {
            if (child == null) {
                return CompletableFuture.completedFuture(null);
            }
            for (DependencyLayer.DependencyLayerElement element : child.elements) {
                resolveCache.put(new VersionlessDependency(element.gav.group(), element.gav.artifact(), element.classifier, element.type), element);
            }
            return this.resolveAllChildren0((DependencyLayer)child, executor, resolveCache);
        });
    }

    public CompletableFuture<Void> resolveAllChildren(@NotNull DependencyLayer current, @NotNull Executor executor) {
        HashMap<VersionlessDependency, DependencyLayer.DependencyLayerElement> resolveCache = new HashMap<VersionlessDependency, DependencyLayer.DependencyLayerElement>();
        DependencyLayer layer = current;
        while (layer != null) {
            for (DependencyLayer.DependencyLayerElement element : layer.elements) {
                resolveCache.put(new VersionlessDependency(element.gav.group(), element.gav.artifact(), element.classifier, element.type), element);
            }
            layer = layer.parent;
        }
        return this.resolveAllChildren0(current, executor, resolveCache);
    }

    public CompletableFuture<DependencyLayer> resolveChildLayer(@NotNull DependencyLayer current, @NotNull Executor executor) {
        HashMap<VersionlessDependency, DependencyLayer.DependencyLayerElement> resolveCache = new HashMap<VersionlessDependency, DependencyLayer.DependencyLayerElement>();
        DependencyLayer layer = current;
        while (layer != null) {
            for (DependencyLayer.DependencyLayerElement element : layer.elements) {
                resolveCache.put(new VersionlessDependency(element.gav.group(), element.gav.artifact(), element.classifier, element.type), element);
            }
            layer = layer.parent;
        }
        return this.resolveChildLayer(current, executor, resolveCache);
    }

    private CompletableFuture<DependencyContainerNode> getNode(@NotNull GAV gav, @Nullable String classifier, @NotNull String type, @NotNull Executor executor) {
        DependencyContainerNode node = (DependencyContainerNode)this.depdenencyCache.get(gav);
        if (node != null) {
            return CompletableFuture.completedFuture(node);
        }
        return ((CompletableFuture)this.downloadPom(gav, executor).thenCompose(xmlDoc -> {
            ArrayList<Map.Entry<@NotNull GAV, @NotNull Document>> list = new ArrayList<Map.Entry<GAV, Document>>();
            list.add(new AbstractMap.SimpleImmutableEntry<GAV, Document>(gav, (Document)xmlDoc));
            Element project = xmlDoc.getDocumentElement();
            project.normalize();
            Element parent = XMLUtil.optElement(project, "parent");
            if (parent == null) {
                return CompletableFuture.completedFuture(list);
            }
            return this.downloadParentPoms(parent, executor, list);
        })).thenCompose(poms -> {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            MavenResolver.computePlaceholders(poms, 0, placeholders);
            return this.getDependencyManagementTree(executor, (List<Map.Entry<GAV, Document>>)poms, 0).thenApply(depManagement -> this.getDependencyNode0((Map<String, String>)placeholders, (List<Map.Entry<GAV, Document>>)poms, (DependencyManagementTree)depManagement));
        });
    }

    private DependencyContainerNode getDependencyNode0(@NotNull Map<String, String> placeholders, List<Map.Entry<@NotNull GAV, @NotNull Document>> poms, @NotNull DependencyManagementTree dependencyManagement) {
        Document xmlDoc = poms.get(0).getValue();
        DependencyContainerNode container = new DependencyContainerNode(poms.get(0).getKey());
        Element project = xmlDoc.getDocumentElement();
        Element deps = XMLUtil.optElement(project, "dependencies");
        if (deps == null) {
            return container;
        }
        HashMap<VersionlessDependency, DependencyManagementTree.DependencyManagementNode> managementNodes = new HashMap<VersionlessDependency, DependencyManagementTree.DependencyManagementNode>();
        dependencyManagement.collectNodes(managementNodes);
        for (Element dependency : new XMLUtil.ChildElementIterable(deps)) {
            String group = XMLUtil.elementText(dependency, "groupId");
            String artifactId = XMLUtil.elementText(dependency, "artifactId");
            String version = XMLUtil.elementText(dependency, "version");
            String scope = XMLUtil.elementText(dependency, "scope");
            String classifier = XMLUtil.elementText(dependency, "classifier");
            String type = XMLUtil.elementText(dependency, "type");
            String optional = XMLUtil.elementText(dependency, "optional");
            ExclusionContainer<Exclusion> exclusions = MavenResolver.parseExclusions(XMLUtil.optElement(dependency, "exclusions"), placeholders);
            group = Objects.requireNonNull(MavenResolver.applyPlaceholders(group, placeholders));
            artifactId = Objects.requireNonNull(MavenResolver.applyPlaceholders(artifactId, placeholders));
            version = MavenResolver.applyPlaceholders(version, placeholders);
            scope = MavenResolver.applyPlaceholders(scope, placeholders);
            classifier = MavenResolver.applyPlaceholders(classifier, placeholders);
            type = MavenResolver.applyPlaceholders(type, placeholders);
            optional = MavenResolver.applyPlaceholders(optional, placeholders);
            DependencyManagementTree.DependencyManagementNode managementNode = (DependencyManagementTree.DependencyManagementNode)managementNodes.get(new VersionlessDependency(group, artifactId, classifier, type));
            if (managementNode != null) {
                if (version == null) {
                    version = managementNode.range;
                }
                if (scope == null) {
                    scope = managementNode.scope;
                }
                if (exclusions == null) {
                    exclusions = managementNode.exclusions;
                }
            }
            if (this.ignoreTestDependencies && "test".equalsIgnoreCase(scope) || this.ignoreOptionalDependencies && "true".equalsIgnoreCase(optional)) continue;
            if (version == null) {
                throw new IllegalStateException("Fatal failure while assembling dependency " + group + ":" + artifactId + ":" + classifier + ":" + type + " as defined by " + poms.get(0).getKey() + ". This likely hints at either an impoper POM or incorrect dependency management parsing by the resolver.");
            }
            if (type == null) {
                type = "jar";
            }
            if (container.selectDependency(group, artifactId, classifier, type) != null) {
                this.logger.warn(MavenResolver.class, "POM of project {} defines duplicate dependency for {}:{}:{}:{}:{}. It is highly recommended to fix these problems because they threaten the stability of the resolver output. Future versions of Maven may no longer support these configurations.", container.gav, group, artifactId, version, classifier, type);
                continue;
            }
            container.createDependency(group, artifactId, classifier, type, VersionRange.parse(version), Scope.fromString(scope), exclusions);
        }
        return container;
    }

    private CompletableFuture<@NotNull List<Map.Entry<@NotNull GAV, @NotNull Document>>> downloadParentPoms(@NotNull Element parentElement, @NotNull Executor executor, @NotNull @NotNull List<Map.Entry<@NotNull GAV, @NotNull Document>> sink) {
        String group = XMLUtil.elementText(parentElement, "groupId");
        String artifactId = XMLUtil.elementText(parentElement, "artifactId");
        String version = XMLUtil.elementText(parentElement, "version");
        if (group == null) {
            return JavaInterop.failedFuture(new IllegalStateException("groupId missing in parent element"));
        }
        if (artifactId == null) {
            return JavaInterop.failedFuture(new IllegalStateException("artifactId missing in parent element"));
        }
        if (version == null) {
            return JavaInterop.failedFuture(new IllegalStateException("version missing in parent element"));
        }
        GAV gav = new GAV(group, artifactId, MavenVersion.parse(version));
        return this.downloadPom(gav, executor).thenCompose(xmlDoc -> {
            List list = sink;
            synchronized (list) {
                sink.add(new AbstractMap.SimpleImmutableEntry<GAV, Document>(gav, (Document)xmlDoc));
            }
            Element project = xmlDoc.getDocumentElement();
            project.normalize();
            Element parent = XMLUtil.optElement(project, "parent");
            if (parent != null) {
                return this.downloadParentPoms(parent, executor, sink);
            }
            return CompletableFuture.completedFuture(sink);
        });
    }

    private static void computePlaceholders(List<Map.Entry<@NotNull GAV, @NotNull Document>> poms, int pomIndex, Map<String, String> out) {
        GAV gav = poms.get(pomIndex).getKey();
        if (!poms.isEmpty()) {
            ListIterator<Map.Entry<@NotNull GAV, @NotNull Document>> lit = poms.listIterator(pomIndex);
            while (lit.hasNext()) {
                Map.Entry<@NotNull GAV, @NotNull Document> entry = lit.next();
                MavenResolver.extractProperties(entry.getValue(), entry.getKey(), out);
            }
        }
        out.put("project.version", gav.version().getOriginText());
        out.put("project.groupId", gav.group());
        out.put("pom.version", gav.version().getOriginText());
        out.put("pom.groupId", gav.group());
        out.put("version", gav.version().getOriginText());
        out.put("groupId", gav.group());
    }

    private CompletableFuture<DependencyManagementTree> getDependencyManagementBOMTree(@NotNull Executor executor, @NotNull String group, @NotNull String artifact, @NotNull VersionRange version, @NotNull DependencyManagementTree parentNode) {
        return ((CompletableFuture)((CompletableFuture)this.downloadPom(group, artifact, version, executor).thenCompose(entry -> {
            Document xmlDoc = (Document)entry.getValue();
            ArrayList<Map.Entry<@NotNull GAV, @NotNull Document>> list = new ArrayList<Map.Entry<GAV, Document>>();
            list.add((Map.Entry<GAV, Document>)entry);
            Element project = xmlDoc.getDocumentElement();
            project.normalize();
            Element parent = XMLUtil.optElement(project, "parent");
            if (parent == null) {
                return CompletableFuture.completedFuture(list);
            }
            return this.downloadParentPoms(parent, executor, list);
        })).thenCompose(poms -> this.getDependencyManagementTree(executor, (List<Map.Entry<GAV, Document>>)poms, 0))).thenApply(node -> {
            parentNode.addImportNode((DependencyManagementTree)node);
            return node;
        });
    }

    private CompletableFuture<@NotNull DependencyManagementTree> getDependencyManagementTree(@NotNull Executor executor, @NotNull @NotNull List<Map.Entry<@NotNull GAV, @NotNull Document>> poms, int pomIndex) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        MavenResolver.computePlaceholders(poms, pomIndex, placeholders);
        Element project = poms.get(pomIndex).getValue().getDocumentElement();
        Element dependencyManagement = XMLUtil.optElement(project, "dependencyManagement");
        int parentPomIndex = pomIndex + 1;
        Element dependencies = dependencyManagement == null ? null : XMLUtil.optElement(dependencyManagement, "dependencies");
        if (dependencies == null) {
            if (parentPomIndex == poms.size()) {
                return CompletableFuture.completedFuture(DependencyManagementTree.EMPTY);
            }
            return this.getDependencyManagementTree(executor, poms, parentPomIndex).thenApply(parentTree -> {
                DependencyManagementTree tree = new DependencyManagementTree();
                tree.setParent((DependencyManagementTree)parentTree);
                return tree;
            });
        }
        DependencyManagementTree tree = new DependencyManagementTree();
        ArrayList<CompletableFuture<DependencyManagementTree>> dependencyFutures = new ArrayList<CompletableFuture<DependencyManagementTree>>();
        for (Element dependency : new XMLUtil.ChildElementIterable(dependencies)) {
            String group = XMLUtil.elementText(dependency, "groupId");
            String artifactId = XMLUtil.elementText(dependency, "artifactId");
            String version = XMLUtil.elementText(dependency, "version");
            String scope = XMLUtil.elementText(dependency, "scope");
            String classifier = XMLUtil.elementText(dependency, "classifier");
            String type = XMLUtil.elementText(dependency, "type");
            String optional = XMLUtil.elementText(dependency, "optional");
            ExclusionContainer<Exclusion> exclusions = MavenResolver.parseExclusions(XMLUtil.optElement(dependency, "exclusions"), placeholders);
            group = Objects.requireNonNull(MavenResolver.applyPlaceholders(group, placeholders));
            artifactId = Objects.requireNonNull(MavenResolver.applyPlaceholders(artifactId, placeholders));
            version = Objects.requireNonNull(MavenResolver.applyPlaceholders(version, placeholders));
            scope = MavenResolver.applyPlaceholders(scope, placeholders);
            classifier = MavenResolver.applyPlaceholders(classifier, placeholders);
            type = MavenResolver.applyPlaceholders(type, placeholders);
            optional = MavenResolver.applyPlaceholders(optional, placeholders);
            if (scope != null && scope.equals("import")) {
                DependencyManagementTree importNode = new DependencyManagementTree();
                tree.addImportNode(importNode);
                dependencyFutures.add(this.getDependencyManagementBOMTree(executor, group, artifactId, VersionRange.parse(version), importNode));
                continue;
            }
            tree.addNode(new VersionlessDependency(group, artifactId, classifier, type), new DependencyManagementTree.DependencyManagementNode(scope, version, exclusions));
        }
        if (parentPomIndex == poms.size()) {
            return CompletableFuture.completedFuture(tree);
        }
        return ((CompletableFuture)this.getDependencyManagementTree(executor, poms, parentPomIndex).thenCompose(parentDependencyManagement -> {
            parentDependencyManagement.setParent(tree);
            return new StronglyMultiCompletableFuture(dependencyFutures);
        })).thenApply(ignore -> tree);
    }

    public CompletableFuture<Map.Entry<@NotNull GAV, RepositoryAttachedValue<Path>>> download(@NotNull String group, @NotNull String artifact, @NotNull VersionRange versionRange, @Nullable String classifier, @NotNull String extension, @NotNull Executor executor) {
        return this.getVersions(group, artifact, executor).thenCompose(catalogue -> {
            MavenVersion selected = versionRange.selectFrom(catalogue.releaseVersions, catalogue.releaseVersion);
            if (selected == null) {
                throw new IllegalStateException("Unable to resolve a sensical version for range " + versionRange + " for coordinates " + group + ":" + artifact + ":?:" + classifier + ":" + extension);
            }
            GAV gav = new GAV(group, artifact, selected);
            return this.download(gav, classifier, extension, executor).thenApply(rav -> new AbstractMap.SimpleImmutableEntry<GAV, RepositoryAttachedValue>(gav, (RepositoryAttachedValue)rav));
        });
    }

    private CompletableFuture<VersionCatalogue> getVersions(@NotNull String groupId, @NotNull String artifactId, @NotNull Executor executor) {
        return this.negotiator.resolveMavenMeta(groupId.replace('.', '/') + '/' + artifactId + "/maven-metadata.xml", executor).thenApply(item -> {
            ArrayList<VersionCatalogue> catalogues = new ArrayList<VersionCatalogue>(item.size());
            for (RepositoryAttachedValue rav : item) {
                VersionCatalogue catalogue;
                try (InputStream is = Files.newInputStream((Path)rav.getValue(), new OpenOption[0]);){
                    catalogue = new VersionCatalogue(is);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                catalogues.add(catalogue);
            }
            return VersionCatalogue.merge(catalogues);
        });
    }

    private CompletableFuture<Map.Entry<@NotNull GAV, @NotNull Document>> downloadPom(@NotNull String group, @NotNull String artifact, @NotNull VersionRange range, @NotNull Executor executor) {
        return this.download(group, artifact, range, null, "pom", executor).thenApply(entry -> {
            try {
                Document xmlDoc;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                try (InputStream is = Files.newInputStream((Path)((RepositoryAttachedValue)entry.getValue()).getValue(), new OpenOption[0]);){
                    xmlDoc = factory.newDocumentBuilder().parse(is);
                }
                xmlDoc.getDocumentElement().normalize();
                return new AbstractMap.SimpleImmutableEntry<GAV, Document>((GAV)entry.getKey(), xmlDoc);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Nullable
    private static ExclusionContainer<Exclusion> parseExclusions(@Nullable Element element, @NotNull Map<String, String> placeholders) {
        if (element == null) {
            return null;
        }
        List<@NotNull Element> exclusions = XMLUtil.getChildElements(element);
        ArrayList<@NotNull Exclusion> parsed = new ArrayList<Exclusion>(exclusions.size());
        for (Element exclusion : exclusions) {
            String group = XMLUtil.elementText(exclusion, "groupId");
            String artifact = XMLUtil.elementText(exclusion, "artifactId");
            group = MavenResolver.applyPlaceholders(group, placeholders);
            artifact = MavenResolver.applyPlaceholders(artifact, placeholders);
            parsed.add(new Exclusion(group, artifact));
        }
        return new ExclusionContainer<Exclusion>(ExclusionContainer.ExclusionMode.ANY, parsed, false);
    }

    public void setLogger(@NotNull LoggingAdapter logger) {
        this.logger = Objects.requireNonNull(logger, "logger may not be null.");
    }
}

