/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.mod;

import de.geolykt.starloader.mod.DiscoveredExtension;
import de.geolykt.starloader.mod.Extension;
import de.geolykt.starloader.mod.ExtensionPrototype;
import de.geolykt.starloader.transformers.ASMTransformer;
import de.geolykt.starloader.transformers.ReversibleAccessSetterTransformer;
import de.geolykt.starloader.util.JavaInterop;
import de.geolykt.starloader.util.MirroringURIMavenRepository;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import net.minestom.server.extras.selfmodification.MinestomExtensionClassLoader;
import net.minestom.server.extras.selfmodification.MinestomRootClassLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixins;
import org.stianloader.picoresolve.DependencyLayer;
import org.stianloader.picoresolve.GAV;
import org.stianloader.picoresolve.MavenResolver;
import org.stianloader.picoresolve.Scope;
import org.stianloader.picoresolve.exclusion.ExclusionContainer;
import org.stianloader.picoresolve.repo.MavenRepository;
import org.stianloader.picoresolve.repo.RepositoryAttachedValue;
import org.stianloader.picoresolve.version.MavenVersion;

public class ExtensionManager {
    static final ThreadLocal<Extension.ExtensionDescription> CURRENTLY_LOADED_EXTENSION = new ThreadLocal();
    @ApiStatus.Internal
    public static final Logger LOGGER = LoggerFactory.getLogger(ExtensionManager.class);
    @ApiStatus.AvailableSince(value="4.0.0-a20240601")
    private static final boolean MIRROR_MAVEN_REQUESTS = Boolean.getBoolean("org.stianloader.sll.log.MIRROR_MAVEN_REQUESTS");
    private final Map<String, MinestomExtensionClassLoader> extensionClassloaders = new HashMap<String, MinestomExtensionClassLoader>();
    @NotNull
    private final List<Extension> extensionList = new CopyOnWriteArrayList<Extension>();
    private final Map<String, Extension> extensions = new ConcurrentHashMap<String, Extension>();
    @NotNull
    private final List<Extension> immutableExtensionListView = Collections.unmodifiableList(this.extensionList);
    private boolean loaded;
    @NotNull
    @ApiStatus.AvailableSince(value="4.0.0-a20240601")
    private final Path mavenCacheDir;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public ExtensionManager() {
        this(Paths.get(".picoresolve-cache", new String[0]));
    }

    public ExtensionManager(@NotNull Path mavenCacheDir) {
        this.mavenCacheDir = mavenCacheDir;
    }

    public void loadExtensions(List<@NotNull ? extends ExtensionPrototype> extensionCandidates) {
        if (this.loaded) {
            throw new IllegalStateException("Extensions are already loaded!");
        }
        this.loaded = true;
        List<DiscoveredExtension> discoveredExtensions = this.discoverExtensions(extensionCandidates);
        discoveredExtensions = this.generateLoadOrder(discoveredExtensions);
        assert (discoveredExtensions != null);
        discoveredExtensions.removeIf(ext -> ext.getLoadStatus() != DiscoveredExtension.LoadStatus.LOAD_SUCCESS);
        for (DiscoveredExtension extension : discoveredExtensions) {
            if (extension.loader != null) {
                try {
                    extension.loader.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close leftover classloader for extension {}", (Object)extension.getName(), (Object)e);
                }
                extension.loader = null;
            }
            if (extension.getLoadStatus() != DiscoveredExtension.LoadStatus.LOAD_SUCCESS) continue;
            extension.loader = this.newClassLoader(extension);
        }
        this.setupAccessWideners(discoveredExtensions);
        this.setupCodeModifiers(discoveredExtensions);
        discoveredExtensions.removeIf(ext -> ext.getLoadStatus() != DiscoveredExtension.LoadStatus.LOAD_SUCCESS);
        for (DiscoveredExtension discoveredExtension : discoveredExtensions) {
            if (discoveredExtension == null) continue;
            try {
                this.attemptSingleLoad(discoveredExtension);
            }
            catch (Exception e) {
                discoveredExtension.setLoadStatus(DiscoveredExtension.LoadStatus.LOAD_FAILED);
                e.printStackTrace();
                LOGGER.error("Failed to load extension {}", (Object)discoveredExtension.getName(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Extension attemptSingleLoad(@NotNull DiscoveredExtension discoveredExtension) {
        Constructor<Extension> constructor;
        Class<Extension> extensionClass;
        Class<?> jarClass;
        String extensionName = discoveredExtension.getName();
        String mainClass = discoveredExtension.getEntrypoint();
        Extension.ExtensionDescription extensionDescription = new Extension.ExtensionDescription(extensionName, discoveredExtension.getVersion(), Arrays.asList(discoveredExtension.getAuthors()), discoveredExtension);
        MinestomExtensionClassLoader loader = discoveredExtension.loader;
        if (this.extensions.containsKey(extensionName.toLowerCase(Locale.ROOT))) {
            LOGGER.error("An extension called '{}' has already been registered.", (Object)extensionName);
            return null;
        }
        try {
            jarClass = loader.loadClassAsChild(mainClass.replace('/', '.'), true);
            if (jarClass.getClassLoader() != loader) {
                throw new ClassNotFoundException("Class " + jarClass.getName() + " is loaded by classloader \"" + JavaInterop.getClassloaderName(jarClass.getClassLoader()) + "\", but expected it to be loaded by \"" + JavaInterop.getClassloaderName(loader) + "\"");
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Could not find main class '{}' in extension '{}' with associated URLs '{}'.", new Object[]{mainClass, extensionName, extensionDescription.getOrigin().files, e});
            return null;
        }
        try {
            extensionClass = jarClass.asSubclass(Extension.class);
        }
        catch (ClassCastException e) {
            LOGGER.error("Main class '{}' in '{}' does not extend the 'Extension' superclass. Instead it directly extends '{}' from classloader '{}'", new Object[]{mainClass, extensionName, jarClass.getSuperclass().getName(), JavaInterop.getClassloaderName(jarClass.getSuperclass().getClassLoader()), e});
            return null;
        }
        try {
            constructor = extensionClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Main class '{}' in '{}' does not define a no-args constructor.", new Object[]{mainClass, extensionName, e});
            return null;
        }
        Extension extension = null;
        try {
            CURRENTLY_LOADED_EXTENSION.set(extensionDescription);
            extension = constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            LOGGER.error("Main class '{}' in '{}' cannot be an abstract class.", new Object[]{mainClass, extensionName, e});
            Extension extension2 = null;
            return extension2;
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            LOGGER.error("While instantiating the main class '{}' in '{}' an exception was thrown.", new Object[]{mainClass, extensionName, e.getTargetException()});
            Extension extension3 = null;
            return extension3;
        }
        finally {
            CURRENTLY_LOADED_EXTENSION.set(null);
        }
        for (String dependency : discoveredExtension.getDependencies()) {
            Extension dep = this.extensions.get(dependency.toLowerCase());
            if (dep == null) {
                LOGGER.warn("Dependency {} of {} is null? This means the extension has been loaded without its dependency, which could cause issues later.", (Object)dependency, (Object)discoveredExtension.getName());
                continue;
            }
            dep.getDescription().getDependents().add(discoveredExtension.getName());
        }
        this.extensionList.add(extension);
        this.extensions.put(extensionName.toLowerCase(), extension);
        return extension;
    }

    @NotNull
    private List<DiscoveredExtension> discoverExtensions(List<@NotNull ? extends ExtensionPrototype> extensionCandidates) {
        LinkedList<DiscoveredExtension> extensions = new LinkedList<DiscoveredExtension>();
        for (ExtensionPrototype extensionPrototype : extensionCandidates) {
            if (extensionPrototype.enabled) {
                DiscoveredExtension extension = this.discoverFromPrototype(extensionPrototype);
                if (extension == null) {
                    LOGGER.debug("Ignoring prototype {} as no extension could be discovered from it's registered URLs.", (Object)extensionPrototype);
                    continue;
                }
                if (extension.getLoadStatus() == DiscoveredExtension.LoadStatus.LOAD_SUCCESS) {
                    extensions.add(extension);
                    continue;
                }
                LOGGER.debug("Ignoring prototype {} as discovered failed (load status = " + (Object)((Object)extension.getLoadStatus()) + ").", (Object)extensionPrototype);
                continue;
            }
            LOGGER.trace("Ignoring prototype {} as it is disabled.", (Object)extensionPrototype);
        }
        return extensions;
    }

    @Nullable
    private DiscoveredExtension discoverFromPrototype(@NotNull ExtensionPrototype prototype) {
        DiscoveredExtension discoveredExtension;
        block14: {
            List<URL> urls = prototype.originURLs;
            URLClassLoader discardLoader = MinestomRootClassLoader.getInstance().newChild(urls.toArray(new URL[0]));
            URL resource = discardLoader.findResource("extension.json");
            if (resource == null) {
                throw new IOException("Extension does not have an extension.json file: " + urls);
            }
            InputStream is = resource.openStream();
            try {
                DiscoveredExtension extension = DiscoveredExtension.fromJSON(is, prototype);
                extension.files.addAll(urls);
                DiscoveredExtension.verifyIntegrity(extension);
                discardLoader.close();
                discoveredExtension = extension;
                if (is == null) break block14;
            }
            catch (Throwable extension) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            extension.addSuppressed(throwable);
                        }
                    }
                    throw extension;
                }
                catch (IOException e) {
                    try {
                        discardLoader.close();
                    }
                    catch (IOException e2) {
                        UncheckedIOException unchecked = new UncheckedIOException("Cannot close temporary discard classloader", e2);
                        unchecked.addSuppressed(e);
                        throw unchecked;
                    }
                    e.printStackTrace();
                    return null;
                }
                catch (Throwable t) {
                    try {
                        discardLoader.close();
                    }
                    catch (IOException e) {
                        UncheckedIOException unchecked = new UncheckedIOException("Cannot close temporary discard classloader", e);
                        unchecked.addSuppressed(t);
                        throw unchecked;
                    }
                    throw t;
                }
            }
            is.close();
        }
        return discoveredExtension;
    }

    @Nullable
    private List<DiscoveredExtension> generateLoadOrder(@NotNull List<DiscoveredExtension> discoveredExtensions) {
        List loadableExtensions;
        HashMap<String, DiscoveredExtension> extensionMap = new HashMap<String, DiscoveredExtension>();
        HashMap<DiscoveredExtension, List> dependencyMap = new HashMap<DiscoveredExtension, List>();
        for (DiscoveredExtension discoveredExtension : discoveredExtensions) {
            extensionMap.put(discoveredExtension.getName().toLowerCase(), discoveredExtension);
        }
        for (DiscoveredExtension discoveredExtension : discoveredExtensions) {
            List dependencies = Arrays.stream(discoveredExtension.getDependencies()).map(dependencyName -> {
                DiscoveredExtension dependencyExtension = (DiscoveredExtension)extensionMap.get(dependencyName.toLowerCase());
                if (dependencyExtension == null) {
                    if (this.extensions.containsKey(dependencyName.toLowerCase(Locale.ROOT))) {
                        return this.extensions.get(dependencyName.toLowerCase(Locale.ROOT)).getDescription().getOrigin();
                    }
                    LOGGER.error("Extension {} requires an extension called {}.", (Object)discoveredExtension.getName(), dependencyName);
                    LOGGER.error("However the extension {} could not be found.", dependencyName);
                    LOGGER.error("Therefore {} will not be loaded.", (Object)discoveredExtension.getName());
                    discoveredExtension.setLoadStatus(DiscoveredExtension.LoadStatus.MISSING_DEPENDENCIES);
                }
                return (DiscoveredExtension)extensionMap.get(dependencyName.toLowerCase());
            }).collect(Collectors.toList());
            if (dependencies.contains(null)) continue;
            dependencyMap.put(discoveredExtension, dependencies);
        }
        LinkedList<DiscoveredExtension> sortedList = new LinkedList<DiscoveredExtension>();
        while (!(loadableExtensions = dependencyMap.entrySet().stream().filter(entry -> this.areAllDependenciesLoaded((List)entry.getValue())).collect(Collectors.toList())).isEmpty()) {
            for (Map.Entry entry2 : loadableExtensions) {
                sortedList.add((DiscoveredExtension)entry2.getKey());
                dependencyMap.remove(entry2.getKey());
                dependencyMap.forEach((key, dependencyList) -> dependencyList.remove(entry2.getKey()));
            }
        }
        if (!dependencyMap.isEmpty()) {
            LOGGER.error("SLL found {} cyclic mods.", (Object)dependencyMap.size());
            LOGGER.error("Cyclic mods depend on each other and can therefore not be loaded.");
            for (Map.Entry entry3 : dependencyMap.entrySet()) {
                DiscoveredExtension discoveredExtension = (DiscoveredExtension)entry3.getKey();
                LOGGER.error("{} could not be loaded, as it depends on: {}.", (Object)discoveredExtension.getName(), (Object)((List)entry3.getValue()).stream().map(DiscoveredExtension::getName).collect(Collectors.joining(", ")));
            }
        }
        return sortedList;
    }

    private boolean areAllDependenciesLoaded(List<DiscoveredExtension> dependencies) {
        return dependencies.isEmpty() || dependencies.stream().allMatch(ext -> this.extensions.containsKey(ext.getName().toLowerCase()));
    }

    @NotNull
    public MinestomExtensionClassLoader newClassLoader(@NotNull DiscoveredExtension extension) {
        MinestomRootClassLoader root = MinestomRootClassLoader.getInstance();
        MinestomExtensionClassLoader loader = new MinestomExtensionClassLoader(extension.getName(), extension.files.toArray(new URL[0]), root);
        DiscoveredExtension.ExternalDependencies dependencies = extension.getExternalDependencies();
        if (dependencies != null) {
            ArrayList<DependencyLayer.DependencyEdge> dependencyEdges = new ArrayList<DependencyLayer.DependencyEdge>();
            for (DiscoveredExtension.ExternalDependencyArtifact externalDependencyArtifact : dependencies.getArtifacts()) {
                dependencyEdges.add(new DependencyLayer.DependencyEdge(externalDependencyArtifact.getGroup(), externalDependencyArtifact.getArtifact(), externalDependencyArtifact.getClassifier(), externalDependencyArtifact.getExtension(), externalDependencyArtifact.getVersion(), Scope.RUNTIME, externalDependencyArtifact.getExclusions()));
            }
            if (!dependencyEdges.isEmpty()) {
                Set paths;
                MavenResolver resolver = new MavenResolver(this.mavenCacheDir);
                for (DiscoveredExtension.ExternalRepository repo : dependencies.getRepositories()) {
                    Path mirrorOut;
                    Path path = mirrorOut = repo.isMirrorable() && MIRROR_MAVEN_REQUESTS ? this.mavenCacheDir.resolve(".mirror-out") : null;
                    if (repo.isMirrorOnly() && !MIRROR_MAVEN_REQUESTS) continue;
                    resolver.addRepository((MavenRepository)new MirroringURIMavenRepository(repo.getName(), URI.create(repo.getUrl()), mirrorOut));
                }
                GAV gAV = new GAV("sll-virtual-dependency", extension.getName(), MavenVersion.parse((String)extension.getVersion()));
                DependencyLayer.DependencyLayerElement virtualElement = new DependencyLayer.DependencyLayerElement(gAV, null, null, ExclusionContainer.empty(), dependencyEdges);
                DependencyLayer layer = new DependencyLayer(null, Collections.singletonList(virtualElement));
                Executor executor = Objects.requireNonNull(ForkJoinPool.commonPool());
                try {
                    resolver.resolveAllChildren(layer, executor).get(60L, TimeUnit.SECONDS);
                }
                catch (CompletionException | ExecutionException e) {
                    LOGGER.error("Unable to fetch remote dependencies of extension {} v{}.", (Object)extension.getName(), (Object)extension.getVersion());
                    throw new RuntimeException("Unable to fetch remote dependencies of extension " + extension.getName() + ", version " + extension.getVersion(), e);
                }
                catch (InterruptedException | TimeoutException e) {
                    LOGGER.error("Unable to fetch remote dependencies of extension {} v{} (timed out. Extensions have a maximum of 60 seconds to resolve remove dependencies).", (Object)extension.getName(), (Object)extension.getVersion());
                    throw new RuntimeException("Unable to fetch remote dependencies of extension " + extension.getName() + ", version " + extension.getVersion() + ": Timed out", e);
                }
                CompletionStage combined = CompletableFuture.completedFuture(ConcurrentHashMap.newKeySet());
                ArrayList<GAV> dependencyGAVs = new ArrayList<GAV>();
                for (layer = layer.getChild(); layer != null; layer = layer.getChild()) {
                    for (DependencyLayer.DependencyLayerElement element : layer.elements) {
                        dependencyGAVs.add(element.gav);
                        CompletableFuture download = resolver.download(element.gav, element.classifier, element.type, executor);
                        combined = combined.thenCombine((CompletionStage)download, (set, downloadResult) -> {
                            set.add(downloadResult);
                            return set;
                        });
                    }
                }
                try {
                    paths = combined.get(60L, TimeUnit.SECONDS);
                }
                catch (CompletionException | ExecutionException e) {
                    LOGGER.error("Unable to download remote dependencies of extension {} v{}. Requested GAVs: {}", new Object[]{extension.getName(), extension.getVersion(), dependencyGAVs});
                    throw new RuntimeException("Unable to download remote dependencies of extension " + extension.getName() + ", version " + extension.getVersion(), e);
                }
                catch (InterruptedException | TimeoutException e) {
                    LOGGER.error("Unable to download remote dependencies of extension {} v{} (timed out. Extensions have a maximum of 60 seconds to resolve remove dependencies). Requested GAVs: {}", new Object[]{extension.getName(), extension.getVersion(), dependencyGAVs});
                    throw new RuntimeException("Unable to download remote dependencies of extension " + extension.getName() + ", version " + extension.getVersion() + ": Timed out", e);
                }
                for (RepositoryAttachedValue value : paths) {
                    String repoId = "null (cached in maven local, but without a known maven repository)";
                    MavenRepository repo = value.getRepository();
                    if (repo != null) {
                        repoId = repo.getRepositoryId();
                    }
                    LOGGER.debug("Adding {} to the classpath of extension '{}' v{}. The dependency was found in repository '{}'", new Object[]{value.getValue(), extension.getName(), extension.getVersion(), repoId});
                    try {
                        loader.addURL(((Path)value.getValue()).toUri().toURL());
                    }
                    catch (MalformedURLException e) {
                        LOGGER.warn("Failed to add {} to the classpath of extension '{}' v{}. The dependency was found in repository '{}'", new Object[]{value.getValue(), extension.getName(), extension.getVersion(), repoId, e});
                    }
                }
            }
        }
        if (extension.getDependencies().length == 0) {
            root.addChild(loader);
        } else {
            boolean missedOne = false;
            for (String dependency : extension.getDependencies()) {
                MinestomExtensionClassLoader parent = this.extensionClassloaders.get(dependency.toLowerCase(Locale.ROOT));
                if (parent != null) {
                    parent.addChild(loader);
                    continue;
                }
                missedOne = true;
            }
            if (missedOne) {
                LOGGER.error("Could not load extension '{}' as it was not possible to find any of the following parents in the classloader hierarchy: {}. Following classloaders are currently registered: {}", new Object[]{extension.getName(), Arrays.toString(extension.getDependencies()), this.extensionClassloaders.keySet()});
                throw new RuntimeException("Could not load extension " + extension.getName() + " as it was not possible find any of the following parents inside classloader hierarchy (this indicates a likely issue with SLL internals): " + Arrays.toString(extension.getDependencies()));
            }
        }
        this.extensionClassloaders.put(extension.getName().toLowerCase(Locale.ROOT), loader);
        return loader;
    }

    @NotNull
    public List<Extension> getExtensions() {
        return this.immutableExtensionListView;
    }

    @Nullable
    public Extension getExtension(@NotNull String name) {
        return this.extensions.get(name.toLowerCase());
    }

    private void setupAccessWideners(List<DiscoveredExtension> extensionsToLoad) {
        for (DiscoveredExtension extension : extensionsToLoad) {
            if (extension.getLoadStatus() != DiscoveredExtension.LoadStatus.LOAD_SUCCESS || extension.getAccessWidener().equals("")) continue;
            URL entry = extension.loader.findResource(extension.getAccessWidener());
            if (entry == null) {
                LOGGER.warn("Unable to find the access widener file for extension {}!", (Object)extension.getName());
                continue;
            }
            try {
                InputStream awFile = entry.openStream();
                try {
                    MinestomRootClassLoader.getInstance().readAccessWidener(awFile);
                }
                finally {
                    if (awFile == null) continue;
                    awFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.warn("Failed to set up an access widener for {}!", (Object)extension.getName());
            }
        }
        ReversibleAccessSetterTransformer transformer = null;
        for (ASMTransformer asmTransformer : MinestomRootClassLoader.getInstance().getTransformers()) {
            if (!(asmTransformer instanceof ReversibleAccessSetterTransformer)) continue;
            transformer = (ReversibleAccessSetterTransformer)asmTransformer;
            break;
        }
        if (transformer == null) {
            transformer = new ReversibleAccessSetterTransformer();
            MinestomRootClassLoader.getInstance().addASMTransformer(transformer);
        }
        for (DiscoveredExtension extension : extensionsToLoad) {
            BufferedReader br;
            InputStreamReader isr;
            InputStream rasFile;
            if (extension.getLoadStatus() != DiscoveredExtension.LoadStatus.LOAD_SUCCESS || extension.getReversibleAccessSetter().isEmpty()) continue;
            URL entry = extension.loader.findResource(extension.getReversibleAccessSetter());
            if (entry == null) {
                LOGGER.warn("Unable to find the reversible access setter file for extension {}!", (Object)extension.getName());
                continue;
            }
            try {
                rasFile = entry.openStream();
                try {
                    isr = new InputStreamReader(rasFile, StandardCharsets.UTF_8);
                    try {
                        br = new BufferedReader(isr);
                        try {
                            transformer.getReverseContext().read(extension.getName(), br, true);
                        }
                        finally {
                            br.close();
                        }
                    }
                    finally {
                        isr.close();
                    }
                }
                finally {
                    if (rasFile != null) {
                        rasFile.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.warn("Failed to set up the reversed reversible access setter for {}!", (Object)extension.getName());
                continue;
            }
            try {
                rasFile = entry.openStream();
                try {
                    isr = new InputStreamReader(rasFile, StandardCharsets.UTF_8);
                    try {
                        br = new BufferedReader(isr);
                        try {
                            transformer.getMainContext().read(extension.getName(), br, false);
                        }
                        finally {
                            br.close();
                        }
                    }
                    finally {
                        isr.close();
                    }
                }
                finally {
                    if (rasFile == null) continue;
                    rasFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.warn("Failed to set up the standard reversible access setter for {}!", (Object)extension.getName());
            }
        }
    }

    private void setupCodeModifiers(@NotNull List<DiscoveredExtension> extensions) {
        ClassLoader cl = this.getClass().getClassLoader();
        if (!(cl instanceof MinestomRootClassLoader)) {
            cl = MinestomRootClassLoader.getInstance();
        }
        MinestomRootClassLoader modifiableClassLoader = (MinestomRootClassLoader)cl;
        LOGGER.info("Start loading code modifiers...");
        for (DiscoveredExtension extension : extensions) {
            try {
                for (String codeModifierClass : extension.getCodeModifiers()) {
                    modifiableClassLoader.loadModifier(extension.loader, codeModifierClass);
                }
                if (extension.getMixinConfig().isEmpty()) continue;
                String mixinConfigFile = extension.getMixinConfig();
                Mixins.addConfiguration((String)mixinConfigFile);
                LOGGER.info("Found mixin in extension {}: {}", (Object)extension.getName(), (Object)mixinConfigFile);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load code modifier for extension in files: {}", extension.files, (Object)e);
            }
        }
        LOGGER.info("Done loading code modifiers.");
    }

    private void unload(Extension ext) {
        ext.preTerminate();
        ext.terminate();
        ext.postTerminate();
        ext.unload();
        for (Extension e : this.extensionList) {
            e.getDescription().getDependents().remove(ext.getDescription().getName());
        }
        String id = ext.getDescription().getName().toLowerCase(Locale.ROOT);
        this.extensions.remove(id);
        this.extensionList.remove(ext);
        MinestomExtensionClassLoader classloader = this.extensionClassloaders.remove(id);
        try {
            if (classloader != null) {
                classloader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MinestomExtensionClassLoader modifierClassloader = ext.getDescription().getOrigin().loader;
        if (modifierClassloader != null) {
            try {
                modifierClassloader.close();
            }
            catch (IOException e) {
                LOGGER.error("Unable to close extension codemodifier classloader", (Throwable)e);
            }
            ext.getDescription().getOrigin().loader = null;
        }
    }

    public void reload(String extensionName) {
        Extension ext = this.extensions.get(extensionName.toLowerCase());
        if (ext == null) {
            throw new IllegalArgumentException("Extension " + extensionName + " is not currently loaded.");
        }
        LOGGER.info("Reload extension {}", (Object)extensionName);
        LinkedList<String> dependents = new LinkedList<String>(ext.getDescription().getDependents());
        LinkedList<@NotNull ExtensionPrototype> dependentsPrototypes = new LinkedList<ExtensionPrototype>();
        for (String dependentID : dependents) {
            Extension dependentExt = this.extensions.get(dependentID.toLowerCase());
            dependentsPrototypes.add(dependentExt.getDescription().getOrigin().getSourcePrototype());
            LOGGER.info("Unloading dependent extension {} (because it depends on {})", (Object)dependentID, (Object)extensionName);
            this.unload(dependentExt);
        }
        LOGGER.info("Unloading extension {}", (Object)extensionName);
        this.unload(ext);
        LinkedList<DiscoveredExtension> extensionsToReload = new LinkedList<DiscoveredExtension>();
        LOGGER.info("Rediscovering extension {}", (Object)extensionName);
        DiscoveredExtension rediscoveredExtension = this.discoverFromPrototype(ext.getDescription().getOrigin().getSourcePrototype());
        extensionsToReload.add(rediscoveredExtension);
        for (ExtensionPrototype dependentPrototype : dependentsPrototypes) {
            LOGGER.info("Rediscover dependent extension prototype '{}' (depends on {})", (Object)dependentPrototype, (Object)extensionName);
            extensionsToReload.add(this.discoverFromPrototype(dependentPrototype));
        }
        this.loadExtensionList(extensionsToReload);
    }

    private boolean loadExtensionList(@NotNull List<DiscoveredExtension> extensionsToLoad) {
        this.generateLoadOrder(extensionsToLoad);
        for (DiscoveredExtension extension : extensionsToLoad) {
            if (extension.loader != null) {
                try {
                    extension.loader.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close leftover classloader for extension {}", (Object)extension.getName(), (Object)e);
                }
                extension.loader = null;
            }
            if (extension.getLoadStatus() != DiscoveredExtension.LoadStatus.LOAD_SUCCESS) continue;
            extension.loader = this.newClassLoader(extension);
        }
        this.setupAccessWideners(extensionsToLoad);
        this.setupCodeModifiers(extensionsToLoad);
        LinkedList<Extension> newExtensions = new LinkedList<Extension>();
        for (DiscoveredExtension toReload : extensionsToLoad) {
            LOGGER.info("Actually load extension {}", (Object)toReload.getName());
            Extension loadedExtension = this.attemptSingleLoad(toReload);
            if (loadedExtension == null) continue;
            newExtensions.add(loadedExtension);
        }
        if (newExtensions.isEmpty()) {
            LOGGER.error("No extensions to load, skipping callbacks");
            return false;
        }
        LOGGER.info("Load complete, firing preinit, init and then postinit callbacks");
        newExtensions.forEach(Extension::preInitialize);
        newExtensions.forEach(Extension::initialize);
        newExtensions.forEach(Extension::postInitialize);
        return true;
    }

    public void unloadExtension(String extensionName) {
        Extension ext = this.extensions.get(extensionName.toLowerCase());
        if (ext == null) {
            throw new IllegalArgumentException("Extension " + extensionName + " is not currently loaded.");
        }
        LinkedList<String> dependents = new LinkedList<String>(ext.getDescription().getDependents());
        for (String dependentID : dependents) {
            Extension dependentExt = this.extensions.get(dependentID.toLowerCase());
            LOGGER.info("Unloading dependent extension {} (because it depends on {})", (Object)dependentID, (Object)extensionName);
            this.unload(dependentExt);
        }
        LOGGER.info("Unloading extension {}", (Object)extensionName);
        this.unload(ext);
        System.gc();
    }

    public void shutdown() {
        this.extensionList.forEach(this::unload);
    }
}

