/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.stianloader.picoresolve.internal.ConfusedResolverException;
import org.stianloader.picoresolve.internal.JavaInterop;
import org.stianloader.picoresolve.version.MavenVersionPart;
import org.stianloader.picoresolve.version.NumericVersionPart;
import org.stianloader.picoresolve.version.PrereleaseVersionPart;
import org.stianloader.picoresolve.version.QualifierVersionPart;

public class MavenVersion
implements Comparable<MavenVersion> {
    private final List<MavenVersionPart> parts;
    private final String origin;

    private MavenVersion(String origin, List<MavenVersionPart> parts) {
        this.parts = Collections.unmodifiableList(new ArrayList<MavenVersionPart>(parts));
        this.origin = origin;
    }

    @NotNull
    public static MavenVersion parse(@NotNull String string) {
        List<String> tokens = MavenVersion.purgeTokens(MavenVersion.splitTokens(string));
        if (tokens.isEmpty()) {
            return new MavenVersion(string, Arrays.asList(new MavenVersionPart[0]));
        }
        ArrayList<MavenVersionPart> parts = new ArrayList<MavenVersionPart>();
        int prefix = 45;
        Iterator<String> it = tokens.iterator();
        while (it.hasNext()) {
            String token = it.next();
            try {
                parts.add(new NumericVersionPart(prefix, Integer.valueOf(token)));
            }
            catch (NumberFormatException nfe) {
                switch (token) {
                    case "alpha": 
                    case "beta": 
                    case "milestone": 
                    case "rc": 
                    case "cr": 
                    case "snapshot": 
                    case "final": 
                    case "ga": 
                    case "sp": {
                        parts.add(new PrereleaseVersionPart(prefix, token));
                        break;
                    }
                    default: {
                        parts.add(new QualifierVersionPart(prefix, token));
                    }
                }
            }
            if (!it.hasNext()) continue;
            String x = it.next();
            if (x.length() != 1) {
                throw new ConfusedResolverException("Got string \"" + x + "\" from the iterator");
            }
            prefix = x.codePointAt(0);
        }
        return new MavenVersion(string, parts);
    }

    private static List<String> purgeTokens(List<String> tokens) {
        boolean trimMode = true;
        boolean trimFromEnd = true;
        for (int i = tokens.size() - 1; i >= 0; --i) {
            String token = tokens.get(i);
            if (trimMode && (token.equals("0") || token.equals("final") || token.equals("ga") || token.equals(".") || trimFromEnd && token.equals("-"))) {
                tokens.remove(i);
            } else if (!token.equals("-")) {
                trimMode = false;
            }
            if (!token.equals("-")) continue;
            if (trimMode && !trimFromEnd) {
                tokens.add(i + 1, "0");
            }
            trimMode = true;
            trimFromEnd = false;
        }
        if (trimMode && !trimFromEnd) {
            tokens.add(0, "0");
        }
        return tokens;
    }

    private static List<String> splitTokens(String versionString) {
        versionString = versionString.toLowerCase(Locale.ROOT);
        int[] codepoints = versionString.codePoints().toArray();
        ArrayList<String> tokens = new ArrayList<String>();
        int lastSeperator = -1;
        boolean wasDigit = false;
        for (int i = 0; i < codepoints.length; ++i) {
            int codepoint = codepoints[i];
            if (codepoint == 45 || codepoint == 46) {
                int len = i - (lastSeperator + 1);
                if (len == 0) {
                    tokens.add("0");
                } else {
                    tokens.add(versionString.substring(lastSeperator + 1, i));
                }
                tokens.add(JavaInterop.codepointToString(codepoint));
                lastSeperator = i;
            } else if (lastSeperator + 1 != i) {
                if (!wasDigit) {
                    if (Character.isDigit(codepoint)) {
                        String token = versionString.substring(lastSeperator + 1, i);
                        if (token.length() == 1) {
                            if (token.equals("a")) {
                                token = "alpha";
                            } else if (token.equals("b")) {
                                token = "beta";
                            } else if (token.equals("m")) {
                                token = "milestone";
                            }
                        }
                        tokens.add(token);
                        tokens.add("-");
                        lastSeperator = i - 1;
                    }
                } else if (!Character.isDigit(codepoint)) {
                    tokens.add(versionString.substring(lastSeperator + 1, i));
                    tokens.add("-");
                    lastSeperator = i - 1;
                }
            }
            wasDigit = Character.isDigit(codepoint);
        }
        if (lastSeperator + 1 != versionString.length()) {
            tokens.add(versionString.substring(lastSeperator + 1, versionString.length()));
        }
        return tokens;
    }

    @Override
    public int compareTo(MavenVersion o) {
        int maxIndex = Math.min(this.parts.size(), o.parts.size());
        for (int i = 0; i < maxIndex; ++i) {
            int cmp = this.parts.get(i).compareTo(o.parts.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        if (this.parts.size() == o.parts.size()) {
            return 0;
        }
        if (this.parts.size() < o.parts.size()) {
            MavenVersionPart part = o.parts.get(this.parts.size());
            if (part instanceof NumericVersionPart || part instanceof QualifierVersionPart) {
                return -1;
            }
            return -part.compareTo(new PrereleaseVersionPart(part.getPrefixCodepoint(), ""));
        }
        if (this.parts.size() > o.parts.size()) {
            MavenVersionPart part = this.parts.get(o.parts.size());
            if (part instanceof NumericVersionPart || part instanceof QualifierVersionPart) {
                return 1;
            }
            return part.compareTo(new PrereleaseVersionPart(part.getPrefixCodepoint(), ""));
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.origin);
        builder.append(" [Interpreted as ");
        StringBuilder builder2 = new StringBuilder();
        for (MavenVersionPart part : this.parts) {
            builder2.append(part.toString());
        }
        if (builder2.length() != 0) {
            builder2.deleteCharAt(0);
            builder.append((CharSequence)builder2);
        }
        builder.append(']');
        return builder.toString();
    }

    public boolean isNewerThan(MavenVersion older) {
        return this.compareTo(older) > 0;
    }

    public int hashCode() {
        StringBuilder builder2 = new StringBuilder();
        for (MavenVersionPart part : this.parts) {
            builder2.append(part.toString());
        }
        return builder2.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MavenVersion) {
            MavenVersion other = (MavenVersion)obj;
            if (other.parts.size() != this.parts.size()) {
                return false;
            }
            for (int i = 0; i < other.parts.size(); ++i) {
                if (other.parts.get(i).stringifyContent().equals(this.parts.get(i).stringifyContent())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getOriginText() {
        return this.origin;
    }
}

