/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.logging.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.stianloader.picoresolve.logging.LoggingAdapter;

class JULLogAdapter
extends LoggingAdapter {
    JULLogAdapter() {
    }

    @NotNull
    @Contract(pure=false, mutates="param1", value="!null, _, _ -> param1")
    private static String createMessage(String message, Object ... args) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            int replaceHead = message.indexOf("{}");
            if (replaceHead == -1) {
                builder.append(message);
                message = "";
                if (i == args.length - 1 && args[i] instanceof Throwable) {
                    builder.append('\n');
                    StringWriter sw = new StringWriter();
                    ((Throwable)args[i]).printStackTrace(new PrintWriter(sw));
                    builder.append(sw.toString());
                    continue;
                }
                builder.append(Objects.toString(args[i]));
                continue;
            }
            builder.append(message.subSequence(0, replaceHead)).append(Objects.toString(args[i]));
            message = message.substring(replaceHead + 2);
        }
        builder.append(message);
        return builder.toString();
    }

    @Override
    public void debug(Class<?> clazz, String message, Object ... args) {
        Logger.getLogger(clazz.getName()).fine(() -> JULLogAdapter.createMessage(message, args));
    }

    @Override
    public void error(Class<?> clazz, String message, Object ... args) {
        Logger.getLogger(clazz.getName()).severe(() -> JULLogAdapter.createMessage(message, args));
    }

    @Override
    public void info(Class<?> clazz, String message, Object ... args) {
        Logger.getLogger(clazz.getName()).info(() -> JULLogAdapter.createMessage(message, args));
    }

    @Override
    public void warn(Class<?> clazz, String message, Object ... args) {
        Logger.getLogger(clazz.getName()).warning(() -> JULLogAdapter.createMessage(message, args));
    }
}

