/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.ras;

import de.geolykt.starloader.ras.AccessUtil;
import de.geolykt.starloader.ras.JavaInterop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTinyRASRemapper
implements OutputConsumerPath.ResourceRemapper {
    protected Logger getLogger() {
        return LoggerFactory.getLogger(AbstractTinyRASRemapper.class);
    }

    /*
     * Unable to fully structure code
     */
    protected void remapRAS(@NotNull BufferedReader reader, BufferedWriter bw, String namespace, TinyRemapper tinyRemapper) throws IOException {
        remapper = tinyRemapper.getEnvironment().getRemapper();
        header = reader.readLine();
        lineNumber = 1;
        while (header != null && (JavaInterop.isBlank(header) || header.codePointAt(0) == 35)) {
            bw.write(header);
            bw.newLine();
            header = reader.readLine();
            ++lineNumber;
        }
        if (header == null) {
            throw new IOException("Input stream exhausted before reaching RAS header for namespace " + namespace + ".");
        }
        bw.write(header);
        bw.newLine();
        if (!header.startsWith("RAS")) {
            throw new IOException("Malformed ReversibleAccessSetter header of namespace " + namespace + ": Syntax error at line " + lineNumber + ": RAS header should begin with \"RAS\"");
        }
        headerSplits = header.split("\\s+");
        if (headerSplits.length != 3) {
            throw new IOException("Malformed ReversibleAccessSetter of namespace " + namespace + ": Syntax error at line " + lineNumber + ": Expected format \"RAS <format-version> <format-dialect>\".");
        }
        requestedFormatVersion = headerSplits[1];
        requestedDialect = headerSplits[2];
        if (!(requestedFormatVersion.equals("v1") || requestedFormatVersion.equals("1") || requestedFormatVersion.equals("v1.0") || requestedFormatVersion.equals("1.1"))) {
            throw new IOException("ReversibleAccessSetter of namespace " + namespace + " has format version " + requestedFormatVersion + ", but this RAS implementation only supports one of ['1', 'v1', '1.1', 'v1.1'].");
        }
        if (!requestedDialect.equals("std") && !requestedDialect.equals("starrian")) {
            throw new IOException("ReversibleAccessSetter of namespace " + namespace + " has format dialect " + requestedDialect + ", but this RAS implementation only supports one of ['std', 'starrian'].");
        }
        ++lineNumber;
        line = reader.readLine();
        while (line != null) {
            block14: {
                block24: {
                    block25: {
                        block22: {
                            block23: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                block16: {
                                                    block17: {
                                                        block15: {
                                                            block13: {
                                                                if (!JavaInterop.isBlank(line) && line.codePointAt(0) != 35) break block13;
                                                                bw.write(line);
                                                                bw.newLine();
                                                                break block14;
                                                            }
                                                            if (line.length() >= 9) break block15;
                                                            this.getLogger().error("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace \"" + namespace + "\": The smallest possible line length is 9 characters, but got " + line.length() + " chars instead.");
                                                            break block14;
                                                        }
                                                        prefix = line.codePointAt(0);
                                                        if (Character.isWhitespace(prefix) || prefix == 64 || prefix == 33) break block16;
                                                        if (Character.isWhitespace(line.codePointAt(1)) != false && (prefix == 97 || prefix == 98 || prefix == 114) || Character.isWhitespace(line.codePointAt(3)) != false && line.startsWith("all") != false || Character.isWhitespace(line.codePointAt(5)) != false && line.startsWith("build") != false || Character.isWhitespace(line.codePointAt(7)) && line.startsWith("runtime")) break block17;
                                                        this.getLogger().error("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace \"" + namespace + "\": Invalid prefix " + JavaInterop.codepointToString(prefix) + ".");
                                                        break block14;
                                                    }
                                                    this.getLogger().warn("Malformed ReversibleAccessSetter transform in line {} of namespace \"{}\": Special prefixes are not optional according to the spec. Consider resolving this issue to prevent failures in other RAS implementations.", (Object)lineNumber, (Object)namespace);
                                                    line = ' ' + line;
                                                    prefix = 32;
                                                }
                                                if (Character.isWhitespace(prefix)) {
                                                    line = '0' + line.substring(1);
                                                }
                                                if ((parts = (line = line.trim()).split("\\s+")).length == 4 || parts.length == 6) break block18;
                                                this.getLogger().error("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": Expected format \"<prefix>scope <original-access> <target-access> <className>\" or \"<prefix>scope <original-access> <target-access> <className> <memberName> <memberDescriptor>\". (Consists of " + parts.length + " parts, but expected 4 or 6 parts)");
                                                break block14;
                                            }
                                            scope = parts[0].substring(1);
                                            if (!scope.isEmpty()) break block19;
                                            this.getLogger().error("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": Empty scope");
                                            break block14;
                                        }
                                        if (scope.equals("a") || scope.equals("all") || scope.equals("b") || scope.equals("build") || scope.equals("r") || scope.equals("runtime")) break block20;
                                        this.getLogger().error("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": Unknown scope \"" + scope + "\". Make sure you use the right dialect!");
                                        break block14;
                                    }
                                    leftAccess = AccessUtil.parseAccess(parts[1]);
                                    rightAccess = AccessUtil.parseAccess(parts[2]);
                                    leftAccessType = AccessUtil.getAccessCategory(parts[1]);
                                    rightAccessType = AccessUtil.getAccessCategory(parts[2]);
                                    if (leftAccess != 0 && rightAccess != 0) {
                                        visibilityUnchanging = (leftAccess & 7) == 0;
                                        if (visibilityUnchanging != ((rightAccess & 7) == 0)) {
                                            throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": Incompatible accesses.");
                                        }
                                        if (visibilityUnchanging && leftAccess != rightAccess) {
                                            throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": Incompatible accesses.");
                                        }
                                    }
                                    if (leftAccessType != 3 && rightAccessType != 3) break block21;
                                    this.getLogger().error("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": This access can only be applied on module-info.class entries, which cannot be changed by RAS as of v1.0.");
                                    break block14;
                                }
                                className = remapper.map(parts[3]);
                                if (parts.length != 4) break block22;
                                if ((leftAccessType == -1 || leftAccessType == 0) && (rightAccessType == -1 || rightAccessType == 0)) break block23;
                                this.getLogger().error("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": This access cannot be applied on classes.");
                                break block14;
                            }
                            line = JavaInterop.codepointToString(prefix) + scope + " " + parts[1] + " " + parts[2] + " " + className;
                            ** GOTO lbl102
                        }
                        memberName = parts[4];
                        memberDesc = parts[5];
                        if (memberDesc.codePointAt(0) != 40) break block24;
                        if ((leftAccessType == -1 || leftAccessType == 2) && (rightAccessType == -1 || rightAccessType == 2)) break block25;
                        this.getLogger().error("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": This access cannot be applied on methods.");
                        break block14;
                    }
                    memberName = remapper.mapMethodName(parts[3], memberName, memberDesc);
                    memberDesc = remapper.mapMethodDesc(memberDesc);
                    ** GOTO lbl101
                }
                if (leftAccessType != -1 && leftAccessType != 1 || rightAccessType != -1 && rightAccessType != 1) {
                    this.getLogger().error("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": This access cannot be applied on fields.");
                } else {
                    memberName = remapper.mapFieldName(parts[3], memberName, memberDesc);
                    memberDesc = remapper.mapDesc(memberDesc);
lbl101:
                    // 2 sources

                    line = JavaInterop.codepointToString(prefix) + scope + " " + parts[1] + " " + parts[2] + " " + className + " " + memberName + " " + memberDesc;
lbl102:
                    // 2 sources

                    bw.write(line);
                    bw.newLine();
                }
            }
            line = reader.readLine();
            ++lineNumber;
        }
    }

    public void transform(Path destinationDirectory, Path relativePath, InputStream input, TinyRemapper remapper) throws IOException {
        if (relativePath == null) {
            throw new NullPointerException("relativePath was null");
        }
        Path outputFile = destinationDirectory.resolve(relativePath);
        Path outputDir = outputFile.getParent();
        if (outputDir != null) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        try (BufferedWriter out = Files.newBufferedWriter(outputFile, new OpenOption[0]);
             BufferedReader in = new BufferedReader(new InputStreamReader(input));){
            this.remapRAS(in, out, relativePath.toString(), remapper);
        }
    }
}

