/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.transformers;

import de.geolykt.starloader.transformers.ASMTransformer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarplaneAnnotationsInlineTransformer
extends ASMTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarplaneAnnotationsInlineTransformer.class);

    @Override
    public boolean accept(@NotNull ClassNode node) {
        HashMap<MemberTriple, MemberTriple> memberMapRequests = new HashMap<MemberTriple, MemberTriple>();
        HashMap<MemberTriple, String> memberMapFormat = new HashMap<MemberTriple, String>();
        HashMap<MemberTriple, String> classMapRequests = new HashMap<MemberTriple, String>();
        boolean transformed = false;
        block0: for (FieldNode field : node.fields) {
            List<AnnotationNode> annotations = field.invisibleAnnotations;
            if (annotations == null) continue;
            Iterator it = annotations.iterator();
            while (it.hasNext()) {
                String typeName;
                AnnotationNode annotation = (AnnotationNode)it.next();
                if (annotation.desc.equals("Lde/geolykt/starloader/starplane/annotations/StarplaneReobfuscateReference;")) {
                    it.remove();
                    transformed = true;
                    continue block0;
                }
                if (annotation.desc.equals("Lde/geolykt/starloader/starplane/annotations/RemapClassReference;")) {
                    it.remove();
                    transformed = true;
                    if (annotation.values == null || annotation.values.size() == 0) {
                        LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapClassReference, but neither the 'name' nor the 'type' value of the annotation is set.", node.name, field.name, field.desc);
                        continue block0;
                    }
                    if (annotation.values.size() == 4) {
                        LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapClassReference, but both the 'name' and the 'type' value of the annotation is set. Consider only setting one of these values.", node.name, field.name, field.desc);
                        continue block0;
                    }
                    if (annotation.values.get(0).equals("name")) {
                        typeName = ((String)annotation.values.get(0)).replace('.', '/');
                    } else if (annotation.values.get(0).equals("type")) {
                        typeName = ((Type)annotation.values.get(1)).getInternalName();
                    } else {
                        LOGGER.error("Erroneous annotation value: " + annotation.values.get(0) + " for RemapClassReference. Are you depending on the wrong starplane-annotations version?");
                        continue block0;
                    }
                    classMapRequests.put(new MemberTriple(node.name, field.name, field.desc), typeName);
                    continue;
                }
                if (!annotation.desc.equals("Lde/geolykt/starloader/starplane/annotations/RemapMemberReference;")) continue;
                it.remove();
                if (annotation.values == null) {
                    LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapMemberReference, but does not define any of the required values.", node.name, field.name, field.desc);
                    continue block0;
                }
                if (annotation.values.size() >= 10) {
                    LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapMemberReference, but more than the required values of the annotation is set. Consider removing duplicates.", node.name, field.name, field.desc);
                    continue block0;
                }
                typeName = null;
                String memberName = null;
                String memberDesc = null;
                String format = null;
                for (int i = 0; i < annotation.values.size(); i += 2) {
                    String valueName = (String)annotation.values.get(i);
                    if (valueName.equals("ownerType")) {
                        typeName = ((Type)annotation.values.get(i + 1)).getInternalName();
                        continue;
                    }
                    if (valueName.equals("owner")) {
                        typeName = ((String)annotation.values.get(i + 1)).replace('.', '/');
                        continue;
                    }
                    if (valueName.equals("name")) {
                        memberName = (String)annotation.values.get(i + 1);
                        continue;
                    }
                    if (valueName.equals("desc")) {
                        if (memberDesc != null) {
                            LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapMemberReference, but multiple values contain descriptor-giving values. Consider removing duplicated.", node.name, field.name, field.desc);
                            break;
                        }
                        memberDesc = (String)annotation.values.get(i + 1);
                        continue;
                    }
                    if (valueName.equals("descType")) {
                        if (memberDesc != null) {
                            LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapMemberReference, but multiple values contain descriptor-giving values. Consider removing duplicated.", node.name, field.name, field.desc);
                            break;
                        }
                        memberDesc = ((Type)annotation.values.get(i + 1)).getDescriptor();
                        continue;
                    }
                    if (valueName.equals("methodDesc")) {
                        int ret;
                        int args;
                        AnnotationNode methodDesc = (AnnotationNode)annotation.values.get(i + 1);
                        if (methodDesc.values.get(0).equals("args")) {
                            args = 1;
                            ret = 3;
                        } else {
                            ret = 1;
                            args = 3;
                        }
                        String argDesc = "";
                        List arglist = (List)methodDesc.values.get(args);
                        for (int j = 0; j < arglist.size(); ++j) {
                            Type arg = (Type)arglist.get(j);
                            if (arg == null) {
                                throw new AssertionError();
                            }
                            argDesc = argDesc + arg.getDescriptor();
                        }
                        if (memberDesc != null) {
                            LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapMemberReference, but multiple values contain descriptor-giving values. Consider removing duplicated.", node.name, field.name, field.desc);
                            break;
                        }
                        memberDesc = "(" + argDesc + ")" + ((Type)methodDesc.values.get(ret)).getDescriptor();
                        continue;
                    }
                    if (valueName.equals("format")) {
                        format = ((String[])annotation.values.get(i + 1))[1];
                        continue;
                    }
                    LOGGER.error("Erroneous annotation value: {} for RemapMemberReference. Are you depending on the wrong starplane-annotations version?", (Object)valueName);
                    break;
                }
                if (typeName == null) {
                    LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapMemberReference, but neither the 'owner' nor the 'ownerType' value of the annotation is set. Consider setting one of these values.", node.name, field.name, field.desc);
                    continue block0;
                }
                MemberTriple targetTriple = new MemberTriple(typeName, memberName, memberDesc);
                MemberTriple fieldTriple = new MemberTriple(node.name, field.name, field.desc);
                memberMapFormat.put(fieldTriple, format);
                memberMapRequests.put(fieldTriple, targetTriple);
            }
        }
        block4: for (MethodNode method : node.methods) {
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                String replacementLdc;
                AbstractInsnNode nextInsn;
                if (insn.getOpcode() != 184) continue;
                MethodInsnNode minsn = (MethodInsnNode)insn;
                if (!minsn.owner.equals("de/geolykt/starloader/starplane/annotations/ReferenceSource") || !minsn.name.equals("getStringValue") || !minsn.desc.equals("()Ljava/lang/String;")) continue;
                for (nextInsn = insn.getNext(); nextInsn != null && (nextInsn.getOpcode() == -1 || nextInsn.getOpcode() == 25); nextInsn = nextInsn.getNext()) {
                }
                if (nextInsn == null) {
                    LOGGER.error("Method {}.{} {} contains a rouge ReferenceSource.getStringValue() call.", node.name, method.name, method.desc);
                    continue block4;
                }
                if (nextInsn.getOpcode() != 179 && nextInsn.getOpcode() != 181) {
                    LOGGER.error("Method {}.{} {} contains a call to ReferenceSource.getStringValue() that is not immediately assigned to a field.", node.name, method.name, method.desc);
                    continue;
                }
                MemberTriple assignmentTriple = new MemberTriple(((FieldInsnNode)nextInsn).owner, ((FieldInsnNode)nextInsn).name, ((FieldInsnNode)nextInsn).desc);
                String cl = (String)classMapRequests.get(assignmentTriple);
                if (cl != null) {
                    replacementLdc = cl;
                } else {
                    boolean isMethod;
                    MemberTriple member = (MemberTriple)memberMapRequests.get(assignmentTriple);
                    String format = (String)memberMapFormat.get(assignmentTriple);
                    if (member == null || format == null) {
                        LOGGER.error("Method {}.{} {} contains a call to ReferenceSource.getStringValue() that is assigned to {}.{} {} which is not annotated with a starplane remapping annotation. (Note: this feature does not work across classes!)", node.name, method.name, method.desc, assignmentTriple.owner, assignmentTriple.name, assignmentTriple.desc);
                        continue;
                    }
                    boolean bl = isMethod = member.desc.codePointAt(0) == 40;
                    if (format.equals("OWNER")) {
                        replacementLdc = member.owner;
                    } else if (format.equals("NAME")) {
                        replacementLdc = member.name;
                    } else if (format.equals("DESCRIPTOR")) {
                        replacementLdc = member.desc;
                    } else if (format.equals("COMBINED_LEGACY")) {
                        replacementLdc = isMethod ? member.owner + "." + member.name + member.desc : member.owner + "." + member.name + " " + member.desc;
                    } else {
                        LOGGER.error("Method {}.{} {} contains a call to ReferenceSource.getStringValue() that is assigned to {}.{} {} which uses an unsupported format. (Are you using the right version of starplane-annotations?)", node.name, method.name, method.desc, assignmentTriple.owner, assignmentTriple.name, assignmentTriple.desc);
                        continue;
                    }
                }
                transformed = true;
                method.instructions.set(insn, new LdcInsnNode(replacementLdc));
                insn = nextInsn;
            }
        }
        return transformed;
    }

    @Override
    public boolean isValidTarget(@NotNull String internalName) {
        return true;
    }

    @Override
    public int getPriority() {
        return -10010;
    }

    private static class MemberTriple {
        @NotNull
        final String owner;
        @NotNull
        final String name;
        @NotNull
        final String desc;

        public MemberTriple(String owner, String name, String desc) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        public int hashCode() {
            return this.owner.hashCode() ^ this.name.hashCode() ^ this.desc.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MemberTriple) {
                MemberTriple other = (MemberTriple)obj;
                return this.owner.equals(other.owner) && this.name.equals(other.name) && this.desc.equals(other.desc);
            }
            return false;
        }
    }
}

