/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.selfmodification;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.minestom.server.extras.selfmodification.JavaInteropURLClassloader;
import net.minestom.server.extras.selfmodification.MinestomExtensionClassLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public abstract class HierarchyClassLoader
extends JavaInteropURLClassloader {
    protected final List<MinestomExtensionClassLoader> children = new LinkedList<MinestomExtensionClassLoader>();
    protected final List<HierarchyClassLoader> parents = new LinkedList<HierarchyClassLoader>();

    public HierarchyClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(name, urls, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull MinestomExtensionClassLoader loader) {
        Class<HierarchyClassLoader> clazz = HierarchyClassLoader.class;
        synchronized (HierarchyClassLoader.class) {
            this.children.add(loader);
            loader.parents.add(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String findLibrary(String libname) {
        return super.findLibrary(libname);
    }

    @Nullable
    public InputStream getResourceAsStreamWithChildren(@NotNull String name) {
        URL url = this.findResource(name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(HierarchyClassLoader.class).warn("Unable to open URL '{}' (from pathname '{}') from classloader '{}'!", url, name, this.getName(), e);
            }
        }
        for (MinestomExtensionClassLoader child : this.children) {
            InputStream childInput = child.getResourceAsStreamWithChildren(name);
            if (childInput == null) continue;
            return childInput;
        }
        return null;
    }

    @Nullable
    @ApiStatus.AvailableSince(value="4.0.0-a20241006")
    public URL getResourceAsURLWithChildren(@NotNull String name) {
        URL url = this.findResource(name);
        if (url != null) {
            return url;
        }
        for (MinestomExtensionClassLoader child : this.children) {
            URL childURL = child.getResourceAsURLWithChildren(name);
            if (childURL == null) continue;
            return childURL;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildInHierarchy(MinestomExtensionClassLoader child) {
        Class<HierarchyClassLoader> clazz = HierarchyClassLoader.class;
        synchronized (HierarchyClassLoader.class) {
            this.children.remove(child);
            this.children.forEach(c -> c.removeChildInHierarchy(child));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

