/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.version;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.picoresolve.version.MavenVersion;

public class VersionRange {
    @NotNull
    public static final VersionRange FREE_RANGE = new VersionRange(Collections.emptyList(), Collections.emptyList());
    @NotNull
    public static final VersionRange RELEASE = new VersionRange(Collections.emptyList(), Collections.emptyList());
    @NotNull
    private final @NotNull List<@NotNull MavenVersion> recommendedVersions;
    @NotNull
    private final @NotNull List<@NotNull VersionSet> versionSets;

    @NotNull
    public static VersionRange parse(@NotNull String string) {
        if (string.equals(",")) {
            return FREE_RANGE;
        }
        if (string.equals("RELEASE") || string.equals("[RELEASE]")) {
            return RELEASE;
        }
        ArrayList<@NotNull VersionSet> sets = new ArrayList<VersionSet>();
        ArrayList<@NotNull MavenVersion> recommendedVersions = new ArrayList<MavenVersion>();
        int[] codepoints = string.codePoints().toArray();
        ArrayList<String> tokens = new ArrayList<String>();
        boolean parsingRange = false;
        int lastDelimiter = -1;
        for (int i = 0; i < codepoints.length; ++i) {
            int codepoint = codepoints[i];
            if (codepoint == 40 || codepoint == 91) {
                parsingRange = true;
                continue;
            }
            if (codepoint == 41 || codepoint == 93) {
                parsingRange = false;
                continue;
            }
            if (codepoint != 44 || parsingRange) continue;
            tokens.add(string.substring(lastDelimiter + 1, i));
            lastDelimiter = i;
        }
        if (lastDelimiter + 1 != codepoints.length) {
            tokens.add(string.substring(lastDelimiter + 1, codepoints.length));
        }
        for (String token : tokens) {
            boolean closedRight;
            if (token.codePointAt(0) != 91 && token.codePointAt(0) != 40) {
                recommendedVersions.add(MavenVersion.parse(token));
                continue;
            }
            boolean edge = token.codePointAt(1) == 44 || token.codePointAt(token.length() - 2) == 44;
            boolean closedLeft = token.codePointAt(0) == 91;
            boolean bl = closedRight = token.codePointAt(token.length() - 1) == 93;
            if (edge) {
                EdgeType type;
                MavenVersion version;
                boolean edgeLeft;
                boolean bl2 = edgeLeft = token.codePointAt(1) == 44;
                if (edgeLeft) {
                    version = MavenVersion.parse(token.substring(2, token.length() - 1));
                    type = closedRight ? EdgeType.UP_TO : EdgeType.UNDER;
                } else {
                    version = MavenVersion.parse(token.substring(1, token.length() - 2));
                    type = closedLeft ? EdgeType.NOT_UNDER : EdgeType.ABOVE;
                }
                sets.add(new Edge(version, type));
                continue;
            }
            int seperatorPos = token.indexOf(44);
            if (seperatorPos == -1) {
                if (closedLeft && closedRight) {
                    sets.add(new PinnedVersion(MavenVersion.parse(token.substring(1, token.length() - 1))));
                    continue;
                }
                throw new AssertionError((Object)(token + "---" + string));
            }
            MavenVersion left = MavenVersion.parse(token.substring(1, seperatorPos));
            MavenVersion right = MavenVersion.parse(token.substring(seperatorPos + 1, token.length() - 1));
            IntervalType type = closedLeft ? (closedRight ? IntervalType.CLOSED : IntervalType.UPPER_OPEN) : (closedRight ? IntervalType.LOWER_OPEN : IntervalType.BOTH_OPEN);
            sets.add(new Interval(left, right, type));
        }
        return new VersionRange(sets, recommendedVersions);
    }

    private VersionRange(@NotNull @NotNull List<@NotNull VersionSet> sets, @NotNull @NotNull List<@NotNull MavenVersion> recommended) {
        this.recommendedVersions = Collections.unmodifiableList(new ArrayList<MavenVersion>(recommended));
        this.versionSets = Collections.unmodifiableList(new ArrayList<VersionSet>(sets));
    }

    public boolean containsVersion(MavenVersion version) {
        if (this.versionSets.isEmpty()) {
            for (MavenVersion recommended : this.recommendedVersions) {
                if (recommended.compareTo(version) != 0) continue;
                return true;
            }
            return false;
        }
        for (VersionSet set : this.versionSets) {
            if (set.contains(version)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public MavenVersion getRecommended() {
        MavenVersion newest = null;
        for (MavenVersion version : this.recommendedVersions) {
            if (!this.containsVersion(version) || newest != null && !version.isNewerThan(newest)) continue;
            newest = version;
        }
        return newest;
    }

    public List<@NotNull MavenVersion> getRecommendedVersions() {
        return this.recommendedVersions;
    }

    @NotNull
    public VersionRange intersect(@NotNull VersionRange version) {
        if (this == FREE_RANGE) {
            return version;
        }
        if (version == FREE_RANGE) {
            return this;
        }
        if (this == RELEASE) {
            return version;
        }
        if (version == RELEASE) {
            return this;
        }
        ArrayList<@NotNull VersionSet> sets = new ArrayList<VersionSet>(this.versionSets);
        ArrayList<@NotNull MavenVersion> recommended = new ArrayList<MavenVersion>(this.recommendedVersions);
        sets.addAll(version.versionSets);
        recommended.addAll(version.recommendedVersions);
        return new VersionRange(sets, recommended);
    }

    @Nullable
    public MavenVersion selectFrom(@Nullable Collection<@NotNull MavenVersion> knownAvailable, @Nullable MavenVersion releaseVersion) {
        if (this == RELEASE) {
            return releaseVersion;
        }
        MavenVersion candidateVersion = null;
        for (MavenVersion version : this.getRecommendedVersions()) {
            if (candidateVersion != null && !version.isNewerThan(candidateVersion) || !this.containsVersion(version)) continue;
            candidateVersion = version;
        }
        if (candidateVersion != null) {
            return candidateVersion;
        }
        if (knownAvailable != null) {
            for (MavenVersion known : knownAvailable) {
                if (candidateVersion != null && !known.isNewerThan(candidateVersion) || !this.containsVersion(known)) continue;
                candidateVersion = known;
            }
            if (candidateVersion != null) {
                return candidateVersion;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (VersionSet set : this.versionSets) {
            builder.append(set.toString());
            builder.append(',');
        }
        if (this.recommendedVersions.isEmpty()) {
            if (this.versionSets.isEmpty()) {
                return ",";
            }
            builder.setLength(builder.length() - 1);
            return builder.toString();
        }
        for (MavenVersion recommended : this.recommendedVersions) {
            builder.append(recommended.toString());
            builder.append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    private static enum EdgeType {
        UP_TO,
        UNDER,
        NOT_UNDER,
        ABOVE;

    }

    private static class Edge
    implements VersionSet {
        private final MavenVersion edgeVersion;
        private final EdgeType type;

        public Edge(MavenVersion edgeVersion, EdgeType type) {
            this.edgeVersion = edgeVersion;
            this.type = type;
        }

        @Override
        public boolean contains(MavenVersion version) {
            if (this.type == EdgeType.UP_TO) {
                return !version.isNewerThan(this.edgeVersion);
            }
            if (this.type == EdgeType.UNDER) {
                return this.edgeVersion.isNewerThan(version);
            }
            if (this.type == EdgeType.NOT_UNDER) {
                return !this.edgeVersion.isNewerThan(version);
            }
            return version.isNewerThan(this.edgeVersion);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Edge) {
                Edge other = (Edge)obj;
                return other.edgeVersion.equals(this.edgeVersion) && other.type.equals((Object)this.type);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.edgeVersion, this.type});
        }

        public String toString() {
            if (this.type == EdgeType.UP_TO) {
                return "(," + this.edgeVersion + ']';
            }
            if (this.type == EdgeType.UNDER) {
                return "(," + this.edgeVersion + ')';
            }
            if (this.type == EdgeType.NOT_UNDER) {
                return "[" + this.edgeVersion + ",)";
            }
            return "(" + this.edgeVersion + ",)";
        }
    }

    private static class PinnedVersion
    implements VersionSet {
        private final MavenVersion version;

        public PinnedVersion(MavenVersion version) {
            this.version = version;
        }

        @Override
        public boolean contains(MavenVersion version) {
            return !this.version.isNewerThan(version) && !version.isNewerThan(this.version);
        }

        public String toString() {
            return '[' + this.version.toString() + ']';
        }
    }

    private static enum IntervalType {
        BOTH_OPEN,
        CLOSED,
        UPPER_OPEN,
        LOWER_OPEN;

    }

    private static class Interval
    implements VersionSet {
        private final MavenVersion lowerBound;
        private final MavenVersion upperBound;
        private final IntervalType type;

        public Interval(MavenVersion lowerBound, MavenVersion upperBound, IntervalType type) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.type = type;
        }

        @Override
        public boolean contains(MavenVersion version) {
            if (this.type == IntervalType.CLOSED) {
                return !version.isNewerThan(this.upperBound) && !this.lowerBound.isNewerThan(version);
            }
            if (this.type == IntervalType.UPPER_OPEN) {
                return this.upperBound.isNewerThan(version) && !this.lowerBound.isNewerThan(version);
            }
            if (this.type == IntervalType.LOWER_OPEN) {
                return !version.isNewerThan(this.upperBound) && version.isNewerThan(this.lowerBound);
            }
            return version.isNewerThan(this.lowerBound) && this.upperBound.isNewerThan(version);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Interval) {
                Interval other = (Interval)obj;
                return other.lowerBound.equals(this.lowerBound) && other.upperBound.equals(this.upperBound) && other.type.equals((Object)this.type);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.lowerBound, this.upperBound, this.type});
        }

        public String toString() {
            if (this.type == IntervalType.CLOSED) {
                return '[' + this.lowerBound.toString() + ',' + this.upperBound + ']';
            }
            if (this.type == IntervalType.UPPER_OPEN) {
                return '[' + this.lowerBound.toString() + ',' + this.upperBound + ')';
            }
            if (this.type == IntervalType.LOWER_OPEN) {
                return '(' + this.lowerBound.toString() + ',' + this.upperBound + ']';
            }
            return '(' + this.lowerBound.toString() + ',' + this.upperBound + ')';
        }
    }

    private static interface VersionSet {
        public boolean contains(MavenVersion var1);
    }
}

