/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.repo;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.stianloader.picoresolve.internal.ConcurrencyUtil;
import org.stianloader.picoresolve.internal.JavaInterop;
import org.stianloader.picoresolve.internal.MultiCompletableFuture;
import org.stianloader.picoresolve.internal.StronglyMultiCompletableFuture;
import org.stianloader.picoresolve.internal.meta.LastUpdatedFile;
import org.stianloader.picoresolve.internal.meta.RemoteRepositoryProperties;
import org.stianloader.picoresolve.internal.meta.ResolverMetaStatus;
import org.stianloader.picoresolve.repo.MavenRepository;
import org.stianloader.picoresolve.repo.RepositoryAttachedValue;
import org.stianloader.picoresolve.repo.RepositoryNegotiatior;

public class MavenLocalRepositoryNegotiator
implements RepositoryNegotiatior {
    @NotNull
    private final Path mavenLocal;
    @NotNull
    private final Set<String> remoteIds = new HashSet<String>();
    @NotNull
    private final List<MavenRepository> remoteRepositories = new ArrayList<MavenRepository>();
    private boolean writeMetadata = true;

    public MavenLocalRepositoryNegotiator(@NotNull Path mavenLocal) {
        this.mavenLocal = Objects.requireNonNull(mavenLocal, "The cache directory defined by \"mavenLocal\" may not be null!");
        if (!Files.isDirectory(mavenLocal, new LinkOption[0])) {
            if (Files.notExists(mavenLocal, new LinkOption[0])) {
                try {
                    Files.createDirectories(mavenLocal, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new IllegalStateException("The \"mavenLocal\" argument must point to a directory. However this constructor was unable to make \"" + mavenLocal.toAbsolutePath() + "\" a directory.", e);
                }
            } else {
                throw new IllegalArgumentException("The \"mavenLocal\" argument must point to a directory. It currently points to " + mavenLocal.toAbsolutePath());
            }
        }
    }

    @Override
    @NotNull
    @Contract(mutates="this", pure=false, value="null -> fail; !null -> this")
    public MavenLocalRepositoryNegotiator addRepository(@NotNull MavenRepository remote) {
        if (!this.remoteIds.add(remote.getRepositoryId())) {
            throw new IllegalStateException("There is already a repository with the id \"" + remote.getRepositoryId() + "\" registered!");
        }
        this.remoteRepositories.add(remote);
        return this;
    }

    @NotNull
    public Path getLocalCache() {
        return this.mavenLocal;
    }

    @Override
    @NotNull
    public CompletableFuture<List<RepositoryAttachedValue<Path>>> resolveMavenMeta(@NotNull String path, @NotNull Executor executor) {
        Path parentDirectory = this.mavenLocal.resolve(path).getParent();
        if (parentDirectory == null) {
            throw new IllegalStateException("\"path\" might only consist of a slash!");
        }
        Path resolverProperties = parentDirectory.resolve("resolver-status.properties");
        if (!path.endsWith("/maven-metadata.xml")) {
            throw new IllegalArgumentException("This method may not be used to resolve anything but maven-metadata.xml (although it may be in various folders). Instead \"" + path + "\" was used as an input.");
        }
        ArrayList futures = new ArrayList();
        if (!Files.exists(parentDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(parentDirectory, new FileAttribute[0]);
            }
            catch (IOException iOException) {}
        } else {
            Path mvnLocalMeta = parentDirectory.resolve("maven-metadata-local.xml");
            if (Files.exists(mvnLocalMeta, new LinkOption[0])) {
                futures.add(CompletableFuture.completedFuture(new RepositoryAttachedValue<Path>(null, mvnLocalMeta)));
            }
        }
        ResolverMetaStatus resolverStatus = ResolverMetaStatus.tryParse(resolverProperties);
        for (MavenRepository remote : this.remoteRepositories) {
            Path localFile = parentDirectory.resolve("maven-metadata-" + remote.getRepositoryId() + ".xml");
            Long lastFetch = resolverStatus.getLastFetchTime(remote.getRepositoryId());
            if (lastFetch != null && lastFetch + remote.getUpdateIntervall() > System.currentTimeMillis()) {
                if (resolverStatus.hasErrored(remote.getRepositoryId())) continue;
                if (Files.exists(localFile, new LinkOption[0])) {
                    futures.add(CompletableFuture.completedFuture(new RepositoryAttachedValue<Path>(remote, localFile)));
                    continue;
                }
            }
            CompletableFuture<RepositoryAttachedValue> fetchFuture = ConcurrencyUtil.exceptionally(remote.getResource(path, executor), ex -> {
                if (Files.exists(localFile, new LinkOption[0])) {
                    return null;
                }
                resolverStatus.updateEntryErrored(remote.getRepositoryId(), ex.toString(), System.currentTimeMillis());
                return null;
            });
            CompletableFuture<RepositoryAttachedValue> future = fetchFuture.thenApply(rav -> {
                resolverStatus.updateEntrySuccess(remote.getRepositoryId(), System.currentTimeMillis());
                this.write((byte[])rav.getValue(), localFile);
                return new RepositoryAttachedValue<Path>(rav.getRepository(), localFile);
            });
            future = ConcurrencyUtil.exceptionally(future, ex -> {
                if (Files.exists(localFile, new LinkOption[0])) {
                    return new RepositoryAttachedValue<Path>(remote, localFile);
                }
                return null;
            });
            futures.add(future);
        }
        Path directMetadata = parentDirectory.resolve("maven-metadata.xml");
        if (Files.exists(directMetadata, new LinkOption[0])) {
            futures.add(CompletableFuture.completedFuture(new RepositoryAttachedValue<Path>(null, directMetadata)));
        }
        CompletionStage combined = futures.isEmpty() ? JavaInterop.failedFuture(new IllegalStateException("RepositoryNegotiator has exhausted all available repositories").fillInStackTrace()) : new StronglyMultiCompletableFuture(futures);
        if (this.writeMetadata) {
            combined = combined.thenApply(value -> {
                try {
                    resolverStatus.write(resolverProperties);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return value;
            });
        }
        return combined;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<RepositoryAttachedValue<Path>> resolveStandard(@NotNull String path, @NotNull Executor executor) {
        void var12_17;
        Path localFile = this.mavenLocal.resolve(path);
        Path lastUpdateFile = this.mavenLocal.resolve(path + ".lastUpdated");
        Path remoteRepos = localFile.resolveSibling("_remote.repositories");
        boolean localFilePresent = Files.exists(localFile, new LinkOption[0]);
        RemoteRepositoryProperties repoProps = RemoteRepositoryProperties.tryRead(remoteRepos);
        Optional<String> sourceRepo = repoProps.getSourceRepository(localFile.getFileName().toString());
        if (localFilePresent && !sourceRepo.isPresent()) {
            return CompletableFuture.completedFuture(new RepositoryAttachedValue<Path>(null, localFile));
        }
        if (!localFilePresent && Files.notExists(localFile.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(localFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LastUpdatedFile lastUpdated = LastUpdatedFile.tryParse(lastUpdateFile);
        ArrayList<MavenRepository> candidateRepositories = new ArrayList<MavenRepository>();
        for (MavenRepository mavenRepository : this.remoteRepositories) {
            Long l = lastUpdated.getLastFetchTime(mavenRepository.getPlaintextURL());
            if (sourceRepo.isPresent() && mavenRepository.getRepositoryId().equals(sourceRepo.get())) {
                if (l == null) {
                    return CompletableFuture.completedFuture(new RepositoryAttachedValue<Path>(mavenRepository, localFile));
                }
                if (l + mavenRepository.getUpdateIntervall() > System.currentTimeMillis()) {
                    return CompletableFuture.completedFuture(new RepositoryAttachedValue<Path>(mavenRepository, localFile));
                }
                candidateRepositories.clear();
                candidateRepositories.add(mavenRepository);
                break;
            }
            if (!lastUpdated.hasErrored(mavenRepository.getPlaintextURL())) {
                if (l != null && l + mavenRepository.getUpdateIntervall() > System.currentTimeMillis()) {
                    return CompletableFuture.completedFuture(new RepositoryAttachedValue<Path>(mavenRepository, localFile));
                }
            } else if (l != null && l + mavenRepository.getUpdateIntervall() > System.currentTimeMillis()) continue;
            candidateRepositories.add(mavenRepository);
        }
        if (candidateRepositories.isEmpty() && localFilePresent) {
            return CompletableFuture.completedFuture(new RepositoryAttachedValue<Path>(null, localFile));
        }
        ArrayList futures = new ArrayList();
        for (MavenRepository mavenRepository : candidateRepositories) {
            CompletableFuture<RepositoryAttachedValue<byte[]>> future = mavenRepository.getResource(path, executor);
            future.exceptionally(ex -> {
                lastUpdated.updateEntryErrored(remote.getPlaintextURL(), ex.toString(), System.currentTimeMillis());
                return null;
            });
            future.thenRun(() -> lastUpdated.updateEntrySuccess(remote.getPlaintextURL(), System.currentTimeMillis()));
            futures.add(future);
            if (!future.isDone() || future.isCompletedExceptionally()) continue;
            break;
        }
        if (!futures.isEmpty()) {
            MultiCompletableFuture multiCompletableFuture = new MultiCompletableFuture(futures);
        } else {
            CompletableFuture completableFuture = JavaInterop.failedFuture(new IOException("There are no remote repositories to fetch the file from and the file is not stored locally.").fillInStackTrace());
        }
        CompletableFuture<RepositoryAttachedValue<Path>> completableFuture = ConcurrencyUtil.exceptionally(var12_17.thenApply(rav -> {
            this.write((byte[])rav.getValue(), localFile);
            MavenRepository originRepository = rav.getRepository();
            if (originRepository != null) {
                repoProps.setSourceRepository(localFile.getFileName().toString(), originRepository.getRepositoryId());
                if (this.writeMetadata) {
                    repoProps.tryWrite(remoteRepos);
                }
            }
            return new RepositoryAttachedValue<Path>(originRepository, localFile);
        }), ex -> {
            if (Files.exists(localFile, new LinkOption[0])) {
                return new RepositoryAttachedValue<Path>(null, localFile);
            }
            return null;
        });
        if (this.writeMetadata) {
            completableFuture.thenRun(() -> {
                try {
                    lastUpdated.write(lastUpdateFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        return completableFuture;
    }

    @Override
    @NotNull
    @Contract(mutates="this", pure=false, value="-> this")
    public MavenLocalRepositoryNegotiator setWriteCacheMetadata(boolean writeMetadata) {
        this.writeMetadata = writeMetadata;
        return this;
    }

    protected void write(byte[] data, Path to) {
        FileLock fileLock = null;
        try {
            Path parts = to.resolveSibling(to.getFileName().toString() + ".part");
            Path lock = to.resolveSibling(to.getFileName().toString() + ".part.lock");
            FileChannel lockChannel = FileChannel.open(lock, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE);
            long idleTime = 0L;
            while ((fileLock = lockChannel.tryLock()) == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((idleTime += 10L) <= 10000L) continue;
                throw new IOException("Waited more than 10 seconds to acquire lock on " + parts.toAbsolutePath());
            }
            Files.write(parts, data, StandardOpenOption.CREATE_NEW);
            Files.move(parts, to, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            fileLock.release();
            fileLock.acquiredBy().close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (fileLock != null) {
                try {
                    fileLock.release();
                    fileLock.acquiredBy().close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

