/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.selectors.constant;

import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.stianloader.micromixin.transform.internal.annotation.ConstantSelector;

public class FloatConstantSelector
extends ConstantSelector {
    private final float value;

    public FloatConstantSelector(float value) {
        this.value = value;
    }

    @Override
    public boolean matchesConstant(@NotNull AbstractInsnNode insn) {
        if (insn instanceof InsnNode) {
            return insn.getOpcode() == 11 && this.value == 0.0f || insn.getOpcode() == 12 && this.value == 1.0f || insn.getOpcode() == 13 && this.value == 2.0f;
        }
        if (insn instanceof LdcInsnNode) {
            return ((LdcInsnNode)insn).cst instanceof Float && ((Float)((LdcInsnNode)insn).cst).floatValue() == this.value;
        }
        return false;
    }
}

