/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.internal.meta;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.stianloader.picoresolve.internal.ConfusedResolverException;
import org.stianloader.picoresolve.internal.XMLUtil;
import org.stianloader.picoresolve.version.MavenVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@ApiStatus.Internal
public class VersionCatalogue {
    public String fallbackSnapshotVersion;
    public String lastUpdated;
    public int lastUpdateDay;
    public int lastUpdateHour;
    public int lastUpdateMinute;
    public int lastUpdateMonth;
    public int lastUpdateSecond;
    public int lastUpdateYear;
    public MavenVersion latestVersion;
    public boolean localCopy;
    public MavenVersion releaseVersion;
    @NotNull
    public final @NotNull List<@NotNull MavenVersion> releaseVersions = new ArrayList<MavenVersion>();
    @NotNull
    public final @NotNull List<@NotNull SnapshotVersion> snapshotVersions = new ArrayList<SnapshotVersion>();

    public static VersionCatalogue merge(Iterable<VersionCatalogue> sources) {
        VersionCatalogue merged = new VersionCatalogue();
        for (VersionCatalogue source : sources) {
            for (MavenVersion mavenVersion : source.releaseVersions) {
                if (merged.releaseVersions.contains(mavenVersion)) continue;
                merged.releaseVersions.add(mavenVersion);
            }
            for (SnapshotVersion snapshotVersion : source.snapshotVersions) {
                SnapshotVersion conflict = null;
                for (SnapshotVersion old : merged.snapshotVersions) {
                    if (!Objects.equals(old.classifier, snapshotVersion.classifier) || !old.extension.equals(snapshotVersion.extension)) continue;
                    conflict = old;
                    break;
                }
                if (conflict == null) {
                    merged.snapshotVersions.add(snapshotVersion);
                    continue;
                }
                if (conflict.lastUpdated.compareTo(snapshotVersion.lastUpdated) >= 0) continue;
                merged.snapshotVersions.remove(conflict);
                merged.snapshotVersions.add(snapshotVersion);
            }
            if (source.lastUpdateYear > merged.lastUpdateYear) {
                merged.lastUpdateYear = source.lastUpdateYear;
                merged.lastUpdateMonth = source.lastUpdateMonth;
                merged.lastUpdateDay = source.lastUpdateDay;
                merged.lastUpdateHour = source.lastUpdateHour;
                merged.lastUpdateMinute = source.lastUpdateMinute;
                merged.lastUpdateSecond = source.lastUpdateSecond;
            } else if (source.lastUpdateYear >= merged.lastUpdateYear) {
                if (source.lastUpdateMonth > merged.lastUpdateMonth) {
                    merged.lastUpdateMonth = source.lastUpdateMonth;
                    merged.lastUpdateDay = source.lastUpdateDay;
                    merged.lastUpdateHour = source.lastUpdateHour;
                    merged.lastUpdateMinute = source.lastUpdateMinute;
                    merged.lastUpdateSecond = source.lastUpdateSecond;
                } else if (source.lastUpdateMonth >= merged.lastUpdateMonth) {
                    if (source.lastUpdateDay > merged.lastUpdateDay) {
                        merged.lastUpdateDay = source.lastUpdateDay;
                        merged.lastUpdateHour = source.lastUpdateHour;
                        merged.lastUpdateMinute = source.lastUpdateMinute;
                        merged.lastUpdateSecond = source.lastUpdateSecond;
                    } else if (source.lastUpdateDay >= merged.lastUpdateDay) {
                        if (source.lastUpdateHour > merged.lastUpdateHour) {
                            merged.lastUpdateHour = source.lastUpdateHour;
                            merged.lastUpdateMinute = source.lastUpdateMinute;
                            merged.lastUpdateSecond = source.lastUpdateSecond;
                        } else if (source.lastUpdateHour >= merged.lastUpdateHour) {
                            if (source.lastUpdateMinute > merged.lastUpdateMinute) {
                                merged.lastUpdateMinute = source.lastUpdateMinute;
                                merged.lastUpdateSecond = source.lastUpdateSecond;
                            } else if (source.lastUpdateMinute >= merged.lastUpdateMinute) {
                                if (source.lastUpdateSecond > merged.lastUpdateSecond) {
                                    merged.lastUpdateSecond = source.lastUpdateSecond;
                                } else if (source.lastUpdateSecond < merged.lastUpdateSecond) {
                                    // empty if block
                                }
                            }
                        }
                    }
                }
            }
            if (merged.latestVersion == null) {
                merged.latestVersion = source.latestVersion;
            } else if (source.latestVersion != null && source.latestVersion.isNewerThan(merged.latestVersion)) {
                merged.latestVersion = source.latestVersion;
            }
            if (merged.releaseVersion == null) {
                merged.releaseVersion = source.releaseVersion;
            } else if (source.releaseVersion != null && source.releaseVersion.isNewerThan(merged.releaseVersion)) {
                merged.releaseVersion = source.releaseVersion;
            }
            if (merged.fallbackSnapshotVersion != null) {
                merged.fallbackSnapshotVersion = source.fallbackSnapshotVersion;
            }
            merged.localCopy |= source.localCopy;
        }
        merged.lastUpdated = String.format("%04d%02d%02d%02d%02d%02d", merged.lastUpdateYear, merged.lastUpdateMonth, merged.lastUpdateDay, merged.lastUpdateHour, merged.lastUpdateMinute, merged.lastUpdateSecond);
        return merged;
    }

    @NotNull
    public static VersionCatalogue synthesize(List<@NotNull MavenVersion> guessedVersions) {
        VersionCatalogue catalogue = new VersionCatalogue();
        catalogue.releaseVersions.addAll(guessedVersions);
        return catalogue;
    }

    private VersionCatalogue() {
    }

    public VersionCatalogue(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Document xmlDoc = factory.newDocumentBuilder().parse(is);
        if (xmlDoc == null) {
            throw new NullPointerException("xmlDoc is null");
        }
        Element metadata = xmlDoc.getDocumentElement();
        metadata.normalize();
        Element versioning = XMLUtil.reqElement(metadata, "versioning");
        Element versions = null;
        Element snapshotVersions = null;
        for (Element element : new XMLUtil.ChildElementIterable(versioning)) {
            switch (element.getTagName().toLowerCase(Locale.ROOT)) {
                case "versions": {
                    versions = element;
                    break;
                }
                case "release": {
                    this.releaseVersion = MavenVersion.parse(Objects.requireNonNull(element.getTextContent()));
                    break;
                }
                case "latest": {
                    this.latestVersion = MavenVersion.parse(Objects.requireNonNull(element.getTextContent()));
                    break;
                }
                case "lastupdated": {
                    this.lastUpdated = element.getTextContent();
                    if (this.lastUpdated.length() != 14) {
                        throw new ConfusedResolverException("Last updated string \"" + this.lastUpdated + "\" is not following an implemented standard.");
                    }
                    this.lastUpdateYear = Integer.parseInt(this.lastUpdated.substring(0, 4));
                    this.lastUpdateMonth = Integer.parseInt(this.lastUpdated.substring(4, 6));
                    this.lastUpdateDay = Integer.parseInt(this.lastUpdated.substring(6, 8));
                    this.lastUpdateHour = Integer.parseInt(this.lastUpdated.substring(8, 10));
                    this.lastUpdateMinute = Integer.parseInt(this.lastUpdated.substring(10, 12));
                    this.lastUpdateSecond = Integer.parseInt(this.lastUpdated.substring(12, 14));
                    break;
                }
                case "snapshotversions": {
                    snapshotVersions = element;
                    break;
                }
                case "version": {
                    if (this.latestVersion != null) {
                        throw new IllegalStateException();
                    }
                    this.latestVersion = MavenVersion.parse(Objects.requireNonNull(element.getTextContent()));
                }
            }
        }
        Element snapshots = XMLUtil.optElement(versioning, "snapshot");
        Element versionElement = XMLUtil.optElement(metadata, "version");
        if (versions == null && snapshotVersions == null && (snapshots == null || versionElement == null)) {
            throw new ConfusedResolverException("Data did not contain a valid maven-metadata.xml file that lists the versions of an artifact.");
        }
        if (snapshots != null && versionElement != null) {
            Element timestamp = XMLUtil.optElement(snapshots, "timestamp");
            Element buildNr = XMLUtil.optElement(snapshots, "buildNumber");
            Element localCopy = XMLUtil.optElement(snapshots, "localCopy");
            if ((timestamp == null || buildNr == null) && localCopy == null) {
                throw new ConfusedResolverException("Too little data remaining to be able to build up a fallback snapshot version: " + metadata.toString());
            }
            if (localCopy != null) {
                this.localCopy = "true".equalsIgnoreCase(localCopy.getTextContent());
            }
            if (timestamp != null && buildNr != null) {
                int index = versionElement.getTextContent().toLowerCase().lastIndexOf("-snapshot");
                this.fallbackSnapshotVersion = index == -1 ? versionElement.getTextContent() + "-" + timestamp.getTextContent() + "-" + buildNr.getTextContent() : versionElement.getTextContent().substring(0, index) + "-" + timestamp.getTextContent() + "-" + buildNr.getTextContent();
            }
        }
        if (versions != null) {
            for (Element element : new XMLUtil.ChildElementIterable(versions)) {
                if (!element.getTagName().equalsIgnoreCase("version")) continue;
                this.releaseVersions.add(MavenVersion.parse(Objects.requireNonNull(element.getTextContent())));
            }
        }
        if (snapshotVersions != null) {
            for (Element element : new XMLUtil.ChildElementIterable(snapshotVersions)) {
                if (!element.getTagName().equalsIgnoreCase("snapshotVersion")) continue;
                String extension = XMLUtil.elementText(element, "extension");
                String lastUpdated = XMLUtil.elementText(element, "updated");
                String version = XMLUtil.elementText(element, "value");
                String classifier = XMLUtil.elementText(element, "classifier");
                this.snapshotVersions.add(new SnapshotVersion(extension, classifier, version, lastUpdated));
            }
        }
    }

    @ApiStatus.Internal
    public static class SnapshotVersion {
        private final String classifier;
        private final String extension;
        private final String lastUpdated;
        private final String version;

        public SnapshotVersion(String extension, String classifier, String version, String lastUpdated) {
            this.extension = extension;
            this.classifier = classifier;
            this.version = version;
            this.lastUpdated = lastUpdated;
        }

        public String classifier() {
            return this.classifier;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SnapshotVersion) {
                SnapshotVersion other = (SnapshotVersion)obj;
                return this.extension.equals(other.extension) && this.classifier.equals(other.classifier) && this.version.equals(other.version) && this.lastUpdated.equals(other.lastUpdated);
            }
            return false;
        }

        public String extension() {
            return this.extension;
        }

        public int hashCode() {
            return Objects.hash(this.extension, this.classifier, this.version, this.lastUpdated);
        }

        public String lastUpdated() {
            return this.lastUpdated;
        }

        public String version() {
            return this.version;
        }
    }
}

