/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.utils.annotations;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.utils.Types;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public class AnnotationUtils {
    public static Map<String, Object> listToMap(@Nullable List<Object> list) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (list != null) {
            for (int i = 0; i < list.size(); i += 2) {
                map.put((String)list.get(i), list.get(i + 1));
            }
        }
        return map;
    }

    public static List<Object> mapToList(@Nullable Map<String, Object> map) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                list.add(entry.getKey());
                list.add(entry.getValue());
            }
        }
        return list;
    }

    public static AnnotationNode clone(AnnotationNode node) {
        AnnotationNode clone = new AnnotationNode(node.desc);
        if (node.values != null) {
            List<Object> values = clone.values = new ArrayList<Object>(node.values);
            values.replaceAll(AnnotationUtils::cloneObject);
        }
        return clone;
    }

    private static Object cloneObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof AnnotationNode) {
            return AnnotationUtils.clone((AnnotationNode)object);
        }
        if (object.getClass().isArray()) {
            Object clone = Array.newInstance(object.getClass().getComponentType(), Array.getLength(object));
            for (int i = 0; i < Array.getLength(object); ++i) {
                Array.set(clone, i, AnnotationUtils.cloneObject(Array.get(object, i)));
            }
            return clone;
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<Object> clone = new ArrayList<Object>(list.size());
            for (Object value : list) {
                clone.add(AnnotationUtils.cloneObject(value));
            }
            return clone;
        }
        return object;
    }

    public static void forEachVisible(ClassNode classNode, Consumer<AnnotationNode> annotationConsumer) {
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode annotation : classNode.visibleAnnotations) {
                annotationConsumer.accept(annotation);
            }
        }
    }

    public static void forEachVisible(FieldNode fieldNode, Consumer<AnnotationNode> annotationConsumer) {
        if (fieldNode.visibleAnnotations != null) {
            for (AnnotationNode annotation : fieldNode.visibleAnnotations) {
                annotationConsumer.accept(annotation);
            }
        }
    }

    public static void forEachVisible(MethodNode methodNode, Consumer<AnnotationNode> annotationConsumer) {
        if (methodNode.visibleAnnotations != null) {
            for (AnnotationNode annotation : methodNode.visibleAnnotations) {
                annotationConsumer.accept(annotation);
            }
        }
    }

    public static void forEachInvisible(ClassNode classNode, Consumer<AnnotationNode> annotationConsumer) {
        if (classNode.invisibleAnnotations != null) {
            for (AnnotationNode annotation : classNode.invisibleAnnotations) {
                annotationConsumer.accept(annotation);
            }
        }
    }

    public static void forEachInvisible(FieldNode fieldNode, Consumer<AnnotationNode> annotationConsumer) {
        if (fieldNode.invisibleAnnotations != null) {
            for (AnnotationNode annotation : fieldNode.invisibleAnnotations) {
                annotationConsumer.accept(annotation);
            }
        }
    }

    public static void forEachInvisible(MethodNode methodNode, Consumer<AnnotationNode> annotationConsumer) {
        if (methodNode.invisibleAnnotations != null) {
            for (AnnotationNode annotation : methodNode.invisibleAnnotations) {
                annotationConsumer.accept(annotation);
            }
        }
    }

    public static void forEach(ClassNode classNode, Consumer<AnnotationNode> annotationConsumer) {
        AnnotationUtils.forEachVisible(classNode, annotationConsumer);
        AnnotationUtils.forEachInvisible(classNode, annotationConsumer);
    }

    public static void forEach(FieldNode fieldNode, Consumer<AnnotationNode> annotationConsumer) {
        AnnotationUtils.forEachVisible(fieldNode, annotationConsumer);
        AnnotationUtils.forEachInvisible(fieldNode, annotationConsumer);
    }

    public static void forEach(MethodNode methodNode, Consumer<AnnotationNode> annotationConsumer) {
        AnnotationUtils.forEachVisible(methodNode, annotationConsumer);
        AnnotationUtils.forEachInvisible(methodNode, annotationConsumer);
    }

    public static Optional<AnnotationNode> findVisibleAnnotation(ClassNode classNode, Class<?> annotationClass) {
        return AnnotationUtils.findAnnotation(classNode.visibleAnnotations, annotationClass);
    }

    public static Optional<AnnotationNode> findVisibleAnnotation(ClassNode classNode, String annotationDescriptor) {
        return AnnotationUtils.findAnnotation(classNode.visibleAnnotations, annotationDescriptor);
    }

    public static Optional<AnnotationNode> findVisibleAnnotation(FieldNode fieldNode, Class<?> annotationClass) {
        return AnnotationUtils.findAnnotation(fieldNode.visibleAnnotations, annotationClass);
    }

    public static Optional<AnnotationNode> findVisibleAnnotation(FieldNode fieldNode, String annotationDescriptor) {
        return AnnotationUtils.findAnnotation(fieldNode.visibleAnnotations, annotationDescriptor);
    }

    public static Optional<AnnotationNode> findVisibleAnnotation(MethodNode methodNode, Class<?> annotationClass) {
        return AnnotationUtils.findAnnotation(methodNode.visibleAnnotations, annotationClass);
    }

    public static Optional<AnnotationNode> findVisibleAnnotation(MethodNode methodNode, String annotationDescriptor) {
        return AnnotationUtils.findAnnotation(methodNode.visibleAnnotations, annotationDescriptor);
    }

    public static Optional<AnnotationNode[]> findVisibleParameterAnnotations(MethodNode methodNode, Class<?> annotationClass) {
        return AnnotationUtils.findParameterAnnotations(methodNode.visibleParameterAnnotations, annotationClass);
    }

    public static Optional<AnnotationNode[]> findVisibleParameterAnnotations(MethodNode methodNode, String annotationDescriptor) {
        return AnnotationUtils.findParameterAnnotations(methodNode.visibleParameterAnnotations, annotationDescriptor);
    }

    public static Optional<AnnotationNode> findInvisibleAnnotation(ClassNode classNode, Class<?> annotationClass) {
        return AnnotationUtils.findAnnotation(classNode.invisibleAnnotations, annotationClass);
    }

    public static Optional<AnnotationNode> findInvisibleAnnotation(ClassNode classNode, String annotationDescriptor) {
        return AnnotationUtils.findAnnotation(classNode.invisibleAnnotations, annotationDescriptor);
    }

    public static Optional<AnnotationNode> findInvisibleAnnotation(FieldNode fieldNode, Class<?> annotationClass) {
        return AnnotationUtils.findAnnotation(fieldNode.invisibleAnnotations, annotationClass);
    }

    public static Optional<AnnotationNode> findInvisibleAnnotation(FieldNode fieldNode, String annotationDescriptor) {
        return AnnotationUtils.findAnnotation(fieldNode.invisibleAnnotations, annotationDescriptor);
    }

    public static Optional<AnnotationNode> findInvisibleAnnotation(MethodNode methodNode, Class<?> annotationClass) {
        return AnnotationUtils.findAnnotation(methodNode.invisibleAnnotations, annotationClass);
    }

    public static Optional<AnnotationNode> findInvisibleAnnotation(MethodNode methodNode, String annotationDescriptor) {
        return AnnotationUtils.findAnnotation(methodNode.invisibleAnnotations, annotationDescriptor);
    }

    public static Optional<AnnotationNode[]> findInvisibleParameterAnnotations(MethodNode methodNode, Class<?> annotationClass) {
        return AnnotationUtils.findParameterAnnotations(methodNode.invisibleParameterAnnotations, annotationClass);
    }

    public static Optional<AnnotationNode[]> findInvisibleParameterAnnotations(MethodNode methodNode, String annotationDescriptor) {
        return AnnotationUtils.findParameterAnnotations(methodNode.invisibleParameterAnnotations, annotationDescriptor);
    }

    public static Optional<AnnotationNode> findAnnotation(ClassNode classNode, Class<?> annotationClass) {
        Optional<AnnotationNode> annotationNode = AnnotationUtils.findVisibleAnnotation(classNode, annotationClass);
        if (annotationNode.isPresent()) {
            return annotationNode;
        }
        return AnnotationUtils.findInvisibleAnnotation(classNode, annotationClass);
    }

    public static Optional<AnnotationNode> findAnnotation(ClassNode classNode, String annotationDescriptor) {
        Optional<AnnotationNode> annotationNode = AnnotationUtils.findVisibleAnnotation(classNode, annotationDescriptor);
        if (annotationNode.isPresent()) {
            return annotationNode;
        }
        return AnnotationUtils.findInvisibleAnnotation(classNode, annotationDescriptor);
    }

    public static Optional<AnnotationNode> findAnnotation(FieldNode fieldNode, Class<?> annotationClass) {
        Optional<AnnotationNode> annotationNode = AnnotationUtils.findVisibleAnnotation(fieldNode, annotationClass);
        if (annotationNode.isPresent()) {
            return annotationNode;
        }
        return AnnotationUtils.findInvisibleAnnotation(fieldNode, annotationClass);
    }

    public static Optional<AnnotationNode> findAnnotation(FieldNode fieldNode, String annotationDescriptor) {
        Optional<AnnotationNode> annotationNode = AnnotationUtils.findVisibleAnnotation(fieldNode, annotationDescriptor);
        if (annotationNode.isPresent()) {
            return annotationNode;
        }
        return AnnotationUtils.findInvisibleAnnotation(fieldNode, annotationDescriptor);
    }

    public static Optional<AnnotationNode> findAnnotation(MethodNode methodNode, Class<?> annotationClass) {
        Optional<AnnotationNode> annotationNode = AnnotationUtils.findVisibleAnnotation(methodNode, annotationClass);
        if (annotationNode.isPresent()) {
            return annotationNode;
        }
        return AnnotationUtils.findInvisibleAnnotation(methodNode, annotationClass);
    }

    public static Optional<AnnotationNode> findAnnotation(MethodNode methodNode, String annotationDescriptor) {
        Optional<AnnotationNode> annotationNode = AnnotationUtils.findVisibleAnnotation(methodNode, annotationDescriptor);
        if (annotationNode.isPresent()) {
            return annotationNode;
        }
        return AnnotationUtils.findInvisibleAnnotation(methodNode, annotationDescriptor);
    }

    public static Optional<AnnotationNode[]> findParameterAnnotations(MethodNode methodNode, Class<?> annotationClass) {
        Optional<AnnotationNode[]> annotationNode = AnnotationUtils.findVisibleParameterAnnotations(methodNode, annotationClass);
        if (annotationNode.isPresent()) {
            return annotationNode;
        }
        return AnnotationUtils.findInvisibleParameterAnnotations(methodNode, annotationClass);
    }

    public static Optional<AnnotationNode[]> findParameterAnnotations(MethodNode methodNode, String annotationDescriptor) {
        Optional<AnnotationNode[]> annotationNode = AnnotationUtils.findVisibleParameterAnnotations(methodNode, annotationDescriptor);
        if (annotationNode.isPresent()) {
            return annotationNode;
        }
        return AnnotationUtils.findInvisibleParameterAnnotations(methodNode, annotationDescriptor);
    }

    public static Optional<AnnotationNode> findAnnotation(@Nullable List<AnnotationNode> annotations, Class<?> annotationClass) {
        return AnnotationUtils.findAnnotation(annotations, Types.typeDescriptor(annotationClass));
    }

    public static Optional<AnnotationNode> findAnnotation(@Nullable List<AnnotationNode> annotations, String annotationDescriptor) {
        if (annotations == null) {
            return Optional.empty();
        }
        for (AnnotationNode annotation : annotations) {
            if (!annotation.desc.equals(annotationDescriptor)) continue;
            return Optional.of(annotation);
        }
        return Optional.empty();
    }

    public static Optional<AnnotationNode[]> findParameterAnnotations(@Nullable List<AnnotationNode>[] annotations, Class<?> annotationClass) {
        return AnnotationUtils.findParameterAnnotations(annotations, Types.typeDescriptor(annotationClass));
    }

    public static Optional<AnnotationNode[]> findParameterAnnotations(@Nullable List<AnnotationNode>[] annotations, String annotationDescriptor) {
        if (annotations == null) {
            return Optional.empty();
        }
        AnnotationNode[] annotationNodes = new AnnotationNode[annotations.length];
        boolean found = false;
        for (int i = 0; i < annotations.length; ++i) {
            Optional<AnnotationNode> annotationNode = AnnotationUtils.findAnnotation(annotations[i], annotationDescriptor);
            annotationNodes[i] = annotationNode.orElse(null);
            if (!annotationNode.isPresent()) continue;
            found = true;
        }
        if (!found) {
            return Optional.empty();
        }
        return Optional.of(annotationNodes);
    }

    public static boolean hasVisibleAnnotation(ClassNode classNode, Class<?> annotationClass) {
        return AnnotationUtils.findVisibleAnnotation(classNode, annotationClass).isPresent();
    }

    public static boolean hasVisibleAnnotation(ClassNode classNode, String annotationDescriptor) {
        return AnnotationUtils.findVisibleAnnotation(classNode, annotationDescriptor).isPresent();
    }

    public static boolean hasVisibleAnnotation(FieldNode fieldNode, Class<?> annotationClass) {
        return AnnotationUtils.findVisibleAnnotation(fieldNode, annotationClass).isPresent();
    }

    public static boolean hasVisibleAnnotation(FieldNode fieldNode, String annotationDescriptor) {
        return AnnotationUtils.findVisibleAnnotation(fieldNode, annotationDescriptor).isPresent();
    }

    public static boolean hasVisibleAnnotation(MethodNode methodNode, Class<?> annotationClass) {
        return AnnotationUtils.findVisibleAnnotation(methodNode, annotationClass).isPresent();
    }

    public static boolean hasVisibleAnnotation(MethodNode methodNode, String annotationDescriptor) {
        return AnnotationUtils.findVisibleAnnotation(methodNode, annotationDescriptor).isPresent();
    }

    public static boolean hasVisibleParameterAnnotations(MethodNode methodNode, Class<?> annotationClass) {
        return AnnotationUtils.findVisibleParameterAnnotations(methodNode, annotationClass).isPresent();
    }

    public static boolean hasVisibleParameterAnnotations(MethodNode methodNode, String annotationDescriptor) {
        return AnnotationUtils.findVisibleParameterAnnotations(methodNode, annotationDescriptor).isPresent();
    }

    public static boolean hasInvisibleAnnotation(ClassNode classNode, Class<?> annotationClass) {
        return AnnotationUtils.findInvisibleAnnotation(classNode, annotationClass).isPresent();
    }

    public static boolean hasInvisibleAnnotation(ClassNode classNode, String annotationDescriptor) {
        return AnnotationUtils.findInvisibleAnnotation(classNode, annotationDescriptor).isPresent();
    }

    public static boolean hasInvisibleAnnotation(FieldNode fieldNode, Class<?> annotationClass) {
        return AnnotationUtils.findInvisibleAnnotation(fieldNode, annotationClass).isPresent();
    }

    public static boolean hasInvisibleAnnotation(FieldNode fieldNode, String annotationDescriptor) {
        return AnnotationUtils.findInvisibleAnnotation(fieldNode, annotationDescriptor).isPresent();
    }

    public static boolean hasInvisibleAnnotation(MethodNode methodNode, Class<?> annotationClass) {
        return AnnotationUtils.findInvisibleAnnotation(methodNode, annotationClass).isPresent();
    }

    public static boolean hasInvisibleAnnotation(MethodNode methodNode, String annotationDescriptor) {
        return AnnotationUtils.findInvisibleAnnotation(methodNode, annotationDescriptor).isPresent();
    }

    public static boolean hasInvisibleParameterAnnotations(MethodNode methodNode, Class<?> annotationClass) {
        return AnnotationUtils.findInvisibleParameterAnnotations(methodNode, annotationClass).isPresent();
    }

    public static boolean hasInvisibleParameterAnnotations(MethodNode methodNode, String annotationDescriptor) {
        return AnnotationUtils.findInvisibleParameterAnnotations(methodNode, annotationDescriptor).isPresent();
    }

    public static boolean hasAnnotation(ClassNode classNode, Class<?> annotationClass) {
        return AnnotationUtils.findAnnotation(classNode, annotationClass).isPresent();
    }

    public static boolean hasAnnotation(ClassNode classNode, String annotationDescriptor) {
        return AnnotationUtils.findAnnotation(classNode, annotationDescriptor).isPresent();
    }

    public static boolean hasAnnotation(FieldNode fieldNode, Class<?> annotationClass) {
        return AnnotationUtils.findAnnotation(fieldNode, annotationClass).isPresent();
    }

    public static boolean hasAnnotation(FieldNode fieldNode, String annotationDescriptor) {
        return AnnotationUtils.findAnnotation(fieldNode, annotationDescriptor).isPresent();
    }

    public static boolean hasAnnotation(MethodNode methodNode, Class<?> annotationClass) {
        return AnnotationUtils.findAnnotation(methodNode, annotationClass).isPresent();
    }

    public static boolean hasAnnotation(MethodNode methodNode, String annotationDescriptor) {
        return AnnotationUtils.findAnnotation(methodNode, annotationDescriptor).isPresent();
    }

    public static boolean hasParameterAnnotations(MethodNode methodNode, Class<?> annotationClass) {
        return AnnotationUtils.findParameterAnnotations(methodNode, annotationClass).isPresent();
    }

    public static boolean hasParameterAnnotations(MethodNode methodNode, String annotationDescriptor) {
        return AnnotationUtils.findParameterAnnotations(methodNode, annotationDescriptor).isPresent();
    }

    public static boolean hasAnnotation(@Nullable List<AnnotationNode> annotations, Class<?> annotationClass) {
        return AnnotationUtils.findAnnotation(annotations, annotationClass).isPresent();
    }

    public static boolean hasAnnotation(@Nullable List<AnnotationNode> annotations, String annotationDescriptor) {
        return AnnotationUtils.findAnnotation(annotations, annotationDescriptor).isPresent();
    }

    public static boolean hasParameterAnnotations(@Nullable List<AnnotationNode>[] annotations, Class<?> annotationClass) {
        return AnnotationUtils.findParameterAnnotations(annotations, annotationClass).isPresent();
    }

    public static boolean hasParameterAnnotations(@Nullable List<AnnotationNode>[] annotations, String annotationDescriptor) {
        return AnnotationUtils.findParameterAnnotations(annotations, annotationDescriptor).isPresent();
    }
}

