/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.transformer.types;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.transformer.AnnotationHandler;
import net.lenni0451.classtransform.utils.ASMUtils;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public abstract class RemovingAnnotationHandler<T extends Annotation>
extends AnnotationHandler {
    private final Class<? extends Annotation> annotationClass;

    public RemovingAnnotationHandler(Class<T> annotationClass) {
        this.annotationClass = annotationClass;
    }

    @Override
    public final void transform(TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer) {
        Iterator<MethodNode> it = transformer.methods.iterator();
        while (it.hasNext()) {
            MethodNode transformerMethod = it.next();
            Annotation annotation = this.getAnnotation(this.annotationClass, transformerMethod, transformerManager);
            if (annotation == null || !this.shouldExecute(annotation)) continue;
            it.remove();
            this.transform(annotation, transformerManager, transformedClass, transformer, ASMUtils.cloneMethod(transformerMethod));
        }
    }

    public abstract void transform(T var1, TransformerManager var2, ClassNode var3, ClassNode var4, MethodNode var5);

    public boolean shouldExecute(T annotation) {
        return true;
    }
}

