/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.mixinstranslator.impl;

import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.annotations.CTarget;
import net.lenni0451.classtransform.mixinstranslator.impl.IAnnotationTranslator;
import net.lenni0451.classtransform.utils.Types;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;

@ParametersAreNonnullByDefault
class AtTranslator
implements IAnnotationTranslator {
    AtTranslator() {
    }

    @Override
    public void translate(AnnotationNode annotation, Map<String, Object> values) {
        annotation.desc = Type.getDescriptor(CTarget.class);
        if (values.containsKey("value") && values.containsKey("target")) {
            String value = (String)values.get("value");
            String target = (String)values.get("target");
            if (value.equalsIgnoreCase("CONSTANT")) {
                if (target.startsWith("nullValue")) {
                    target = "null";
                } else if (target.startsWith("intValue=")) {
                    target = "int " + target.substring(9);
                } else if (target.startsWith("floatValue=")) {
                    target = "float " + target.substring(11);
                } else if (target.startsWith("longValue=")) {
                    target = "long " + target.substring(10);
                } else if (target.startsWith("doubleValue=")) {
                    target = "double " + target.substring(12);
                } else if (target.startsWith("stringValue=")) {
                    target = "string " + target.substring(12);
                } else if (target.startsWith("classValue=")) {
                    target = "type " + target.substring(11);
                } else {
                    throw new IllegalArgumentException("Invalid target: " + target);
                }
                values.put("target", target);
            } else if (value.equalsIgnoreCase("JUMP")) {
                Object opcode = values.get("opcode");
                if (!(opcode instanceof Integer)) {
                    throw new IllegalArgumentException("ClassTransform requires an opcode to be specified");
                }
                values.put("value", "OPCODE");
                values.put("target", opcode);
            } else if (value.equalsIgnoreCase("FIELD") && values.containsKey("opcode")) {
                throw new IllegalArgumentException("ClassTransform does not support the FIELD target with opcode. Please refer to the At#opcode javadoc for information");
            }
        }
        if (values.containsKey("shift")) {
            String[] shift = (String[])values.get("shift");
            shift[0] = Types.typeDescriptor(CTarget.Shift.class);
        } else {
            values.put("shift", new String[]{Types.typeDescriptor(CTarget.Shift.class), "BEFORE"});
        }
    }
}

