/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.mixinstranslator;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.mixinstranslator.CallbackRewriter;
import net.lenni0451.classtransform.mixinstranslator.impl.AnnotationTranslatorManager;
import net.lenni0451.classtransform.mixinstranslator.impl.IAnnotationTranslator;
import net.lenni0451.classtransform.transformer.IAnnotationHandlerPreprocessor;
import net.lenni0451.classtransform.utils.annotations.AnnotationUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public class MixinsTranslator
implements IAnnotationHandlerPreprocessor {
    @Override
    public void process(ClassNode node) {
        this.translate(node.visibleAnnotations);
        this.translate(node.invisibleAnnotations);
        for (FieldNode field : node.fields) {
            this.translate(field.visibleAnnotations);
            this.translate(field.invisibleAnnotations);
        }
        for (MethodNode method : node.methods) {
            this.translate(method.visibleAnnotations);
            this.translate(method.invisibleAnnotations);
            this.translate(method.visibleParameterAnnotations);
            this.translate(method.invisibleParameterAnnotations);
            CallbackRewriter.rewrite(method);
        }
    }

    private void translate(@Nullable List<AnnotationNode>[] annotations) {
        if (annotations == null) {
            return;
        }
        for (List<AnnotationNode> annotationList : annotations) {
            this.translate(annotationList);
        }
    }

    private void translate(@Nullable List<AnnotationNode> annotations) {
        if (annotations == null) {
            return;
        }
        for (AnnotationNode annotation : annotations) {
            IAnnotationTranslator translator = AnnotationTranslatorManager.getTranslator(Type.getType(annotation.desc));
            if (translator == null) continue;
            Map<String, Object> values = AnnotationUtils.listToMap(annotation.values);
            translator.translate(annotation, values);
            annotation.values = AnnotationUtils.mapToList(values);
        }
    }
}

