/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMComparator {
    public static boolean equals(InsnList insnList1, InsnList insnList2) {
        if (insnList1 == insnList2) {
            return true;
        }
        if (insnList1 == null || insnList2 == null) {
            return false;
        }
        if (insnList1.size() != insnList2.size()) {
            return false;
        }
        for (int i = 0; i < insnList1.size(); ++i) {
            AbstractInsnNode insn2;
            AbstractInsnNode insn1 = insnList1.get(i);
            if (ASMComparator.equals(insn1, insn2 = insnList2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(List<? extends AbstractInsnNode> insnList1, List<? extends AbstractInsnNode> insnList2) {
        if (insnList1 == insnList2) {
            return true;
        }
        if (insnList1 == null || insnList2 == null) {
            return false;
        }
        if (insnList1.size() != insnList2.size()) {
            return false;
        }
        for (int i = 0; i < insnList1.size(); ++i) {
            AbstractInsnNode insn2;
            AbstractInsnNode insn1 = insnList1.get(i);
            if (ASMComparator.equals(insn1, insn2 = insnList2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(AbstractInsnNode insn1, AbstractInsnNode insn2) {
        if (insn1 == insn2) {
            return true;
        }
        if (insn1 == null || insn2 == null) {
            return false;
        }
        if (insn1.getOpcode() != insn2.getOpcode()) {
            return false;
        }
        if (insn1.getType() != insn2.getType()) {
            return false;
        }
        if (insn1.getType() == 0) {
            return true;
        }
        if (insn1.getType() == 1) {
            IntInsnNode intInsn1 = (IntInsnNode)insn1;
            IntInsnNode intInsn2 = (IntInsnNode)insn2;
            return intInsn1.operand == intInsn2.operand;
        }
        if (insn1.getType() == 2) {
            VarInsnNode varInsn1 = (VarInsnNode)insn1;
            VarInsnNode varInsn2 = (VarInsnNode)insn2;
            return varInsn1.var == varInsn2.var;
        }
        if (insn1.getType() == 3) {
            TypeInsnNode typeInsn1 = (TypeInsnNode)insn1;
            TypeInsnNode typeInsn2 = (TypeInsnNode)insn2;
            return Objects.equals(typeInsn1.desc, typeInsn2.desc);
        }
        if (insn1.getType() == 4) {
            FieldInsnNode fieldInsn1 = (FieldInsnNode)insn1;
            FieldInsnNode fieldInsn2 = (FieldInsnNode)insn2;
            return Objects.equals(fieldInsn1.owner, fieldInsn2.owner) && Objects.equals(fieldInsn1.name, fieldInsn2.name) && Objects.equals(fieldInsn1.desc, fieldInsn2.desc);
        }
        if (insn1.getType() == 5) {
            MethodInsnNode methodInsn1 = (MethodInsnNode)insn1;
            MethodInsnNode methodInsn2 = (MethodInsnNode)insn2;
            return Objects.equals(methodInsn1.owner, methodInsn2.owner) && Objects.equals(methodInsn1.name, methodInsn2.name) && Objects.equals(methodInsn1.desc, methodInsn2.desc) && methodInsn1.itf == methodInsn2.itf;
        }
        if (insn1.getType() == 6) {
            InvokeDynamicInsnNode invokeDynamicInsn1 = (InvokeDynamicInsnNode)insn1;
            InvokeDynamicInsnNode invokeDynamicInsn2 = (InvokeDynamicInsnNode)insn2;
            return Objects.equals(invokeDynamicInsn1.name, invokeDynamicInsn2.name) && Objects.equals(invokeDynamicInsn1.desc, invokeDynamicInsn2.desc) && Objects.equals(invokeDynamicInsn1.bsm, invokeDynamicInsn2.bsm) && ASMComparator.dynamicEquals(Arrays.asList(invokeDynamicInsn1.bsmArgs), Arrays.asList(invokeDynamicInsn2.bsmArgs));
        }
        if (insn1.getType() == 7) {
            JumpInsnNode jumpInsn1 = (JumpInsnNode)insn1;
            JumpInsnNode jumpInsn2 = (JumpInsnNode)insn2;
            return ASMComparator.equals(jumpInsn1.label, jumpInsn2.label);
        }
        if (insn1.getType() == 8) {
            return true;
        }
        if (insn1.getType() == 9) {
            LdcInsnNode ldcInsn1 = (LdcInsnNode)insn1;
            LdcInsnNode ldcInsn2 = (LdcInsnNode)insn2;
            return Objects.equals(ldcInsn1.cst, ldcInsn2.cst);
        }
        if (insn1.getType() == 10) {
            IincInsnNode iincInsn1 = (IincInsnNode)insn1;
            IincInsnNode iincInsn2 = (IincInsnNode)insn2;
            return iincInsn1.var == iincInsn2.var && iincInsn1.incr == iincInsn2.incr;
        }
        if (insn1.getType() == 11) {
            TableSwitchInsnNode tableSwitchInsn1 = (TableSwitchInsnNode)insn1;
            TableSwitchInsnNode tableSwitchInsn2 = (TableSwitchInsnNode)insn2;
            return tableSwitchInsn1.min == tableSwitchInsn2.min && tableSwitchInsn1.max == tableSwitchInsn2.max && ASMComparator.equals(tableSwitchInsn1.dflt, tableSwitchInsn2.dflt) && ASMComparator.equals(tableSwitchInsn1.labels, tableSwitchInsn2.labels);
        }
        if (insn1.getType() == 12) {
            LookupSwitchInsnNode lookupSwitchInsn1 = (LookupSwitchInsnNode)insn1;
            LookupSwitchInsnNode lookupSwitchInsn2 = (LookupSwitchInsnNode)insn2;
            return ASMComparator.equals(lookupSwitchInsn1.dflt, lookupSwitchInsn2.dflt) && Objects.equals(lookupSwitchInsn1.keys, lookupSwitchInsn2.keys) && ASMComparator.equals(lookupSwitchInsn1.labels, lookupSwitchInsn2.labels);
        }
        if (insn1.getType() == 13) {
            MultiANewArrayInsnNode multiANewArrayInsn1 = (MultiANewArrayInsnNode)insn1;
            MultiANewArrayInsnNode multiANewArrayInsn2 = (MultiANewArrayInsnNode)insn2;
            return Objects.equals(multiANewArrayInsn1.desc, multiANewArrayInsn2.desc) && multiANewArrayInsn1.dims == multiANewArrayInsn2.dims;
        }
        if (insn1.getType() == 14) {
            FrameNode frameNode1 = (FrameNode)insn1;
            FrameNode frameNode2 = (FrameNode)insn2;
            return frameNode1.type == frameNode2.type && ASMComparator.dynamicEquals(frameNode1.local, frameNode2.local) && ASMComparator.dynamicEquals(frameNode1.stack, frameNode2.stack);
        }
        if (insn1.getType() == 15) {
            LineNumberNode lineNumberNode1 = (LineNumberNode)insn1;
            LineNumberNode lineNumberNode2 = (LineNumberNode)insn2;
            return lineNumberNode1.line == lineNumberNode2.line && ASMComparator.equals(lineNumberNode1.start, lineNumberNode2.start);
        }
        return false;
    }

    private static boolean dynamicEquals(List<Object> list1, List<Object> list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            Object obj2;
            Object obj1 = list1.get(i);
            if (obj1 == (obj2 = list2.get(i))) continue;
            if (obj1 == null || obj2 == null) {
                return false;
            }
            if (!(obj1 instanceof AbstractInsnNode && obj2 instanceof AbstractInsnNode ? !ASMComparator.equals((AbstractInsnNode)obj1, (AbstractInsnNode)obj2) : !Objects.equals(obj1, obj2))) continue;
            return false;
        }
        return true;
    }
}

