/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.mixinstranslator.impl;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.mixinstranslator.impl.AnnotationTranslatorManager;
import net.lenni0451.classtransform.utils.annotations.AnnotationUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;

@ParametersAreNonnullByDefault
public interface IAnnotationTranslator {
    public void translate(AnnotationNode var1, Map<String, Object> var2);

    default public void dynamicTranslate(AnnotationNode annotation) {
        IAnnotationTranslator translator = AnnotationTranslatorManager.getTranslator(Type.getType(annotation.desc));
        if (translator != null) {
            Map<String, Object> values = AnnotationUtils.listToMap(annotation.values);
            translator.translate(annotation, values);
            annotation.values = AnnotationUtils.mapToList(values);
        }
    }

    default public AnnotationNode getSingleAnnotation(String name, Map<String, Object> values, String annotationName) {
        Object rawValue = values.remove(name);
        if (rawValue instanceof AnnotationNode) {
            return (AnnotationNode)rawValue;
        }
        if (rawValue instanceof List) {
            values.remove(name);
            List list = (List)rawValue;
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() == 1) {
                values.put(name, list.get(0));
                return (AnnotationNode)list.get(0);
            }
            throw new IllegalStateException("ClassTransform does not support multiple " + name + " in @" + annotationName + " annotations");
        }
        throw new IllegalStateException("Unknown type for " + name + " in @" + annotationName + " annotation");
    }

    default public void move(Map<String, Object> values, String from, String to) {
        if (values.containsKey(from)) {
            values.put(to, values.remove(from));
        }
    }

    default public <F, T> void map(Map<String, Object> values, String from, String to, Function<F, T> mapper) {
        if (values.containsKey(from)) {
            values.put(to, mapper.apply(values.remove(from)));
        }
    }

    default public void move(Map<String, Object> from, Map<String, Object> to, String key) {
        if (from.containsKey(key)) {
            to.put(key, from.remove(key));
        }
    }
}

