/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.mixinstranslator;

import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.InjectionCallback;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@ParametersAreNonnullByDefault
class CallbackRewriter {
    private static final Type CALLBACK_INFO = Type.getType(CallbackInfo.class);
    private static final Type CALLBACK_INFO_RETURNABLE = Type.getType(CallbackInfoReturnable.class);
    private static final Type INJECTION_CALLBACK = Type.getType(InjectionCallback.class);

    CallbackRewriter() {
    }

    static void rewrite(MethodNode methodNode) {
        Type[] parameter = Type.getArgumentTypes(methodNode.desc);
        Type returnType = Type.getReturnType(methodNode.desc);
        boolean setDescriptor = false;
        for (int i = 0; i < parameter.length; ++i) {
            Type type = parameter[i];
            if (!type.equals(CALLBACK_INFO) && !type.equals(CALLBACK_INFO_RETURNABLE)) continue;
            parameter[i] = INJECTION_CALLBACK;
            setDescriptor = true;
        }
        if (returnType.equals(CALLBACK_INFO) || returnType.equals(CALLBACK_INFO_RETURNABLE)) {
            returnType = INJECTION_CALLBACK;
            setDescriptor = true;
        }
        if (setDescriptor) {
            methodNode.desc = Type.getMethodDescriptor(returnType, parameter);
            if (methodNode.signature != null) {
                String cirStart;
                int start;
                while ((start = methodNode.signature.indexOf(cirStart = "L" + CALLBACK_INFO_RETURNABLE.getInternalName())) != -1) {
                    String rest = methodNode.signature.substring(start + cirStart.length());
                    int index = 0;
                    int open = 0;
                    for (char c : rest.toCharArray()) {
                        ++index;
                        if (c == ';' && open <= 0) break;
                        if (c == '<') {
                            ++open;
                            continue;
                        }
                        if (c != '>') continue;
                        --open;
                    }
                    methodNode.signature = methodNode.signature.substring(0, start) + INJECTION_CALLBACK.getDescriptor() + methodNode.signature.substring(start + cirStart.length() + index);
                }
            }
        }
        CallbackRewriter.visitMethodInsn(methodNode);
    }

    private static void visitMethodInsn(MethodNode methodNode) {
        for (AbstractInsnNode insn : methodNode.instructions.toArray()) {
            MethodInsnNode method;
            if (!(insn instanceof MethodInsnNode) || (method = (MethodInsnNode)insn).getOpcode() != 182) continue;
            boolean isCallbackInfo = method.owner.equals(CALLBACK_INFO.getInternalName());
            boolean isCallbackInfoReturnable = method.owner.equals(CALLBACK_INFO_RETURNABLE.getInternalName());
            if (isCallbackInfo || isCallbackInfoReturnable) {
                method.owner = INJECTION_CALLBACK.getInternalName();
                if (method.name.equals("cancel") && method.desc.equals("()V")) {
                    method.name = "setCancelled";
                    method.desc = "(Z)V";
                    methodNode.instructions.insertBefore((AbstractInsnNode)method, new InsnNode(4));
                }
            }
            if (!isCallbackInfoReturnable) continue;
            if (method.name.equals("getReturnValueB") && method.desc.equals("()B")) {
                methodNode.instructions.insert((AbstractInsnNode)method, new MethodInsnNode(182, "java/lang/Byte", "byteValue", "()B"));
                continue;
            }
            if (method.name.equals("getReturnValueC") && method.desc.equals("()C")) {
                methodNode.instructions.insert((AbstractInsnNode)method, new MethodInsnNode(182, "java/lang/Character", "charValue", "()C", false));
                continue;
            }
            if (method.name.equals("getReturnValueD") && method.desc.equals("()D")) {
                methodNode.instructions.insert((AbstractInsnNode)method, new MethodInsnNode(182, "java/lang/Double", "doubleValue", "()D", false));
                continue;
            }
            if (method.name.equals("getReturnValueF") && method.desc.equals("()F")) {
                methodNode.instructions.insert((AbstractInsnNode)method, new MethodInsnNode(182, "java/lang/Float", "floatValue", "()F", false));
                continue;
            }
            if (method.name.equals("getReturnValueI") && method.desc.equals("()I")) {
                methodNode.instructions.insert((AbstractInsnNode)method, new MethodInsnNode(182, "java/lang/Integer", "intValue", "()I", false));
                continue;
            }
            if (method.name.equals("getReturnValueJ") && method.desc.equals("()J")) {
                methodNode.instructions.insert((AbstractInsnNode)method, new MethodInsnNode(182, "java/lang/Long", "longValue", "()J", false));
                continue;
            }
            if (method.name.equals("getReturnValueS") && method.desc.equals("()S")) {
                methodNode.instructions.insert((AbstractInsnNode)method, new MethodInsnNode(182, "java/lang/Short", "shortValue", "()S", false));
                continue;
            }
            if (!method.name.equals("getReturnValueZ") || !method.desc.equals("()Z")) continue;
            methodNode.instructions.insert((AbstractInsnNode)method, new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z", false));
        }
    }
}

