/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.remapper;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ModuleNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.ParameterNode;
import org.objectweb.asm.tree.RecordComponentNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.stianloader.remapper.DescString;
import org.stianloader.remapper.MappingLookup;

public final class Remapper {
    @NotNull
    private final MappingLookup lookup;

    @NotNull
    public static String getRemappedFieldDescriptor(@NotNull MappingLookup lookup, @NotNull String fieldDesc, @NotNull StringBuilder sharedBuilder) {
        sharedBuilder.setLength(0);
        return Remapper.remapSingleDesc(lookup, fieldDesc, sharedBuilder);
    }

    @NotNull
    public static String getRemappedMethodDescriptor(@NotNull MappingLookup lookup, @NotNull String methodDesc, @NotNull StringBuilder sharedBuilder) {
        sharedBuilder.setLength(0);
        if (!Remapper.remapSignature(lookup, methodDesc, sharedBuilder)) {
            return methodDesc;
        }
        return sharedBuilder.toString();
    }

    @NotNull
    public static String remapInternalName(@NotNull MappingLookup lookup, @NotNull String internalName, @NotNull StringBuilder sharedStringBuilder) {
        if (internalName.codePointAt(0) == 91) {
            return Remapper.remapSingleDesc(lookup, internalName, sharedStringBuilder);
        }
        return lookup.getRemappedClassName(internalName);
    }

    public static boolean remapSignature(@NotNull MappingLookup lookup, @NotNull String signature, int start, int end, @NotNull StringBuilder signatureOut) {
        if (start == end) {
            return false;
        }
        int type = signature.codePointAt(start++);
        switch (type) {
            case 76: 
            case 84: {
                int codepoint;
                int endObject = start;
                do {
                    if ((codepoint = signature.codePointAt(++endObject)) != 59) continue;
                    String name = signature.substring(start, endObject);
                    String newName = lookup.getRemappedClassNameFast(name);
                    boolean modified = false;
                    if (newName != null) {
                        name = newName;
                        modified = true;
                    }
                    signatureOut.appendCodePoint(type);
                    signatureOut.append(name);
                    signatureOut.append(';');
                    return modified |= Remapper.remapSignature(lookup, signature, ++endObject, end, signatureOut);
                } while (codepoint != 60);
                int openingBrackets = 1;
                int endGenerics = endObject;
                while (true) {
                    if ((codepoint = signature.codePointAt(++endGenerics)) == 62) {
                        if (--openingBrackets != 0) continue;
                        break;
                    }
                    if (codepoint != 60) continue;
                    ++openingBrackets;
                }
                String name = signature.substring(start, endObject);
                String newName = lookup.getRemappedClassNameFast(name);
                boolean modified = false;
                if (newName != null) {
                    name = newName;
                    modified = true;
                }
                signatureOut.append('L');
                signatureOut.append(name);
                signatureOut.append('<');
                modified |= Remapper.remapSignature(lookup, signature, endObject + 1, endGenerics++, signatureOut);
                signatureOut.append('>');
                signatureOut.appendCodePoint(signature.codePointAt(endGenerics));
                return modified |= Remapper.remapSignature(lookup, signature, ++endGenerics, end, signatureOut);
            }
        }
        signatureOut.appendCodePoint(type);
        return Remapper.remapSignature(lookup, signature, start, end, signatureOut);
    }

    public static boolean remapSignature(@NotNull MappingLookup lookup, @NotNull String signature, @NotNull StringBuilder out) {
        return Remapper.remapSignature(lookup, signature, 0, signature.length(), out);
    }

    @NotNull
    private static String remapSingleDesc(@NotNull MappingLookup lookup, @NotNull String input, StringBuilder sharedBuilder) {
        int indexofL = input.indexOf(76);
        if (indexofL == -1) {
            return input;
        }
        int length = input.length();
        String internalName = input.substring(indexofL + 1, length - 1);
        String newInternalName = lookup.getRemappedClassNameFast(internalName);
        if (newInternalName == null) {
            return input;
        }
        sharedBuilder.setLength(indexofL + 1);
        sharedBuilder.setCharAt(indexofL, 'L');
        while (indexofL != 0) {
            sharedBuilder.setCharAt(--indexofL, '[');
        }
        sharedBuilder.append(newInternalName);
        sharedBuilder.append(';');
        return sharedBuilder.toString();
    }

    public Remapper(@NotNull MappingLookup lookup) {
        this.lookup = lookup;
    }

    @NotNull
    @Contract(pure=true)
    public final MappingLookup getLookup() {
        return this.lookup;
    }

    private void remapAnnotation(AnnotationNode annotation, StringBuilder sharedStringBuilder) {
        String internalName = annotation.desc.substring(1, annotation.desc.length() - 1);
        String newInternalName = this.lookup.getRemappedClassNameFast(internalName);
        if (newInternalName != null) {
            annotation.desc = 'L' + newInternalName + ';';
        }
        if (annotation.values != null) {
            int size = annotation.values.size();
            for (int i = 0; i < size; ++i) {
                String bitvoid = (String)annotation.values.get(i++);
                this.remapAnnotationValue(annotation.values.get(i), i, annotation.values, sharedStringBuilder);
            }
        }
    }

    private void remapAnnotations(List<? extends AnnotationNode> annotations, StringBuilder sharedStringBuilder) {
        if (annotations == null) {
            return;
        }
        for (AnnotationNode annotationNode : annotations) {
            this.remapAnnotation(annotationNode, sharedStringBuilder);
        }
    }

    private void remapAnnotationValue(Object value, int index, List<Object> values, StringBuilder sharedStringBuilder) {
        if (value instanceof Type) {
            String type = ((Type)value).getDescriptor();
            sharedStringBuilder.setLength(0);
            if (Remapper.remapSignature(this.lookup, type, sharedStringBuilder)) {
                values.set(index, Type.getType((String)sharedStringBuilder.toString()));
            }
        } else if (value instanceof String[]) {
            String[] enumvals = (String[])value;
            String ownerName = enumvals[0].substring(1, enumvals[0].length() - 1);
            enumvals[1] = this.lookup.getRemappedFieldName(ownerName, enumvals[1], enumvals[0]);
            String newInternalName = this.lookup.getRemappedClassNameFast(ownerName);
            if (newInternalName != null) {
                enumvals[0] = 'L' + newInternalName + ';';
            }
        } else if (value instanceof AnnotationNode) {
            this.remapAnnotation((AnnotationNode)value, sharedStringBuilder);
        } else if (value instanceof List) {
            List valueList = (List)value;
            int i = valueList.size();
            while (i-- != 0) {
                this.remapAnnotationValue(valueList.get(i), i, valueList, sharedStringBuilder);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void remapBSMArg(Object[] bsmArgs, int index, StringBuilder sharedStringBuilder) {
        Object bsmArg = bsmArgs[index];
        if (bsmArg instanceof Type) {
            Type type = (Type)bsmArg;
            sharedStringBuilder.setLength(0);
            if (type.getSort() == 11) {
                if (!Remapper.remapSignature(this.lookup, type.getDescriptor(), sharedStringBuilder)) return;
                bsmArgs[index] = Type.getMethodType((String)sharedStringBuilder.toString());
                return;
            } else {
                String remappedVal;
                if (type.getSort() != 10) throw new IllegalArgumentException("Unexpected bsm arg Type sort. Sort = " + type.getSort() + "; type = " + type);
                String oldVal = type.getInternalName();
                if (oldVal == (remappedVal = Remapper.remapInternalName(this.lookup, oldVal, sharedStringBuilder))) return;
                bsmArgs[index] = Type.getObjectType((String)remappedVal);
            }
            return;
        } else if (bsmArg instanceof Handle) {
            boolean modified;
            Handle handle = (Handle)bsmArg;
            String oldName = handle.getName();
            String hOwner = handle.getOwner();
            String newName = this.lookup.getRemappedMethodName(hOwner, oldName, handle.getDesc());
            String newOwner = this.lookup.getRemappedClassNameFast(hOwner);
            boolean bl = modified = oldName != newName;
            if (newOwner != null) {
                hOwner = newOwner;
                modified = true;
            }
            String desc = handle.getDesc();
            sharedStringBuilder.setLength(0);
            if (Remapper.remapSignature(this.lookup, desc, sharedStringBuilder)) {
                desc = sharedStringBuilder.toString();
                modified = true;
            }
            if (!modified) return;
            bsmArgs[index] = new Handle(handle.getTag(), hOwner, newName, desc, handle.isInterface());
            return;
        } else {
            if (bsmArg instanceof String) return;
            throw new IllegalArgumentException("Unexpected bsm arg class at index " + index + " for " + Arrays.toString(bsmArgs) + ". Class is " + bsmArg.getClass().getName());
        }
    }

    private void remapFrameNode(@NotNull FrameNode frameNode, @NotNull StringBuilder sharedStringBuilder) {
        Object o;
        int i;
        if (frameNode.stack != null) {
            i = frameNode.stack.size();
            while (i-- != 0) {
                o = frameNode.stack.get(i);
                if (!(o instanceof String)) continue;
                frameNode.stack.set(i, Remapper.remapInternalName(this.lookup, (String)o, sharedStringBuilder));
            }
        }
        if (frameNode.local != null) {
            i = frameNode.local.size();
            while (i-- != 0) {
                o = frameNode.local.get(i);
                if (!(o instanceof String)) continue;
                frameNode.local.set(i, Remapper.remapInternalName(this.lookup, (String)o, sharedStringBuilder));
            }
        }
    }

    private void remapModule(@NotNull ModuleNode module, @NotNull StringBuilder sharedStringBuilder) {
        if (module.mainClass != null) {
            module.mainClass = this.lookup.getRemappedClassName(module.mainClass);
        }
        if (module.uses != null) {
            int i = module.uses.size();
            while (i-- != 0) {
                module.uses.set(i, Remapper.remapInternalName(this.lookup, (String)module.uses.get(i), sharedStringBuilder));
            }
        }
    }

    @Contract(pure=false, mutates="param1,param2", value="_, _ -> this")
    @NotNull
    public Remapper remapNode(@NotNull ClassNode node, @NotNull StringBuilder sharedBuilder) {
        for (FieldNode field : node.fields) {
            this.remapNode(node.name, field, sharedBuilder);
        }
        for (InnerClassNode innerClass : node.innerClasses) {
            String outerName = innerClass.outerName;
            if (outerName != null) {
                innerClass.outerName = this.lookup.getRemappedClassName(outerName);
            }
            innerClass.name = this.lookup.getRemappedClassName(innerClass.name);
        }
        int i = node.interfaces.size();
        while (i-- != 0) {
            node.interfaces.set(i, this.lookup.getRemappedClassName((String)node.interfaces.get(i)));
        }
        this.remapAnnotations(node.invisibleTypeAnnotations, sharedBuilder);
        this.remapAnnotations(node.invisibleAnnotations, sharedBuilder);
        this.remapAnnotations(node.visibleTypeAnnotations, sharedBuilder);
        this.remapAnnotations(node.visibleAnnotations, sharedBuilder);
        for (MethodNode method : node.methods) {
            this.remapNode(node.name, method, sharedBuilder);
        }
        ModuleNode module = node.module;
        if (module != null) {
            this.remapModule(module, sharedBuilder);
        }
        if (node.nestHostClass != null) {
            node.nestHostClass = this.lookup.getRemappedClassName(node.nestHostClass);
        }
        if (node.nestMembers != null) {
            int i2 = node.nestMembers.size();
            while (i2-- != 0) {
                node.nestMembers.set(i2, this.lookup.getRemappedClassName((String)node.nestMembers.get(i2)));
            }
        }
        if (node.outerClass != null) {
            if (node.outerMethod != null && node.outerMethodDesc != null) {
                node.outerMethod = this.lookup.getRemappedMethodName(node.outerClass, node.outerMethod, node.outerMethodDesc);
            }
            node.outerClass = this.lookup.getRemappedClassName(node.outerClass);
        }
        if (node.outerMethodDesc != null) {
            sharedBuilder.setLength(0);
            if (Remapper.remapSignature(this.lookup, node.outerMethodDesc, sharedBuilder)) {
                node.outerMethodDesc = sharedBuilder.toString();
            }
        }
        if (node.permittedSubclasses != null) {
            int i3 = node.permittedSubclasses.size();
            while (i3-- != 0) {
                node.permittedSubclasses.set(i3, this.lookup.getRemappedClassName((String)node.permittedSubclasses.get(i3)));
            }
        }
        if (node.recordComponents != null) {
            for (RecordComponentNode record : node.recordComponents) {
                sharedBuilder.setLength(0);
                if (Remapper.remapSignature(this.lookup, record.descriptor, sharedBuilder)) {
                    record.descriptor = sharedBuilder.toString();
                }
                this.remapAnnotations(record.invisibleAnnotations, sharedBuilder);
                this.remapAnnotations(record.invisibleTypeAnnotations, sharedBuilder);
                this.remapAnnotations(record.visibleAnnotations, sharedBuilder);
                this.remapAnnotations(record.visibleTypeAnnotations, sharedBuilder);
                if (record.signature == null) continue;
                sharedBuilder.setLength(0);
                if (!Remapper.remapSignature(this.lookup, record.signature, sharedBuilder)) continue;
                record.signature = sharedBuilder.toString();
            }
        }
        if (node.signature != null) {
            sharedBuilder.setLength(0);
            if (Remapper.remapSignature(this.lookup, node.signature, sharedBuilder)) {
                node.signature = sharedBuilder.toString();
            }
        }
        if (!Objects.isNull(node.superName)) {
            node.superName = this.lookup.getRemappedClassName(node.superName);
        }
        node.name = this.lookup.getRemappedClassName(node.name);
        return this;
    }

    @NotNull
    @Contract(pure=false, mutates="param2, param3", value="_, _, _ -> this")
    public Remapper remapNode(@NotNull String owner, @NotNull FieldNode field, @NotNull StringBuilder sharedStringBuilder) {
        field.name = this.lookup.getRemappedFieldName(owner, field.name, field.desc);
        char typeType = field.desc.charAt(0);
        if (typeType == '[' || typeType == 'L') {
            sharedStringBuilder.setLength(0);
            field.desc = Remapper.remapSingleDesc(this.lookup, field.desc, sharedStringBuilder);
            if (field.signature != null) {
                sharedStringBuilder.setLength(0);
                if (Remapper.remapSignature(this.lookup, field.signature, sharedStringBuilder)) {
                    field.signature = sharedStringBuilder.toString();
                }
            }
        }
        this.remapAnnotations(field.invisibleTypeAnnotations, sharedStringBuilder);
        this.remapAnnotations(field.invisibleAnnotations, sharedStringBuilder);
        this.remapAnnotations(field.visibleAnnotations, sharedStringBuilder);
        this.remapAnnotations(field.visibleTypeAnnotations, sharedStringBuilder);
        return this;
    }

    @NotNull
    @Contract(pure=false, mutates="param2, param3", value="_, _, _ -> this")
    public Remapper remapNode(@NotNull String owner, @NotNull MethodNode method, @NotNull StringBuilder sharedStringBuilder) {
        InsnList instructions;
        int i;
        List parameters = method.parameters;
        if (parameters != null) {
            i = 0;
            for (ParameterNode parameter : parameters) {
                try {
                    parameter.name = this.getLookup().getRemappedParameterName(owner, method.name, method.desc, i++, (method.access & 8) != 0);
                }
                catch (AbstractMethodError | UnsupportedOperationException throwable) {}
            }
            List lvt = method.localVariables;
            if (lvt != null) {
                int j;
                DescString dString = new DescString(method.desc);
                int paramCount = Type.getArgumentCount((String)method.desc);
                int[] paramIndices = new int[paramCount * 2 + 1];
                i = 0;
                int n = j = (method.access & 8) == 0 ? 1 : 0;
                while (i < paramIndices.length / 2) {
                    int type = dString.nextReferenceType();
                    if (type == 74 || type == 68) {
                        paramIndices[j++] = i;
                    }
                    paramIndices[j++] = i++;
                }
                for (LocalVariableNode lvn : lvt) {
                    if (lvn.index >= paramIndices.length) continue;
                    int paramIndex = paramIndices[lvn.index];
                    if (lvn.index == 0 && (method.access & 8) == 0 || lvn.start.getPrevious() != null || lvn.end.getNext() != null) continue;
                    try {
                        String newName = this.getLookup().getRemappedParameterName(owner, method.name, method.desc, paramIndex, (method.access & 8) != 0);
                        if (newName == null) continue;
                        lvn.name = newName;
                    }
                    catch (AbstractMethodError | UnsupportedOperationException throwable) {}
                }
            }
        }
        method.name = this.lookup.getRemappedMethodName(owner, method.name, method.desc);
        i = method.exceptions.size();
        while (i-- != 0) {
            method.exceptions.set(i, this.lookup.getRemappedClassName((String)method.exceptions.get(i)));
        }
        this.remapAnnotations(method.invisibleTypeAnnotations, sharedStringBuilder);
        this.remapAnnotations(method.invisibleLocalVariableAnnotations, sharedStringBuilder);
        this.remapAnnotations(method.invisibleAnnotations, sharedStringBuilder);
        this.remapAnnotations(method.visibleAnnotations, sharedStringBuilder);
        this.remapAnnotations(method.visibleTypeAnnotations, sharedStringBuilder);
        this.remapAnnotations(method.visibleLocalVariableAnnotations, sharedStringBuilder);
        if (method.invisibleParameterAnnotations != null) {
            for (List annotations : method.invisibleParameterAnnotations) {
                this.remapAnnotations(annotations, sharedStringBuilder);
            }
        }
        if (method.visibleParameterAnnotations != null) {
            for (List annotations : method.visibleParameterAnnotations) {
                this.remapAnnotations(annotations, sharedStringBuilder);
            }
        }
        if (method.localVariables != null) {
            for (LocalVariableNode lvn : method.localVariables) {
                lvn.desc = Remapper.remapSingleDesc(this.lookup, lvn.desc, sharedStringBuilder);
                String signature = lvn.signature;
                if (signature == null) continue;
                sharedStringBuilder.setLength(0);
                if (!Remapper.remapSignature(this.lookup, signature, sharedStringBuilder)) continue;
                lvn.signature = sharedStringBuilder.toString();
            }
        }
        for (TryCatchBlockNode catchBlock : method.tryCatchBlocks) {
            if (catchBlock.type != null) {
                catchBlock.type = this.lookup.getRemappedClassName(catchBlock.type);
            }
            this.remapAnnotations(catchBlock.visibleTypeAnnotations, sharedStringBuilder);
            this.remapAnnotations(catchBlock.invisibleTypeAnnotations, sharedStringBuilder);
        }
        sharedStringBuilder.setLength(0);
        if (Remapper.remapSignature(this.lookup, method.desc, sharedStringBuilder)) {
            method.desc = sharedStringBuilder.toString();
        }
        if (method.signature != null) {
            sharedStringBuilder.setLength(0);
            if (Remapper.remapSignature(this.lookup, method.signature, sharedStringBuilder)) {
                method.signature = sharedStringBuilder.toString();
            }
        }
        if (method.annotationDefault != null && !(method.annotationDefault instanceof Number)) {
            List<Object> annotationList = Arrays.asList(method.annotationDefault);
            this.remapAnnotationValue(method.annotationDefault, 0, annotationList, sharedStringBuilder);
            method.annotationDefault = annotationList.get(0);
        }
        if ((instructions = method.instructions).size() != 0) {
            for (AbstractInsnNode insn = instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn instanceof FieldInsnNode) {
                    FieldInsnNode instruction = (FieldInsnNode)insn;
                    instruction.name = this.lookup.getRemappedFieldName(instruction.owner, instruction.name, instruction.desc);
                    instruction.desc = Remapper.remapSingleDesc(this.lookup, instruction.desc, sharedStringBuilder);
                    instruction.owner = this.lookup.getRemappedClassName(instruction.owner);
                    continue;
                }
                if (insn instanceof FrameNode) {
                    this.remapFrameNode((FrameNode)insn, sharedStringBuilder);
                    continue;
                }
                if (insn instanceof InvokeDynamicInsnNode) {
                    InvokeDynamicInsnNode specialisedInsn = (InvokeDynamicInsnNode)insn;
                    String lambdaType = specialisedInsn.desc.substring(specialisedInsn.desc.indexOf(41) + 2, specialisedInsn.desc.length() - 1);
                    Object[] bsmArgs = specialisedInsn.bsmArgs;
                    specialisedInsn.name = this.lookup.getRemappedMethodName(lambdaType, specialisedInsn.name, ((Type)bsmArgs[0]).getDescriptor());
                    int i2 = bsmArgs.length;
                    while (i2-- != 0) {
                        this.remapBSMArg(bsmArgs, i2, sharedStringBuilder);
                    }
                    sharedStringBuilder.setLength(0);
                    if (!Remapper.remapSignature(this.lookup, specialisedInsn.desc, sharedStringBuilder)) continue;
                    specialisedInsn.desc = sharedStringBuilder.toString();
                    continue;
                }
                if (insn instanceof LdcInsnNode) {
                    String newDescString;
                    String descString;
                    LdcInsnNode specialisedInsn = (LdcInsnNode)insn;
                    if (!(specialisedInsn.cst instanceof Type) || (descString = ((Type)specialisedInsn.cst).getDescriptor()) == (newDescString = Remapper.remapSingleDesc(this.lookup, descString, sharedStringBuilder))) continue;
                    specialisedInsn.cst = Type.getType((String)newDescString);
                    continue;
                }
                if (insn instanceof MethodInsnNode) {
                    boolean isArray;
                    MethodInsnNode instruction = (MethodInsnNode)insn;
                    boolean bl = isArray = instruction.owner.codePointAt(0) == 91;
                    if (!isArray) {
                        instruction.name = this.lookup.getRemappedMethodName(instruction.owner, instruction.name, instruction.desc);
                        instruction.owner = this.lookup.getRemappedClassName(instruction.owner);
                    } else {
                        sharedStringBuilder.setLength(0);
                        instruction.owner = Remapper.remapSingleDesc(this.lookup, instruction.owner, sharedStringBuilder);
                    }
                    sharedStringBuilder.setLength(0);
                    if (!Remapper.remapSignature(this.lookup, instruction.desc, sharedStringBuilder)) continue;
                    instruction.desc = sharedStringBuilder.toString();
                    continue;
                }
                if (insn instanceof MultiANewArrayInsnNode) {
                    MultiANewArrayInsnNode instruction = (MultiANewArrayInsnNode)insn;
                    instruction.desc = Remapper.remapSingleDesc(this.lookup, instruction.desc, sharedStringBuilder);
                    continue;
                }
                if (!(insn instanceof TypeInsnNode)) continue;
                TypeInsnNode instruction = (TypeInsnNode)insn;
                instruction.desc = Remapper.remapInternalName(this.lookup, instruction.desc, sharedStringBuilder);
            }
        }
        return this;
    }
}

