/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.remapper;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonBlocking;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.remapper.MappingLookup;
import org.stianloader.remapper.MappingSink;
import org.stianloader.remapper.MemberRef;

public class HierarchyAwareMappingDelegator<T extends MappingLookup & MappingSink>
implements MappingLookup,
MappingSink {
    @NotNull
    private final TopLevelMemberLookup definitionLookup;
    @NotNull
    private final T delegate;

    public HierarchyAwareMappingDelegator(@NotNull T lookupDelegate, @NotNull TopLevelMemberLookup definitionLookup) {
        this.definitionLookup = definitionLookup;
        this.delegate = lookupDelegate;
    }

    @Override
    @NotNull
    public String getRemappedClassName(@NotNull String srcName) {
        return this.delegate.getRemappedClassName(srcName);
    }

    @Override
    @Nullable
    public String getRemappedClassNameFast(@NotNull String srcName) {
        return this.delegate.getRemappedClassNameFast(srcName);
    }

    @Override
    @NotNull
    public String getRemappedFieldName(@NotNull String srcOwner, @NotNull String srcName, @NotNull String srcDesc) {
        MemberRef topLevel = this.definitionLookup.getDefinition(new MemberRef(srcOwner, srcName, srcDesc));
        if (srcDesc.codePointAt(0) != topLevel.getDesc().codePointAt(0)) {
            throw new IllegalStateException("Definition lookup altered the type of member from " + srcDesc + " to " + topLevel.getDesc() + ", which is not permitted.");
        }
        return this.delegate.getRemappedFieldName(topLevel.getOwner(), topLevel.getName(), topLevel.getDesc());
    }

    @Override
    @NotNull
    public String getRemappedMethodName(@NotNull String srcOwner, @NotNull String srcName, @NotNull String srcDesc) {
        MemberRef topLevel = this.definitionLookup.getDefinition(new MemberRef(srcOwner, srcName, srcDesc));
        if (srcDesc.codePointAt(0) != topLevel.getDesc().codePointAt(0)) {
            throw new IllegalStateException("Definition lookup altered the type of member from " + srcDesc + " to " + topLevel.getDesc() + ", which is not permitted.");
        }
        return this.delegate.getRemappedMethodName(topLevel.getOwner(), topLevel.getName(), topLevel.getDesc());
    }

    @Override
    @Nullable
    public String getRemappedParameterName(@NotNull String srcOwner, @NotNull String srcName, @NotNull String srcDesc, int paramIndex, boolean isStatic) {
        MemberRef topLevel = this.definitionLookup.getDefinition(new MemberRef(srcOwner, srcName, srcDesc));
        if (srcDesc.codePointAt(0) != topLevel.getDesc().codePointAt(0)) {
            throw new IllegalStateException("Definition lookup altered the type of member from " + srcDesc + " to " + topLevel.getDesc() + ", which is not permitted.");
        }
        return this.delegate.getRemappedParameterName(topLevel.getOwner(), topLevel.getName(), topLevel.getDesc(), paramIndex, isStatic);
    }

    @Override
    @NotNull
    public HierarchyAwareMappingDelegator<T> remapClass(@NotNull String srcName, @NotNull String dstName) {
        ((MappingSink)this.delegate).remapClass(srcName, dstName);
        return this;
    }

    @Override
    @NotNull
    public HierarchyAwareMappingDelegator<T> remapMember(@NotNull MemberRef srcRef, @NotNull String dstName) {
        MemberRef topLevel = this.definitionLookup.getDefinition(srcRef);
        if (srcRef.getDesc().codePointAt(0) != topLevel.getDesc().codePointAt(0)) {
            throw new IllegalStateException("Definition lookup altered the type of member from " + srcRef.getDesc() + " to " + topLevel.getDesc() + ", which is not permitted.");
        }
        ((MappingSink)this.delegate).remapMember(topLevel, dstName);
        return this;
    }

    @Override
    @NotNull
    public MappingSink remapParameter(@NotNull String srcOwner, @NotNull String srcMethodName, @NotNull String srcDesc, int paramIndex, @NotNull String destParamName) {
        MemberRef topLevel = this.definitionLookup.getDefinition(new MemberRef(srcOwner, destParamName, srcDesc));
        if (srcDesc.codePointAt(0) != topLevel.getDesc().codePointAt(0)) {
            throw new IllegalStateException("Definition lookup altered the type of member from " + srcDesc + " to " + topLevel.getDesc() + ", which is not permitted.");
        }
        ((MappingSink)this.delegate).remapParameter(topLevel.getOwner(), topLevel.getName(), topLevel.getDesc(), paramIndex, destParamName);
        return this;
    }

    public static interface TopLevelMemberLookup {
        @NotNull
        @Contract(pure=true, value="!null -> !null; null -> fail")
        @NonBlocking
        public MemberRef getDefinition(@NotNull MemberRef var1);
    }
}

