/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.remapper;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class DescString {
    private final String desc;
    private int startIndex = 0;

    public DescString(String desc) {
        int begin = 1;
        int end = desc.lastIndexOf(41);
        this.desc = desc.substring(begin, end);
    }

    public boolean hasNext() {
        return this.desc.length() != this.startIndex;
    }

    public int nextReferenceType() {
        int type = this.desc.codePointAt(this.startIndex);
        if (type == 76) {
            this.startIndex = this.desc.indexOf(59, this.startIndex) + 1;
        } else if (type == 91) {
            int typePosition = -1;
            for (int i = this.startIndex + 1; i < this.desc.length(); ++i) {
                if (this.desc.charAt(i) == '[') continue;
                typePosition = i;
                break;
            }
            this.startIndex = this.desc.charAt(typePosition) == 'L' ? this.desc.indexOf(59, this.startIndex) + 1 : ++typePosition;
        } else {
            ++this.startIndex;
        }
        return type;
    }

    @NotNull
    public String nextType() {
        char type = this.desc.charAt(this.startIndex);
        if (type == 'L') {
            int endPos = this.desc.indexOf(59, this.startIndex) + 1;
            String ret = this.desc.substring(this.startIndex, endPos);
            this.startIndex = endPos;
            return ret;
        }
        if (type == '[') {
            int typePosition = -1;
            for (int i = this.startIndex + 1; i < this.desc.length(); ++i) {
                if (this.desc.charAt(i) == '[') continue;
                typePosition = i;
                break;
            }
            if (this.desc.charAt(typePosition) == 'L') {
                int endPos = this.desc.indexOf(59, this.startIndex) + 1;
                String ret = this.desc.substring(this.startIndex, endPos);
                this.startIndex = endPos;
                return ret;
            }
            String ret = this.desc.substring(this.startIndex, ++typePosition);
            this.startIndex = typePosition;
            return ret;
        }
        ++this.startIndex;
        return Character.toString(type);
    }

    public void reset() {
        this.startIndex = 0;
    }
}

