/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.softmap;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.stianloader.softmap.FramedRemapper;

public class SimpleFramedRemapper
implements FramedRemapper {
    @NotNull
    private final Queue<RemappingFrame> frames = Collections.asLifoQueue(new ArrayDeque());
    @NotNull
    private final @Unmodifiable Map<MethodLoc, MethodRealm> realms;

    @NotNull
    @Contract(pure=true, value="null -> fail; !null -> new")
    private static <T> @NotNull @Unmodifiable Map<T, @NotNull Set<T>> collect(@Unmodifiable @NotNull Map<T, ? extends @Nullable Set<T>> input) {
        HashMap<T, @NotNull HashSet<E>> mapOut = new HashMap();
        ArrayDeque<T> queue = new ArrayDeque<T>();
        for (T key : input.keySet()) {
            HashSet<Object> collected = new HashSet<Object>();
            queue.addAll((Collection)input.get(key));
            while (!queue.isEmpty()) {
                Object queued = queue.remove();
                if (!collected.add(queued)) continue;
                if (mapOut.containsKey(queued)) {
                    collected.addAll((Collection)mapOut.get(queued));
                    continue;
                }
                Set<T> set = input.get(queued);
                if (set == null) continue;
                collected.addAll(set);
                queue.addAll(set);
            }
            mapOut.put(key, collected);
        }
        return Collections.unmodifiableMap(mapOut);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static @NotNull @Unmodifiable Map<@NotNull MethodLoc, @NotNull MethodRealm> realmsOf(@NotNull @Unmodifiable @NotNull List<@NotNull ClassNode> nodes) {
        HashMap<@NotNull String, @NotNull Set> immediateChildren = new HashMap<String, Set>();
        HashMap<@NotNull String, ClassNode> nodeLookup = new HashMap<String, ClassNode>();
        for (ClassNode node : nodes) {
            nodeLookup.put(node.name, node);
            BiFunction<String, Set, Set> combiner = (key, children) -> {
                if (children == null) {
                    children = new TreeSet<String>();
                }
                children.add(node.name);
                return children;
            };
            immediateChildren.compute(node.superName, combiner);
            for (String interfaceName : node.interfaces) {
                immediateChildren.compute(interfaceName, combiner);
            }
        }
        Map<@NotNull K, @NotNull Set<@NotNull K>> allChildren = SimpleFramedRemapper.collect(immediateChildren);
        TreeSet<@NotNull K> applyOrder = new TreeSet((e1, e0) -> {
            int hiOrder = allChildren.getOrDefault(e0, Collections.emptySet()).size() - allChildren.getOrDefault(e1, Collections.emptySet()).size();
            return hiOrder == 0 ? e1.compareTo((String)e0) : hiOrder;
        });
        applyOrder.addAll(nodeLookup.keySet());
        HashMap<@NotNull MethodLoc, @NotNull MethodRealm> realms = new HashMap<MethodLoc, MethodRealm>();
        for (String superType : applyOrder) {
            ClassNode superNode = (ClassNode)nodeLookup.get(superType);
            for (MethodNode superMethod : superNode.methods) {
                MethodLoc myLoc = new MethodLoc(superType, superMethod.name, superMethod.desc);
                if (realms.containsKey(myLoc)) continue;
                if ((superMethod.access & 8) != 0 || (superMethod.access & 2) != 0) {
                    realms.put(myLoc, new MethodRealm(superType, superMethod.name, superMethod.desc, Collections.singleton(superType)));
                } else if ((superMethod.access & 1) != 0 || (superMethod.access & 4) != 0) {
                    Set<String> realmMembers;
                    Set<@NotNull T> children2 = allChildren.getOrDefault(superType, Collections.emptySet());
                    if (children2.isEmpty()) {
                        realmMembers = Collections.singleton(superType);
                    } else {
                        realmMembers = new HashSet(children2);
                        realmMembers.add(superType);
                    }
                    MethodRealm realm = new MethodRealm(superType, superMethod.name, superMethod.desc, realmMembers);
                    realms.put(myLoc, realm);
                    for (String child : children2) {
                        realms.put(new MethodLoc(child, superMethod.name, superMethod.desc), realm);
                    }
                } else {
                    TreeSet<@NotNull String> realmAccess = new TreeSet<String>();
                    Set<@NotNull T> children3 = allChildren.getOrDefault(superType, Collections.emptySet());
                    int lastSlashSuper = superType.lastIndexOf(47);
                    realmAccess.add(superType);
                    for (String child : children3) {
                        int lastSlashChild = child.lastIndexOf(47);
                        if (lastSlashChild != lastSlashSuper || !child.regionMatches(0, superType, 0, lastSlashChild)) continue;
                        realmAccess.add(child);
                        ClassNode childNode = (ClassNode)nodeLookup.get(child);
                        if (childNode == null) continue;
                        for (MethodNode method : childNode.methods) {
                            if (!method.name.equals(superMethod.name) || !method.desc.equals(superMethod.desc) || (method.access & 1) == 0 && (method.access & 4) == 0) continue;
                            realmAccess.addAll(allChildren.getOrDefault(child, Collections.emptySet()));
                        }
                    }
                    MethodRealm realm = new MethodRealm(superType, superMethod.name, superMethod.desc, realmAccess);
                    for (String realmType : realmAccess) {
                        realms.put(new MethodLoc(realmType, superMethod.name, superMethod.desc), realm);
                    }
                }
                if (realms.containsKey(myLoc)) continue;
                System.err.println("???? " + myLoc);
            }
        }
        return Collections.unmodifiableMap(realms);
    }

    public SimpleFramedRemapper(@NotNull @Unmodifiable Map<MethodLoc, MethodRealm> realms) {
        this.realms = realms;
    }

    @Override
    public void discardFrame() {
        this.frames.remove();
    }

    @Override
    @NotNull
    @Contract(pure=true, value="-> new")
    public @NotNull @Unmodifiable List<@NotNull String> exportToTinyV1() {
        ArrayList<@NotNull String> tiny = new ArrayList<String>();
        for (RemappingFrame frame : this.frames) {
            for (Object key : frame.classNameMappings.keySet()) {
                tiny.add("CLASS\t" + (String)key + '\t' + (String)frame.classNameMappings.get(key));
            }
            for (Object key : frame.methodFieldMappings.keySet()) {
                if (((MethodLoc)key).desc.codePointAt(0) == 40) {
                    MethodRealm realm = this.realms.get(key);
                    if (!realm.realmMembers.contains(realm.declaringClass)) {
                        throw new AssertionError((Object)("Declaring class not in realm members: " + realm.declaringClass + " for " + key));
                    }
                    for (String realmMember : realm.realmMembers) {
                        tiny.add("METHOD\t" + realmMember + '\t' + ((MethodLoc)key).desc + '\t' + ((MethodLoc)key).name + '\t' + (String)frame.methodFieldMappings.get(key));
                    }
                    continue;
                }
                tiny.add("FIELD\t" + ((MethodLoc)key).owner + '\t' + ((MethodLoc)key).desc + '\t' + ((MethodLoc)key).name + '\t' + (String)frame.methodFieldMappings.get(key));
            }
        }
        return Collections.unmodifiableList(tiny);
    }

    @Override
    public int getFrameCount() {
        return this.frames.size();
    }

    @Override
    @Nullable
    @Contract(pure=true)
    public String getMappedClass(@NotNull String srcName) {
        String mapping = srcName;
        for (RemappingFrame frame : this.frames) {
            mapping = frame.classNameMappings.getOrDefault(srcName, mapping);
        }
        if (mapping == srcName) {
            return null;
        }
        return mapping;
    }

    @Override
    @Nullable
    public String getMappedField(@NotNull String srcNameOwner, @NotNull String srcNameField, @NotNull String srcDescField) {
        String mapping = srcNameField;
        MethodLoc loc = new MethodLoc(srcNameOwner, srcNameField, srcDescField);
        for (RemappingFrame frame : this.frames) {
            mapping = frame.methodFieldMappings.getOrDefault(loc, mapping);
        }
        if (mapping == srcNameOwner) {
            return null;
        }
        return mapping;
    }

    @Override
    @Nullable
    @Contract(pure=true)
    public String getMappedMethod(@NotNull String srcNameOwner, @NotNull String srcNameMethod, @NotNull String srcDescMethod) {
        if (srcDescMethod.codePointAt(0) != 40) {
            throw new IllegalStateException("Method " + srcNameOwner + "." + srcNameMethod + " " + srcDescMethod + " is not a method. (illegal desc)");
        }
        String mapping = srcNameMethod;
        MethodRealm realm = this.realms.get(new MethodLoc(srcNameOwner, srcNameMethod, srcDescMethod));
        if (realm == null) {
            throw new IllegalStateException("Realm may not be null for methodLoc " + new MethodLoc(srcNameOwner, srcNameMethod, srcDescMethod));
        }
        srcNameOwner = realm.declaringClass;
        MethodLoc loc = new MethodLoc(srcNameOwner, srcNameMethod, srcDescMethod);
        for (RemappingFrame frame : this.frames) {
            mapping = frame.methodFieldMappings.getOrDefault(loc, mapping);
        }
        if (mapping == srcNameOwner) {
            return null;
        }
        return mapping;
    }

    @Override
    @Contract(pure=false)
    public void mapClass(@NotNull String srcOwner, @NotNull String dstOwner) {
        RemappingFrame frame = this.frames.peek();
        if (frame == null) {
            throw new NoSuchElementException("No frame to edit");
        }
        if (srcOwner.codePointBefore(srcOwner.length()) == 59 || srcOwner.codePointAt(0) == 91) {
            throw new IllegalArgumentException("Illegal owner for the source namespace: " + srcOwner);
        }
        if (dstOwner.codePointBefore(dstOwner.length()) == 59 || dstOwner.codePointAt(0) == 91) {
            throw new IllegalArgumentException("Illegal owner for the destination namespace: " + dstOwner);
        }
        frame.classNameMappings.put(srcOwner, dstOwner);
    }

    @Override
    public void mapField(@NotNull String owner, @NotNull String srcName, @NotNull String desc, @NotNull String dstName) {
        RemappingFrame frame = this.frames.peek();
        if (frame == null) {
            throw new NoSuchElementException("No frame to edit");
        }
        frame.methodFieldMappings.put(new MethodLoc(owner, srcName, desc), dstName);
    }

    @Override
    @Contract(pure=false)
    public void mapMethod(@NotNull String owner, @NotNull String srcName, @NotNull String desc, @NotNull String dstName) {
        RemappingFrame frame = this.frames.peek();
        if (frame == null) {
            throw new NoSuchElementException("No frame to edit");
        }
        owner = this.realms.get(new MethodLoc(owner, srcName, desc)).declaringClass;
        frame.methodFieldMappings.put(new MethodLoc(owner, srcName, desc), dstName);
    }

    @Override
    @Contract(pure=false)
    public void mergeFrame() {
        if (this.frames.size() < 2) {
            throw new IllegalStateException("In order to be able to merge frames, at least two frames have to exist");
        }
        RemappingFrame topFrame = this.frames.remove();
        RemappingFrame bottomFrame = this.frames.element();
        bottomFrame.classNameMappings.putAll(topFrame.classNameMappings);
        bottomFrame.methodFieldMappings.putAll(topFrame.methodFieldMappings);
    }

    @Override
    @Contract(pure=false)
    public @NotNull FramedRemapper.RemapperFrame popFrame() {
        return this.frames.remove();
    }

    @Override
    @Contract(pure=false)
    public void pushFrame() {
        this.frames.add(new RemappingFrame());
    }

    @Override
    @Contract(pure=false)
    public void pushFrame(@NotNull FramedRemapper.RemapperFrame frame) {
        this.frames.add(Objects.requireNonNull((RemappingFrame)frame));
    }

    public static class MethodLoc {
        @NotNull
        private final String desc;
        @NotNull
        private final String name;
        @NotNull
        private final String owner;

        public MethodLoc(@NotNull String owner, @NotNull String name, @NotNull String desc) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodLoc)) {
                return false;
            }
            MethodLoc other = (MethodLoc)obj;
            return other.owner.equals(this.owner) && other.name.equals(this.name) && other.desc.equals(this.desc);
        }

        @NotNull
        public String getDesc() {
            return this.desc;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getOwner() {
            return this.owner;
        }

        public int hashCode() {
            return this.owner.hashCode() ^ this.name.hashCode() ^ this.desc.hashCode();
        }

        public String toString() {
            return this.owner + '.' + this.name + ' ' + this.desc;
        }
    }

    public static class MethodRealm {
        @NotNull
        private final String declaringClass;
        @NotNull
        private final String methodDesc;
        @NotNull
        private final String methodName;
        @NotNull
        private final @NotNull Set<@NotNull String> realmMembers;

        public MethodRealm(@NotNull String declaringClass, @NotNull String methodName, @NotNull String methodDesc, @NotNull @NotNull Set<@NotNull String> realmMembers) {
            this.declaringClass = declaringClass;
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.realmMembers = realmMembers;
        }
    }

    private static class RemappingFrame
    implements FramedRemapper.RemapperFrame {
        @NotNull
        private final Map<String, String> classNameMappings = new HashMap<String, String>();
        @NotNull
        private final @NotNull Map<@NotNull MethodLoc, String> methodFieldMappings = new HashMap<MethodLoc, String>();

        private RemappingFrame() {
        }
    }
}

