/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.deobf.stack.source;

import de.geolykt.starloader.deobf.StackElement;
import de.geolykt.starloader.deobf.stack.source.AbstractInsnSource;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.InsnNode;

public final class ArithmeticOperationSource
extends AbstractInsnSource<InsnNode> {
    public final StackElement leftHand;
    public final StackElement rightHand;

    public ArithmeticOperationSource(InsnNode insn, StackElement leftHand, StackElement rightHand) {
        super(insn);
        this.leftHand = leftHand;
        this.rightHand = rightHand;
    }

    @NotNull
    public String getOperandTypeString() {
        switch (this.insn.getOpcode()) {
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                return "F";
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                return "D";
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return "L";
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return "I";
            }
        }
        throw new IllegalStateException("Invalid opcode: " + this.insn.getOpcode());
    }

    public int getOperandType() {
        switch (this.insn.getOpcode()) {
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                return 70;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                return 68;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return 76;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return 73;
            }
        }
        throw new IllegalStateException("Invalid opcode: " + this.insn.getOpcode());
    }
}

