/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.deobf.remapper;

import de.geolykt.starloader.deobf.remapper.ConflicitingMappingException;
import de.geolykt.starloader.deobf.remapper.FieldRenameMap;
import de.geolykt.starloader.deobf.remapper.MethodRenameMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ModuleNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.RecordComponentNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;

public final class Remapper {
    private final FieldRenameMap fieldRenames = new FieldRenameMap();
    private final FieldRenameMap hierarchisedFieldRenames = new FieldRenameMap();
    private final MethodRenameMap methodRenames = new MethodRenameMap();
    private final Map<String, ClassNode> nameToNode = new HashMap<String, ClassNode>();
    private final Map<String, String> oldToNewClassName = new HashMap<String, String>();
    private final List<ClassNode> targets = new ArrayList<ClassNode>();
    private boolean fieldRenameHierarchyOutdated = false;

    public void addTarget(ClassNode node) {
        if (this.nameToNode.put(node.name, node) != null) {
            throw new IllegalStateException("The same class node was registered more than twice.");
        }
        this.targets.add(node);
    }

    public void addTargets(Collection<ClassNode> nodes) {
        this.targets.addAll(Objects.requireNonNull(nodes, "Cannot add a null class node list to the target pool."));
        nodes.forEach(node -> {
            if (this.nameToNode.put(node.name, (ClassNode)node) != null) {
                throw new IllegalStateException("The same class node was registered more than twice.");
            }
        });
    }

    public void clearTargets() {
        this.targets.clear();
        this.nameToNode.clear();
    }

    private void createFieldHierarchy() {
        boolean modified;
        this.hierarchisedFieldRenames.clear();
        HashMap<String, Set> children = new HashMap<String, Set>();
        for (ClassNode node : this.targets) {
            children.compute(node.superName, (k, v) -> {
                if (v == null) {
                    v = new HashSet<String>();
                }
                v.add(node.name);
                return v;
            });
        }
        do {
            modified = false;
            for (ClassNode node : this.targets) {
                Set childNodes = (Set)children.get(node.name);
                if (childNodes == null) continue;
                Set superChildNodes = (Set)children.get(node.superName);
                modified |= superChildNodes.addAll(childNodes);
            }
        } while (modified);
        for (ClassNode node : this.targets) {
            for (FieldNode field : node.fields) {
                String newName = this.fieldRenames.get(node.name, field.desc, field.name);
                if (newName == null) continue;
                this.hierarchisedFieldRenames.put(node.name, field.desc, field.name, newName);
                Set childNodes = (Set)children.get(node.name);
                if (childNodes == null) continue;
                if ((field.access & 4) != 0 || (field.access & 1) != 0) {
                    for (String child : childNodes) {
                        this.hierarchisedFieldRenames.put(child, field.desc, field.name, newName);
                    }
                    continue;
                }
                if ((field.access & 2) != 0) continue;
                int lastIndexOfSlash = node.name.lastIndexOf(47);
                String packageName = lastIndexOfSlash == -1 ? null : node.name.substring(0, lastIndexOfSlash);
                for (String child : childNodes) {
                    if (child.length() <= lastIndexOfSlash || (packageName == null ? child.indexOf(47) != -1 : child.codePointAt(lastIndexOfSlash) != 47 || child.indexOf(47, lastIndexOfSlash + 1) != -1 || !child.startsWith(packageName))) continue;
                    this.hierarchisedFieldRenames.put(child, field.desc, field.name, newName);
                }
            }
        }
        this.hierarchisedFieldRenames.putAllIfAbsent(this.fieldRenames);
    }

    public Map<String, String> fixICNNames(StringBuilder sharedBuilder) {
        HashMap<String, List> outerToInner = new HashMap<String, List>();
        for (ClassNode node : this.targets) {
            int lastIndexOfDollar = node.name.lastIndexOf(36);
            if (lastIndexOfDollar == -1) continue;
            String outerName = node.name.substring(0, lastIndexOfDollar);
            outerToInner.compute(outerName, (key, oldVal) -> {
                if (oldVal == null) {
                    oldVal = new ArrayList<String>();
                }
                oldVal.add(node.name);
                return oldVal;
            });
        }
        HashMap additions = new HashMap();
        HashMap<String, String> allAdditions = new HashMap<String, String>();
        while (!outerToInner.isEmpty()) {
            this.oldToNewClassName.forEach((oldName, newName) -> {
                List innerClasses = (List)outerToInner.remove(oldName);
                if (innerClasses != null) {
                    for (String inner : innerClasses) {
                        if (this.oldToNewClassName.containsKey(inner)) continue;
                        int seperatorPos = inner.lastIndexOf(36);
                        sharedBuilder.setLength(0);
                        sharedBuilder.append((String)newName);
                        sharedBuilder.append(inner, seperatorPos, inner.length());
                        String newInnerName = sharedBuilder.toString();
                        additions.put(inner, newInnerName);
                    }
                }
            });
            if (additions.isEmpty()) break;
            this.oldToNewClassName.putAll(additions);
            allAdditions.putAll(additions);
            additions.clear();
        }
        return allAdditions;
    }

    public List<ClassNode> getOutput() {
        return this.targets;
    }

    @NotNull
    public String getRemappedClassName(@NotNull String name) {
        String s = this.oldToNewClassName.get(name);
        if (s == null) {
            return name;
        }
        return s;
    }

    @NotNull
    public String getRemappedFieldDescriptor(@NotNull String fieldDesc, @NotNull StringBuilder sharedBuilder) {
        sharedBuilder.setLength(0);
        return this.remapSingleDesc(fieldDesc, sharedBuilder);
    }

    @NotNull
    public String getRemappedFieldName(@NotNull String owner, @NotNull String name, @NotNull String desc) {
        String s;
        if (this.fieldRenameHierarchyOutdated) {
            this.createFieldHierarchy();
            this.fieldRenameHierarchyOutdated = false;
        }
        if ((s = this.hierarchisedFieldRenames.get(owner, name, desc)) == null) {
            return name;
        }
        return s;
    }

    @NotNull
    public String getRemappedMethodDescriptor(@NotNull String methodDesc, @NotNull StringBuilder sharedBuilder) {
        sharedBuilder.setLength(0);
        if (!this.remapSignature(methodDesc, sharedBuilder)) {
            return methodDesc;
        }
        return sharedBuilder.toString();
    }

    @NotNull
    public String getRemappedMethodName(@NotNull String owner, @NotNull String name, @NotNull String desc) {
        String s = this.methodRenames.get(owner, name, desc);
        if (s == null) {
            return name;
        }
        return s;
    }

    public void process() {
        StringBuilder sharedStringBuilder = new StringBuilder();
        if (this.fieldRenameHierarchyOutdated) {
            this.createFieldHierarchy();
            this.fieldRenameHierarchyOutdated = false;
        }
        IdentityHashMap<ModuleNode, Boolean> remappedModules = new IdentityHashMap<ModuleNode, Boolean>();
        for (ClassNode node : this.targets) {
            String newName;
            String remapped;
            String member;
            Boolean boole;
            for (FieldNode field : node.fields) {
                this.remapField(node.name, field, sharedStringBuilder);
            }
            for (InnerClassNode innerClass : node.innerClasses) {
                String newName2;
                String newOuterName = this.oldToNewClassName.get(innerClass.outerName);
                if (newOuterName != null) {
                    innerClass.outerName = newOuterName;
                }
                if ((newName2 = this.oldToNewClassName.get(innerClass.name)) == null) continue;
                innerClass.name = newName2;
            }
            for (int i = 0; i < node.interfaces.size(); ++i) {
                String newInterfaceName = this.oldToNewClassName.get(node.interfaces.get(i));
                if (newInterfaceName == null) continue;
                node.interfaces.set(i, newInterfaceName);
            }
            this.remapAnnotations(node.invisibleTypeAnnotations, sharedStringBuilder);
            this.remapAnnotations(node.invisibleAnnotations, sharedStringBuilder);
            this.remapAnnotations(node.visibleTypeAnnotations, sharedStringBuilder);
            this.remapAnnotations(node.visibleAnnotations, sharedStringBuilder);
            for (MethodNode method : node.methods) {
                this.remapMethod(node, method, sharedStringBuilder);
            }
            ModuleNode module = node.module;
            if (module != null && (boole = (Boolean)remappedModules.get(module)) == null) {
                remappedModules.put(module, Boolean.TRUE);
                this.remapModule(module, sharedStringBuilder);
            }
            if (node.nestHostClass != null) {
                node.nestHostClass = this.remapInternalName(node.nestHostClass, sharedStringBuilder);
            }
            if (node.nestMembers != null) {
                int size = node.nestMembers.size();
                for (int i = 0; i < size; ++i) {
                    member = (String)node.nestMembers.get(i);
                    if (member == (remapped = this.remapInternalName(member, sharedStringBuilder))) continue;
                    node.nestMembers.set(i, remapped);
                }
            }
            if (node.outerClass != null) {
                if (node.outerMethod != null && node.outerMethodDesc != null) {
                    node.outerMethod = this.methodRenames.optGet(node.outerClass, node.outerMethodDesc, node.outerMethod);
                }
                node.outerClass = this.remapInternalName(node.outerClass, sharedStringBuilder);
            }
            if (node.outerMethodDesc != null) {
                sharedStringBuilder.setLength(0);
                if (this.remapSignature(node.outerMethodDesc, sharedStringBuilder)) {
                    node.outerMethodDesc = sharedStringBuilder.toString();
                }
            }
            if (node.permittedSubclasses != null) {
                int size = node.permittedSubclasses.size();
                for (int i = 0; i < size; ++i) {
                    member = (String)node.permittedSubclasses.get(i);
                    if (member == (remapped = this.remapInternalName(member, sharedStringBuilder))) continue;
                    node.permittedSubclasses.set(i, remapped);
                }
            }
            if (node.recordComponents != null) {
                for (RecordComponentNode record : node.recordComponents) {
                    sharedStringBuilder.setLength(0);
                    if (this.remapSignature(record.descriptor, sharedStringBuilder)) {
                        record.descriptor = sharedStringBuilder.toString();
                    }
                    this.remapAnnotations(record.invisibleAnnotations, sharedStringBuilder);
                    this.remapAnnotations(record.invisibleTypeAnnotations, sharedStringBuilder);
                    this.remapAnnotations(record.visibleAnnotations, sharedStringBuilder);
                    this.remapAnnotations(record.visibleTypeAnnotations, sharedStringBuilder);
                    if (record.signature == null) continue;
                    sharedStringBuilder.setLength(0);
                    if (!this.remapSignature(record.signature, sharedStringBuilder)) continue;
                    record.signature = sharedStringBuilder.toString();
                }
            }
            if (node.signature != null) {
                sharedStringBuilder.setLength(0);
                if (this.remapSignature(node.signature, sharedStringBuilder)) {
                    node.signature = sharedStringBuilder.toString();
                }
            }
            if (node.superName != null) {
                node.superName = this.remapInternalName(node.superName, sharedStringBuilder);
            }
            if ((newName = this.oldToNewClassName.get(node.name)) == null) continue;
            this.nameToNode.remove(node.name);
            node.name = newName;
            this.nameToNode.put(node.name, node);
        }
        this.oldToNewClassName.clear();
    }

    private void remapAnnotation(AnnotationNode annotation, StringBuilder sharedStringBuilder) {
        String internalName = annotation.desc.substring(1, annotation.desc.length() - 1);
        String newInternalName = this.oldToNewClassName.get(internalName);
        if (newInternalName != null) {
            annotation.desc = 'L' + newInternalName + ';';
        }
        if (annotation.values != null) {
            int size = annotation.values.size();
            for (int i = 0; i < size; ++i) {
                String bitvoid = (String)annotation.values.get(i++);
                this.remapAnnotationValue(annotation.values.get(i), i, annotation.values, sharedStringBuilder);
            }
        }
    }

    private void remapAnnotations(List<? extends AnnotationNode> annotations, StringBuilder sharedStringBuilder) {
        if (annotations == null) {
            return;
        }
        for (AnnotationNode annotationNode : annotations) {
            this.remapAnnotation(annotationNode, sharedStringBuilder);
        }
    }

    private void remapAnnotationValue(Object value, int index, List<Object> values, StringBuilder sharedStringBuilder) {
        if (value instanceof Type) {
            String type = ((Type)value).getDescriptor();
            sharedStringBuilder.setLength(0);
            if (this.remapSignature(type, sharedStringBuilder)) {
                values.set(index, Type.getType((String)sharedStringBuilder.toString()));
            }
        } else if (value instanceof String[]) {
            String[] enumvals = (String[])value;
            String internalName = enumvals[0].substring(1, enumvals[0].length() - 1);
            enumvals[1] = this.hierarchisedFieldRenames.optGet(internalName, enumvals[0], enumvals[1]);
            String newInternalName = this.oldToNewClassName.get(internalName);
            if (newInternalName != null) {
                enumvals[0] = 'L' + newInternalName + ';';
            }
        } else if (value instanceof AnnotationNode) {
            this.remapAnnotation((AnnotationNode)value, sharedStringBuilder);
        } else if (value instanceof List) {
            List valueList = (List)value;
            int size = valueList.size();
            for (int i = 0; i < size; ++i) {
                this.remapAnnotationValue(valueList.get(i), i, valueList, sharedStringBuilder);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void remapBSMArg(Object[] bsmArgs, int index, StringBuilder sharedStringBuilder) {
        Object bsmArg = bsmArgs[index];
        if (bsmArg instanceof Type) {
            Type type = (Type)bsmArg;
            sharedStringBuilder.setLength(0);
            if (type.getSort() == 11) {
                if (!this.remapSignature(type.getDescriptor(), sharedStringBuilder)) return;
                bsmArgs[index] = Type.getMethodType((String)sharedStringBuilder.toString());
                return;
            } else {
                String remappedVal;
                if (type.getSort() != 10) throw new IllegalArgumentException("Unexpected bsm arg Type sort. Sort = " + type.getSort() + "; type = " + type);
                String oldVal = type.getInternalName();
                if (oldVal == (remappedVal = this.remapInternalName(oldVal, sharedStringBuilder))) return;
                bsmArgs[index] = Type.getObjectType((String)remappedVal);
            }
            return;
        } else if (bsmArg instanceof Handle) {
            boolean modified;
            Handle handle = (Handle)bsmArg;
            String oldName = handle.getName();
            String hOwner = handle.getOwner();
            String newName = this.methodRenames.optGet(hOwner, handle.getDesc(), oldName);
            String newOwner = this.oldToNewClassName.get(hOwner);
            boolean bl = modified = oldName != newName;
            if (newOwner != null) {
                hOwner = newOwner;
                modified = true;
            }
            String desc = handle.getDesc();
            sharedStringBuilder.setLength(0);
            if (this.remapSignature(desc, sharedStringBuilder)) {
                desc = sharedStringBuilder.toString();
                modified = true;
            }
            if (!modified) return;
            bsmArgs[index] = new Handle(handle.getTag(), hOwner, newName, desc, handle.isInterface());
            return;
        } else {
            if (bsmArg instanceof String) return;
            throw new IllegalArgumentException("Unexpected bsm arg class at index " + index + " for " + Arrays.toString(bsmArgs) + ". Class is " + bsmArg.getClass().getName());
        }
    }

    public void remapClassName(String oldName, String newName) {
        this.oldToNewClassName.put(oldName, newName);
    }

    public void remapClassNames(Map<String, String> mappings) {
        this.oldToNewClassName.putAll(mappings);
    }

    private void remapField(String owner, FieldNode field, StringBuilder sharedStringBuilder) {
        field.name = this.hierarchisedFieldRenames.optGet(owner, field.desc, field.name);
        char typeType = field.desc.charAt(0);
        if (typeType == '[' || typeType == 'L') {
            sharedStringBuilder.setLength(0);
            field.desc = this.remapSingleDesc(field.desc, sharedStringBuilder);
            if (field.signature != null) {
                sharedStringBuilder.setLength(0);
                if (this.remapSignature(field.signature, sharedStringBuilder)) {
                    field.signature = sharedStringBuilder.toString();
                }
            }
        }
    }

    public void remapField(String owner, String desc, String oldName, String newName) {
        this.fieldRenames.put(owner, desc, oldName, newName);
        this.fieldRenameHierarchyOutdated = true;
    }

    private void remapFrameNode(FrameNode frameNode, StringBuilder sharedStringBuilder) {
        String newName;
        String oldName;
        Object o;
        int i;
        int size;
        if (frameNode.stack != null) {
            size = frameNode.stack.size();
            for (i = 0; i < size; ++i) {
                o = frameNode.stack.get(i);
                if (!(o instanceof String) || (oldName = (String)o) == (newName = this.remapInternalName(oldName, sharedStringBuilder))) continue;
                frameNode.stack.set(i, newName);
            }
        }
        if (frameNode.local != null) {
            size = frameNode.local.size();
            for (i = 0; i < size; ++i) {
                o = frameNode.local.get(i);
                if (!(o instanceof String) || (oldName = (String)o) == (newName = this.remapInternalName(oldName, sharedStringBuilder))) continue;
                frameNode.local.set(i, newName);
            }
        }
    }

    private String remapInternalName(String internalName, StringBuilder sharedStringBuilder) {
        if (internalName.codePointAt(0) == 91) {
            return this.remapSingleDesc(internalName, sharedStringBuilder);
        }
        String remapped = this.oldToNewClassName.get(internalName);
        if (remapped != null) {
            return remapped;
        }
        return internalName;
    }

    private void remapMethod(ClassNode owner, MethodNode method, StringBuilder sharedStringBuilder) {
        InsnList instructions;
        method.name = this.methodRenames.optGet(owner.name, method.desc, method.name);
        for (int i = 0; i < method.exceptions.size(); ++i) {
            String newExceptionName = this.oldToNewClassName.get(method.exceptions.get(i));
            if (newExceptionName == null) continue;
            method.exceptions.set(i, newExceptionName);
        }
        this.remapAnnotations(method.invisibleTypeAnnotations, sharedStringBuilder);
        this.remapAnnotations(method.invisibleLocalVariableAnnotations, sharedStringBuilder);
        this.remapAnnotations(method.invisibleAnnotations, sharedStringBuilder);
        this.remapAnnotations(method.visibleAnnotations, sharedStringBuilder);
        this.remapAnnotations(method.visibleTypeAnnotations, sharedStringBuilder);
        this.remapAnnotations(method.visibleLocalVariableAnnotations, sharedStringBuilder);
        if (method.invisibleParameterAnnotations != null) {
            for (List annotations : method.invisibleParameterAnnotations) {
                this.remapAnnotations(annotations, sharedStringBuilder);
            }
        }
        if (method.localVariables != null) {
            for (LocalVariableNode lvn : method.localVariables) {
                char typeType = lvn.desc.charAt(0);
                boolean isObjectArray = typeType == '[';
                int arrayDimension = 0;
                if (isObjectArray) {
                    if (lvn.desc.codePointBefore(lvn.desc.length()) == 59) {
                        char arrayType;
                        while ((arrayType = lvn.desc.charAt(++arrayDimension)) == '[') {
                        }
                    } else {
                        isObjectArray = false;
                    }
                }
                if (!isObjectArray && typeType != 'L') continue;
                Type type = Type.getType((String)lvn.desc);
                String internalName = type.getInternalName();
                String newInternalName = this.oldToNewClassName.get(internalName);
                if (newInternalName != null) {
                    if (isObjectArray) {
                        sharedStringBuilder.setLength(arrayDimension);
                        for (int i = 0; i < arrayDimension; ++i) {
                            sharedStringBuilder.setCharAt(i, '[');
                        }
                        sharedStringBuilder.append(newInternalName);
                        sharedStringBuilder.append(';');
                        lvn.desc = sharedStringBuilder.toString();
                    } else {
                        lvn.desc = 'L' + newInternalName + ';';
                    }
                }
                if (lvn.signature == null) continue;
                sharedStringBuilder.setLength(0);
                if (!this.remapSignature(lvn.signature, sharedStringBuilder)) continue;
                lvn.signature = sharedStringBuilder.toString();
            }
        }
        for (TryCatchBlockNode catchBlock : method.tryCatchBlocks) {
            String newName;
            if (catchBlock.type != null && (newName = this.oldToNewClassName.get(catchBlock.type)) != null) {
                catchBlock.type = newName;
            }
            this.remapAnnotations(catchBlock.visibleTypeAnnotations, sharedStringBuilder);
            this.remapAnnotations(catchBlock.invisibleTypeAnnotations, sharedStringBuilder);
        }
        sharedStringBuilder.setLength(0);
        if (this.remapSignature(method.desc, sharedStringBuilder)) {
            method.desc = sharedStringBuilder.toString();
        }
        if (method.signature != null) {
            sharedStringBuilder.setLength(0);
            if (this.remapSignature(method.signature, sharedStringBuilder)) {
                method.signature = sharedStringBuilder.toString();
            }
        }
        if (method.annotationDefault != null && !(method.annotationDefault instanceof Number)) {
            List<Object> annotationList = Arrays.asList(method.annotationDefault);
            this.remapAnnotationValue(method.annotationDefault, 0, annotationList, sharedStringBuilder);
            method.annotationDefault = annotationList.get(0);
        }
        if ((instructions = method.instructions) != null && instructions.size() != 0) {
            for (AbstractInsnNode insn = instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn instanceof FieldInsnNode) {
                    FieldInsnNode instruction = (FieldInsnNode)insn;
                    String fieldName = this.hierarchisedFieldRenames.get(instruction.owner, instruction.desc, instruction.name);
                    if (fieldName != null) {
                        instruction.name = fieldName;
                    }
                    instruction.desc = this.remapSingleDesc(instruction.desc, sharedStringBuilder);
                    instruction.owner = this.remapInternalName(instruction.owner, sharedStringBuilder);
                    continue;
                }
                if (insn instanceof FrameNode) {
                    this.remapFrameNode((FrameNode)insn, sharedStringBuilder);
                    continue;
                }
                if (insn instanceof InvokeDynamicInsnNode) {
                    InvokeDynamicInsnNode specialisedInsn = (InvokeDynamicInsnNode)insn;
                    Object[] bsmArgs = specialisedInsn.bsmArgs;
                    int arglen = bsmArgs.length;
                    for (int i = 0; i < arglen; ++i) {
                        this.remapBSMArg(bsmArgs, i, sharedStringBuilder);
                    }
                    sharedStringBuilder.setLength(0);
                    if (!this.remapSignature(specialisedInsn.desc, sharedStringBuilder)) continue;
                    specialisedInsn.desc = sharedStringBuilder.toString();
                    continue;
                }
                if (insn instanceof LdcInsnNode) {
                    String newDescString;
                    String descString;
                    LdcInsnNode specialisedInsn = (LdcInsnNode)insn;
                    if (!(specialisedInsn.cst instanceof Type) || (descString = ((Type)specialisedInsn.cst).getDescriptor()) == (newDescString = this.remapSingleDesc(descString, sharedStringBuilder))) continue;
                    specialisedInsn.cst = Type.getType((String)newDescString);
                    continue;
                }
                if (insn instanceof MethodInsnNode) {
                    boolean isArray;
                    MethodInsnNode instruction = (MethodInsnNode)insn;
                    boolean bl = isArray = instruction.owner.codePointAt(0) == 91;
                    if (!isArray) {
                        instruction.name = this.methodRenames.optGet(instruction.owner, instruction.desc, instruction.name);
                        String newOwner = this.oldToNewClassName.get(instruction.owner);
                        if (newOwner != null) {
                            instruction.owner = newOwner;
                        }
                    } else {
                        sharedStringBuilder.setLength(0);
                        instruction.owner = this.remapSingleDesc(instruction.owner, sharedStringBuilder);
                    }
                    sharedStringBuilder.setLength(0);
                    if (!this.remapSignature(instruction.desc, sharedStringBuilder)) continue;
                    instruction.desc = sharedStringBuilder.toString();
                    continue;
                }
                if (insn instanceof MultiANewArrayInsnNode) {
                    MultiANewArrayInsnNode instruction = (MultiANewArrayInsnNode)insn;
                    instruction.desc = this.remapSingleDesc(instruction.desc, sharedStringBuilder);
                    continue;
                }
                if (!(insn instanceof TypeInsnNode)) continue;
                TypeInsnNode instruction = (TypeInsnNode)insn;
                instruction.desc = this.remapInternalName(instruction.desc, sharedStringBuilder);
            }
        }
    }

    public void remapMethod(String owner, String desc, String oldName, String newName) throws ConflicitingMappingException {
        this.methodRenames.put(owner, desc, oldName, newName);
    }

    private void remapModule(ModuleNode module, StringBuilder sharedStringBuilder) {
        String newMainClass;
        if (module.mainClass != null && (newMainClass = this.oldToNewClassName.get(module.mainClass)) != null) {
            module.mainClass = newMainClass;
        }
        if (module.uses != null) {
            int size = module.uses.size();
            for (int i = 0; i < size; ++i) {
                String service = (String)module.uses.get(i);
                String remapped = this.remapInternalName(service, sharedStringBuilder);
                if (remapped == service) continue;
                module.uses.set(i, remapped);
            }
        }
    }

    private boolean remapSignature(String signature, StringBuilder out) {
        return this.remapSignature(out, signature, 0, signature.length());
    }

    private boolean remapSignature(StringBuilder signatureOut, String signature, int start, int end) {
        if (start == end) {
            return false;
        }
        int type = signature.codePointAt(start++);
        switch (type) {
            case 76: 
            case 84: {
                int codepoint;
                int endObject = start;
                do {
                    if ((codepoint = signature.codePointAt(++endObject)) != 59) continue;
                    String name = signature.substring(start, endObject);
                    String newName = this.oldToNewClassName.get(name);
                    boolean modified = false;
                    if (newName != null) {
                        name = newName;
                        modified = true;
                    }
                    signatureOut.appendCodePoint(type);
                    signatureOut.append(name);
                    signatureOut.append(';');
                    return modified |= this.remapSignature(signatureOut, signature, ++endObject, end);
                } while (codepoint != 60);
                int openingBrackets = 1;
                int endGenerics = endObject;
                while (true) {
                    if ((codepoint = signature.codePointAt(++endGenerics)) == 62) {
                        if (--openingBrackets != 0) continue;
                        break;
                    }
                    if (codepoint != 60) continue;
                    ++openingBrackets;
                }
                String name = signature.substring(start, endObject);
                String newName = this.oldToNewClassName.get(name);
                boolean modified = false;
                if (newName != null) {
                    name = newName;
                    modified = true;
                }
                signatureOut.append('L');
                signatureOut.append(name);
                signatureOut.append('<');
                modified |= this.remapSignature(signatureOut, signature, endObject + 1, endGenerics++);
                signatureOut.append('>');
                signatureOut.appendCodePoint(signature.codePointAt(endGenerics));
                return modified |= this.remapSignature(signatureOut, signature, ++endGenerics, end);
            }
        }
        signatureOut.appendCodePoint(type);
        return this.remapSignature(signatureOut, signature, start, end);
    }

    private String remapSingleDesc(String input, StringBuilder sharedBuilder) {
        int indexofL = input.indexOf(76);
        if (indexofL == -1) {
            return input;
        }
        int length = input.length();
        String internalName = input.substring(indexofL + 1, length - 1);
        String newInternalName = this.oldToNewClassName.get(internalName);
        if (newInternalName == null) {
            return input;
        }
        sharedBuilder.setLength(indexofL + 1);
        sharedBuilder.setCharAt(indexofL, 'L');
        while (indexofL != 0) {
            sharedBuilder.setCharAt(--indexofL, '[');
        }
        sharedBuilder.append(newInternalName);
        sharedBuilder.append(';');
        return sharedBuilder.toString();
    }

    public void removeMethodRemap(String owner, String desc, String name) {
        this.methodRenames.remove(owner, desc, name);
    }
}

