/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.deobf;

import de.geolykt.starloader.deobf.ComputationalTypeCategory;
import de.geolykt.starloader.deobf.stack.source.AbstractSource;
import de.geolykt.starloader.deobf.stack.source.InvalidSource;

public class StackElement {
    public static final StackElement INVALID_ELEMENT = new StackElement((AbstractSource)InvalidSource.INSTANCE, false);
    public final boolean isValid;
    public final boolean isNull;
    public final String type;
    public final AbstractSource source;

    private StackElement(AbstractSource source, boolean valid) {
        this.isValid = valid;
        this.isNull = false;
        this.type = null;
        this.source = source;
    }

    public StackElement(AbstractSource source, String type) {
        this(source, type, false);
    }

    public StackElement(AbstractSource source, String type, boolean isNull) {
        this.isValid = true;
        this.type = type;
        this.isNull = isNull;
        this.source = source;
    }

    public String toString() {
        if (!this.isValid) {
            return "invalid";
        }
        if (this.isNull) {
            return "element_null";
        }
        return this.type;
    }

    public ComputationalTypeCategory getComputationalTypeCategory() {
        if (this.isNull) {
            return ComputationalTypeCategory.CATEGORY_1;
        }
        if (!this.isValid) {
            return null;
        }
        return ComputationalTypeCategory.parse(this.type);
    }

    public boolean isPrimitive() {
        if (this.isNull || !this.isValid) {
            return false;
        }
        return this.type.codePointAt(0) != 76 && this.type.codePointAt(0) != 91;
    }

    public boolean isArray() {
        if (!this.isValid || this.type == null && this.isNull) {
            return false;
        }
        return this.type.codePointAt(0) != 91;
    }
}

