/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.deobf.remapper;

import de.geolykt.starloader.deobf.MethodReference;
import de.geolykt.starloader.deobf.remapper.ConflicitingMappingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MethodRenameMap {
    private final Map<MethodReference, String> renames = new HashMap<MethodReference, String>();

    public void clear() {
        this.renames.clear();
    }

    public String get(String owner, String descriptor, String oldName) {
        return this.renames.get(new MethodReference(owner, descriptor, oldName));
    }

    public String getOrDefault(String owner, String descriptor, String oldName, String defaultValue) {
        return this.renames.getOrDefault(new MethodReference(owner, descriptor, oldName), defaultValue);
    }

    public String optGet(String owner, String descriptor, String oldName) {
        return this.renames.getOrDefault(new MethodReference(owner, descriptor, oldName), oldName);
    }

    public void put(String owner, String descriptor, String name, String newName) throws ConflicitingMappingException {
        MethodReference ref = new MethodReference(owner, descriptor, name);
        String oldMapping = this.renames.get(ref);
        if (oldMapping == null) {
            this.renames.put(ref, Objects.requireNonNull(newName, "newName cannot be null."));
        } else if (!oldMapping.equals(newName)) {
            throw new ConflicitingMappingException("Overriding method rename for method " + ref.toString());
        }
    }

    public void remove(String owner, String desc, String name) {
        this.renames.remove(new MethodReference(owner, desc, name));
    }

    public int size() {
        return this.renames.size();
    }
}

