/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starplane;

import de.geolykt.starloader.deobf.ClassWrapper;
import de.geolykt.starloader.deobf.IntermediaryGenerator;
import de.geolykt.starloader.deobf.MethodReference;
import de.geolykt.starloader.deobf.Oaktree;
import de.geolykt.starloader.deobf.remapper.Remapper;
import de.geolykt.starloader.ras.ReversibleAccessSetterContext;
import de.geolykt.starplane.Autodeobf;
import de.geolykt.starplane.SimpleRASRemapper;
import de.geolykt.starplane.Utils;
import de.geolykt.starplane.remapping.MappingIOMappingProvider;
import de.geolykt.starplane.remapping.MultiMappingProvider;
import de.geolykt.starplane.remapping.StarplaneAnnotationRemapper;
import de.geolykt.starplane.remapping.StarplaneMappingsProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.extension.mixin.MixinExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stianloader.softmap.SoftmapApplicationError;
import org.stianloader.softmap.SoftmapContext;
import org.stianloader.softmap.SoftmapParseError;
import org.stianloader.softmap.tokens.Token;

public class ObfuscationHandler {
    @NotNull
    private static final String COMPILED_SOFTMAP_FILE_NAME = "compiled-softmap.tiny";
    @NotNull
    private static final String INTERMEDIARY_FILE_NAME = "slintermediary.tiny";
    private static final byte @NotNull [] IO_BUFFER = new byte[4096];
    private static final Logger LOGGER = LoggerFactory.getLogger(ObfuscationHandler.class);
    @NotNull
    private static final String STARMAP_FILE_NAME = "spstarmap.tiny";
    @NotNull
    private final Path cacheDir;
    public boolean didRefresh = false;
    @NotNull
    private final Path projectDir;
    @Nullable
    private final String rasContent;
    @NotNull
    private final @NotNull @Unmodifiable Collection<@NotNull Path> softmapFiles;
    @NotNull
    private final @NotNull @Unmodifiable List<Map.Entry<@NotNull MappingFormat, @NotNull Path>> supplementaryMappings;

    private static String getStarplaneChecksum() throws IOException {
        try (InputStream autodeobfClass = Autodeobf.class.getClassLoader().getResourceAsStream("de/geolykt/starplane/Autodeobf.class");){
            String string;
            try (CheckedInputStream checkedIn = new CheckedInputStream(autodeobfClass, new Adler32());){
                while (checkedIn.read(IO_BUFFER) != -1) {
                }
                string = Long.toUnsignedString(checkedIn.getChecksum().getValue(), 36);
            }
            return string;
        }
    }

    @NotNull
    private static String toHexHash(byte[] hash) {
        StringBuilder hex = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            int x = b & 0xFF;
            if (x < 16) {
                hex.append('0');
            }
            hex.append(Integer.toHexString(x));
        }
        return hex.toString();
    }

    public ObfuscationHandler(@NotNull Path cacheDir, @NotNull Path projectDir, @Nullable String rasContent, @NotNull @NotNull @Unmodifiable Collection<@NotNull Path> softmapFiles, @NotNull @NotNull @Unmodifiable List<Map.Entry<@NotNull MappingFormat, @NotNull Path>> supplementaryMappings) {
        this.cacheDir = cacheDir;
        this.projectDir = projectDir;
        this.rasContent = rasContent;
        this.softmapFiles = softmapFiles;
        this.supplementaryMappings = supplementaryMappings;
    }

    private void addSignatures(List<ClassNode> nodes, Map<String, ClassNode> nameToNode, Map<MethodReference, ClassWrapper> signatures) {
        StringBuilder builder = new StringBuilder();
        for (ClassNode node : nodes) {
            for (MethodNode method : node.methods) {
                ClassWrapper newSignature;
                if (method.signature != null || (newSignature = signatures.get(new MethodReference(node.name, method))) == null) continue;
                builder.append(method.desc, 0, method.desc.length() - 1);
                builder.append("<L");
                builder.append(newSignature.getName());
                builder.append(";>;");
                method.signature = builder.toString();
                builder.setLength(0);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObfuscationHandler) {
            ObfuscationHandler other = (ObfuscationHandler)obj;
            return Objects.equals(this.rasContent, other.rasContent) && this.cacheDir.equals(other.cacheDir) && this.projectDir.equals(other.projectDir) && this.softmapFiles.equals(other.softmapFiles);
        }
        return false;
    }

    @NotNull
    private String getAdditionalMappingChecksums() throws IOException {
        CheckedInputStream cis;
        if (this.softmapFiles.isEmpty() && this.supplementaryMappings.isEmpty()) {
            return "0";
        }
        Adler32 csum = new Adler32();
        for (Path path : this.softmapFiles) {
            cis = new CheckedInputStream(Files.newInputStream(path, new OpenOption[0]), csum);
            try {
                while (cis.read(IO_BUFFER) != -1) {
                }
            }
            finally {
                cis.close();
            }
        }
        for (Map.Entry entry : this.supplementaryMappings) {
            csum.update(((MappingFormat)entry.getKey()).ordinal());
            cis = new CheckedInputStream(Files.newInputStream((Path)entry.getValue(), new OpenOption[0]), csum);
            try {
                while (cis.read(IO_BUFFER) != -1) {
                }
            }
            finally {
                cis.close();
            }
        }
        return Long.toUnsignedString(csum.getValue(), 36);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public Path getTransformedGalimulatorJar() {
        File cleanGalimJar;
        Path compileAccess;
        Path runAccess;
        ReversibleAccessSetterContext rasInfo;
        Object currentHash;
        Path awHash;
        block139: {
            block143: {
                block142: {
                    block141: {
                        block140: {
                            if (!Files.isDirectory(this.cacheDir, new LinkOption[0])) {
                                try {
                                    Files.createDirectories(this.cacheDir, new FileAttribute[0]);
                                }
                                catch (IOException e) {
                                    throw new IllegalStateException("Unable to create cache folder!", e);
                                }
                            }
                            awHash = this.cacheDir.resolve("accesswidener-hash.dat");
                            boolean recomputeAw = false;
                            currentHash = null;
                            String rasContent = this.rasContent;
                            if (rasContent == null) {
                                rasInfo = null;
                            } else {
                                try (DigestInputStream din = new DigestInputStream(new ByteArrayInputStream(rasContent.getBytes(StandardCharsets.UTF_8)), MessageDigest.getInstance("SHA-1"));
                                     BufferedReader br = new BufferedReader(new InputStreamReader(din));){
                                    rasInfo = new ReversibleAccessSetterContext(ReversibleAccessSetterContext.RASTransformScope.BUILDTIME, false);
                                    rasInfo.read("<mod>", br, false);
                                    currentHash = ObfuscationHandler.toHexHash(din.getMessageDigest().digest());
                                }
                                catch (Exception e) {
                                    throw new IllegalStateException("Unable to read reversibleAccessSetter!", e);
                                }
                            }
                            try {
                                currentHash = currentHash + "-" + ObfuscationHandler.getStarplaneChecksum() + "-" + this.getAdditionalMappingChecksums();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            if (Files.exists(awHash, new LinkOption[0])) {
                                try (BufferedReader br = Files.newBufferedReader(awHash, StandardCharsets.UTF_8);){
                                    String readLine = br.readLine();
                                    if (!readLine.equalsIgnoreCase((String)currentHash)) {
                                        recomputeAw = true;
                                        LOGGER.warn("AW Hash mismatch. Expected: " + readLine + ", but the current aw hash is " + (String)currentHash + ". Caches are considered invalid.");
                                    }
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    recomputeAw = true;
                                }
                            } else if (rasInfo != null) {
                                recomputeAw = true;
                            }
                            runAccess = this.cacheDir.resolve("galimulator-remapped-rt.jar");
                            compileAccess = this.cacheDir.resolve("galimulator-remapped.jar");
                            if (Files.isRegularFile(runAccess, new LinkOption[0]) && Files.isRegularFile(compileAccess, new LinkOption[0]) && !Boolean.getBoolean("de.geolykt.starplane.nocache") && !recomputeAw) {
                                return compileAccess;
                            }
                            this.didRefresh = true;
                            cleanGalimJar = new File(this.projectDir.toFile(), "galimulator-desktop.jar");
                            if (cleanGalimJar.exists()) break block139;
                            LOGGER.info("Galimulator jar at " + cleanGalimJar.getAbsolutePath() + " not found.");
                            cleanGalimJar = new File(this.cacheDir.toFile(), "galimulator-desktop.jar");
                            if (cleanGalimJar.exists()) break block139;
                            LOGGER.info("Galimulator jar at " + cleanGalimJar.getAbsolutePath() + " not found.");
                            String propertyPath = System.getProperty("de.geolykt.starplane.galimulator-jar");
                            if (propertyPath == null) break block140;
                            cleanGalimJar = this.projectDir.resolve(propertyPath).toFile();
                            if (cleanGalimJar.exists()) break block139;
                            LOGGER.info("Galimulator jar at " + cleanGalimJar.getAbsolutePath() + " not found.");
                            break block141;
                        }
                        LOGGER.info("System property 'de.geolykt.starplane.galimulator-jar' not defined.");
                    }
                    File galimDir = Utils.getGameDir("Galimulator");
                    if (galimDir == null || !galimDir.exists()) break block142;
                    cleanGalimJar = new File(galimDir, "jar/galimulator-desktop.jar");
                    if (cleanGalimJar.exists()) break block139;
                    LOGGER.error("Unable to resolve galimulator jar file (was able to resolve the potential directory though)!");
                    break block143;
                }
                LOGGER.error("Unable to resolve galimulator directory!");
            }
            throw new IllegalStateException("Cannot resolve dependencies");
        }
        LOGGER.info("Using the base galimulator jar found at " + cleanGalimJar.getAbsolutePath());
        Path map = this.cacheDir.resolve(INTERMEDIARY_FILE_NAME);
        Oaktree deobfuscator = new Oaktree();
        try {
            long start = System.currentTimeMillis();
            JarFile jar = new JarFile(cleanGalimJar);
            deobfuscator.index(jar);
            jar.close();
            HashMap<String, ClassNode> nameToNode = new HashMap<String, ClassNode>();
            for (ClassNode node : deobfuscator.getClassNodesDirectly()) {
                nameToNode.put(node.name, node);
            }
            LOGGER.info("Loaded input jar in " + (System.currentTimeMillis() - start) + " ms.");
            long startDeobf = System.currentTimeMillis();
            deobfuscator.fixInnerClasses();
            deobfuscator.fixParameterLVT();
            deobfuscator.guessFieldGenerics();
            this.addSignatures(deobfuscator.getClassNodesDirectly(), nameToNode, deobfuscator.analyseLikelyMethodReturnCollectionGenerics());
            HashMap<MethodReference, ClassWrapper> methods = new HashMap<MethodReference, ClassWrapper>();
            deobfuscator.lambdaStreamGenericSignatureGuessing(null, methods);
            this.addSignatures(deobfuscator.getClassNodesDirectly(), nameToNode, methods);
            deobfuscator.inferMethodGenerics();
            deobfuscator.inferConstructorGenerics();
            deobfuscator.fixForeachOnArray();
            deobfuscator.fixComparators(true);
            deobfuscator.guessAnonymousInnerClasses();
            LOGGER.info("Deobfuscated classes in " + (System.currentTimeMillis() - startDeobf) + " ms.");
            long startIntermediarisation = System.currentTimeMillis();
            IntermediaryGenerator generator = new IntermediaryGenerator(map, null, (Collection)deobfuscator.getClassNodesDirectly());
            generator.useAlternateClassNaming(!Boolean.getBoolean("de.geolykt.starplane.oldnames"));
            generator.remapClassesV2(true);
            deobfuscator.fixSwitchMaps();
            generator.doProposeEnumFieldsV2();
            generator.remapGetters();
            generator.deobfuscate();
            try {
                Remapper remapper = new Remapper();
                remapper.addTargets((Collection)deobfuscator.getClassNodesDirectly());
                long startSlStarmap = System.currentTimeMillis();
                Autodeobf deobf = new Autodeobf(deobfuscator.getClassNodesDirectly(), remapper);
                try (BufferedWriter writer = Files.newBufferedWriter(this.cacheDir.resolve(STARMAP_FILE_NAME), StandardOpenOption.CREATE);){
                    writer.write("v1\tintermediary\tnamed\n");
                    deobf.runAll(writer);
                    for (Map.Entry entry : remapper.fixICNNames(new StringBuilder()).entrySet()) {
                        writer.write("CLASS\t");
                        writer.write((String)entry.getKey());
                        ((Writer)writer).write(9);
                        writer.write((String)entry.getValue());
                        ((Writer)writer).write(10);
                    }
                    ((Writer)writer).flush();
                    remapper.process();
                }
                LOGGER.info("Computed spStarmap in " + (System.currentTimeMillis() - startSlStarmap) + " ms.");
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot write Autodeobf.java-generated mappings", e);
            }
            try {
                Path compiledSoftmap = this.cacheDir.resolve(COMPILED_SOFTMAP_FILE_NAME);
                if (this.softmapFiles.isEmpty()) {
                    Files.deleteIfExists(compiledSoftmap);
                } else {
                    Remapper remapper = new Remapper();
                    remapper.addTargets((Collection)deobfuscator.getClassNodesDirectly());
                    long startOfSoftmap = System.currentTimeMillis();
                    @NotNull @NotNull List nodes = deobfuscator.getClassNodesDirectly();
                    ArrayList<@NotNull String> allTiny = new ArrayList<String>();
                    allTiny.add("v1\tintermediary\tnamed");
                    allTiny.add("# This file was compiled from softmap files, do not touch unless you know what you are doing");
                    for (Path softmapFile : this.softmapFiles) {
                        List<@NotNull String> generatedTiny = this.compileSoftmap(softmapFile, nodes);
                        allTiny.addAll(generatedTiny);
                        for (String s : generatedTiny) {
                            String[] parts = s.split("\\s+");
                            if (parts[0].equals("METHOD")) {
                                remapper.remapMethod(parts[1], parts[2], parts[3], parts[4]);
                                continue;
                            }
                            if (parts[0].equals("FIELD")) {
                                remapper.remapField(parts[1], parts[2], parts[3], parts[4]);
                                continue;
                            }
                            if (!parts[0].equals("CLASS")) continue;
                            remapper.remapClassName(parts[1], parts[2]);
                        }
                        remapper.process();
                    }
                    Files.write(compiledSoftmap, allTiny, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    LOGGER.info("Compiled all softmap files in " + (System.currentTimeMillis() - startOfSoftmap) + "ms.");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot write softmap-generated mappings", e);
            }
            deobfuscator.invalidateNameCaches();
            deobfuscator.applyInnerclasses();
            LOGGER.info("Computed intermediaries of classes in " + (System.currentTimeMillis() - startIntermediarisation) + " ms.");
            if (rasInfo == null) {
                try (OutputStream os = Files.newOutputStream(compileAccess, new OpenOption[0]);){
                    deobfuscator.write(os, cleanGalimJar.toPath());
                }
                Files.copy(compileAccess, runAccess, StandardCopyOption.REPLACE_EXISTING);
                try (BufferedWriter bw = Files.newBufferedWriter(awHash, StandardCharsets.UTF_8, new OpenOption[0]);){
                    bw.write("null-");
                    bw.write(ObfuscationHandler.getStarplaneChecksum());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                ArrayList<ClassNode> runNodes = new ArrayList<ClassNode>();
                HashMap<String, ClassNode> compileNodes = new HashMap<String, ClassNode>();
                for (ClassNode node : deobfuscator.getClassNodesDirectly()) {
                    if (node == null) continue;
                    try {
                        rasInfo.accept(node);
                    }
                    catch (ReversibleAccessSetterContext.RASTransformFailure e) {
                        LOGGER.error("Unable to apply RAS on class {}", (Object)node.name, (Object)e);
                    }
                    ClassNode duplicate = new ClassNode();
                    node.accept((ClassVisitor)duplicate);
                    runNodes.add(duplicate);
                    compileNodes.put(node.name, node);
                }
                try (BufferedWriter bw = Files.newBufferedWriter(awHash, StandardCharsets.UTF_8, new OpenOption[0]);){
                    bw.write((String)currentHash);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try (OutputStream os = Files.newOutputStream(compileAccess, new OpenOption[0]);){
                    deobfuscator.write(os, cleanGalimJar.toPath());
                }
                os = new ZipOutputStream(Files.newOutputStream(runAccess, new OpenOption[0]), StandardCharsets.UTF_8);
                try {
                    try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(cleanGalimJar));){
                        ZipEntry entry = zipIn.getNextEntry();
                        while (entry != null) {
                            if (!entry.getName().endsWith(".class")) {
                                int n;
                                ((ZipOutputStream)os).putNextEntry(entry);
                                byte[] b = new byte[4096];
                                while ((n = zipIn.read(b)) != -1) {
                                    ((ZipOutputStream)os).write(b, 0, n);
                                }
                            }
                            entry = zipIn.getNextEntry();
                        }
                    }
                    TreeSet<ClassNode> sortedNodes = new TreeSet<ClassNode>((node1, node2) -> node1.name.compareTo(node2.name));
                    sortedNodes.addAll(runNodes);
                    for (ClassNode node : sortedNodes) {
                        ClassWriter classWriter = new ClassWriter(0);
                        node.accept((ClassVisitor)classWriter);
                        ((ZipOutputStream)os).putNextEntry(new ZipEntry(node.name + ".class"));
                        ((FilterOutputStream)os).write(classWriter.toByteArray());
                    }
                }
                finally {
                    ((ZipOutputStream)os).close();
                }
            }
            LOGGER.info("Finished transforming classes in " + (System.currentTimeMillis() - start) + " ms.");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (!this.supplementaryMappings.isEmpty()) {
            Path ctWorkJar = compileAccess;
            Path rtWorkJar = runAccess;
            int i = 0;
            TinyRemapper remapper = null;
            for (Map.Entry<MappingFormat, Path> supplementaryMapping : this.supplementaryMappings) {
                MemoryMappingTree mappingTree = new MemoryMappingTree();
                try {
                    MappingReader.read((Path)supplementaryMapping.getValue(), (MappingFormat)supplementaryMapping.getKey(), (MappingVisitor)mappingTree);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to consume supplementary mappings file at " + supplementaryMapping, e);
                }
                mappingTree.reset();
                i = (i + 1) % 2;
                Path ctTargetJar = ctWorkJar.resolveSibling("compile-access-jar-" + i + ".tmp");
                try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(ctTargetJar).assumeArchive(true).build();){
                    remapper = TinyRemapper.newRemapper().withMappings((IMappingProvider)new MappingIOMappingProvider((MappingTreeView)mappingTree, mappingTree.getMinNamespaceId(), mappingTree.getMaxNamespaceId() - 1)).extension((TinyRemapper.Extension)new StarplaneAnnotationRemapper()).extension((TinyRemapper.Extension)new MixinExtension()).build();
                    remapper.readInputs(new Path[]{ctWorkJar});
                    outputConsumer.addNonClassFiles(ctWorkJar);
                    remapper.apply((BiConsumer)outputConsumer);
                }
                catch (IOException t) {
                    throw new UncheckedIOException("Unable to apply supplementary mappings file at " + supplementaryMapping + " for compile-time access", t);
                }
                finally {
                    if (remapper != null) {
                        remapper.finish();
                    }
                }
                ctWorkJar = ctTargetJar;
                mappingTree.reset();
                i = (i + 1) % 2;
                Path rtTargetJar = ctWorkJar.resolveSibling("runtime-access-jar-" + i + ".tmp");
                try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(rtTargetJar).assumeArchive(true).build();){
                    remapper = TinyRemapper.newRemapper().withMappings((IMappingProvider)new MappingIOMappingProvider((MappingTreeView)mappingTree, mappingTree.getMinNamespaceId(), mappingTree.getMaxNamespaceId() - 1)).extension((TinyRemapper.Extension)new StarplaneAnnotationRemapper()).extension((TinyRemapper.Extension)new MixinExtension()).build();
                    remapper.readInputs(new Path[]{rtWorkJar});
                    outputConsumer.addNonClassFiles(rtWorkJar);
                    remapper.apply((BiConsumer)outputConsumer);
                }
                catch (IOException t) {
                    throw new UncheckedIOException("Unable to apply supplementary mappings file at " + supplementaryMapping + " for compile-time access", t);
                }
                finally {
                    if (remapper != null) {
                        remapper.finish();
                    }
                }
                rtWorkJar = rtTargetJar;
            }
            try {
                Files.move(ctWorkJar, compileAccess, StandardCopyOption.REPLACE_EXISTING);
                Files.move(rtWorkJar, runAccess, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to apply supplementary mappings: Generic I/O error", e);
            }
        }
        return compileAccess;
    }

    @NotNull
    @Contract(pure=true)
    private @NotNull @Unmodifiable List<@NotNull String> compileSoftmap(@NotNull Path softmapFile, @NotNull @NotNull List<@NotNull ClassNode> obfuscatedNodes) throws IOException {
        SoftmapContext.ApplicationResult result;
        List applyErrors;
        long fileStart = System.currentTimeMillis();
        String softmapContent = new String(Files.readAllBytes(softmapFile), StandardCharsets.UTF_8);
        SoftmapContext softmapContext = SoftmapContext.parse((String)softmapContent, (int)0, (int)softmapContent.length(), (int)1, (int)1);
        List parseErrors = softmapContext.getParseErrors();
        if (!parseErrors.isEmpty()) {
            System.out.println();
            for (SoftmapParseError error : parseErrors) {
                Object contentSplice;
                if (error.endCodepoint - error.startCodepoint < 100) {
                    contentSplice = softmapContent.substring(error.startCodepoint, error.endCodepoint);
                } else {
                    contentSplice = softmapContent.substring(error.startCodepoint, error.startCodepoint + 80);
                    contentSplice = (String)contentSplice + "... (and " + (error.endCodepoint - error.startCodepoint - 80) + " further characters)";
                }
                LOGGER.error("Syntax error in softmap file {} (row {}, column {}): {}", new Object[]{softmapFile, error.row, error.column, error.getDescription()});
                LOGGER.error("Invalid token: {}", contentSplice);
            }
            System.out.println();
        }
        if (!(applyErrors = (result = softmapContext.tryApply(obfuscatedNodes)).getErrors()).isEmpty()) {
            System.out.println();
            for (SoftmapApplicationError error : applyErrors) {
                Object contentSplice;
                Token errorLoc = error.getErrorLocation();
                if (errorLoc.getStart() - errorLoc.getEnd() < 100) {
                    contentSplice = softmapContent.substring(errorLoc.getStart(), errorLoc.getEnd());
                } else {
                    contentSplice = softmapContent.substring(errorLoc.getStart(), errorLoc.getStart() + 80);
                    contentSplice = (String)contentSplice + "... (and " + (errorLoc.getEnd() - errorLoc.getStart() - 80) + " further characters)";
                }
                LOGGER.error("Application error in softmap file {} (row {}, column {}): {}.", new Object[]{softmapFile, errorLoc.getRow(), errorLoc.getColumn(), error.getDescription()});
                LOGGER.error("Invalid token: {}", contentSplice);
            }
            System.out.println();
        }
        LOGGER.info("Softmap file {} compiled in {}ms.", (Object)softmapFile, (Object)(System.currentTimeMillis() - fileStart));
        return result.getGeneratedTinyV1Mappings();
    }

    public int hashCode() {
        return Objects.hash(this.rasContent, this.cacheDir, this.projectDir, this.softmapFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reobfuscateJar(@NotNull Path jarPath, @NotNull Path starmappedGalimulator, @NotNull @NotNull Collection<@NotNull Path> alsoInclude) throws IOException {
        Path spstarmap = this.cacheDir.resolve(STARMAP_FILE_NAME);
        Path slintermediary = this.cacheDir.resolve(INTERMEDIARY_FILE_NAME);
        Path compiledSoftmap = this.cacheDir.resolve(COMPILED_SOFTMAP_FILE_NAME);
        TinyRemapper tinyRemapper = TinyRemapper.newRemapper().withMappings((IMappingProvider)new MultiMappingProvider(new StarplaneMappingsProvider(slintermediary, true), new StarplaneMappingsProvider(spstarmap, true), new StarplaneMappingsProvider(compiledSoftmap, true, true))).extension((TinyRemapper.Extension)new StarplaneAnnotationRemapper()).extension((TinyRemapper.Extension)new MixinExtension()).keepInputData(true).build();
        if (!this.supplementaryMappings.isEmpty()) {
            LOGGER.info("Applying supplementary mappings");
            Path workJar = jarPath;
            int i = 0;
            TinyRemapper remapper = null;
            ListIterator<Map.Entry<@NotNull MappingFormat, @NotNull Path>> it = this.supplementaryMappings.listIterator(this.supplementaryMappings.size());
            HashSet<Path> cleanPaths = new HashSet<Path>();
            try {
                while (it.hasPrevious()) {
                    Map.Entry<@NotNull MappingFormat, @NotNull Path> supplementaryMapping = it.previous();
                    MemoryMappingTree mappingTree = new MemoryMappingTree();
                    try {
                        MappingReader.read((Path)supplementaryMapping.getValue(), (MappingFormat)supplementaryMapping.getKey(), (MappingVisitor)mappingTree);
                    }
                    catch (IOException e) {
                        throw new IOException("Unable to consume supplementary mappings file at " + supplementaryMapping, e);
                    }
                    mappingTree.reset();
                    i = (i + 1) % 2;
                    Path targetJar = jarPath.resolveSibling("supplementary-reobf-jar-" + i + ".tmp");
                    cleanPaths.add(targetJar);
                    try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(targetJar).assumeArchive(true).build();){
                        remapper = TinyRemapper.newRemapper().withMappings((IMappingProvider)new MappingIOMappingProvider((MappingTreeView)mappingTree, mappingTree.getMinNamespaceId(), mappingTree.getMaxNamespaceId() - 1)).extension((TinyRemapper.Extension)new StarplaneAnnotationRemapper()).extension((TinyRemapper.Extension)new MixinExtension()).build();
                        remapper.readInputs(new Path[]{workJar});
                        remapper.apply((BiConsumer)outputConsumer);
                    }
                    catch (IOException t) {
                        throw new IOException("Unable to apply supplementary mappings file at " + supplementaryMapping + " for compile-time access", t);
                    }
                    finally {
                        if (remapper != null) {
                            remapper.finish();
                        }
                    }
                    workJar = targetJar;
                }
                try {
                    Files.move(workJar, jarPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new IOException("Unable to apply supplementary mappings: Generic I/O error", e);
                }
            }
            finally {
                for (Path p : cleanPaths) {
                    Files.deleteIfExists(p);
                }
            }
        }
        Path intermediaryBuild = this.cacheDir.resolve("temporaryBuild.jar");
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(intermediaryBuild).build();){
            LOGGER.info("Reobfuscating... (reading inputs)");
            tinyRemapper.readInputs(new Path[]{jarPath});
            tinyRemapper.readClassPath(new Path[]{starmappedGalimulator});
            outputConsumer.addNonClassFiles(jarPath, tinyRemapper, Collections.singletonList(SimpleRASRemapper.INSTANCE));
            for (Path additionalInput : alsoInclude) {
                tinyRemapper.readInputs(new Path[]{additionalInput});
                outputConsumer.addNonClassFiles(additionalInput, tinyRemapper, Collections.singletonList(SimpleRASRemapper.INSTANCE));
            }
            LOGGER.info("Reobfuscating... (applying)");
            tinyRemapper.apply((BiConsumer)outputConsumer);
        }
        catch (IOException t) {
            throw new RuntimeException(t);
        }
        finally {
            tinyRemapper.finish();
        }
        Files.move(intermediaryBuild, jarPath, StandardCopyOption.REPLACE_EXISTING);
        LOGGER.info("Reobfuscating... (done)");
    }
}

