/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starplane.remapping;

import de.geolykt.starplane.remapping.MIOContainerFormat;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.mappingio.tree.VisitableMappingTree;
import org.jetbrains.annotations.NotNull;

public class MIOMappingTreeProvider {
    @NotNull
    private final MIOContainerFormat format;
    @NotNull
    private final Path path;

    public MIOMappingTreeProvider(@NotNull MappingFormat format, @NotNull Path path) {
        this.format = new MIOContainerFormat(format, MIOContainerFormat.MappingContainer.PLAIN);
        this.path = path;
    }

    public MIOMappingTreeProvider(@NotNull MIOContainerFormat format, @NotNull Path path) {
        this.format = format;
        this.path = path;
    }

    @NotNull
    public VisitableMappingTree get() throws IOException {
        MemoryMappingTree tree = new MemoryMappingTree();
        try {
            this.format.read(this.path, (MappingVisitor)tree);
        }
        catch (IOException e) {
            throw new IOException("Unable to consume supplementary mappings file at " + String.valueOf(this.path) + " using format " + this.format.toString(), e);
        }
        tree.reset();
        return tree;
    }

    public void checksum(@NotNull Checksum csum, byte @NotNull [] exhaustBuffer) throws IOException {
        csum.update(this.format.containerFormat.ordinal());
        csum.update(this.format.coreFormat.ordinal());
        try (CheckedInputStream cis = new CheckedInputStream(Files.newInputStream(this.path, new OpenOption[0]), csum);){
            while (cis.read(exhaustBuffer) != -1) {
            }
        }
    }
}

