/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starplane;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    public static final String OPERATING_SYSTEM = System.getProperty("os.name");
    @Nullable
    private static final MethodHandle READ_ALL_BYTES_HANDLE;
    public static final int STEAM_GALIMULATOR_APPID = 808100;
    public static final String STEAM_GALIMULATOR_APPNAME = "Galimulator";
    public static final String STEAM_WINDOWS_REGISTRY_INSTALL_DIR_KEY = "InstallPath";
    public static final String STEAM_WINDOWS_REGISTRY_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Valve\\Steam";

    public static final String getChecksum(File file) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (!file.exists()) {
            throw new RuntimeException("Jar was not found!");
        }
        try (DigestInputStream digestStream = new DigestInputStream(new FileInputStream(file), digest);){
            MethodHandle mh = READ_ALL_BYTES_HANDLE;
            if (mh != null) {
                mh.invoke(digestStream);
            } else {
                while (digestStream.read() != -1) {
                }
            }
            digest = digestStream.getMessageDigest();
        }
        catch (Throwable t) {
            throw new RuntimeException("Something went wrong while obtaining the checksum of the galimulator jar.", t);
        }
        StringBuilder result = new StringBuilder();
        for (byte b : digest.digest()) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    @NotNull
    public static final File getCurrentDir() {
        return new File(".");
    }

    @Nullable
    public static final File getGameDir(@NotNull String game) {
        File steamExec = Utils.getSteamExecutableDir();
        if (steamExec == null || !steamExec.exists()) {
            if (OPERATING_SYSTEM.toLowerCase(Locale.ROOT).startsWith("win")) {
                steamExec = Utils.getOneOfExistingFiles("C:\\Steam\\", "C:\\Program Files (x86)\\Steam\\", "C:\\Program Files\\Steam\\", "D:\\Steam\\", "C:\\Programmes\\Steam\\", "D:\\Programmes\\Steam\\");
            }
            if (steamExec == null) {
                return null;
            }
        }
        if (!steamExec.isDirectory()) {
            throw new IllegalStateException("Steam executable directory not a directory.");
        }
        File appdata = new File(steamExec, "steamapps");
        File common = new File(appdata, "common");
        return new File(common, game);
    }

    @Nullable
    public static final File getOneOfExistingFiles(String ... paths) {
        for (String path : paths) {
            File file = new File(path);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static final Path getSourceJar(Class<?> clazz) {
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        String path = url.getPath();
        if (path.contains("!")) {
            path = path.substring(0, path.indexOf(33));
        }
        return Path.of(path, new String[0]);
    }

    @Nullable
    public static final File getSteamExecutableDir() {
        if (OPERATING_SYSTEM.toLowerCase(Locale.ROOT).startsWith("win")) {
            String val = Utils.readWindowsRegistry(STEAM_WINDOWS_REGISTRY_KEY, STEAM_WINDOWS_REGISTRY_INSTALL_DIR_KEY);
            System.out.println(val);
            if (val == null) {
                return null;
            }
            return new File(val);
        }
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            return null;
        }
        File usrHome = new File(homeDir);
        File steamHome = new File(usrHome, ".steam");
        if (steamHome.exists()) {
            File debianInstall = new File(steamHome, "debian-installation");
            if (debianInstall.exists()) {
                return debianInstall;
            }
            return new File(steamHome, "steam");
        }
        File local = new File(usrHome, ".local");
        if (!local.exists()) {
            return null;
        }
        File share = new File(local, "share");
        if (!share.exists()) {
            return null;
        }
        return new File(share, "Steam");
    }

    public static final boolean isBlank(@NotNull String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static byte @NotNull [] readAllBytes(InputStream is) throws IOException {
        MethodHandle mh = READ_ALL_BYTES_HANDLE;
        if (mh == null) {
            int read;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            byte[] b = new byte[4096];
            while ((read = is.read(b)) != -1) {
                bytes.write(b, 0, read);
            }
            return bytes.toByteArray();
        }
        try {
            return mh.invoke(is);
        }
        catch (Throwable e) {
            throw new IOException("Unable to read all bytes via the method handle", e);
        }
    }

    public static final String readWindowsRegistry(String location, String key) {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + location + "\" /v " + key);
            process.waitFor();
            InputStream is = process.getInputStream();
            String output = new String(Utils.readAllBytes(is), StandardCharsets.UTF_8);
            is.close();
            if (!output.contains(location) || !output.contains(key)) {
                return null;
            }
            String[] parsed = output.split("\\s+");
            return parsed[parsed.length - 1];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        MethodHandle handle = null;
        try {
            handle = MethodHandles.publicLookup().findVirtual(InputStream.class, "readAllBytes", MethodType.fromMethodDescriptorString("()[B", Utils.class.getClassLoader()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        READ_ALL_BYTES_HANDLE = handle;
    }
}

