/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starplane.sourcegen;

import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FernflowerLoggerAdapter
extends IFernflowerLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(FernflowerLoggerAdapter.class);

    public FernflowerLoggerAdapter(IFernflowerLogger.Severity severity) {
        this.setSeverity(severity);
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity) {
        if (!this.accepts(severity)) {
            return;
        }
        switch (severity) {
            case ERROR: {
                LOGGER.error(message);
                break;
            }
            case INFO: {
                LOGGER.info(message);
                break;
            }
            case TRACE: {
                LOGGER.trace(message);
                break;
            }
            case WARN: {
                LOGGER.warn(message);
                break;
            }
            default: {
                LOGGER.error(message);
            }
        }
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t) {
        if (!this.accepts(severity)) {
            return;
        }
        switch (severity) {
            case ERROR: {
                LOGGER.error(message, t);
                break;
            }
            case INFO: {
                LOGGER.info(message, t);
                break;
            }
            case TRACE: {
                LOGGER.trace(message, t);
                break;
            }
            case WARN: {
                LOGGER.warn(message, t);
                break;
            }
            default: {
                LOGGER.error(message, t);
            }
        }
    }
}

