/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.gslstarplane;

import de.geolykt.starplane.remapping.MIOContainerFormat;
import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import net.fabricmc.mappingio.format.MappingFormat;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GslExtension {
    @Nullable
    public Object eclipseEEA;
    @NotNull
    public final List<Object> externalMods = new ArrayList<Object>();
    @Nullable
    public List<Object> internalMods;
    @NotNull
    public final @NotNull List<Map.Entry<@NotNull MIOContainerFormat, @NotNull Object>> mappings = new ArrayList<Map.Entry<MIOContainerFormat, Object>>();
    @Nullable
    public Path modDirectory;
    @Nullable
    public Object reversibleAccessSetter;
    @NotNull
    public final List<Object> softmapMappings = new ArrayList<Object>();
    List<BiConsumer<ModType, Object>> updateHooks = new ArrayList<BiConsumer<ModType, Object>>();

    public void externalMod(Object ... notations) {
        for (Object o : notations) {
            this.externalMod(o);
        }
    }

    public void externalMod(Object notation) {
        this.externalMods.add(notation);
        for (BiConsumer<ModType, Object> hook : this.updateHooks) {
            hook.accept(ModType.EXTERNAL, notation);
        }
    }

    @Nullable
    public String getRASContents(@NotNull Project project) {
        if (this.reversibleAccessSetter == null) {
            return null;
        }
        return project.getResources().getText().fromFile(this.reversibleAccessSetter, StandardCharsets.UTF_8.name()).asString();
    }

    public void internalMod(Object ... notations) {
        for (Object o : notations) {
            this.internalMod(o);
        }
    }

    public void internalMod(Object notation) {
        List<Object> internalMods = this.internalMods;
        if (internalMods == null) {
            this.internalMods = internalMods = new ArrayList<Object>();
        }
        internalMods.add(notation);
        for (BiConsumer<ModType, Object> hook : this.updateHooks) {
            hook.accept(ModType.INTERNAL, notation);
        }
    }

    public void mappingsFile(@NotNull String format, @NotNull Object notation) {
        this.mappingsFile(format, null, notation);
    }

    public void mappingsFile(@NotNull String format, @Nullable String containerFormat, @NotNull Object notation) {
        MappingFormat mFormat;
        MIOContainerFormat.MappingContainer cFormat;
        block10: {
            if (containerFormat == null || containerFormat.isBlank()) {
                cFormat = MIOContainerFormat.MappingContainer.PLAIN;
            } else {
                if (containerFormat.startsWith(".")) {
                    containerFormat = containerFormat.substring(1);
                }
                cFormat = MIOContainerFormat.MappingContainer.valueOf(containerFormat.toUpperCase(Locale.ROOT).replace('.', '_'));
            }
            mFormat = null;
            try {
                mFormat = MappingFormat.valueOf((String)format.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                for (MappingFormat mf : MappingFormat.values()) {
                    if (mf.name == null || !mf.name.equalsIgnoreCase(format)) continue;
                    mFormat = mf;
                    break;
                }
                if (format.equalsIgnoreCase("tiny2") || format.equalsIgnoreCase("tinyv2")) {
                    mFormat = MappingFormat.TINY_2_FILE;
                }
                if (format.equalsIgnoreCase("enigma")) {
                    mFormat = cFormat == MIOContainerFormat.MappingContainer.TAR_XZ ? MappingFormat.ENIGMA_DIR : MappingFormat.ENIGMA_FILE;
                }
                if (mFormat != null) break block10;
                for (MappingFormat mf : MappingFormat.values()) {
                    if (mf.fileExt == null || !mf.fileExt.equalsIgnoreCase(format)) continue;
                    mFormat = mf;
                    break;
                }
            }
        }
        if (mFormat == null) {
            throw new IllegalArgumentException("No mappings format known under the following name: '" + format + "'");
        }
        this.mappings.add(new AbstractMap.SimpleImmutableEntry<MIOContainerFormat, Object>(new MIOContainerFormat(mFormat, cFormat), notation));
    }

    public void softmapFile(@NotNull Object notation) {
        if (!(notation instanceof Configuration || notation instanceof CharSequence || notation instanceof File || notation instanceof Path || notation instanceof URI || notation instanceof URL || notation instanceof Directory || notation instanceof RegularFile || notation instanceof Provider || notation instanceof TextResource || notation instanceof Closure || notation instanceof Callable)) {
            Objects.requireNonNull("Argument 'notation' may not be null");
            throw new IllegalArgumentException("Notation not of supported type. Please consult the gslStarplane README for further details. Argument 'notation' is an instance of " + notation.getClass().getName());
        }
        this.softmapMappings.add(notation);
    }

    public void withRAS(Object notation) {
        this.reversibleAccessSetter = notation;
    }

    public static enum ModType {
        EXTERNAL,
        INTERNAL;

    }
}

