/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.gslstarplane;

import de.geolykt.starloader.gslstarplane.GradleInteropUtil;
import de.geolykt.starloader.gslstarplane.GslStarplanePlugin;
import de.geolykt.starplane.Utils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.tasks.JavaExec;
import org.gradle.jvm.tasks.Jar;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;

@DisableCachingByDefault(because="Does not make sense")
public class GslRunModsTask
extends JavaExec {
    @NotNull
    private final List<Object> extraMods = new ArrayList<Object>();

    public GslRunModsTask() {
        super.dependsOn(new Object[]{"deployMods"});
        super.dependsOn(new Object[]{"jar"});
        super.setDescription("Run the development environment.");
        super.setGroup("GslStarplane");
        super.getMainClass().set((Object)"de.geolykt.starloader.launcher.IDELauncher");
        super.setIgnoreExitValue(true);
        super.systemProperty("de.geolykt.starloader.launcher.IDELauncher.inlineStarplaneAnnotations", (Object)true);
    }

    public void from(Object notation) {
        if (notation instanceof Task) {
            super.dependsOn(new Object[]{notation});
        }
        this.extraMods.add(notation);
    }

    public void from(Object ... notation) {
        for (Object o : notation) {
            this.from(o);
        }
    }

    @NotNull
    private @NotNull List<@NotNull Path> getModPaths() {
        LinkedHashSet<@NotNull Path> out = new LinkedHashSet<Path>();
        for (Object modJar : this.extraMods) {
            this.getLogger().info("Looking at " + modJar);
            if (modJar instanceof SoftwareComponent) {
                for (UsageContext usageCtx : GradleInteropUtil.getUsageContexts((SoftwareComponent)modJar)) {
                    if (usageCtx == null) continue;
                    for (PublishArtifact artifact : usageCtx.getArtifacts()) {
                        if (artifact == null) continue;
                        out.add(artifact.getFile().toPath());
                    }
                }
                continue;
            }
            if (modJar instanceof PublishArtifact) {
                out.add(((PublishArtifact)modJar).getFile().toPath());
                continue;
            }
            if (modJar instanceof Jar) {
                out.add(((RegularFile)((Jar)modJar).getArchiveFile().get()).getAsFile().toPath());
                continue;
            }
            out.add(super.getProject().file(modJar).toPath());
        }
        this.getLogger().info("Potential mods path: " + out);
        return new ArrayList<Path>(out);
    }

    private void setupLauncherProperties() {
        super.jvmArgs(new Object[]{GslStarplanePlugin.getBootPath(super.getProject())});
        JSONArray modURLs = new JSONArray();
        for (Path p : this.getModPaths()) {
            JSONArray mod = new JSONArray();
            try {
                mod.put((Object)p.toUri().toURL().toExternalForm());
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException((Throwable)e);
            }
            modURLs.put((Object)mod);
        }
        super.systemProperty("de.geolykt.starloader.launcher.IDELauncher.modURLs", (Object)modURLs.toString());
    }

    private void resolveClasspath() {
        super.classpath(new Object[]{super.getProject().getConfigurations().getByName("devRuntime").resolve()});
    }

    private void linkDataFolder() {
        Path dataFolder = super.getWorkingDir().toPath().resolve("data");
        if (Files.notExists(dataFolder, new LinkOption[0])) {
            Path galimDataFolder;
            File gameFolder = Utils.getGameDir("Galimulator");
            if (gameFolder == null || Files.notExists(galimDataFolder = gameFolder.toPath().resolve("data"), new LinkOption[0])) {
                super.getLogger().warn("Couldn't locate data folder. You might need to copy the data folder manually in order to be able to run this task");
            } else {
                try {
                    Files.createSymbolicLink(dataFolder, galimDataFolder, new FileAttribute[0]);
                }
                catch (IOException e) {
                    super.getLogger().warn("Cannot link data folder. You might need to copy the data folder manually in order to be able to run this task", (Throwable)e);
                }
            }
        }
    }

    public void exec() {
        this.resolveClasspath();
        this.linkDataFolder();
        this.setupLauncherProperties();
        super.exec();
    }
}

