/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.remapper;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonBlocking;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.stianloader.remapper.HierarchyAwareMappingDelegator;
import org.stianloader.remapper.MemberRef;

public class SimpleTopLevelLookup
implements HierarchyAwareMappingDelegator.TopLevelMemberLookup {
    private final @Unmodifiable @NotNull Map<MemberRef, MemberRealm> realms;

    @NotNull
    @Contract(pure=true, value="null -> fail; !null -> new")
    private static <T> @NotNull @Unmodifiable Map<T, @NotNull Set<T>> assembleInvertedTree(@Unmodifiable @NotNull Map<T, ? extends @Nullable Set<T>> input) {
        HashMap<T, @NotNull HashSet<E>> mapOut = new HashMap();
        ArrayDeque<T> queue = new ArrayDeque<T>();
        for (T key : input.keySet()) {
            HashSet collected = new HashSet();
            queue.addAll((Collection)input.get(key));
            while (!queue.isEmpty()) {
                Object queued = queue.remove();
                if (!collected.add(queued)) continue;
                Set elements = (Set)mapOut.get(queued);
                if (!Objects.isNull(elements)) {
                    collected.addAll(elements);
                    continue;
                }
                Set<T> set = input.get(queued);
                if (set == null) continue;
                queue.addAll(set);
            }
            mapOut.put(key, collected);
        }
        return Collections.unmodifiableMap(mapOut);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static @NotNull @Unmodifiable Map<@NotNull MemberRef, @NotNull MemberRealm> realmsOf(@NotNull @Unmodifiable @NotNull List<@NotNull ClassNode> nodes) {
        HashMap<@NotNull String, @NotNull Set> immediateChildren = new HashMap<String, Set>();
        HashMap<@NotNull String, ClassNode> nodeLookup = new HashMap<String, ClassNode>();
        for (ClassNode node : nodes) {
            nodeLookup.put(node.name, node);
            BiFunction<String, Set, Set> combiner = (key, children) -> {
                if (children == null) {
                    children = new TreeSet<String>();
                }
                children.add(node.name);
                return children;
            };
            immediateChildren.compute(node.superName, combiner);
            for (String interfaceName : node.interfaces) {
                immediateChildren.compute(interfaceName, combiner);
            }
        }
        Map<@NotNull K, @NotNull Set<@NotNull K>> allChildren = SimpleTopLevelLookup.assembleInvertedTree(immediateChildren);
        TreeSet<@NotNull K> applyOrder = new TreeSet((e1, e0) -> {
            int hiOrder = allChildren.getOrDefault(e0, Collections.emptySet()).size() - allChildren.getOrDefault(e1, Collections.emptySet()).size();
            return hiOrder == 0 ? e1.compareTo((String)e0) : hiOrder;
        });
        applyOrder.addAll(nodeLookup.keySet());
        HashMap<@NotNull MemberRef, @NotNull Object> realms = new HashMap<MemberRef, Object>();
        for (String superType : applyOrder) {
            Object realm;
            ClassNode childNode;
            Set children2;
            TreeSet<String> realmAccess;
            Set<String> realmMembers;
            Set children3;
            MemberRef myLoc;
            ClassNode superNode = (ClassNode)nodeLookup.get(superType);
            for (MethodNode superMethod : superNode.methods) {
                myLoc = new MemberRef(superType, superMethod.name, superMethod.desc);
                if (realms.containsKey(myLoc)) continue;
                if ((superMethod.access & 2) != 0) {
                    realms.put(myLoc, new MemberRealm(myLoc, Collections.singleton(superType)));
                } else if ((superMethod.access & 1) != 0 || (superMethod.access & 4) != 0) {
                    children3 = allChildren.getOrDefault(superType, Collections.emptySet());
                    if (children3.isEmpty()) {
                        realmMembers = Collections.singleton(superType);
                    } else {
                        realmMembers = new HashSet(children3);
                        realmMembers.add(superType);
                    }
                    MemberRealm realm2 = new MemberRealm(myLoc, realmMembers);
                    realms.put(myLoc, realm2);
                    for (Object child2 : children3) {
                        realms.put(new MemberRef((String)child2, superMethod.name, superMethod.desc), realm2);
                    }
                } else {
                    Object child2;
                    realmAccess = new TreeSet<String>();
                    children2 = allChildren.getOrDefault(superType, Collections.emptySet());
                    int lastSlashSuper = superType.lastIndexOf(47);
                    realmAccess.add(superType);
                    for (Object child2 : children2) {
                        int lastSlashChild = ((String)child2).lastIndexOf(47);
                        if (lastSlashChild != lastSlashSuper || !((String)child2).regionMatches(0, superType, 0, lastSlashChild)) continue;
                        realmAccess.add((String)child2);
                        childNode = (ClassNode)nodeLookup.get(child2);
                        if (childNode == null) continue;
                        for (MethodNode method : childNode.methods) {
                            if (!method.name.equals(superMethod.name) || !method.desc.equals(superMethod.desc) || (method.access & 1) == 0 && (method.access & 4) == 0) continue;
                            realmAccess.addAll(allChildren.getOrDefault(child2, Collections.emptySet()));
                        }
                    }
                    realm = new MemberRealm(myLoc, realmAccess);
                    child2 = realmAccess.iterator();
                    while (child2.hasNext()) {
                        String realmType = (String)child2.next();
                        realms.put(new MemberRef(realmType, superMethod.name, superMethod.desc), realm);
                    }
                }
                if (realms.containsKey(myLoc)) continue;
                throw new IllegalStateException("Reference not in list of realms: " + myLoc);
            }
            for (FieldNode superField : superNode.fields) {
                myLoc = new MemberRef(superType, superField.name, superField.desc);
                if (realms.containsKey(myLoc)) continue;
                if ((superField.access & 2) != 0) {
                    realms.put(myLoc, new MemberRealm(myLoc, Collections.singleton(superType)));
                } else if ((superField.access & 1) != 0 || (superField.access & 4) != 0) {
                    children3 = allChildren.getOrDefault(superType, Collections.emptySet());
                    if (children3.isEmpty()) {
                        realmMembers = Collections.singleton(superType);
                    } else {
                        realmMembers = new HashSet(children3);
                        realmMembers.add(superType);
                    }
                    MemberRealm realm3 = new MemberRealm(myLoc, realmMembers);
                    realms.put(myLoc, realm3);
                    for (Object child2 : children3) {
                        realms.put(new MemberRef((String)child2, superField.name, superField.desc), realm3);
                    }
                } else {
                    realmAccess = new TreeSet();
                    children2 = allChildren.getOrDefault(superType, Collections.emptySet());
                    int lastSlashSuper = superType.lastIndexOf(47);
                    realmAccess.add(superType);
                    for (Object child2 : children2) {
                        int lastSlashChild = ((String)child2).lastIndexOf(47);
                        if (lastSlashChild != lastSlashSuper || !((String)child2).regionMatches(0, superType, 0, lastSlashChild)) continue;
                        realmAccess.add((String)child2);
                        childNode = (ClassNode)nodeLookup.get(child2);
                        if (childNode == null) continue;
                        for (FieldNode field : childNode.fields) {
                            if (!field.name.equals(superField.name) || !field.desc.equals(superField.desc) || (field.access & 1) == 0 && (field.access & 4) == 0) continue;
                            realmAccess.addAll(allChildren.getOrDefault(child2, Collections.emptySet()));
                        }
                    }
                    realm = new MemberRealm(myLoc, realmAccess);
                    for (String realmType : realmAccess) {
                        realms.put(new MemberRef(realmType, superField.name, superField.desc), realm);
                    }
                }
                if (realms.containsKey(myLoc)) continue;
                throw new IllegalStateException("Reference not in list of realms: " + myLoc);
            }
        }
        return Collections.unmodifiableMap(realms);
    }

    public SimpleTopLevelLookup(@NotNull @Unmodifiable @NotNull List<@NotNull ClassNode> applicationClasses) {
        this(SimpleTopLevelLookup.realmsOf(applicationClasses));
    }

    public SimpleTopLevelLookup(@Unmodifiable @NotNull Map<MemberRef, MemberRealm> realms) {
        this.realms = realms;
    }

    @Override
    @NotNull
    @Contract(pure=true, value="!null -> !null; null -> fail")
    @NonBlocking
    public MemberRef getDefinition(@NotNull MemberRef reference) {
        MemberRealm realm = this.realmOf(reference);
        if (realm == null) {
            return reference;
        }
        return realm.rootDefinition;
    }

    @Nullable
    @Contract(pure=true)
    public MemberRealm realmOf(@NotNull MemberRef reference) {
        return this.realms.get(reference);
    }

    public static class MemberRealm {
        @NotNull
        public final @NotNull @Unmodifiable Set<@NotNull String> realmMembers;
        @NotNull
        public final MemberRef rootDefinition;

        public MemberRealm(@NotNull MemberRef rootDefinition, @NotNull @Unmodifiable @NotNull Set<@NotNull String> realmMembers) {
            this.rootDefinition = rootDefinition;
            this.realmMembers = realmMembers;
        }

        public String toString() {
            return "MemberRealm[root='" + this.rootDefinition + "',members='" + this.realmMembers + "']";
        }
    }
}

