/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.concurrent;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongArray;

public final class ConcurrentInt62Set
implements LongSet {
    final Bucket[] buckets;
    final int bucketCount;
    private static final long CTRL_BIT_READ = Long.MIN_VALUE;
    private static final long INT_32_BITS = 0xFFFFFFFFL;
    private static final long INT_63_BITS = Long.MAX_VALUE;
    private static final long INT_62_BITS = 0x3FFFFFFFFFFFFFFFL;
    static final AtomicIntegerFieldUpdater<Bucket> BUCKET_SIZE = AtomicIntegerFieldUpdater.newUpdater(Bucket.class, "size");
    static final AtomicIntegerFieldUpdater<Bucket> BUCKET_CTRL = AtomicIntegerFieldUpdater.newUpdater(Bucket.class, "ctrl");

    private static int indexFor(long element, int size) {
        return (int)(element & 0xFFFFFFFFL ^ element >> 32) & size - 1;
    }

    public ConcurrentInt62Set(int bucketCount) {
        if (Integer.bitCount(bucketCount) != 1) {
            throw new IllegalArgumentException("bucketCount must be a power of 2.");
        }
        this.bucketCount = bucketCount;
        this.buckets = new Bucket[bucketCount];
        for (int i = 0; i < this.bucketCount; ++i) {
            this.buckets[i] = new Bucket();
        }
    }

    public boolean add(long element) {
        if ((element & 0xC000000000000000L) != 0L) {
            throw new IllegalArgumentException("Input element is not a 62-bit unsigned integer: " + element);
        }
        return this.buckets[ConcurrentInt62Set.indexFor(++element, this.bucketCount)].add(element);
    }

    public boolean remove(long element) {
        if ((element & 0xC000000000000000L) != 0L) {
            throw new IllegalArgumentException("Input element is not a 62-bit unsigned integer: " + element);
        }
        return this.buckets[ConcurrentInt62Set.indexFor(++element, this.bucketCount)].remove(element);
    }

    public boolean contains(long element) {
        return this.buckets[ConcurrentInt62Set.indexFor(++element, this.bucketCount)].contains(element);
    }

    public long[] toLongArray() {
        LongArrayList list = new LongArrayList();
        this.iterator().forEachRemaining(arg_0 -> ((LongArrayList)list).add(arg_0));
        return list.toLongArray();
    }

    public long[] toArray(long[] a) {
        long[] array = this.toLongArray();
        if (array.length < a.length) {
            System.arraycopy(array, 0, a, 0, array.length);
            return a;
        }
        return array;
    }

    public boolean addAll(LongCollection c) {
        LongIterator lt = c.longIterator();
        boolean modified = false;
        while (lt.hasNext()) {
            modified |= this.add(lt.nextLong());
        }
        return modified;
    }

    public boolean containsAll(LongCollection c) {
        LongIterator lt = c.longIterator();
        while (lt.hasNext()) {
            if (this.contains(lt.nextLong())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(LongCollection c) {
        LongIterator lt = c.longIterator();
        boolean modified = false;
        while (lt.hasNext()) {
            modified |= this.remove(lt.nextLong());
        }
        return modified;
    }

    public boolean retainAll(LongCollection c) {
        LongIterator it = this.longIterator();
        boolean modified = false;
        while (it.hasNext()) {
            if (c.contains(it.nextLong())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public boolean addAll(Collection<? extends Long> c) {
        Iterator<? extends Long> lt = c.iterator();
        boolean modified = false;
        while (lt.hasNext()) {
            modified |= this.add(lt.next());
        }
        return modified;
    }

    public int size() {
        int size = 0;
        for (Bucket b : this.buckets) {
            size += b.size;
        }
        return size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object[] toArray() {
        LongArrayList list = new LongArrayList();
        this.iterator().forEachRemaining(arg_0 -> ((LongArrayList)list).add(arg_0));
        return list.toArray();
    }

    public <T> T[] toArray(T[] a) {
        LongArrayList list = new LongArrayList();
        this.iterator().forEachRemaining(arg_0 -> ((LongArrayList)list).add(arg_0));
        return list.toArray((Object[])a);
    }

    @Deprecated
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(Collection<?> c) {
        LongIterator it = this.longIterator();
        boolean modified = false;
        while (it.hasNext()) {
            if (c.contains(it.nextLong())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            if (!(o instanceof Number) || !this.remove(((Number)o).longValue())) continue;
            modified = true;
        }
        return modified;
    }

    public void clear() {
        for (int i = 0; i < this.bucketCount; ++i) {
            this.buckets[i] = new Bucket();
        }
    }

    public LongIterator iterator() {
        return new LongIterator(){
            private final Bucket[] buckets;
            private int indexGlobal;
            private int indexBucket;
            private int lastIdxG;
            private AtomicLongArray currentBucketArray;
            private long lastValue;
            {
                this.buckets = ConcurrentInt62Set.this.buckets;
                this.indexGlobal = -1;
                this.lastIdxG = -1;
            }

            public boolean hasNext() {
                if (this.indexGlobal == -1) {
                    this.indexGlobal = 0;
                    this.currentBucketArray = this.buckets[0].values;
                }
                if (this.indexGlobal >= this.buckets.length || this.currentBucketArray == null) {
                    return false;
                }
                int len = this.currentBucketArray.length();
                while ((this.currentBucketArray.get(this.indexBucket) & Long.MIN_VALUE) == 0L) {
                    if (++this.indexBucket != len) continue;
                    if (++this.indexGlobal >= this.buckets.length) {
                        return false;
                    }
                    this.currentBucketArray = this.buckets[this.indexGlobal].values;
                    len = this.currentBucketArray.length();
                }
                return true;
            }

            public long nextLong() {
                if (this.indexGlobal == -1) {
                    this.hasNext();
                }
                if (this.indexGlobal > this.buckets.length) {
                    throw new NoSuchElementException("Iterator exhausted. (Note: In very rare cases this can be caused by resizing internal Arrays. In other cases this can be traced back to concurrency problems. The usage of the iterator in concurrent environments is dangerous.)");
                }
                long val = this.currentBucketArray.get(this.indexBucket);
                while ((val & Long.MIN_VALUE) == 0L) {
                    if (this.hasNext()) {
                        val = this.currentBucketArray.get(this.indexBucket);
                        continue;
                    }
                    throw new NoSuchElementException("Iterator exhausted. (Note: In very rare cases this can be caused by resizing internal Arrays. In other cases this can be traced back to concurrency problems. The usage of the iterator in concurrent environments is dangerous.)");
                }
                this.lastIdxG = this.indexGlobal++;
                this.lastValue = val &= Long.MAX_VALUE;
                if (++this.indexBucket == this.currentBucketArray.length()) {
                    this.indexBucket = 0;
                    this.currentBucketArray = this.indexGlobal == this.buckets.length ? null : this.buckets[this.indexGlobal].values;
                }
                return val - 1L;
            }

            public void remove() {
                if (this.lastIdxG == -1) {
                    throw new IllegalStateException("#next() has not been called!");
                }
                if (!this.buckets[this.lastIdxG].remove(this.lastValue)) {
                    throw new IllegalStateException("Element already removed.");
                }
            }
        };
    }

    static final class Bucket {
        volatile int ctrl;
        volatile AtomicLongArray values;
        volatile int size;

        Bucket() {
        }

        private final void lockCtrl() {
            int ctrl;
            while (!BUCKET_CTRL.compareAndSet(this, ctrl = this.ctrl, -ctrl - 1)) {
            }
            while (this.ctrl != -1) {
                Thread.yield();
            }
        }

        private final void decrementCtrl() {
            int ctrl;
            while (!BUCKET_CTRL.compareAndSet(this, ctrl, (ctrl = this.ctrl) < 0 ? ctrl + 1 : ctrl - 1)) {
            }
        }

        private final void incrementCtrl() {
            while (true) {
                int ctrl;
                if ((ctrl = this.ctrl) < 0) {
                    Thread.yield();
                    continue;
                }
                if (BUCKET_CTRL.compareAndSet(this, ctrl, ctrl + 1)) break;
            }
        }

        boolean contains(long value) {
            AtomicLongArray values = this.values;
            if (values == null) {
                return false;
            }
            value |= Long.MIN_VALUE;
            int index = values.length();
            while (index-- != 0) {
                if (values.get(index) != value) continue;
                return true;
            }
            return false;
        }

        boolean add(long element) {
            this.incrementCtrl();
            AtomicLongArray values = this.values;
            if (values == null) {
                this.decrementCtrl();
                this.growValues(values);
                return this.add(element);
            }
            int len = BUCKET_SIZE.incrementAndGet(this);
            if (len >= values.length()) {
                this.decrementCtrl();
                this.growValues(values);
                BUCKET_SIZE.decrementAndGet(this);
                return this.add(element);
            }
            int index = values.length();
            int storeIndex = -1;
            while (index-- != 0) {
                if (storeIndex == -1 && values.compareAndSet(index, 0L, element)) {
                    storeIndex = index;
                    continue;
                }
                if ((values.get(index) & Long.MAX_VALUE) != element) continue;
                if (storeIndex >= 0) {
                    values.set(storeIndex, 0L);
                }
                BUCKET_SIZE.decrementAndGet(this);
                this.decrementCtrl();
                return false;
            }
            if (storeIndex >= 0) {
                if (!values.compareAndSet(storeIndex, element, element | Long.MIN_VALUE)) {
                    BUCKET_SIZE.decrementAndGet(this);
                    this.decrementCtrl();
                    throw new AssertionError((Object)"Unable to CAS back to read-enabled (but not write-disabled) state.");
                }
                this.decrementCtrl();
                return true;
            }
            BUCKET_SIZE.decrementAndGet(this);
            this.decrementCtrl();
            return this.add(element);
        }

        boolean remove(long element) {
            this.incrementCtrl();
            AtomicLongArray values = this.values;
            if (values == null) {
                this.decrementCtrl();
                return false;
            }
            int index = values.length();
            while (index-- != 0) {
                long value = values.get(index);
                if ((value & Long.MAX_VALUE) != element) continue;
                if (!values.compareAndSet(index, value, 0L)) {
                    ++index;
                    continue;
                }
                BUCKET_SIZE.decrementAndGet(this);
                this.decrementCtrl();
                return true;
            }
            this.decrementCtrl();
            return false;
        }

        synchronized void growValues(AtomicLongArray witness) {
            if (this.values != witness) {
                return;
            }
            if (witness == null) {
                this.values = new AtomicLongArray(16);
                return;
            }
            this.lockCtrl();
            int len = witness.length();
            AtomicLongArray grown = new AtomicLongArray(len << 1);
            for (int i = 0; i < len; ++i) {
                grown.set(i + len, witness.get(i));
            }
            this.values = grown;
            BUCKET_CTRL.incrementAndGet(this);
        }
    }
}

