/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.stianknn;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.stianknn.PointObjectPair;
import org.stianloader.stianknn.SpatialIndexIterable;
import org.stianloader.stianknn.SpatialRingIndex1NN;

public class SpatialBufferedQueryArray<E>
implements SpatialRingIndex1NN<E>,
SpatialIndexIterable<E> {
    private static final int KNN_ITERATOR_THRESHOLD = Integer.MAX_VALUE;
    @NotNull
    private final PointObjectPair<E>[] points;

    public SpatialBufferedQueryArray(@NotNull @NotNull Collection<@NotNull PointObjectPair<E>> points) {
        @NotNull PointObjectPair[] pointArray = points.toArray(new PointObjectPair[0]);
        this.points = pointArray;
        Arrays.sort(this.points);
    }

    private int binarySearch(int leftAnchor, int rightAnchor, float x) {
        --rightAnchor;
        while (leftAnchor <= rightAnchor) {
            int center = (leftAnchor + rightAnchor) / 2;
            int compareResult = Float.compare(this.points[center].x, x);
            if (compareResult < 0) {
                leftAnchor = center + 1;
                continue;
            }
            if (compareResult == 0) {
                return center;
            }
            rightAnchor = center - 1;
        }
        return leftAnchor;
    }

    @Override
    public Iterator<@NotNull E> createIterator(final float x, final float y) {
        return new Iterator<E>(){
            private PriorityQueue<CachedObject<E>> queue = new PriorityQueue();
            private int leftEdge;
            private int rightEdge;
            {
                int searchOrigin = SpatialBufferedQueryArray.this.binarySearch(0, SpatialBufferedQueryArray.this.points.length, x);
                this.leftEdge = searchOrigin - 1;
                this.rightEdge = searchOrigin;
            }

            @Override
            public boolean hasNext() {
                return !this.queue.isEmpty() || this.leftEdge >= 0 || this.rightEdge < SpatialBufferedQueryArray.this.points.length;
            }

            @Override
            @NotNull
            public E next() {
                CachedObject nearest = this.next0();
                if (nearest == null) {
                    throw new NoSuchElementException(SpatialBufferedQueryArray.this.points.length == 0 ? "No elements to iterate over" : "Iterator has been exhausted");
                }
                this.queue.poll();
                return nearest.object.object;
            }

            private CachedObject<E> next0() {
                boolean crawlRight;
                CachedObject<Object> nearest = this.queue.peek();
                float nearestDistSq = nearest == null ? Float.POSITIVE_INFINITY : ((CachedObject)nearest).distanceSq;
                PointObjectPair[] points = SpatialBufferedQueryArray.this.points;
                boolean crawlLeft = this.leftEdge >= 0;
                boolean bl = crawlRight = this.rightEdge < points.length;
                while (crawlLeft || crawlRight) {
                    CachedObject object;
                    float objectDistanceSq;
                    float horizontalDistanceSq;
                    PointObjectPair pair;
                    if (crawlLeft) {
                        pair = points[this.leftEdge--];
                        if (this.leftEdge < 0) {
                            crawlLeft = false;
                        }
                        horizontalDistanceSq = (pair.x - x) * (pair.x - x);
                        objectDistanceSq = horizontalDistanceSq + (pair.y - y) * (pair.y - y);
                        object = new CachedObject(pair, objectDistanceSq);
                        this.queue.add(object);
                        if (horizontalDistanceSq >= nearestDistSq) {
                            crawlLeft = false;
                        } else if (objectDistanceSq < nearestDistSq) {
                            nearest = object;
                            nearestDistSq = objectDistanceSq;
                        }
                    }
                    if (!crawlRight) continue;
                    pair = points[this.rightEdge++];
                    if (this.rightEdge == points.length) {
                        crawlRight = false;
                    }
                    horizontalDistanceSq = (pair.x - x) * (pair.x - x);
                    objectDistanceSq = horizontalDistanceSq + (pair.y - y) * (pair.y - y);
                    object = new CachedObject(pair, objectDistanceSq);
                    this.queue.add(object);
                    if (horizontalDistanceSq >= nearestDistSq) {
                        crawlRight = false;
                        continue;
                    }
                    if (!(objectDistanceSq < nearestDistSq)) continue;
                    nearest = object;
                    nearestDistSq = objectDistanceSq;
                }
                return nearest;
            }
        };
    }

    @Override
    @Nullable
    public E query1nn(float x, float y, float minDistSq, float maxDistSq) {
        PointObjectPair<E> pair = this.query1nn0(x, y, minDistSq, maxDistSq);
        return pair == null ? null : (E)pair.object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private PointObjectPair<E> query1nn0(float x, float y, float minDistSq, float maxDistSq) {
        int maxPoints = this.points.length;
        int searchOrigin = this.binarySearch(0, maxPoints, x);
        int leftEdge = searchOrigin - 1;
        int rightEdge = searchOrigin;
        PointObjectPair<E> currentNearest = null;
        while (true) {
            float distSq;
            float dy;
            float dx;
            PointObjectPair<E> pair;
            if (leftEdge >= 0) {
                pair = this.points[leftEdge--];
                dx = pair.x - x;
                if ((dx *= dx) > maxDistSq) {
                    if (rightEdge >= maxPoints) return currentNearest;
                    leftEdge = -1;
                } else {
                    dy = pair.y - y;
                    distSq = dx + dy * dy;
                    if (distSq >= minDistSq && distSq < maxDistSq) {
                        currentNearest = pair;
                        maxDistSq = distSq;
                    }
                }
            }
            if (rightEdge < maxPoints) {
                pair = this.points[rightEdge++];
                dx = pair.x - x;
                if ((dx *= dx) > maxDistSq) {
                    if (leftEdge < 0) return currentNearest;
                    rightEdge = maxPoints;
                    continue;
                }
                dy = pair.y - y;
                distSq = dx + dy * dy;
                if (!(distSq >= minDistSq) || !(distSq < maxDistSq)) continue;
                currentNearest = pair;
                maxDistSq = distSq;
                continue;
            }
            if (leftEdge < 0) return currentNearest;
        }
    }

    @Override
    public void queryKnn(float x, float y, int neighbourCount, @NotNull @NotNull Consumer<@NotNull E> out) {
        boolean crawlRight;
        if ((neighbourCount = Math.min(neighbourCount, this.points.length)) > Integer.MAX_VALUE) {
            Iterator<@NotNull E> it = this.createIterator(x, y);
            while (neighbourCount-- != 0) {
                out.accept(it.next());
            }
            return;
        }
        Object[] collector = new CachedObject[neighbourCount];
        Arrays.fill(collector, CachedObject.NULL_OBJECT);
        int searchOrigin = this.binarySearch(0, this.points.length, x);
        int leftEdge = searchOrigin - 1;
        int rightEdge = searchOrigin;
        int lastElement = neighbourCount - 1;
        boolean crawlLeft = leftEdge >= 0;
        boolean bl = crawlRight = rightEdge < this.points.length;
        while (crawlLeft || crawlRight) {
            int i;
            float objectDistanceSq;
            float horizontalDistanceSq;
            PointObjectPair<E> pair;
            if (crawlLeft) {
                pair = this.points[leftEdge--];
                if (leftEdge < 0) {
                    crawlLeft = false;
                }
                if ((horizontalDistanceSq = (pair.x - x) * (pair.x - x)) >= ((CachedObject)collector[lastElement]).distanceSq) {
                    crawlLeft = false;
                } else {
                    objectDistanceSq = horizontalDistanceSq + (pair.y - y) * (pair.y - y);
                    if (objectDistanceSq < ((CachedObject)collector[lastElement]).distanceSq) {
                        i = lastElement;
                        while (i > 0) {
                            if (objectDistanceSq < ((CachedObject)collector[i--]).distanceSq) continue;
                        }
                        System.arraycopy(collector, i, collector, i + 1, lastElement - i);
                        collector[i] = new CachedObject(pair, objectDistanceSq);
                    }
                }
            }
            if (!crawlRight) continue;
            pair = this.points[rightEdge++];
            if (rightEdge == this.points.length) {
                crawlRight = false;
            }
            if ((horizontalDistanceSq = (pair.x - x) * (pair.x - x)) >= ((CachedObject)collector[lastElement]).distanceSq) {
                crawlRight = false;
                continue;
            }
            objectDistanceSq = horizontalDistanceSq + (pair.y - y) * (pair.y - y);
            if (!(objectDistanceSq < ((CachedObject)collector[lastElement]).distanceSq)) continue;
            i = lastElement;
            while (i > 0) {
                if (objectDistanceSq < ((CachedObject)collector[i--]).distanceSq) continue;
            }
            System.arraycopy(collector, i, collector, i + 1, lastElement - i);
            collector[i] = new CachedObject(pair, objectDistanceSq);
        }
        for (Object collected : collector) {
            if (((CachedObject)collected).object == null) {
                this.queryKnn(x, y, neighbourCount, out);
            }
            out.accept(((CachedObject)collected).object.object);
        }
    }

    static final class CachedObject<T>
    implements Comparable<CachedObject<T>> {
        private static final CachedObject<Object> NULL_OBJECT = new CachedObject(null, Float.POSITIVE_INFINITY);
        private final PointObjectPair<T> object;
        private final float distanceSq;

        private CachedObject(PointObjectPair<T> o, float distanceSq) {
            this.object = o;
            this.distanceSq = distanceSq;
        }

        @Override
        public int compareTo(CachedObject<T> o) {
            int ret = Float.compare(this.distanceSq, o.distanceSq);
            if (ret != 0) {
                return ret;
            }
            return this.object.compareTo(o.object);
        }
    }
}

