/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.stianknn;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.stianknn.PointObjectPair;
import org.stianloader.stianknn.SpatialIndexIterable;
import org.stianloader.stianknn.SpatialRingIndex1NN;

@Deprecated
public class SpatialQueryArrayLegacy<E>
implements SpatialRingIndex1NN<E>,
SpatialIndexIterable<E> {
    @NotNull
    private final PointObjectPair<E>[] points;

    public SpatialQueryArrayLegacy(@NotNull @NotNull Collection<@NotNull PointObjectPair<E>> points) {
        this.points = points.toArray(new PointObjectPair[0]);
        Arrays.sort(this.points);
    }

    private int binarySearch(int leftAnchor, int rightAnchor, float x) {
        --rightAnchor;
        while (leftAnchor <= rightAnchor) {
            int center = (leftAnchor + rightAnchor) / 2;
            int compareResult = Float.compare(this.points[center].x, x);
            if (compareResult < 0) {
                leftAnchor = center + 1;
                continue;
            }
            if (compareResult == 0) {
                return center;
            }
            rightAnchor = center - 1;
        }
        return leftAnchor;
    }

    @Override
    public Iterator<@NotNull E> createIterator(float x, float y) {
        return this.queryKnn(x, y);
    }

    @Override
    @Nullable
    public E query1nn(float x, float y, float minDistSq, float maxDistSq) {
        PointObjectPair<E> pair = this.query1nn0(x, y, minDistSq, maxDistSq);
        return pair == null ? null : (E)pair.object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private PointObjectPair<E> query1nn0(float x, float y, float minDistSq, float maxDistSq) {
        int maxPoints = this.points.length;
        int searchOrigin = this.binarySearch(0, maxPoints, x);
        int leftEdge = searchOrigin - 1;
        int rightEdge = searchOrigin;
        PointObjectPair<E> currentNearest = null;
        while (true) {
            float distSq;
            float dy;
            float dx;
            PointObjectPair<E> pair;
            if (leftEdge >= 0) {
                pair = this.points[leftEdge--];
                dx = pair.x - x;
                if ((dx *= dx) > maxDistSq) {
                    if (rightEdge >= maxPoints) return currentNearest;
                    leftEdge = -1;
                } else {
                    dy = pair.y - y;
                    distSq = dx + dy * dy;
                    if (distSq >= minDistSq && distSq < maxDistSq) {
                        currentNearest = pair;
                        maxDistSq = distSq;
                    }
                }
            }
            if (rightEdge < maxPoints) {
                pair = this.points[rightEdge++];
                dx = pair.x - x;
                if ((dx *= dx) > maxDistSq) {
                    if (leftEdge < 0) return currentNearest;
                    rightEdge = maxPoints;
                    continue;
                }
                dy = pair.y - y;
                distSq = dx + dy * dy;
                if (!(distSq >= minDistSq) || !(distSq < maxDistSq)) continue;
                currentNearest = pair;
                maxDistSq = distSq;
                continue;
            }
            if (leftEdge < 0) return currentNearest;
        }
    }

    @Deprecated
    @NotNull
    public @NotNull Iterator<@NotNull E> queryKnn(final float x, final float y) {
        return new Iterator<E>(){
            private float minDistance = 0.0f;
            @Nullable
            private E nextElement;

            @Override
            public boolean hasNext() {
                if (this.nextElement == null) {
                    if (this.minDistance == Float.POSITIVE_INFINITY) {
                        return false;
                    }
                    PointObjectPair element = SpatialQueryArrayLegacy.this.query1nn0(x, y, this.minDistance, Float.POSITIVE_INFINITY);
                    if (element == null) {
                        this.minDistance = Float.POSITIVE_INFINITY;
                        return false;
                    }
                    this.nextElement = element.object;
                    float dx = element.x - x;
                    float dy = element.y - y;
                    this.minDistance = Math.nextUp(dx * dx + dy * dy);
                }
                return true;
            }

            @Override
            @NotNull
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Iterator exhausted");
                }
                @Nullable E element = this.nextElement;
                assert (element != null);
                this.nextElement = null;
                return element;
            }
        };
    }

    @Override
    public void queryKnn(float x, float y, int nearestNeighbours, Consumer<E> out) {
        float minDistance = 0.0f;
        while (nearestNeighbours-- != 0) {
            @Nullable PointObjectPair<E> element = this.query1nn0(x, y, minDistance, Float.POSITIVE_INFINITY);
            if (element == null) {
                return;
            }
            out.accept(element.object);
            float dx = element.x - x;
            float dy = element.y - y;
            minDistance = Math.nextUp(dx * dx + dy * dy);
        }
    }
}

