/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.softmap.insns;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.stianloader.softmap.FramedRemapper;
import org.stianloader.softmap.SoftmapParseError;
import org.stianloader.softmap.insns.InsnBlock;
import org.stianloader.softmap.insns.InsnParser;
import org.stianloader.softmap.insns.MatchResult;
import org.stianloader.softmap.tokens.StringToken;

public final class SimpleInsnBlock
implements InsnBlock {
    private final int opcode;
    @NotNull
    private final StringToken token;
    @NotNull
    public static final InsnParser<SimpleInsnBlock> NOP = new SimpleInsnBlockParser(0);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> ACONST_NULL = new SimpleInsnBlockParser(1);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> IALOAD = new SimpleInsnBlockParser(46);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LALOAD = new SimpleInsnBlockParser(47);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> FALOAD = new SimpleInsnBlockParser(48);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DALOAD = new SimpleInsnBlockParser(49);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> AALOAD = new SimpleInsnBlockParser(50);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> BALOAD = new SimpleInsnBlockParser(51);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> CALOAD = new SimpleInsnBlockParser(52);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> SALOAD = new SimpleInsnBlockParser(53);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> IASTORE = new SimpleInsnBlockParser(79);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LASTORE = new SimpleInsnBlockParser(80);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> FASTORE = new SimpleInsnBlockParser(81);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DASTORE = new SimpleInsnBlockParser(82);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> AASTORE = new SimpleInsnBlockParser(83);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> BASTORE = new SimpleInsnBlockParser(84);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> CASTORE = new SimpleInsnBlockParser(85);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> SASTORE = new SimpleInsnBlockParser(86);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> POP = new SimpleInsnBlockParser(87);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> POP2 = new SimpleInsnBlockParser(88);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DUP = new SimpleInsnBlockParser(89);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DUP2 = new SimpleInsnBlockParser(92);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DUP_X1 = new SimpleInsnBlockParser(90);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DUP2_X1 = new SimpleInsnBlockParser(93);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DUP_X2 = new SimpleInsnBlockParser(91);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DUP2_X2 = new SimpleInsnBlockParser(94);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> SWAP = new SimpleInsnBlockParser(95);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> IADD = new SimpleInsnBlockParser(96);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LADD = new SimpleInsnBlockParser(97);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> FADD = new SimpleInsnBlockParser(98);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DADD = new SimpleInsnBlockParser(99);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> ISUB = new SimpleInsnBlockParser(100);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LSUB = new SimpleInsnBlockParser(101);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> FSUB = new SimpleInsnBlockParser(102);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DSUB = new SimpleInsnBlockParser(103);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> IMUL = new SimpleInsnBlockParser(104);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LMUL = new SimpleInsnBlockParser(105);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> FMUL = new SimpleInsnBlockParser(106);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DMUL = new SimpleInsnBlockParser(107);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> IDIV = new SimpleInsnBlockParser(108);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LDIV = new SimpleInsnBlockParser(109);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> FDIV = new SimpleInsnBlockParser(110);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DDIV = new SimpleInsnBlockParser(111);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> IREM = new SimpleInsnBlockParser(112);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LREM = new SimpleInsnBlockParser(113);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> FREM = new SimpleInsnBlockParser(114);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DREM = new SimpleInsnBlockParser(115);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> INEG = new SimpleInsnBlockParser(116);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LNEG = new SimpleInsnBlockParser(117);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> FNEG = new SimpleInsnBlockParser(118);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DNEG = new SimpleInsnBlockParser(119);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> ISHL = new SimpleInsnBlockParser(120);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LSHL = new SimpleInsnBlockParser(121);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> ISHR = new SimpleInsnBlockParser(122);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LSHR = new SimpleInsnBlockParser(123);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> IUSHR = new SimpleInsnBlockParser(124);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LUSHR = new SimpleInsnBlockParser(125);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> IAND = new SimpleInsnBlockParser(126);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LAND = new SimpleInsnBlockParser(127);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> IOR = new SimpleInsnBlockParser(128);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LOR = new SimpleInsnBlockParser(129);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> IXOR = new SimpleInsnBlockParser(130);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LXOR = new SimpleInsnBlockParser(131);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> I2L = new SimpleInsnBlockParser(133);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> I2F = new SimpleInsnBlockParser(134);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> I2D = new SimpleInsnBlockParser(135);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> I2S = new SimpleInsnBlockParser(147);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> I2B = new SimpleInsnBlockParser(145);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> I2C = new SimpleInsnBlockParser(146);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> L2I = new SimpleInsnBlockParser(136);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> L2F = new SimpleInsnBlockParser(137);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> L2D = new SimpleInsnBlockParser(138);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> F2D = new SimpleInsnBlockParser(141);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> F2I = new SimpleInsnBlockParser(139);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> F2L = new SimpleInsnBlockParser(140);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LCMP = new SimpleInsnBlockParser(148);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> FCMPL = new SimpleInsnBlockParser(149);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> FCMPG = new SimpleInsnBlockParser(150);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DCMPL = new SimpleInsnBlockParser(151);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DCMPG = new SimpleInsnBlockParser(152);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> IRETURN = new SimpleInsnBlockParser(172);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> LRETURN = new SimpleInsnBlockParser(173);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> FRETURN = new SimpleInsnBlockParser(174);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> DRETURN = new SimpleInsnBlockParser(175);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> ARETURN = new SimpleInsnBlockParser(176);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> RETURN = new SimpleInsnBlockParser(177);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> ARRAYLENGTH = new SimpleInsnBlockParser(190);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> ATHROW = new SimpleInsnBlockParser(191);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> MONITOREXIT = new SimpleInsnBlockParser(195);
    @NotNull
    public static final InsnParser<SimpleInsnBlock> MONITORENTER = new SimpleInsnBlockParser(194);

    public SimpleInsnBlock(int opcode, @NotNull StringToken token) {
        this.opcode = opcode;
        this.token = token;
    }

    @Override
    @NotNull
    public MatchResult matchesInstruction(@NotNull AbstractInsnNode insn, @NotNull FramedRemapper remapper) {
        if (insn.getOpcode() != this.opcode) {
            return new MatchResult("Opcode mismatch", this.token);
        }
        return MatchResult.RESULT_BREAK;
    }

    private static final class SimpleInsnBlockParser
    implements InsnParser<SimpleInsnBlock> {
        private final int opcode;

        public SimpleInsnBlockParser(int opcode) {
            this.opcode = opcode;
        }

        @Override
        @NotNull
        public SimpleInsnBlock parseInstruction(@NotNull @NotNull List<@NotNull StringToken> lineContents, @NotNull @NotNull List<@NotNull SoftmapParseError> errorStream) {
            if (lineContents.size() != 1) {
                StringToken startToken = lineContents.get(1);
                StringToken endToken = lineContents.get(lineContents.size() - 1);
                errorStream.add(new SoftmapParseError(startToken.getStart(), endToken.getEnd(), startToken.getRow(), startToken.getColumn(), "Unexpected arguments for expression."));
            }
            return new SimpleInsnBlock(this.opcode, lineContents.get(0));
        }
    }
}

