/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.softmap.insns;

import java.util.List;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.stianloader.softmap.DescString;
import org.stianloader.softmap.FramedRemapper;
import org.stianloader.softmap.SoftmapParseError;
import org.stianloader.softmap.insns.InsnBlock;
import org.stianloader.softmap.insns.InsnParser;
import org.stianloader.softmap.insns.MatchResult;
import org.stianloader.softmap.tokens.StringToken;
import org.stianloader.softmap.tokens.Token;

public class InvokeInsn
implements InsnBlock {
    @NotNull
    public static final InsnParser<InvokeInsn> PARSER_INVOKESTATIC = new Parser(184);
    @NotNull
    public static final InsnParser<InvokeInsn> PARSER_INVOKEVIRTUAL = new Parser(182);
    @NotNull
    public static final InsnParser<InvokeInsn> PARSER_INVOKEINTERFACE = new Parser(185);
    @NotNull
    public static final InsnParser<InvokeInsn> PARSER_INVOKESPECIAL = new Parser(183);
    private final int opcode;
    @Nullable
    private final StringToken className;
    @Nullable
    private final StringToken methodName;
    @Nullable
    private final StringToken methodDescriptor;
    @NotNull
    private final StringToken opcodeToken;

    public InvokeInsn(int opcode, @NotNull StringToken opcodeToken, @Nullable StringToken className, @Nullable StringToken methodName, @Nullable StringToken methodDescriptor) {
        this.opcode = opcode;
        this.opcodeToken = opcodeToken;
        this.className = className;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
    }

    @Override
    @Contract(pure=false, mutates="param2")
    @CheckReturnValue
    @NotNull
    public MatchResult matchesInstruction(@NotNull AbstractInsnNode insn, @NotNull FramedRemapper remapper) {
        MatchResult result;
        StringToken methodDescToken;
        StringToken methodNameToken;
        if (insn.getOpcode() != this.opcode) {
            return new MatchResult("Instruction opcode mismatch", this.opcodeToken);
        }
        MethodInsnNode mInsn = (MethodInsnNode)insn;
        StringToken classNameToken = this.className;
        if (classNameToken != null) {
            String srcOwner = mInsn.owner;
            String dstOwner = remapper.getMappedClassOpt(srcOwner);
            if (classNameToken.lastCodepoint() != 63) {
                if (!classNameToken.contentMatches(dstOwner)) {
                    if (!srcOwner.equals(dstOwner)) {
                        return new MatchResult("Owner mismatch (explicit match, srcName: '" + srcOwner + "', dstName: '" + dstOwner + "')", classNameToken);
                    }
                    return new MatchResult("Owner mismatch (explicit match)", classNameToken);
                }
            } else if (srcOwner.equals(dstOwner)) {
                remapper.mapClass(srcOwner, classNameToken.getText());
            } else if (!classNameToken.contentMatches(false, dstOwner, 0, dstOwner.length())) {
                return new MatchResult("Owner mismatch (mapping match; mapping collision. srcName: '" + srcOwner + "', dstName: '" + dstOwner + "')", classNameToken);
            }
        }
        if ((methodNameToken = this.methodName) != null) {
            String srcName = mInsn.name;
            String dstName = remapper.getMappedMethodOpt(mInsn.owner, srcName, mInsn.desc);
            if (methodNameToken.lastCodepoint() != 63) {
                if (!methodNameToken.contentMatches(dstName)) {
                    return new MatchResult("Method name mismatch (explicit match, srcName: '" + srcName + "', dstName: '" + dstName + "', srcOwner: '" + mInsn.owner + "', srcDesc: '" + mInsn.desc + "')", methodNameToken);
                }
            } else if (srcName.equals(dstName)) {
                remapper.mapMethod(mInsn.owner, srcName, mInsn.desc, methodNameToken.getText());
            }
        }
        if ((methodDescToken = this.methodDescriptor) != null && (result = InvokeInsn.mapDescriptor(methodDescToken, mInsn.desc, remapper)) != null) {
            return result;
        }
        return MatchResult.RESULT_BREAK;
    }

    @Nullable
    public static MatchResult mapDescriptor(@NotNull StringToken methodDescToken, @NotNull String methodDesc, @NotNull FramedRemapper remapper) {
        int head = 1;
        int headCodepoint = methodDescToken.codepointAt(head);
        DescString dString = new DescString(methodDesc);
        while (headCodepoint != 41) {
            int lookaheadIndex;
            if (!dString.hasNext()) {
                return new MatchResult("Method descriptor mismatch (Argument count mismatch, descriptor of matched method: '" + methodDesc + "')", methodDescToken);
            }
            String cmpType = dString.nextType();
            if (cmpType.codePointAt(0) != headCodepoint) {
                return new MatchResult("Method descriptor mismatch (Argument type mismatch [different computational type]; descriptor of matched method: '" + methodDesc + "', discrepancy starting from column " + (methodDescToken.getStart() + head) + ")", methodDescToken);
            }
            headCodepoint = methodDescToken.codepointAt(++head);
            int arraydepth = 0;
            if (cmpType.codePointAt(0) == 91) {
                while (headCodepoint == 91) {
                    ++arraydepth;
                    headCodepoint = methodDescToken.codepointAt(++head);
                }
                if (cmpType.length() < arraydepth + 2 || cmpType.codePointAt(arraydepth) != 91 || cmpType.codePointAt(arraydepth + 1) == 91) {
                    return new MatchResult("Method descriptor mismatch (Argument type mismatch [different array depth]; descriptor of matched method: '" + methodDesc + "', discrepancy is around column " + (methodDescToken.getStart() + head) + ")", methodDescToken);
                }
                ++arraydepth;
            }
            if (headCodepoint != cmpType.codePointAt(arraydepth)) {
                return new MatchResult("Method descriptor mismatch (Argument type mismatch [different computational types once skipping arrays]; descriptor of matched method: '" + methodDesc + "', discrepancy starting from column " + (methodDescToken.getStart() + head) + ")", methodDescToken);
            }
            if (headCodepoint != 76) {
                if (cmpType.codePointAt(arraydepth) != headCodepoint) {
                    return new MatchResult("Method descriptor mismatch (Argument type mismatch [unrolled computational type mismatch]; descriptor of matched method: '" + methodDesc + "', discrepancy is around column " + (methodDescToken.getStart() + head) + ")", methodDescToken);
                }
                if ((headCodepoint = methodDescToken.codepointAt(++head)) != 63) continue;
                headCodepoint = methodDescToken.codepointAt(++head);
                continue;
            }
            if ((lookaheadIndex = methodDescToken.indexOf(59, ++head)) == -1 || methodDescToken.indexOf(41, lookaheadIndex) == -1) {
                return new MatchResult("Invalidly parsed invoke instruction: Invalid method descriptor: Missing closing ';' after start of 'L'-type reference", methodDescToken);
            }
            if (cmpType.codePointAt(arraydepth) != 76) {
                return new MatchResult("Method descriptor mismatch (Argument type mismatch [unrolled computational type mismatch]; descriptor of matched method: '" + methodDesc + "', discrepancy is around column " + (methodDescToken.getStart() + head) + ")", methodDescToken);
            }
            String srcClass = cmpType.substring(arraydepth + 1, cmpType.length() - 1);
            String dstClass = remapper.getMappedClassOpt(srcClass);
            if (methodDescToken.codepointAt(lookaheadIndex + 1) == 63) {
                if (!srcClass.equals(dstClass)) {
                    if (lookaheadIndex - head == dstClass.length() && methodDescToken.contentMatches(false, head, dstClass, 0, dstClass.length())) continue;
                    return new MatchResult("Method descriptor mismatch (mapping match; mapping collision. srcType: '" + srcClass + "', dstType: '" + dstClass + "', full (src) method descriptor of matched method: '" + methodDesc + "'. Discrepancy arises between column " + (head + methodDescToken.getColumn()) + " and " + (lookaheadIndex + methodDescToken.getColumn()) + ")", methodDescToken);
                }
                remapper.mapClass(srcClass, methodDescToken.subtext(head, lookaheadIndex));
                continue;
            }
            if (lookaheadIndex - head == dstClass.length() && methodDescToken.contentMatches(false, head, dstClass, 0, dstClass.length())) continue;
            return new MatchResult("Method descriptor mismatch (explicit match. srcType: '" + srcClass + "', dstType: '" + dstClass + "', full (src) method descriptor of matched method: '" + methodDesc + "'. Discrepancy arises between column " + (head + methodDescToken.getColumn()) + " and " + (lookaheadIndex + methodDescToken.getColumn()) + ")", methodDescToken);
        }
        return null;
    }

    private static final class Parser
    implements InsnParser<InvokeInsn> {
        private final int opcode;

        private Parser(int opcode) {
            this.opcode = opcode;
        }

        @Override
        @NotNull
        @Contract(pure=true)
        public InvokeInsn parseInstruction(@NotNull @NotNull List<@NotNull StringToken> lineContents, @NotNull @NotNull List<@NotNull SoftmapParseError> errorStream) {
            StringToken arg = null;
            if (lineContents.size() == 1) {
                errorStream.add(new SoftmapParseError(lineContents.get(0), "InvokeX instruction is missing the method that is invoked, it is formatted in the scheme of '<opcode> <class>.<name><desc>', e.g.: 'INVOKESTATIC java/lang/String.toString()Ljava/lang/String;'."));
            } else if (lineContents.size() == 2) {
                arg = lineContents.get(1);
            } else {
                arg = lineContents.get(1);
                Token firstSuperflous = lineContents.get(2);
                Token last = lineContents.get(lineContents.size() - 1);
                errorStream.add(new SoftmapParseError(firstSuperflous.getStart(), last.getEnd(), firstSuperflous.getRow(), firstSuperflous.getColumn(), "InvokeX instruction provided with superflous arguments, it is formatted in the scheme of '<opcode> <class>.<name><desc>', e.g.: 'INVOKESTATIC java/lang/String.toString()Ljava/lang/String;'. Are there any rouge whitespaces? (Note: The softmap format does not support whitespaces in member names, even though that is valid according to the JVMS)"));
            }
            Token ownerName = null;
            StringToken methodName = null;
            StringToken methodDesc = null;
            if (arg != null) {
                int endOfName;
                int endOfOwner = arg.indexOf(46);
                int startOfDesc = arg.indexOf(40, endOfOwner + 1);
                if (endOfOwner == -1) {
                    errorStream.add(new SoftmapParseError(arg, "InvokeX target method missing owner name, which are separated from the method name via '.'. The instruction is formatted in the scheme of '<opcode> <class>.<name><desc>', e.g.: 'INVOKESTATIC java/lang/String.toString()Ljava/lang/String;'."));
                } else if (startOfDesc == -1) {
                    errorStream.add(new SoftmapParseError(arg, "InvokeX target method missing descriptor, which starts with '('. The instruction is formatted in the scheme of '<opcode> <class>.<name><desc>', e.g.: 'INVOKESTATIC java/lang/String.toString()Ljava/lang/String;'."));
                } else if (arg.indexOf(41, startOfDesc) == -1) {
                    errorStream.add(new SoftmapParseError(arg, "InvokeX target method has an invalid descriptor: missing codepoint ')'. The instruction is formatted in the scheme of '<opcode> <class>.<name><desc>', e.g.: 'INVOKESTATIC java/lang/String.toString()Ljava/lang/String;'."));
                }
                if (endOfOwner != -1) {
                    ownerName = arg.subtoken(0, endOfOwner);
                }
                if (startOfDesc != -1) {
                    methodDesc = arg.subtoken(startOfDesc, arg.getContentLength());
                    endOfName = startOfDesc;
                } else {
                    endOfName = arg.getContentLength();
                }
                methodName = arg.subtoken(endOfOwner + 1, endOfName);
            }
            if (methodName != null && methodName.indexOf(46) != -1) {
                int column;
                int startWith;
                if (ownerName != null) {
                    startWith = ownerName.getStart();
                    column = ownerName.getColumn();
                } else {
                    startWith = methodName.getStart();
                    column = methodName.getColumn();
                }
                errorStream.add(new SoftmapParseError(startWith, methodName.getEnd(), methodName.getRow(), column, "The owner definition contains at least one dot ('.'), which is a character banned from usage in method names. Remember that package names should be separated out with forward slashes ('/'), not dots. This hints at an invalid owner name."));
            }
            if (methodDesc != null && methodDesc.indexOf(46) != -1) {
                errorStream.add(new SoftmapParseError(methodDesc, "The target method descriptor contains at least one dot ('.'), which is a character banned from usage in descriptors. Remember that package names should be separated out with forward slashes ('/'), not dots. This hints at an invalid descriptor type."));
            }
            return new InvokeInsn(this.opcode, lineContents.get(0), (StringToken)ownerName, methodName, methodDesc);
        }
    }
}

