/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.softmap.insns;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.stianloader.softmap.FramedRemapper;
import org.stianloader.softmap.SoftmapParseError;
import org.stianloader.softmap.insns.InsnBlock;
import org.stianloader.softmap.insns.InsnParser;
import org.stianloader.softmap.insns.MatchResult;
import org.stianloader.softmap.tokens.StringToken;

public final class FieldInsn
implements InsnBlock {
    @NotNull
    public static final InsnParser<FieldInsn> PARSER_GETFIELD = new Parser(180);
    @NotNull
    public static final InsnParser<FieldInsn> PARSER_GETSTATIC = new Parser(178);
    @NotNull
    public static final InsnParser<FieldInsn> PARSER_PUTFIELD = new Parser(181);
    @NotNull
    public static final InsnParser<FieldInsn> PARSER_PUTSTATIC = new Parser(179);
    @Nullable
    private final StringToken fieldDesc;
    @Nullable
    private final StringToken fieldName;
    @Nullable
    private final StringToken fieldOwner;
    private final int matchOpcode;
    @NotNull
    private final StringToken opcodeToken;

    private FieldInsn(int matchOpcode, @NotNull StringToken opcodeToken, @Nullable StringToken fieldOwner, @Nullable StringToken fieldName, @Nullable StringToken fieldDesc) {
        this.matchOpcode = matchOpcode;
        this.opcodeToken = opcodeToken;
        this.fieldOwner = fieldOwner;
        this.fieldName = fieldName;
        this.fieldDesc = fieldDesc;
    }

    @Override
    @NotNull
    public MatchResult matchesInstruction(@NotNull AbstractInsnNode insn, @NotNull FramedRemapper remapper) {
        if (insn.getOpcode() != this.matchOpcode) {
            return new MatchResult("Instruction opcode mismatch", this.opcodeToken);
        }
        FieldInsnNode fInsn = (FieldInsnNode)insn;
        StringToken fieldOwner = this.fieldOwner;
        if (fieldOwner != null && fieldOwner.codepointBefore(fieldOwner.getContentLength()) != 63 && !fieldOwner.contentMatches(fInsn.owner)) {
            return new MatchResult("Field owner mismatch (got " + fInsn.owner + ')', fieldOwner);
        }
        StringToken fieldName = this.fieldName;
        if (fieldName != null && fieldName.codepointBefore(fieldName.getContentLength()) != 63 && !fieldName.contentMatches(fInsn.name)) {
            return new MatchResult("Field name mismatch (got " + fInsn.name + ')', fieldName);
        }
        StringToken fieldDesc = this.fieldDesc;
        if (fieldDesc != null) {
            if (fieldDesc.codepointBefore(fieldDesc.getContentLength()) != 63) {
                if (!fieldDesc.contentMatches(fInsn.desc)) {
                    return new MatchResult("Field descriptor mismatch (got " + fInsn.desc + ')', fieldDesc);
                }
            } else {
                int srcArrayDepth = 0;
                while (fieldDesc.codepointAt(srcArrayDepth) == 91) {
                    ++srcArrayDepth;
                }
                int dstArrayDepth = 0;
                while (fInsn.desc.codePointAt(dstArrayDepth) == 91) {
                    ++dstArrayDepth;
                }
                if (srcArrayDepth != dstArrayDepth) {
                    return new MatchResult("Field descriptor array depth mismatch (got " + fInsn.desc + ')', fieldDesc);
                }
                if (fieldDesc.codepointAt(srcArrayDepth) != fInsn.desc.codePointAt(srcArrayDepth)) {
                    return new MatchResult("Field descriptor computation type mismatch (got " + fInsn.desc + ')', fieldDesc);
                }
                if (fieldDesc.codepointAt(srcArrayDepth) == 76) {
                    String dstName;
                    String mappedName = fieldDesc.subtext(srcArrayDepth + 1, fieldDesc.getContentLength() - 2);
                    String srcName = fInsn.desc.substring(srcArrayDepth + 1, fInsn.desc.length() - 1);
                    if (!srcName.equals(dstName = remapper.getMappedClassOpt(srcName))) {
                        if (!mappedName.equals(dstName)) {
                            return new MatchResult("Descriptor mismatch (mapping match; mapping collision. srcName: '" + srcName + "', dstName: '" + dstName + "')", fieldDesc);
                        }
                    } else {
                        remapper.mapClass(srcName, mappedName);
                    }
                }
            }
        }
        if (fieldOwner != null && fieldOwner.codepointBefore(fieldOwner.getContentLength()) == 63) {
            String srcName = fInsn.owner;
            String dstName = remapper.getMappedClassOpt(srcName);
            if (srcName.equals(dstName)) {
                remapper.mapClass(srcName, fieldOwner.subtext(0, fieldOwner.getContentLength() - 1));
            } else if (!dstName.equals(fieldOwner.subtext(0, fieldOwner.getContentLength() - 1))) {
                return new MatchResult("Owner mismatch (mapping match; mapping collision. srcName: '" + srcName + "', dstName: '" + dstName + "')", fieldOwner);
            }
        }
        if (fieldName != null && fieldName.codepointBefore(fieldName.getContentLength()) == 63) {
            String srcName = fInsn.name;
            String dstName = remapper.getMappedFieldOpt(fInsn.owner, srcName, fInsn.desc);
            if (srcName.equals(dstName)) {
                remapper.mapField(fInsn.owner, srcName, fInsn.desc, fieldName.subtext(0, fieldName.getContentLength() - 1));
            } else if (!dstName.equals(fieldName.subtext(0, fieldName.getContentLength() - 1))) {
                return new MatchResult("Field name mismatch (mapping match; mapping collision. srcName: '" + srcName + "', dstName: '" + dstName + "')", fieldName);
            }
        }
        return MatchResult.RESULT_BREAK;
    }

    private static class Parser
    implements InsnParser<FieldInsn> {
        private final int matchOpcode;

        private Parser(int matchOpcode) {
            this.matchOpcode = matchOpcode;
        }

        @Override
        @NotNull
        public FieldInsn parseInstruction(@NotNull @NotNull List<@NotNull StringToken> lineContents, @NotNull @NotNull List<@NotNull SoftmapParseError> errorStream) {
            StringToken opcodeToken = lineContents.get(0);
            if (lineContents.size() < 3) {
                errorStream.add(new SoftmapParseError(lineContents.get(lineContents.size() - 1), "Too few arguments to FieldInsn-type opcode. Expression expected '<opcode> <owner>.<name> <desc>'"));
            } else if (lineContents.size() > 3) {
                errorStream.add(new SoftmapParseError(lineContents.get(3), "Too many arguments to FieldInsn-type opcode. Expression expected '<opcode> <owner>.<name> <desc>'"));
            }
            StringToken owner = null;
            StringToken name = null;
            StringToken desc = null;
            if (lineContents.size() > 1) {
                StringToken tok = lineContents.get(1);
                int dotIndex = tok.indexOf(46);
                if (dotIndex == -1) {
                    if (lineContents.size() == 2) {
                        name = tok;
                    } else {
                        owner = tok;
                        name = lineContents.get(2);
                        if (lineContents.size() > 3) {
                            desc = lineContents.get(3);
                        } else {
                            errorStream.add(new SoftmapParseError(tok, "Malformed field instruction: Expected expression format: '<opcode> <owner>.<name> <desc>'; missing codepoint '.'."));
                        }
                    }
                } else {
                    owner = tok.subtoken(0, dotIndex);
                    name = tok.subtoken(dotIndex + 1, tok.getContentLength());
                    if (lineContents.size() > 2) {
                        desc = lineContents.get(2);
                    }
                }
            }
            if (desc != null && desc.codepointBefore(desc.getContentLength()) == 91) {
                errorStream.add(new SoftmapParseError(desc, "Malformed field instruction: Malformed descriptor: A descriptor may not end with the character '['."));
                desc = null;
            }
            if (desc != null) {
                int srcArrayDepth = 0;
                while (desc.codepointAt(srcArrayDepth) == 91) {
                    ++srcArrayDepth;
                }
                if (desc.codepointAt(srcArrayDepth) == 76) {
                    int semicolonIndex = desc.indexOf(59);
                    if (semicolonIndex == -1) {
                        errorStream.add(new SoftmapParseError(desc, "Malformed field instruction: Malformed descriptor: An L-type reference must be closed with ';', but no ';' could be found."));
                        desc = null;
                    } else if (desc.codepointBefore(desc.getContentLength()) == 63) {
                        if (semicolonIndex != desc.getContentLength() - 2) {
                            errorStream.add(new SoftmapParseError(desc, "Malformed field instruction: Malformed descriptor: ';' must be the last character before '?'."));
                            desc = null;
                        }
                    } else if (semicolonIndex != desc.getContentLength() - 1) {
                        errorStream.add(new SoftmapParseError(desc, "Malformed field instruction: Malformed descriptor: ';' must be the last character of a L-type reference."));
                        desc = null;
                    } else if (desc.indexOf(46) != -1) {
                        errorStream.add(new SoftmapParseError(desc, "Malformed field instruction: Malformed descriptor: Illegal codepoint '.', use forward slashes ('/') to separate packages."));
                    }
                } else if (desc.getContentLength() != srcArrayDepth + 1) {
                    if (desc.codepointAt(srcArrayDepth + 1) == 63) {
                        errorStream.add(new SoftmapParseError(desc, "Malformed field instruction: Malformed descriptor: Illegal attempt at mapping a primitive."));
                        desc = desc.subtoken(0, srcArrayDepth + 1);
                    } else {
                        errorStream.add(new SoftmapParseError(desc, "Malformed field instruction: Malformed descriptor: Unexpected character after primitive at column " + (desc.getColumn() + srcArrayDepth + 1) + "."));
                        desc = null;
                    }
                }
            }
            return new FieldInsn(this.matchOpcode, opcodeToken, owner, name, desc);
        }
    }
}

