/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.softmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.stianloader.softmap.FramedRemapper;
import org.stianloader.softmap.MethodExpression;
import org.stianloader.softmap.SimpleFramedRemapper;
import org.stianloader.softmap.SoftmapApplicationError;
import org.stianloader.softmap.SoftmapParseError;
import org.stianloader.softmap.TokenizeReader;
import org.stianloader.softmap.insns.FieldInsn;
import org.stianloader.softmap.insns.InsnBlock;
import org.stianloader.softmap.insns.InsnParser;
import org.stianloader.softmap.insns.InvokeInsn;
import org.stianloader.softmap.insns.MatchResult;
import org.stianloader.softmap.insns.SimpleInsnBlock;
import org.stianloader.softmap.insns.VarInsn;
import org.stianloader.softmap.insns.WildcardInsnBlock;
import org.stianloader.softmap.tokens.BlockToken;
import org.stianloader.softmap.tokens.CommentToken;
import org.stianloader.softmap.tokens.StringToken;
import org.stianloader.softmap.tokens.Token;

public class SoftmapContext {
    private static final int FALLBACK_VERSION = 1;
    @NotNull
    private static final @Unmodifiable @NotNull Map<@NotNull String, @NotNull InsnParser<?>> INSTRUCTION_PARSERS;
    @NotNull
    private final @NotNull @Unmodifiable List<@NotNull MethodExpression> methodExpressions;
    @NotNull
    private final @NotNull @Unmodifiable List<@NotNull SoftmapParseError> parseErrors;

    @Nullable
    private static InsnBlock evaluateMethodBodyLine(@NotNull @NotNull List<@NotNull SoftmapParseError> errors, @NotNull @NotNull List<@NotNull Token> line) {
        ArrayList<@NotNull StringToken> dataTokens = new ArrayList<StringToken>();
        for (Token t : line) {
            if (t instanceof StringToken) {
                dataTokens.add((StringToken)t);
                continue;
            }
            if (t instanceof CommentToken) continue;
            errors.add(new SoftmapParseError(t, "Unknown/Unexpected token type: " + t.getClass().getName()));
        }
        if (dataTokens.isEmpty()) {
            return null;
        }
        String opcode = ((StringToken)dataTokens.get(0)).getText();
        if (!INSTRUCTION_PARSERS.containsKey(opcode) && !INSTRUCTION_PARSERS.containsKey(opcode = opcode.toUpperCase(Locale.ROOT))) {
            errors.add(new SoftmapParseError((Token)dataTokens.get(0), "Cannot decode instruction line: Unknown/Unsupported opcode"));
            return null;
        }
        InsnParser<?> parser = INSTRUCTION_PARSERS.get(opcode);
        Object insn = parser.parseInstruction(dataTokens, errors);
        if (Objects.isNull(insn)) {
            throw new NullPointerException("parser#parseInstruction may not return null for opcode " + opcode + " (parser resolves to instance of type " + parser.getClass().getName() + ")");
        }
        return insn;
    }

    @NotNull
    @Contract(pure=true, value="null, _, _, _, _ -> fail; !null, _, _, _, _ -> new")
    public static SoftmapContext parse(@NotNull String source, int start, int end, int rowStart, int columnStart) {
        List<Token> tokens = SoftmapContext.tokenize(source, start, end, rowStart, columnStart);
        ArrayList<@NotNull MethodExpression> methods = new ArrayList<MethodExpression>();
        ArrayList<@NotNull SoftmapParseError> parseErrors = new ArrayList<SoftmapParseError>();
        int currentVersion = -1;
        for (int readerIndex = 0; readerIndex < tokens.size(); ++readerIndex) {
            int parsedVersion;
            Token token = tokens.get(readerIndex);
            if (token instanceof CommentToken) continue;
            if (!(token instanceof StringToken)) {
                parseErrors.add(new SoftmapParseError(token.getStart(), token.getEnd(), token.getRow(), token.getColumn(), "Unknown token type: " + token.getClass().getName() + ", expected any of 'softmap [...]', 'method [...]'; Failed to comprehend beginning of expression."));
                continue;
            }
            StringToken stringToken = (StringToken)token;
            if (stringToken.contentMatches(true, "method")) {
                int useVersion = currentVersion;
                if (currentVersion == -1) {
                    useVersion = 1;
                    parseErrors.add(new SoftmapParseError(stringToken, "Start of 'method' expression without declaring the format version/header. Expected 'softmap v1' at this position."));
                }
                readerIndex += SoftmapContext.parseMethod(tokens, readerIndex, useVersion, methods, parseErrors);
                continue;
            }
            if (!stringToken.contentMatches(true, "softmap")) continue;
            StringToken next = null;
            while (++readerIndex < tokens.size()) {
                Token t = tokens.get(readerIndex);
                if (t instanceof StringToken) {
                    next = (StringToken)t;
                    break;
                }
                if (t instanceof CommentToken) continue;
                parseErrors.add(new SoftmapParseError(t.getStart(), t.getEnd(), t.getRow(), t.getColumn(), "Unknown token type: " + t.getClass().getName() + ", expected expression 'softmap <version>'; failed to resolve '<version>'."));
            }
            if (next == null) {
                parseErrors.add(new SoftmapParseError(token.getStart(), token.getEnd(), token.getRow(), token.getColumn(), "Expected expression 'softmap <version>'; failed to resolve '<version>': End of parsing range. Premature end of file?"));
                continue;
            }
            String versionName = next.getText();
            if (versionName.codePointAt(0) == 118) {
                versionName = versionName.substring(1);
            }
            try {
                parsedVersion = Integer.parseInt(versionName);
            }
            catch (NumberFormatException e) {
                parseErrors.add(new SoftmapParseError(next.getStart(), next.getEnd(), next.getRow(), next.getColumn(), "Incorrect expression 'softmap <version>'; Invalid format for '<version>': Expected any of '<number>', 'v<number>'."));
                continue;
            }
            if (parsedVersion != 1) {
                parseErrors.add(new SoftmapParseError(next.getStart(), next.getEnd(), next.getRow(), next.getColumn(), "Incorrect expression 'softmap <version>'; Unknown version. This parser only supports version 1."));
                continue;
            }
            currentVersion = parsedVersion;
        }
        return new SoftmapContext(Collections.unmodifiableList(methods), Collections.unmodifiableList(parseErrors));
    }

    @Contract(pure=false, mutates="param4,param5")
    @CheckReturnValue
    private static int parseMethod(@NotNull @NotNull List<@NotNull Token> tokens, int readerIndex, int version, @NotNull @NotNull List<@NotNull MethodExpression> out, @NotNull @NotNull List<@NotNull SoftmapParseError> errors) {
        StringToken methodLoc;
        int startIndex = readerIndex++;
        if (readerIndex == tokens.size()) {
            errors.add(new SoftmapParseError(tokens.get(startIndex), "Unable to parse method expression: Premature end of token stream. Expected at least the following structure: 'method <class>.<method><descriptor> {}'"));
            return 0;
        }
        Token t = tokens.get(readerIndex);
        while (t instanceof CommentToken) {
            if (readerIndex == tokens.size()) {
                errors.add(new SoftmapParseError(tokens.get(startIndex).getStart(), t.getEnd(), t.getRow(), t.getColumn(), "Unable to parse method expression: Premature end of token stream. Expected at least the following structure: 'method <class>.<method><descriptor> {}'"));
                return readerIndex - startIndex - 1;
            }
            t = tokens.get(++readerIndex);
        }
        StringToken ownerName = null;
        StringToken methodName = null;
        StringToken methodDesc = null;
        if (!(t instanceof StringToken)) {
            methodLoc = null;
            errors.add(new SoftmapParseError(tokens.get(startIndex), "Unable to parse method expression: Unexpected token type when attempting to extract '<class>.<method><descriptor>'. Expected at least the following structure: 'method <class>.<method><descriptor> {}'"));
        } else {
            methodLoc = (StringToken)t;
            int beginName = methodLoc.indexOf(46);
            int beginDesc = methodLoc.indexOf(40);
            int beginRet = methodLoc.indexOf(41) + 1;
            if (beginName == -1) {
                errors.add(new SoftmapParseError(methodLoc, "Unable to parse method expression: The method location definition is invalid, it should be in the format of '<class>.<method><descriptor>'. Missing codepoint '.' (which separates owner name and method name)"));
            } else if (beginDesc == -1) {
                errors.add(new SoftmapParseError(methodLoc, "Unable to parse method expression: The method location definition is invalid, it should be in the format of '<class>.<method><descriptor>'. The descriptor is malformed (missing codepoint '(')"));
            } else if (beginRet == 0) {
                errors.add(new SoftmapParseError(methodLoc.getStart() + beginDesc, methodLoc.getEnd(), methodLoc.getRow(), methodLoc.getColumn() + beginDesc, "Unable to parse method expression: The method location definition is invalid, it should be in the format of '<class>.<method><descriptor>'. The descriptor is malformed (missing codepoint ')')"));
            } else if (beginRet < beginDesc) {
                errors.add(new SoftmapParseError(methodLoc, "Unable to parse method expression: The method location definition is invalid, it should be in the format of '<class>.<method><descriptor>'. The descriptor is malformed (Codepoint ')' is before codepoint '(')"));
            } else if (methodLoc.indexOf(40, beginDesc + 1) != -1) {
                errors.add(new SoftmapParseError(methodLoc, "Unable to parse method expression: The method location definition is invalid, it should be in the format of '<class>.<method><descriptor>'. The descriptor is malformed (duplicate codepoint '(')"));
            } else if (methodLoc.indexOf(41, beginRet) != -1) {
                errors.add(new SoftmapParseError(methodLoc, "Unable to parse method expression: The method location definition is invalid, it should be in the format of '<class>.<method><descriptor>'. The descriptor is malformed (duplicate codepoint ')')"));
            }
            int endName = beginDesc;
            if (beginDesc == -1) {
                endName = methodLoc.getContentLength();
            }
            if (beginName != -1) {
                ownerName = methodLoc.subtoken(0, beginName);
                if (beginName + 1 != endName) {
                    methodName = methodLoc.subtoken(beginName + 1, endName);
                }
            } else if (endName != 0) {
                methodName = methodLoc.subtoken(0, endName);
            }
            if (beginDesc != -1 && beginRet != -1) {
                methodDesc = methodLoc.subtoken(beginDesc, methodLoc.getContentLength());
            }
        }
        t = tokens.get(++readerIndex);
        while (t instanceof CommentToken) {
            if (readerIndex == tokens.size()) {
                int startError = methodLoc != null ? methodLoc.getEnd() + 1 : tokens.get(startIndex).getStart();
                errors.add(new SoftmapParseError(startError, t.getEnd(), t.getRow(), t.getColumn(), "Unable to parse method expression: Premature end of token stream. Expected at least the following structure: 'method <class>.<method><descriptor> {}'"));
                return readerIndex - startIndex - 1;
            }
            t = tokens.get(++readerIndex);
        }
        BlockToken startBlockToken = null;
        if (t instanceof StringToken) {
            errors.add(new SoftmapParseError(t, "Unable to parse method expression: Unexpected string token; Ensure that the method location definition does not contain newlines or whitespaces. Expected codepoint at this position is '{'. The following structure is required at minimum: 'method <class>.<method><descriptor> {}'"));
        } else if (!(t instanceof BlockToken)) {
            errors.add(new SoftmapParseError(t, "Unable to parse method expression: Unexpected token type; no further information. Expected codepoint at this position is '{'. The following structure is required at minimum: 'method <class>.<method><descriptor> {}'"));
        } else {
            startBlockToken = (BlockToken)t;
            if (startBlockToken.isEndOfBlock()) {
                errors.add(new SoftmapParseError(startBlockToken, "Unable to parse method expression: Unexpected end of block. Expected codepoint at this position is '{'. The following structure is required at minimum: 'method <class>.<method><descriptor> {}'"));
                return readerIndex - startIndex;
            }
        }
        BlockToken endBlockToken = null;
        int beginBlockIndex = ++readerIndex;
        while (readerIndex < tokens.size()) {
            Token token = tokens.get(readerIndex);
            if (token instanceof BlockToken) {
                BlockToken bToken = (BlockToken)token;
                if (bToken.isStartOfBlock()) {
                    errors.add(new SoftmapParseError(bToken, "Unable to parse method expression body: Unexpected start of block. Was a '}' ommitted in previous lines?"));
                } else {
                    endBlockToken = bToken;
                    break;
                }
            }
            ++readerIndex;
        }
        List<@NotNull Token> bodyTokens = tokens.subList(beginBlockIndex, readerIndex);
        List<@NotNull ? extends InsnBlock> insns = SoftmapContext.parseMethodBody(bodyTokens, errors);
        out.add(new MethodExpression((StringToken)tokens.get(startIndex), methodLoc, ownerName, methodName, methodDesc, startBlockToken, endBlockToken, Collections.unmodifiableList(bodyTokens), Collections.unmodifiableList(insns)));
        if (endBlockToken == null) {
            Token last = tokens.get(readerIndex - 1);
            errors.add(new SoftmapParseError(last, "Unable to parse method expression: Premature end of token stream. Expected character at this position is '}'."));
            return readerIndex - startIndex - 1;
        }
        return readerIndex - startIndex;
    }

    @NotNull
    private static @NotNull List<@NotNull ? extends InsnBlock> parseMethodBody(@NotNull @NotNull @Unmodifiable List<@NotNull Token> contents, @NotNull @NotNull List<@NotNull SoftmapParseError> errors) {
        if (contents.isEmpty()) {
            return Collections.emptyList();
        }
        int currentRow = -1;
        int currentCol = -1;
        ArrayList<@NotNull Token> lineBuffer = new ArrayList<Token>();
        Iterator<Token> it = contents.iterator();
        ArrayList<@NotNull InsnBlock> insnBlocks = new ArrayList<InsnBlock>();
        while (it.hasNext()) {
            Token currentToken = it.next();
            boolean endOfLine = false;
            if (currentRow < currentToken.getRow()) {
                if (currentRow != -1) {
                    endOfLine = true;
                }
                currentRow = currentToken.getRow();
                currentCol = currentToken.getColumn();
            } else if (currentRow == currentToken.getRow()) {
                if (currentCol > currentToken.getColumn()) {
                    throw new IllegalStateException("currentCol = " + currentCol + " > currentToken.getColumn() = " + currentToken.getColumn());
                }
                currentCol = currentToken.getColumn();
            } else {
                throw new IllegalStateException("currentRow = " + currentRow + " > currentToken.getRow() = " + currentToken.getRow());
            }
            if (endOfLine) {
                InsnBlock insnBlock = SoftmapContext.evaluateMethodBodyLine(errors, lineBuffer);
                if (insnBlock != null) {
                    insnBlocks.add(insnBlock);
                }
                lineBuffer.clear();
            }
            lineBuffer.add(currentToken);
        }
        InsnBlock finalBlock = SoftmapContext.evaluateMethodBodyLine(errors, lineBuffer);
        if (finalBlock != null) {
            insnBlocks.add(finalBlock);
        }
        return insnBlocks;
    }

    @NotNull
    @Contract(pure=true, value="null, _, _, _, _ -> fail; !null, _, _, _, _ -> new")
    private static @NotNull List<@NotNull Token> tokenize(@NotNull String source, int codepointStart, int codepointEnd, int row, int col) {
        TokenizeReader reader = new TokenizeReader(Objects.requireNonNull(source, "source may not be null"), codepointStart, codepointEnd, row, col);
        ArrayList<@NotNull Token> expressions = new ArrayList<Token>();
        while (!reader.isExhausted()) {
            reader.consumeWhitespace(expressions);
            if (reader.isExhausted()) break;
            Token token = reader.consumeToken();
            if (token == null) continue;
            expressions.add(token);
        }
        return expressions;
    }

    protected SoftmapContext(@NotNull @NotNull @Unmodifiable List<@NotNull MethodExpression> expressions, @NotNull @NotNull @Unmodifiable List<@NotNull SoftmapParseError> parseErrors) {
        this.methodExpressions = expressions;
        this.parseErrors = parseErrors;
    }

    @NotNull
    @Contract(pure=true)
    public @NotNull @Unmodifiable List<@NotNull SoftmapParseError> getParseErrors() {
        return this.parseErrors;
    }

    @NotNull
    @Contract(pure=true)
    public ApplicationResult tryApply(@NotNull @NotNull List<@NotNull ClassNode> obfuscatedNodes) {
        SimpleFramedRemapper remapper = new SimpleFramedRemapper(SimpleFramedRemapper.realmsOf(obfuscatedNodes));
        remapper.pushFrame();
        HashMap<String, ClassNode> nodeLookup = new HashMap<String, ClassNode>();
        for (ClassNode classNode : obfuscatedNodes) {
            nodeLookup.put(classNode.name, classNode);
        }
        ArrayList<@NotNull SoftmapApplicationError> applicationErrors = new ArrayList<SoftmapApplicationError>();
        block1: for (MethodExpression expr : this.methodExpressions) {
            Token errorSource;
            boolean mapOwnerName = false;
            String mappedOwnerName = null;
            StringToken ownerName = expr.getOwnerName();
            if (ownerName != null) {
                if (ownerName.codepointBefore(ownerName.getContentLength()) == 63) {
                    mapOwnerName = true;
                    mappedOwnerName = ownerName.subtext(0, ownerName.getContentLength() - 1);
                } else {
                    mappedOwnerName = ownerName.getText();
                }
            }
            boolean mapMethodName = false;
            String mappedMethodName = null;
            StringToken methodName = expr.getMethodName();
            if (methodName != null) {
                if (methodName.codepointBefore(methodName.getContentLength()) == 63) {
                    mapMethodName = true;
                    mappedMethodName = methodName.subtext(0, methodName.getContentLength() - 1);
                } else {
                    mappedMethodName = methodName.getText();
                }
            }
            boolean mapMethodDesc = false;
            String mappedMethodDesc = null;
            StringToken methodDesc = expr.getMethodDesc();
            if (methodDesc != null) {
                if (methodDesc.indexOf(63) != -1) {
                    mapMethodDesc = true;
                }
                mappedMethodDesc = methodDesc.getText();
            }
            Collection<ClassNode> candidateNodes = obfuscatedNodes;
            if (!mapOwnerName && mappedOwnerName != null) {
                ClassNode foundNode = (ClassNode)nodeLookup.get(mappedOwnerName);
                if (foundNode == null) {
                    applicationErrors.add(new SoftmapApplicationError(Objects.requireNonNull(ownerName), "No class exists with this name"));
                    continue;
                }
                candidateNodes = Collections.singleton(foundNode);
            }
            FramedRemapper.RemapperFrame completeFrameFrame = null;
            SimpleFramedRemapper.MethodLoc completeFrameLoc = null;
            int furthestInsns = -1;
            MatchResult furthestError = null;
            boolean furthestExhaustedInstructions = false;
            ArrayList<SimpleFramedRemapper.MethodLoc> visitedMethods = new ArrayList<SimpleFramedRemapper.MethodLoc>();
            for (ClassNode node : candidateNodes) {
                for (MethodNode method : node.methods) {
                    AbstractInsnNode currentInsn;
                    String nameDst;
                    String nameSrc;
                    if (!mapMethodName && mappedMethodName != null && !method.name.equals(mappedMethodName) || !mapMethodDesc && mappedMethodDesc != null && !method.desc.equals(mappedMethodDesc)) continue;
                    if (remapper.getFrameCount() != 1) {
                        throw new IllegalStateException("Unexpected frame count: " + remapper.getFrameCount());
                    }
                    remapper.pushFrame();
                    if (mapOwnerName) {
                        nameSrc = node.name;
                        nameDst = remapper.getMappedClassOpt(nameSrc);
                        if (!nameSrc.equals(nameDst)) {
                            if (!Objects.requireNonNull(mappedOwnerName).equals(nameDst)) {
                                remapper.discardFrame();
                                continue;
                            }
                        } else {
                            remapper.mapClass(nameSrc, Objects.requireNonNull(mappedOwnerName));
                        }
                    }
                    if (mapMethodName) {
                        nameSrc = method.name;
                        nameDst = remapper.getMappedMethodOpt(node.name, nameSrc, method.desc);
                        if (!nameSrc.equals(nameDst)) {
                            if (!Objects.requireNonNull(mappedMethodName).equals(nameDst)) {
                                remapper.discardFrame();
                                continue;
                            }
                        } else {
                            remapper.mapMethod(node.name, nameSrc, method.desc, Objects.requireNonNull(mappedMethodName));
                        }
                    }
                    if (mapMethodDesc && InvokeInsn.mapDescriptor(Objects.requireNonNull(methodDesc), method.desc, remapper) != null) {
                        remapper.discardFrame();
                        continue;
                    }
                    if (remapper.getFrameCount() != 2) {
                        throw new IllegalStateException("Unexpected frame count: " + remapper.getFrameCount());
                    }
                    visitedMethods.add(new SimpleFramedRemapper.MethodLoc(node.name, method.name, method.desc));
                    List<? extends @NotNull InsnBlock> insnBlocks = expr.getInsns();
                    int i = 0;
                    MatchResult lastResult = null;
                    for (currentInsn = method.instructions.getFirst(); i != insnBlocks.size() && currentInsn != null; currentInsn = currentInsn.getNext()) {
                        InsnBlock currentBlock = insnBlocks.get(i);
                        remapper.pushFrame();
                        if (remapper.getFrameCount() != 3) {
                            throw new IllegalStateException("Unexpected frame count: " + remapper.getFrameCount());
                        }
                        MatchResult result = currentBlock.matchesInstruction(currentInsn, remapper);
                        if (result.isBreakingMatching()) {
                            ++i;
                            remapper.mergeFrame();
                            continue;
                        }
                        if (result.isGreedyMatch() && insnBlocks.size() != i + 1) {
                            result = insnBlocks.get(i + 1).matchesInstruction(currentInsn, remapper);
                            if (result.isBreakingMatching()) {
                                remapper.mergeFrame();
                                i += 2;
                                continue;
                            }
                            if (result.isContinuingMatching() || result.isGreedyMatch()) {
                                ++i;
                                remapper.mergeFrame();
                                continue;
                            }
                            if (result.isAnyMatch()) {
                                throw new IllegalStateException("Unexpected positive-match type (problem in the softmap implementation code - please report this bug):" + result.toString());
                            }
                            lastResult = result;
                            remapper.discardFrame();
                            continue;
                        }
                        if (result.isGreedyMatch() || result.isContinuingMatching()) {
                            remapper.mergeFrame();
                            lastResult = result;
                            continue;
                        }
                        if (result.isAnyMatch()) {
                            throw new IllegalStateException("Unexpected positive-match type (problem in the softmap implementation code - please report this bug):" + result.toString());
                        }
                        lastResult = result;
                        remapper.discardFrame();
                        break;
                    }
                    if (lastResult != null && !lastResult.isGreedyMatch()) {
                        if (i > furthestInsns) {
                            furthestInsns = i;
                            furthestError = lastResult;
                            furthestExhaustedInstructions = currentInsn == null;
                        }
                        remapper.discardFrame();
                        continue;
                    }
                    SimpleFramedRemapper.MethodLoc newLoc = new SimpleFramedRemapper.MethodLoc(node.name, method.name, method.desc);
                    if (completeFrameLoc != null) {
                        StringToken errorSource2 = expr.getMethodLocation();
                        if (errorSource2 == null) {
                            errorSource2 = expr.getDeclaringLocation();
                        }
                        String sourceA = node.name + '.' + method.name + method.desc;
                        String sourceB = node.name.equals(completeFrameLoc.getOwner()) ? "*" : completeFrameLoc.getOwner();
                        sourceB = sourceB + (method.name.equals(completeFrameLoc.getName()) ? "*" : completeFrameLoc.getName());
                        sourceB = sourceB + (method.desc.equals(completeFrameLoc.getDesc()) ? "*" : completeFrameLoc.getDesc());
                        applicationErrors.add(new SoftmapApplicationError(errorSource2, "Multiple methods match the expression. Two of potentially multiple matches: '" + sourceA + "' and '" + sourceB + "'."));
                        remapper.discardFrame();
                        continue block1;
                    }
                    completeFrameLoc = newLoc;
                    completeFrameFrame = remapper.popFrame();
                }
            }
            if (completeFrameFrame != null) {
                remapper.pushFrame(completeFrameFrame);
                remapper.mergeFrame();
                continue;
            }
            if (furthestError != null) {
                errorSource = furthestError.getErrorLocation();
                if (errorSource == null) {
                    errorSource = expr.getDeclaringLocation();
                }
                if (furthestExhaustedInstructions) {
                    applicationErrors.add(new SoftmapApplicationError(errorSource, "Instructions exhausted after evaluating " + furthestInsns + " insn blocks. Beware that the supplied error message and error location may not be the ultimate cause of the issue. Provided error message: " + furthestError.getErrorDescription()));
                    continue;
                }
                applicationErrors.add(new SoftmapApplicationError(errorSource, "InsnBlock failed match after evaluating " + furthestInsns + " insn blocks. Beware that the supplied error message and error location may not be the ultimate cause of the issue. Provided error message: " + furthestError.getErrorDescription()));
                continue;
            }
            errorSource = expr.getMethodLocation();
            if (errorSource == null) {
                errorSource = expr.getDeclaringLocation();
            }
            applicationErrors.add(new SoftmapApplicationError(errorSource, "No methods match the expression. Consider double-checking for typos and cross-reference the supplied method owner, name and descriptor with the bytecode owner, name and descriptor. Visited methods: " + visitedMethods));
        }
        List<@NotNull String> list = remapper.exportToTinyV1();
        remapper.discardFrame();
        return new ApplicationResult(list, Collections.unmodifiableList(applicationErrors));
    }

    static {
        HashMap<@NotNull @NotNull String, @NotNull @NotNull InsnParser<InsnBlock>> insnParsersModifable = new HashMap<String, InsnParser<InsnBlock>>();
        insnParsersModifable.put("*", WildcardInsnBlock.PARSER);
        insnParsersModifable.put("GETFIELD", FieldInsn.PARSER_GETFIELD);
        insnParsersModifable.put("GETSTATIC", FieldInsn.PARSER_GETSTATIC);
        insnParsersModifable.put("PUTFIELD", FieldInsn.PARSER_PUTFIELD);
        insnParsersModifable.put("PUTSTATIC", FieldInsn.PARSER_PUTSTATIC);
        insnParsersModifable.put("INVOKEINTERFACE", InvokeInsn.PARSER_INVOKEINTERFACE);
        insnParsersModifable.put("INVOKEVIRTUAL", InvokeInsn.PARSER_INVOKEVIRTUAL);
        insnParsersModifable.put("INVOKESTATIC", InvokeInsn.PARSER_INVOKESTATIC);
        insnParsersModifable.put("INVOKESPECIAL", InvokeInsn.PARSER_INVOKESPECIAL);
        insnParsersModifable.put("NOP", SimpleInsnBlock.NOP);
        insnParsersModifable.put("ACONST_NULL", SimpleInsnBlock.ACONST_NULL);
        insnParsersModifable.put("IALOAD", SimpleInsnBlock.IALOAD);
        insnParsersModifable.put("LALOAD", SimpleInsnBlock.LALOAD);
        insnParsersModifable.put("FALOAD", SimpleInsnBlock.FALOAD);
        insnParsersModifable.put("DALOAD", SimpleInsnBlock.DALOAD);
        insnParsersModifable.put("CALOAD", SimpleInsnBlock.CALOAD);
        insnParsersModifable.put("BALOAD", SimpleInsnBlock.BALOAD);
        insnParsersModifable.put("AALOAD", SimpleInsnBlock.AALOAD);
        insnParsersModifable.put("SALOAD", SimpleInsnBlock.SALOAD);
        insnParsersModifable.put("IASTORE", SimpleInsnBlock.IASTORE);
        insnParsersModifable.put("LASTORE", SimpleInsnBlock.LASTORE);
        insnParsersModifable.put("FASTORE", SimpleInsnBlock.FASTORE);
        insnParsersModifable.put("DASTORE", SimpleInsnBlock.DASTORE);
        insnParsersModifable.put("CASTORE", SimpleInsnBlock.CASTORE);
        insnParsersModifable.put("BASTORE", SimpleInsnBlock.BASTORE);
        insnParsersModifable.put("AASTORE", SimpleInsnBlock.AASTORE);
        insnParsersModifable.put("SASTORE", SimpleInsnBlock.SASTORE);
        insnParsersModifable.put("POP", SimpleInsnBlock.POP);
        insnParsersModifable.put("POP2", SimpleInsnBlock.POP2);
        insnParsersModifable.put("DUP", SimpleInsnBlock.DUP);
        insnParsersModifable.put("DUP2", SimpleInsnBlock.DUP2);
        insnParsersModifable.put("DUP2_X1", SimpleInsnBlock.DUP2_X1);
        insnParsersModifable.put("DUP2_X2", SimpleInsnBlock.DUP2_X2);
        insnParsersModifable.put("DUP_X1", SimpleInsnBlock.DUP_X1);
        insnParsersModifable.put("DUP_X2", SimpleInsnBlock.DUP_X2);
        insnParsersModifable.put("SWAP", SimpleInsnBlock.SWAP);
        insnParsersModifable.put("IADD", SimpleInsnBlock.IADD);
        insnParsersModifable.put("LADD", SimpleInsnBlock.LADD);
        insnParsersModifable.put("FADD", SimpleInsnBlock.FADD);
        insnParsersModifable.put("DADD", SimpleInsnBlock.DADD);
        insnParsersModifable.put("ISUB", SimpleInsnBlock.ISUB);
        insnParsersModifable.put("LSUB", SimpleInsnBlock.LSUB);
        insnParsersModifable.put("FSUB", SimpleInsnBlock.FSUB);
        insnParsersModifable.put("DSUB", SimpleInsnBlock.DSUB);
        insnParsersModifable.put("IMUL", SimpleInsnBlock.IMUL);
        insnParsersModifable.put("LMUL", SimpleInsnBlock.LMUL);
        insnParsersModifable.put("FMUL", SimpleInsnBlock.FMUL);
        insnParsersModifable.put("DMUL", SimpleInsnBlock.DMUL);
        insnParsersModifable.put("IDIV", SimpleInsnBlock.IDIV);
        insnParsersModifable.put("LDIV", SimpleInsnBlock.LDIV);
        insnParsersModifable.put("FDIV", SimpleInsnBlock.FDIV);
        insnParsersModifable.put("DDIV", SimpleInsnBlock.DDIV);
        insnParsersModifable.put("IREM", SimpleInsnBlock.IREM);
        insnParsersModifable.put("LREM", SimpleInsnBlock.LREM);
        insnParsersModifable.put("FREM", SimpleInsnBlock.FREM);
        insnParsersModifable.put("DREM", SimpleInsnBlock.DREM);
        insnParsersModifable.put("INEG", SimpleInsnBlock.INEG);
        insnParsersModifable.put("LNEG", SimpleInsnBlock.LNEG);
        insnParsersModifable.put("FNEG", SimpleInsnBlock.FNEG);
        insnParsersModifable.put("DNEG", SimpleInsnBlock.DNEG);
        insnParsersModifable.put("ISHL", SimpleInsnBlock.ISHL);
        insnParsersModifable.put("LSHL", SimpleInsnBlock.LSHL);
        insnParsersModifable.put("ISHR", SimpleInsnBlock.ISHR);
        insnParsersModifable.put("LSHR", SimpleInsnBlock.LSHR);
        insnParsersModifable.put("IUSHR", SimpleInsnBlock.IUSHR);
        insnParsersModifable.put("LUSHR", SimpleInsnBlock.LUSHR);
        insnParsersModifable.put("IAND", SimpleInsnBlock.IAND);
        insnParsersModifable.put("LAND", SimpleInsnBlock.LAND);
        insnParsersModifable.put("IOR", SimpleInsnBlock.IOR);
        insnParsersModifable.put("LOR", SimpleInsnBlock.LOR);
        insnParsersModifable.put("IXOR", SimpleInsnBlock.IXOR);
        insnParsersModifable.put("LXOR", SimpleInsnBlock.LXOR);
        insnParsersModifable.put("I2L", SimpleInsnBlock.I2L);
        insnParsersModifable.put("I2F", SimpleInsnBlock.I2F);
        insnParsersModifable.put("I2D", SimpleInsnBlock.I2D);
        insnParsersModifable.put("I2S", SimpleInsnBlock.I2S);
        insnParsersModifable.put("I2B", SimpleInsnBlock.I2B);
        insnParsersModifable.put("I2C", SimpleInsnBlock.I2C);
        insnParsersModifable.put("L2I", SimpleInsnBlock.L2I);
        insnParsersModifable.put("L2F", SimpleInsnBlock.L2F);
        insnParsersModifable.put("L2D", SimpleInsnBlock.L2D);
        insnParsersModifable.put("F2D", SimpleInsnBlock.F2D);
        insnParsersModifable.put("F2I", SimpleInsnBlock.F2I);
        insnParsersModifable.put("F2L", SimpleInsnBlock.F2L);
        insnParsersModifable.put("LCMP", SimpleInsnBlock.LCMP);
        insnParsersModifable.put("FCMPL", SimpleInsnBlock.FCMPL);
        insnParsersModifable.put("FCMPG", SimpleInsnBlock.FCMPG);
        insnParsersModifable.put("DCMPL", SimpleInsnBlock.DCMPL);
        insnParsersModifable.put("DCMPG", SimpleInsnBlock.DCMPG);
        insnParsersModifable.put("IRETURN", SimpleInsnBlock.IRETURN);
        insnParsersModifable.put("LRETURN", SimpleInsnBlock.LRETURN);
        insnParsersModifable.put("FRETURN", SimpleInsnBlock.FRETURN);
        insnParsersModifable.put("DRETURN", SimpleInsnBlock.DRETURN);
        insnParsersModifable.put("ARETURN", SimpleInsnBlock.ARETURN);
        insnParsersModifable.put("RETURN", SimpleInsnBlock.RETURN);
        insnParsersModifable.put("ARRAYLENGTH", SimpleInsnBlock.ARRAYLENGTH);
        insnParsersModifable.put("ATHROW", SimpleInsnBlock.ATHROW);
        insnParsersModifable.put("MONITOREXIT", SimpleInsnBlock.MONITOREXIT);
        insnParsersModifable.put("MONITORENTER", SimpleInsnBlock.MONITORENTER);
        insnParsersModifable.put("ALOAD", VarInsn.PARSER_ALOAD);
        insnParsersModifable.put("DLOAD", VarInsn.PARSER_DLOAD);
        insnParsersModifable.put("ILOAD", VarInsn.PARSER_ILOAD);
        insnParsersModifable.put("FLOAD", VarInsn.PARSER_FLOAD);
        insnParsersModifable.put("LLOAD", VarInsn.PARSER_LLOAD);
        insnParsersModifable.put("ASTORE", VarInsn.PARSER_ASTORE);
        insnParsersModifable.put("DSTORE", VarInsn.PARSER_DSTORE);
        insnParsersModifable.put("ISTORE", VarInsn.PARSER_ISTORE);
        insnParsersModifable.put("FSTORE", VarInsn.PARSER_FSTORE);
        insnParsersModifable.put("LSTORE", VarInsn.PARSER_LSTORE);
        INSTRUCTION_PARSERS = Collections.unmodifiableMap(insnParsersModifable);
    }

    public static class ApplicationResult {
        @NotNull
        private final @NotNull @Unmodifiable List<@NotNull SoftmapApplicationError> errors;
        @NotNull
        private final @NotNull @Unmodifiable List<@NotNull String> generatedTinyV1Mappings;

        public ApplicationResult(@NotNull @NotNull @Unmodifiable List<@NotNull String> tinyV1, @NotNull @NotNull @Unmodifiable List<@NotNull SoftmapApplicationError> errors) {
            this.generatedTinyV1Mappings = tinyV1;
            this.errors = errors;
        }

        @Contract(pure=true)
        @NotNull
        public @NotNull @Unmodifiable List<@NotNull SoftmapApplicationError> getErrors() {
            return this.errors;
        }

        @Contract(pure=true)
        @NotNull
        public @NotNull @Unmodifiable List<@NotNull String> getGeneratedTinyV1Mappings() {
            return this.generatedTinyV1Mappings;
        }
    }
}

