/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.smatterdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Lazy<T> {
    @NotNull
    private final Supplier<T> lazySupplier;
    @NotNull
    private final List<Consumer<T>> lazyConfigurations;
    @NotNull
    private volatile Optional<T> value;
    @Nullable
    private volatile Throwable computeEx = null;

    public Lazy(@NotNull Supplier<T> supplier) {
        this.lazySupplier = supplier;
        this.lazyConfigurations = new ArrayList<Consumer<T>>();
        this.value = Optional.empty();
    }

    public Lazy(@NotNull T value) {
        this.value = Optional.of(value);
        this.lazySupplier = () -> {
            throw new UnsupportedOperationException();
        };
        this.lazyConfigurations = Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @Contract(pure=false)
    public T get() {
        if (this.value.isEmpty()) {
            Throwable t = this.computeEx;
            if (t != null) {
                throw new IllegalStateException("Previous attempt at initializing the value failed.", t);
            }
            Lazy lazy = this;
            synchronized (lazy) {
                if (this.value.isPresent()) {
                    T val = this.value.get();
                    assert (val != null);
                    return val;
                }
                t = this.computeEx;
                if (t != null) {
                    throw new IllegalStateException("Previous attempt at initializing the value failed. Warning: This exception is possibly caused by a race condition!", t);
                }
                try {
                    T val = this.lazySupplier.get();
                    val = Objects.requireNonNull(val, "'val' may not be null!");
                    for (Consumer<T> consumer : this.lazyConfigurations) {
                        consumer.accept(val);
                    }
                    this.value = Optional.of(val);
                }
                catch (Throwable t2) {
                    this.computeEx = t2;
                    if (t2 instanceof Error && !(t2 instanceof AssertionError)) {
                        throw t2;
                    }
                    throw new IllegalStateException("Attempt at initializing the value failed.", t2);
                }
                finally {
                    this.lazyConfigurations.clear();
                }
            }
        }
        T val = this.value.get();
        assert (val != null);
        return val;
    }

    @NotNull
    @Contract(pure=true)
    public Optional<T> getIfPresent() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @Contract(mutates="this", pure=false, value="null -> fail; !null -> this")
    public Lazy<T> configure(@NotNull Consumer<T> action) {
        if (this.value.isPresent()) {
            action.accept(this.value.get());
        } else {
            Lazy lazy = this;
            synchronized (lazy) {
                if (this.value.isPresent()) {
                    action.accept(this.value.get());
                    return this;
                }
                this.lazyConfigurations.add(Objects.requireNonNull(action));
            }
        }
        return this;
    }

    public boolean isDone() {
        return this.value.isPresent() || this.computeEx != null;
    }
}

