/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.smatterdi;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;
import org.stianloader.smatterdi.Autowire;
import org.stianloader.smatterdi.Inject;
import org.stianloader.smatterdi.InjectionContext;
import org.stianloader.smatterdi.ObjectAllocator;
import software.coley.cafedude.InvalidClassException;
import software.coley.cafedude.classfile.ClassFile;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.Field;
import software.coley.cafedude.classfile.attribute.CodeAttribute;
import software.coley.cafedude.classfile.attribute.StackMapTableAttribute;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpFieldRef;
import software.coley.cafedude.classfile.constant.CpInterfaceMethodRef;
import software.coley.cafedude.classfile.constant.CpMethodRef;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.classfile.instruction.BasicInstruction;
import software.coley.cafedude.classfile.instruction.CpRefInstruction;
import software.coley.cafedude.classfile.instruction.IntOperandInstruction;
import software.coley.cafedude.io.ClassFileWriter;

public abstract class CDObjectAllocator
implements ObjectAllocator {
    private static final AtomicLong GENERATED_CLASS_COUNTER = new AtomicLong();
    private final Map<Class<?>, Allocator<?>> caches = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> T allocate(@NotNull Class<T> type, @NotNull InjectionContext injectCtx, Object ... args) {
        Allocator<?> cachedAllocator = this.caches.get(type);
        if (cachedAllocator != null) {
            return (T)cachedAllocator.allocate(injectCtx, args);
        }
        if (type.getSuperclass() == null || type.isArray()) {
            throw new UnsupportedOperationException("Cannot create an instance of class " + type + ". It is likely an interface or any other type which cannot be initialized in this way.");
        }
        CDObjectAllocator cDObjectAllocator = this;
        synchronized (cDObjectAllocator) {
            Allocator<T> allocator = this.createAllocator(type);
            this.caches.put(type, allocator);
            return allocator.allocate(injectCtx, args);
        }
    }

    @NotNull
    private <T> Allocator<T> createReflectionAllocator(@NotNull Class<T> clazz) {
        return (ctx, args) -> {
            ArrayList candidateCtors = new ArrayList();
            block2: for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
                Class<?>[] c = ctor.getParameterTypes();
                if (c.length != args.length) continue;
                for (int i = 0; i < args.length; ++i) {
                    if (c[i].isPrimitive() ? !(args[i] instanceof Number) && (!(args[i] instanceof Character) || c[i] != Character.TYPE) : args[i] != null && !c[i].isInstance(args[i])) continue block2;
                }
                candidateCtors.add(ctor);
            }
            if (candidateCtors.size() != 1) {
                throw new UnsupportedOperationException("No constructors apply for argument array " + Arrays.stream(args).map(x -> {
                    if (x == null) {
                        return "(any)";
                    }
                    if (x instanceof Number) {
                        return x.getClass().descriptorString() + " (or primitive of that type)";
                    }
                    if (x instanceof Character) {
                        return "(char or java.lang.Character)";
                    }
                    return x.getClass().descriptorString();
                }).collect(ArrayList::new, ArrayList::add, ArrayList::addAll) + ", found " + candidateCtors.size());
            }
            try {
                return ((Constructor)candidateCtors.get(0)).newInstance(args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("Unable to call constructor of class " + clazz + ".", e);
            }
        };
    }

    private static CpClass lazyClass(Map<String, CpClass> m, Map<String, CpUtf8> s, String key) {
        return m.compute(key, (k, oldVal) -> {
            if (oldVal != null) {
                return oldVal;
            }
            return new CpClass(s.compute((String)k, CDObjectAllocator::lazyUtf8));
        });
    }

    @NotNull
    private static CpUtf8 lazyUtf8(String key, CpUtf8 val) {
        if (val != null) {
            return val;
        }
        return new CpUtf8(key);
    }

    @NotNull
    private <T> Allocator<T> createAllocator(@NotNull Class<T> clazz) {
        boolean doAutowire = clazz.isAnnotationPresent(Autowire.class);
        ArrayList<Object> injectMethods = new ArrayList<Object>();
        for (Class<T> c = clazz; c != Object.class; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(Inject.class)) continue;
                injectMethods.add(m);
            }
        }
        if (!doAutowire && injectMethods.isEmpty()) {
            return this.createReflectionAllocator(clazz);
        }
        LinkedHashSet<Map.Entry<String, CallSite>> injects = new LinkedHashSet<Map.Entry<String, CallSite>>();
        for (Method method : injectMethods) {
            if (method.getParameters().length != 0) {
                throw new IllegalStateException("Class " + clazz.getName() + " is invalid; an @Inject-annotated method may not have any parameters! Method " + method.getName() + " has though!");
            }
            if (method.getReturnType().isPrimitive() || method.getReturnType() == Void.TYPE) {
                throw new IllegalStateException("Class " + clazz.getName() + " is invalid; an @Inject-annotated method must return a non-primitive, non-void type! Method " + method.getName() + " doesn't though!");
            }
            injects.add(Map.entry(method.getName(), "()" + method.getReturnType().descriptorString()));
        }
        ConstPool cp = new ConstPool();
        String string = clazz.getPackageName().replace('.', '/') + "/generated_" + clazz.getSimpleName() + "_" + GENERATED_CLASS_COUNTER.getAndIncrement();
        CpUtf8 nameUtf8 = new CpUtf8(string);
        CpClass nameClass = new CpClass(nameUtf8);
        cp.add((CpEntry)nameUtf8);
        cp.add((CpEntry)nameClass);
        CpUtf8 superUtf8 = new CpUtf8(clazz.getName().replace('.', '/'));
        CpClass superClass = new CpClass(superUtf8);
        cp.add((CpEntry)superUtf8);
        cp.add((CpEntry)superClass);
        ArrayList<Field> fields = new ArrayList<Field>();
        String context = "generated_context_" + System.currentTimeMillis();
        CpUtf8 contextUtf8 = new CpUtf8(context);
        CpUtf8 contextTypeUtf8 = new CpUtf8("Lorg/stianloader/smatterdi/InjectionContext;");
        cp.add((CpEntry)contextUtf8);
        cp.add((CpEntry)contextTypeUtf8);
        fields.add(new Field(Collections.emptyList(), 4113, contextUtf8, contextTypeUtf8));
        ArrayList<software.coley.cafedude.classfile.Method> methods = new ArrayList<software.coley.cafedude.classfile.Method>();
        CpNameType contextNameType = new CpNameType(contextUtf8, contextTypeUtf8);
        CpFieldRef contextField = new CpFieldRef(nameClass, contextNameType);
        cp.add((CpEntry)contextField);
        cp.add((CpEntry)contextNameType);
        LinkedHashMap<String, CpUtf8> names = new LinkedHashMap<String, CpUtf8>();
        LinkedHashMap<String, CpClass> types = new LinkedHashMap<String, CpClass>();
        LinkedHashMap<String, CpNameType> constructorNTCache = new LinkedHashMap<String, CpNameType>();
        ArrayList<CpMethodRef> otherEntries = new ArrayList<CpMethodRef>();
        CpUtf8 codeUtf8 = names.compute("Code", CDObjectAllocator::lazyUtf8);
        CpUtf8 constructorNameUtf8 = names.compute("<init>", CDObjectAllocator::lazyUtf8);
        CpClass contextClass = CDObjectAllocator.lazyClass(types, names, "org/stianloader/smatterdi/InjectionContext");
        CpUtf8 contextLookupNameUtf8 = names.compute("getInstance", CDObjectAllocator::lazyUtf8);
        CpUtf8 contextLookupDescUtf8 = names.compute("(Ljava/lang/Class;)Ljava/lang/Object;", CDObjectAllocator::lazyUtf8);
        CpNameType contextLookupNT = new CpNameType(contextLookupNameUtf8, contextLookupDescUtf8);
        CpInterfaceMethodRef contextLookup = new CpInterfaceMethodRef(contextClass, contextLookupNT);
        CpNameType contextAutowireNT = null;
        CpInterfaceMethodRef contextAutowire = null;
        CpNameType autowireBoolFieldNT = null;
        CpFieldRef autowireBoolField = null;
        CpNameType autowireMethodNT = null;
        CpMethodRef autowireMethod = null;
        if (doAutowire) {
            CpUtf8 autowireBoolName = names.compute("generated_autowired_" + System.currentTimeMillis(), CDObjectAllocator::lazyUtf8);
            CpUtf8 cpUtf8 = names.compute("Z", CDObjectAllocator::lazyUtf8);
            CpUtf8 contextAutowireNameUtf8 = names.compute("autowire", CDObjectAllocator::lazyUtf8);
            CpUtf8 contextAutowireDescUtf8 = names.compute("(Ljava/lang/Class;Ljava/lang/Object;)V", CDObjectAllocator::lazyUtf8);
            CpUtf8 voidNoArgsMethodUtf8 = names.compute("()V", CDObjectAllocator::lazyUtf8);
            CpUtf8 stackMapAttributeNameUtf8 = names.compute("StackMapTable", CDObjectAllocator::lazyUtf8);
            contextAutowireNT = new CpNameType(contextAutowireNameUtf8, contextAutowireDescUtf8);
            contextAutowire = new CpInterfaceMethodRef(contextClass, contextAutowireNT);
            autowireBoolFieldNT = new CpNameType(autowireBoolName, cpUtf8);
            autowireBoolField = new CpFieldRef(nameClass, autowireBoolFieldNT);
            autowireMethodNT = new CpNameType(autowireBoolName, voidNoArgsMethodUtf8);
            autowireMethod = new CpMethodRef(nameClass, autowireMethodNT);
            fields.add(new Field(Collections.emptyList(), 4098, autowireBoolName, cpUtf8));
            ArrayList methodAttrs = new ArrayList();
            ArrayList<Object> insns = new ArrayList<Object>();
            insns.add(new BasicInstruction(42));
            insns.add(new CpRefInstruction(180, (CpEntry)autowireBoolField));
            insns.add(new IntOperandInstruction(153, 4));
            insns.add(new BasicInstruction(177));
            insns.add(new BasicInstruction(42));
            insns.add(new BasicInstruction(4));
            insns.add(new CpRefInstruction(181, (CpEntry)autowireBoolField));
            insns.add(new BasicInstruction(42));
            insns.add(new CpRefInstruction(180, (CpEntry)contextField));
            insns.add(new CpRefInstruction(18, (CpEntry)superClass));
            insns.add(new BasicInstruction(42));
            insns.add(new CpRefInstruction(185, (CpEntry)contextAutowire));
            insns.add(new BasicInstruction(177));
            ArrayList<StackMapTableAttribute.SameFrame> frames = new ArrayList<StackMapTableAttribute.SameFrame>();
            frames.add(new StackMapTableAttribute.SameFrame(8));
            methodAttrs.add(new CodeAttribute(codeUtf8, 3, 1, insns, Collections.emptyList(), List.of(new StackMapTableAttribute(stackMapAttributeNameUtf8, frames))));
            methods.add(new software.coley.cafedude.classfile.Method((List)methodAttrs, 4114, autowireBoolName, voidNoArgsMethodUtf8));
        }
        for (CpUtf8 ctor : clazz.getDeclaredConstructors()) {
            Object descriptor = "";
            ArrayList<String> args2 = new ArrayList<String>();
            for (Class<?> param : ctor.getParameterTypes()) {
                descriptor = (String)descriptor + param.descriptorString();
                args2.add(param.descriptorString());
            }
            descriptor = (String)descriptor + ")V";
            String descriptorSuper = "(" + (String)descriptor;
            descriptor = "(Lorg/stianloader/smatterdi/InjectionContext;" + (String)descriptor;
            CpUtf8 descutf8 = names.compute((String)descriptor, CDObjectAllocator::lazyUtf8);
            ArrayList<CodeAttribute> methodAttrs = new ArrayList<CodeAttribute>();
            ArrayList<Object> insns = new ArrayList<Object>();
            int locals = 2;
            insns.add(new BasicInstruction(42));
            insns.add(new BasicInstruction(43));
            insns.add(new CpRefInstruction(181, (CpEntry)contextField));
            insns.add(new BasicInstruction(42));
            for (String arg : args2) {
                int ocode;
                boolean wide = false;
                switch (arg.charAt(0)) {
                    case 'D': {
                        ocode = 24;
                        wide = true;
                        break;
                    }
                    case 'J': {
                        ocode = 22;
                        wide = true;
                        break;
                    }
                    case 'F': {
                        ocode = 23;
                        break;
                    }
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        ocode = 21;
                        break;
                    }
                    case 'L': 
                    case '[': {
                        ocode = 25;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected type: " + arg);
                    }
                }
                insns.add(new IntOperandInstruction(ocode, locals));
                locals += wide ? 2 : 1;
            }
            CpNameType ctorNT = constructorNTCache.compute(descriptorSuper, (ignore, val) -> {
                if (val != null) {
                    return val;
                }
                return new CpNameType(constructorNameUtf8, names.compute(descriptorSuper, CDObjectAllocator::lazyUtf8));
            });
            CpMethodRef mref = new CpMethodRef(superClass, ctorNT);
            otherEntries.add(mref);
            insns.add(new CpRefInstruction(183, (CpEntry)mref));
            if (doAutowire) {
                insns.add(new BasicInstruction(42));
                insns.add(new CpRefInstruction(182, (CpEntry)autowireMethod));
            }
            insns.add(new BasicInstruction(177));
            methodAttrs.add(new CodeAttribute(codeUtf8, Math.max(3, locals), Math.max(2, locals), insns, Collections.emptyList(), Collections.emptyList()));
            methods.add(new software.coley.cafedude.classfile.Method(methodAttrs, 1, constructorNameUtf8, descutf8));
        }
        for (Map.Entry entry : injects) {
            CpUtf8 nutf8 = names.compute((String)entry.getKey(), CDObjectAllocator::lazyUtf8);
            CpUtf8 descutf8 = names.compute((String)entry.getValue(), CDObjectAllocator::lazyUtf8);
            ArrayList<CodeAttribute> methodAttrs = new ArrayList<CodeAttribute>();
            CpClass returnType = CDObjectAllocator.lazyClass(types, names, ((String)entry.getValue()).substring(3, ((String)entry.getValue()).length() - 1).replace('.', '/'));
            ArrayList<Object> insns = new ArrayList<Object>();
            if (doAutowire) {
                insns.add(new BasicInstruction(42));
                insns.add(new CpRefInstruction(182, (CpEntry)autowireMethod));
            }
            insns.add(new BasicInstruction(42));
            insns.add(new CpRefInstruction(180, (CpEntry)contextField));
            insns.add(new CpRefInstruction(19, (CpEntry)returnType));
            insns.add(new CpRefInstruction(185, (CpEntry)contextLookup));
            insns.add(new CpRefInstruction(192, (CpEntry)returnType));
            insns.add(new BasicInstruction(176));
            methodAttrs.add(new CodeAttribute(codeUtf8, 2, 1, insns, Collections.emptyList(), Collections.emptyList()));
            methods.add(new software.coley.cafedude.classfile.Method(methodAttrs, 4113, nutf8, descutf8));
        }
        cp.addAll(names.values());
        cp.addAll(types.values());
        cp.addAll(constructorNTCache.values());
        cp.addAll(otherEntries);
        cp.add((CpEntry)contextLookupNT);
        cp.add((CpEntry)contextLookup);
        if (doAutowire) {
            cp.add((CpEntry)contextAutowireNT);
            cp.add((CpEntry)contextAutowire);
            cp.add((CpEntry)autowireBoolFieldNT);
            cp.add((CpEntry)autowireBoolField);
            cp.add(autowireMethodNT);
            cp.add(autowireMethod);
        }
        ClassFile cf = new ClassFile(0, 52, cp, 17, nameClass, superClass, Collections.emptyList(), fields, methods, Collections.emptyList());
        try {
            byte[] byArray = new ClassFileWriter().write(cf);
            if (Boolean.getBoolean("org.stianloader.smatterdi.debug")) {
                Path p = Path.of("smatterdi-generated", cf.getName() + ".class");
                Path parent = p.getParent();
                if (parent == null) {
                    throw new AssertionError();
                }
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                    Files.write(p, byArray, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Unable to write generated class bytes", (Throwable)e);
                }
            }
            Allocator<?> forwardAllocator = this.createReflectionAllocator(this.defineClass(string, byArray, clazz));
            return (ctx, args) -> {
                Object[] realArgs = new Object[args.length + 1];
                realArgs[0] = ctx;
                System.arraycopy(args, 0, realArgs, 1, args.length);
                Object allocated = forwardAllocator.allocate(ctx, realArgs);
                return allocated;
            };
        }
        catch (InvalidClassException invalidClassException) {
            throw new UnsupportedOperationException("Unable to define injection wrapper class '" + string + "'.", invalidClassException);
        }
    }

    @NotNull
    public abstract Class<?> defineClass(@NotNull String var1, @NotNull byte[] var2, @NotNull Class<?> var3);

    private static interface Allocator<T> {
        @NotNull
        public T allocate(InjectionContext var1, Object ... var2);
    }
}

