/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.deobf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class JavaInterop {
    JavaInterop() {
    }

    @NotNull
    public static String codepointToString(int codepoint) {
        return new String(new int[]{codepoint}, 0, 1);
    }

    @SafeVarargs
    public static <T> Set<T> modifableSet(T ... objects) {
        HashSet<T> set = new HashSet<T>();
        for (T o : objects) {
            set.add(o);
        }
        return set;
    }

    @NotNull
    public static ClassLoader newURLClassloader(@NotNull String name, URL @NotNull [] urls, ClassLoader parent) {
        return new URLClassLoader(urls, parent);
    }

    public static byte @NotNull [] readAllBytes(@NotNull InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JavaInterop.transferTo(in, baos);
        return baos.toByteArray();
    }

    public static void transferTo(@NotNull InputStream source, @NotNull OutputStream sink) throws IOException {
        byte[] buffer = new byte[4096];
        int len = source.read(buffer);
        while (len != -1) {
            sink.write(buffer, 0, len);
            len = source.read(buffer);
        }
    }

    @SafeVarargs
    public static <T> Set<T> unmodifableSet(T ... objects) {
        return Collections.unmodifiableSet(JavaInterop.modifableSet(objects));
    }
}

