/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.deobf;

import de.geolykt.starloader.deobf.ClassNodeNameComparator;
import de.geolykt.starloader.deobf.FieldReference;
import de.geolykt.starloader.deobf.JavaInterop;
import de.geolykt.starloader.deobf.MethodReference;
import de.geolykt.starloader.deobf.Oaktree;
import de.geolykt.starloader.deobf.OverrideScope;
import de.geolykt.starloader.deobf.remapper.ConflicitingMappingException;
import de.geolykt.starloader.deobf.remapper.Remapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class IntermediaryGenerator {
    private boolean alternateClassNaming;
    private final Path map;
    private final List<ClassNode> nodes = new ArrayList<ClassNode>();
    private final Map<String, ClassNode> nameToNode = new HashMap<String, ClassNode>();
    private final Path output;
    private final Remapper remapper = new Remapper();
    private final List<Map.Entry<String, byte[]>> resources = new ArrayList<Map.Entry<String, byte[]>>();

    public IntermediaryGenerator(@Nullable Path map, Path output, @Nullable Collection<ClassNode> nodes) {
        this.map = map;
        this.output = output;
        if (nodes != null) {
            this.nodes.addAll(nodes);
            this.nodes.forEach(node -> this.nameToNode.put(node.name, (ClassNode)node));
            this.remapper.addTargets(nodes);
        }
    }

    public IntermediaryGenerator(File input, Path map, Path output) {
        this(map, output, (Collection<ClassNode>)null);
        try {
            JarFile inJar = new JarFile(input);
            Enumeration<JarEntry> entries = inJar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                InputStream is = inJar.getInputStream(entry);
                if (!entry.getName().endsWith(".class")) {
                    if (is == null) continue;
                    this.resources.add(new AbstractMap.SimpleImmutableEntry<String, byte[]>(entry.getName(), JavaInterop.readAllBytes(is)));
                    is.close();
                    continue;
                }
                ClassNode node = new ClassNode(589824);
                ClassReader reader = new ClassReader(is);
                reader.accept((ClassVisitor)node, 0);
                this.nodes.add(node);
                is.close();
            }
            inJar.close();
            this.remapper.addTargets(this.nodes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addResources(@NotNull File input) throws IOException {
        try (JarFile inJar = new JarFile(input);){
            Enumeration<JarEntry> entries = inJar.entries();
            while (entries.hasMoreElements()) {
                InputStream is;
                JarEntry entry = entries.nextElement();
                if (entry.getName().endsWith(".class") || (is = inJar.getInputStream(entry)) == null) continue;
                this.resources.add(new AbstractMap.SimpleImmutableEntry<String, byte[]>(entry.getName(), JavaInterop.readAllBytes(is)));
                is.close();
            }
            inJar.close();
        }
    }

    protected Map<String, List<String>> computeFullHierarchy(Map<String, List<String>> nearbyHierarchy) {
        HashMap<String, List<String>> allSubtypes = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> clazz : nearbyHierarchy.entrySet()) {
            String name = clazz.getKey();
            ArrayList<String> subtypes = new ArrayList<String>();
            for (String subtype : clazz.getValue()) {
                this.computeFullHierarchy0(subtypes, nearbyHierarchy, subtype);
            }
            allSubtypes.put(name, subtypes);
        }
        return allSubtypes;
    }

    private void computeFullHierarchy0(List<String> out, Map<String, List<String>> nearbyHierarchy, String current) {
        out.add(current);
        List<String> l = nearbyHierarchy.get(current);
        if (l == null) {
            return;
        }
        for (String subtype : l) {
            this.computeFullHierarchy0(out, nearbyHierarchy, subtype);
        }
    }

    private String createString(int num) {
        if (this.alternateClassNaming) {
            return Integer.toString(num);
        }
        ++num;
        int len = 16;
        byte[] characters = new byte[len];
        int i = len - 1;
        while (num != 0) {
            characters[i] = (byte)(--num % 26 + 97);
            num /= 26;
            --i;
        }
        return new String(characters, ++i, len - i, StandardCharsets.US_ASCII);
    }

    public void deobfuscate() {
        this.remapper.process();
        if (this.output != null) {
            try (OutputStream rawOut = Files.newOutputStream(this.output, new OpenOption[0]);
                 JarOutputStream jarOut = new JarOutputStream(rawOut);){
                for (ClassNode classNode : this.nodes) {
                    ClassWriter writer = new ClassWriter(0);
                    classNode.accept((ClassVisitor)writer);
                    jarOut.putNextEntry(new ZipEntry(classNode.name + ".class"));
                    jarOut.write(writer.toByteArray());
                    jarOut.closeEntry();
                }
                for (Map.Entry entry : this.resources) {
                    jarOut.putNextEntry(new ZipEntry((String)entry.getKey()));
                    jarOut.write((byte[])entry.getValue());
                    jarOut.closeEntry();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void doProposeEnumFieldsV2() {
        BufferedWriter bw = null;
        if (this.map != null) {
            try {
                BufferedWriter dontcomplain;
                bw = dontcomplain = Files.newBufferedWriter(this.map, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                bw.write("# begin enum field remapping");
                bw.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, FieldNode> memberNames = new HashMap<String, FieldNode>();
        for (ClassNode node : this.nodes) {
            if (!node.superName.equals("java/lang/Enum")) continue;
            memberNames.clear();
            String expectedDesc = 'L' + node.name + ';';
            for (FieldNode field : node.fields) {
                if (!field.desc.equals(expectedDesc)) continue;
                memberNames.put(field.name, field);
            }
            block8: for (MethodNode method : node.methods) {
                if (!method.name.equals("<clinit>")) continue;
                AbstractInsnNode instruction = method.instructions.getFirst();
                while (instruction != null) {
                    if (instruction.getOpcode() == 187) {
                        TypeInsnNode newCall = (TypeInsnNode)instruction;
                        if ((instruction = newCall.getNext()) == null || instruction.getOpcode() != 89 || (instruction = instruction.getNext()) == null || instruction.getOpcode() != 18) continue block8;
                        LdcInsnNode enumName = (LdcInsnNode)instruction;
                        if (!(enumName.cst instanceof String)) continue;
                        if ((instruction = instruction.getNext()) == null || (instruction = instruction.getNext()) == null) continue block8;
                        AbstractInsnNode formerInsn = instruction;
                        while (!(instruction == null || instruction.getOpcode() == 183 && ((MethodInsnNode)instruction).owner.equals(newCall.desc))) {
                            instruction = instruction.getNext();
                        }
                        if (instruction == null) {
                            instruction = formerInsn;
                            continue;
                        }
                        if (!((MethodInsnNode)instruction).name.equals("<init>")) {
                            instruction = formerInsn;
                            continue;
                        }
                        if ((instruction = instruction.getNext()).getOpcode() != 179) {
                            instruction = formerInsn;
                            continue;
                        }
                        FieldInsnNode field = (FieldInsnNode)instruction;
                        if (!(field.owner.equals(node.name) && field.desc.equals(expectedDesc) && memberNames.containsKey(field.name))) {
                            instruction = formerInsn;
                            continue;
                        }
                        if (field.name.equals(enumName.cst)) continue;
                        if (bw != null) {
                            try {
                                bw.write("FIELD\t");
                                bw.write(node.name);
                                bw.write(9);
                                bw.write(expectedDesc);
                                bw.write(9);
                                bw.write(field.name);
                                bw.write(9);
                                bw.write(enumName.cst.toString());
                                bw.write(10);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        this.remapper.remapField(node.name, expectedDesc, field.name, enumName.cst.toString());
                        continue;
                    }
                    instruction = instruction.getNext();
                }
            }
        }
        if (bw != null) {
            try {
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<ClassNode> getAsClassNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    private Map<String, List<String>> invertHierarchy(Map<String, List<String>> allSubtypes) {
        HashMap<String, List<String>> allSupertypes = new HashMap<String, List<String>>();
        allSubtypes.forEach((superType, inSubtypes) -> {
            for (String subtype : inSubtypes) {
                ArrayList<String> outSupertypes = (ArrayList<String>)allSupertypes.get(subtype);
                if (outSupertypes == null) {
                    outSupertypes = new ArrayList<String>();
                    allSupertypes.put(subtype, outSupertypes);
                }
                outSupertypes.add((String)superType);
            }
        });
        return allSupertypes;
    }

    private void propagateDownwards(Map<String, List<String>> directChildren, Collection<MethodReference> output, ClassNode currentNode, MethodReference declaringRef, Map<String, ClassNode> name2Node, OverrideScope currentScope) {
        if (currentScope == OverrideScope.NEVER) {
            return;
        }
        List<String> children = directChildren.get(currentNode.name);
        for (String childName : children) {
            String overrdingMethodPackage;
            String superMethodPackage;
            boolean canOverride;
            ClassNode childNode = name2Node.get(childName);
            boolean bl = canOverride = currentScope == OverrideScope.ALWAYS;
            if (!canOverride && (superMethodPackage = declaringRef.getOwner().substring(0, declaringRef.getOwner().lastIndexOf(47))).equals(overrdingMethodPackage = childName.substring(0, childName.lastIndexOf(47)))) {
                canOverride = true;
            }
            output.add(new MethodReference(childName, declaringRef.getDesc(), declaringRef.getName()));
            boolean found = false;
            for (MethodNode childMethod : childNode.methods) {
                if (!childMethod.name.equals(declaringRef.getName()) || !childMethod.desc.equals(declaringRef.getDesc()) || (childMethod.access & 8) == 0) continue;
                found = true;
                int flagWithoutFinal = childMethod.access & 0xFFFFFFEF;
                this.propagateDownwards(directChildren, output, childNode, declaringRef, name2Node, OverrideScope.fromFlags(flagWithoutFinal));
                break;
            }
            if (found) continue;
            this.propagateDownwards(directChildren, output, childNode, declaringRef, name2Node, currentScope);
        }
    }

    private void remapClass(String oldName, String newName, BufferedWriter bw) {
        this.remapper.remapClassName(oldName, newName);
        if (bw != null) {
            try {
                bw.write("CLASS\t");
                bw.write(oldName);
                bw.write(9);
                bw.write(newName);
                bw.write(10);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void remapClassesV2() {
        this.remapClassesV2(false);
    }

    public void remapClassesV2(boolean findLocalClasses) {
        Map<Object, Object> localClasses;
        BufferedWriter bw;
        if (this.map != null) {
            BufferedWriter temp = null;
            try {
                BufferedWriter dontcomplain;
                temp = dontcomplain = Files.newBufferedWriter(this.map, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                temp.write("v1\tofficial\tintermediary\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            bw = temp;
        } else {
            bw = null;
        }
        if (findLocalClasses) {
            Oaktree oaktree = new Oaktree();
            oaktree.getClassNodesDirectly().addAll(this.nodes);
            localClasses = oaktree.guessLocalClasses();
        } else {
            localClasses = Collections.emptyMap();
        }
        HashMap<String, TreeSet<ClassNode>> remappedEnums = new HashMap<String, TreeSet<ClassNode>>();
        HashMap<String, TreeSet<ClassNode>> remappedInterfaces = new HashMap<String, TreeSet<ClassNode>>();
        HashMap<String, TreeSet<ClassNode>> remappedInners = new HashMap<String, TreeSet<ClassNode>>();
        HashMap<String, TreeSet<ClassNode>> remappedLocals = new HashMap<String, TreeSet<ClassNode>>();
        HashMap<String, TreeSet<ClassNode>> remappedPrivateClasses = new HashMap<String, TreeSet<ClassNode>>();
        HashMap<String, TreeSet<ClassNode>> remappedProtectedClasses = new HashMap<String, TreeSet<ClassNode>>();
        HashMap<String, TreeSet<ClassNode>> remappedPublicClasses = new HashMap<String, TreeSet<ClassNode>>();
        for (ClassNode node : this.nodes) {
            TreeSet remapSet;
            if (localClasses.containsKey(node.name)) continue;
            int lastSlash = node.name.lastIndexOf(47);
            String className = node.name.substring(lastSlash + 1);
            String packageName = node.name.substring(0, lastSlash);
            if (packageName.startsWith("org/hamcrest") || packageName.startsWith("org/lwjgl") || className.length() >= 3) continue;
            if ("java/lang/Enum".equals(node.superName)) {
                remapSet = (TreeSet)remappedEnums.get(packageName);
                if (remapSet == null) {
                    remapSet = new TreeSet(ClassNodeNameComparator.INSTANCE);
                    remappedEnums.put(packageName, remapSet);
                }
                remapSet.add(node);
                continue;
            }
            if (node.outerClass != null) {
                if (node.outerMethod == null) {
                    remapSet = (TreeSet)remappedInners.get(packageName);
                    if (remapSet == null) {
                        remapSet = new TreeSet(ClassNodeNameComparator.INSTANCE);
                        remappedInners.put(packageName, remapSet);
                    }
                    remapSet.add(node);
                    continue;
                }
                remapSet = (TreeSet)remappedLocals.get(packageName);
                if (remapSet == null) {
                    remapSet = new TreeSet<ClassNode>(ClassNodeNameComparator.INSTANCE);
                    remappedLocals.put(packageName, remapSet);
                }
                remapSet.add(node);
                continue;
            }
            if ((node.access & 0x200) != 0) {
                remapSet = (TreeSet)remappedInterfaces.get(packageName);
                if (remapSet == null) {
                    remapSet = new TreeSet(ClassNodeNameComparator.INSTANCE);
                    remappedInterfaces.put(packageName, remapSet);
                }
                remapSet.add((ClassNode)node);
                continue;
            }
            if ((node.access & 1) != 0) {
                remapSet = (TreeSet)remappedPublicClasses.get(packageName);
                if (remapSet == null) {
                    remapSet = new TreeSet(ClassNodeNameComparator.INSTANCE);
                    remappedPublicClasses.put(packageName, remapSet);
                }
                remapSet.add((ClassNode)node);
                continue;
            }
            if ((node.access & 4) != 0) {
                remapSet = (TreeSet)remappedProtectedClasses.get(packageName);
                if (remapSet == null) {
                    remapSet = new TreeSet<ClassNode>(ClassNodeNameComparator.INSTANCE);
                    remappedProtectedClasses.put(packageName, remapSet);
                }
                remapSet.add((ClassNode)node);
                continue;
            }
            remapSet = (TreeSet)remappedPrivateClasses.get(packageName);
            if (remapSet == null) {
                remapSet = new TreeSet<ClassNode>(ClassNodeNameComparator.INSTANCE);
                remappedPrivateClasses.put(packageName, remapSet);
            }
            remapSet.add((ClassNode)node);
        }
        HashMap<String, String> remapMap = new HashMap<String, String>();
        this.remapSet(remappedEnums, bw, "enum_", remapMap);
        this.remapSet(remappedInterfaces, bw, "interface_", remapMap);
        this.remapSet(remappedInners, bw, "innerclass_", remapMap);
        this.remapSet(remappedLocals, bw, "localclass_", remapMap);
        this.remapSet(remappedPublicClasses, bw, "class_", remapMap);
        this.remapSet(remappedProtectedClasses, bw, "pclass_", remapMap);
        this.remapSet(remappedPrivateClasses, bw, "ppclass_", remapMap);
        HashMap<String, List> mappings = new HashMap<String, List>();
        HashSet unmappedInnerClasses = new HashSet();
        localClasses.forEach((inner, outer) -> {
            mappings.compute((String)outer, (key, list) -> {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(inner);
                return list;
            });
            unmappedInnerClasses.add(inner);
        });
        while (unmappedInnerClasses.size() != 0) {
            int oldSize = unmappedInnerClasses.size();
            mappings.forEach((outer, inners) -> {
                if (unmappedInnerClasses.contains(outer)) {
                    return;
                }
                inners.sort(String::compareTo);
                int counter = 0;
                ClassNode outerNode = this.nameToNode.get(outer);
                for (String inner : inners) {
                    ClassNode innerNode = this.nameToNode.get(inner);
                    String innerName = "Local" + counter++;
                    InnerClassNode icn = new InnerClassNode(inner, outer, innerName, innerNode.access);
                    outerNode.innerClasses.add(icn);
                    innerNode.innerClasses.add(icn);
                    String newName = remapMap.getOrDefault(outer, (String)outer) + '$' + innerName;
                    remapMap.put(inner, newName);
                    this.remapClass(inner, newName, bw);
                    unmappedInnerClasses.remove(inner);
                }
            });
            if (unmappedInnerClasses.size() != oldSize) continue;
            for (String s : unmappedInnerClasses) {
                System.out.println("IntermediaryGenerator: " + s + " is part of a nested pair. Discarded from intermediary");
            }
        }
        if (bw != null) {
            try {
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void remapGetters() {
        BufferedWriter bw = null;
        if (this.map != null) {
            try {
                BufferedWriter dontcomplain;
                bw = dontcomplain = Files.newBufferedWriter(this.map, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                bw.write("# begin getter remapping");
                bw.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, ClassNode> name2Node = new HashMap<String, ClassNode>(this.nodes.size());
        ArrayList<AbstractMap.SimpleImmutableEntry<MethodReference, FieldReference>> getterCandidates = new ArrayList<AbstractMap.SimpleImmutableEntry<MethodReference, FieldReference>>();
        HashMap<String, List<String>> directSubtypes = new HashMap<String, List<String>>(this.nodes.size());
        HashMap<String, List> declaredMethods = new HashMap<String, List>();
        for (ClassNode node : this.nodes) {
            name2Node.put(node.name, node);
            if ((node.access & 0x10) != 0) {
                directSubtypes.put(node.name, Collections.emptyList());
            } else {
                directSubtypes.put(node.name, new ArrayList());
            }
            ArrayList<MethodReference> methods = new ArrayList<MethodReference>();
            declaredMethods.put(node.name, methods);
            for (MethodNode method : node.methods) {
                AbstractInsnNode insn;
                MethodReference mref2 = new MethodReference(node.name, method);
                methods.add(mref2);
                if (method.name.length() > 2 || method.desc.codePointAt(1) != 41 || (insn = method.instructions.getFirst()) == null) continue;
                while (insn instanceof FrameNode || insn instanceof LineNumberNode || insn instanceof LabelNode) {
                    insn = insn.getNext();
                }
                if ((method.access & 8) == 0 && insn instanceof VarInsnNode && ((VarInsnNode)insn).var == 0) {
                    insn = insn.getNext();
                }
                if (insn.getOpcode() != 178 && insn.getOpcode() != 180) continue;
                FieldInsnNode getField = (FieldInsnNode)insn;
                insn = insn.getNext();
                while (insn instanceof FrameNode || insn instanceof LineNumberNode) {
                    insn = insn.getNext();
                }
                if (!(insn instanceof InsnNode) || insn.getOpcode() != 176 && insn.getOpcode() != 172 && insn.getOpcode() != 175 && insn.getOpcode() != 174 && insn.getOpcode() != 173 || !getField.owner.equals(node.name)) continue;
                FieldReference fref2 = new FieldReference(getField);
                getterCandidates.add(new AbstractMap.SimpleImmutableEntry<MethodReference, FieldReference>(mref2, fref2));
            }
        }
        for (ClassNode node : this.nodes) {
            Object a = (List)directSubtypes.get(node.superName);
            if (a != null) {
                a.add(node.name);
            }
            for (String interfaceName : node.interfaces) {
                a = (List)directSubtypes.get(interfaceName);
                if (a == null) continue;
                a.add(node.name);
            }
        }
        HashSet<MethodReference> conflictingMappings = new HashSet<MethodReference>();
        HashMap<MethodReference, FieldReference> existingMappings = new HashMap<MethodReference, FieldReference>();
        for (Map.Entry entry : getterCandidates) {
            MethodReference mref3 = (MethodReference)entry.getKey();
            FieldReference fref3 = (FieldReference)entry.getValue();
            if (conflictingMappings.contains(mref3)) continue;
            FieldReference oldFieldReference = existingMappings.getOrDefault(existingMappings, fref3);
            if (!oldFieldReference.getName().equals(fref3.getName())) {
                existingMappings.remove(mref3);
                conflictingMappings.add(mref3);
                continue;
            }
            existingMappings.putIfAbsent(mref3, oldFieldReference);
        }
        Map<String, List<String>> allSubtypes = this.computeFullHierarchy(directSubtypes);
        Map<String, List<String>> map = this.invertHierarchy(allSubtypes);
        HashMap methodGroups = new HashMap();
        declaredMethods.forEach((declarerName, declaredMethodRefs) -> {
            ClassNode declarerNode = (ClassNode)name2Node.get(declarerName);
            List<String> supers = (List<String>)allSupertypes.get(declarerName);
            if (supers == null) {
                supers = Collections.emptyList();
            }
            ArrayList superNodes = new ArrayList();
            supers.forEach(name -> superNodes.add((ClassNode)name2Node.get(name)));
            ArrayList<MethodNode> declaredMethodNodes = new ArrayList<MethodNode>();
            block0: for (MethodReference mref : declaredMethodRefs) {
                for (MethodNode method2 : declarerNode.methods) {
                    if (!method2.name.equals(mref.getName()) || !method2.desc.equals(mref.getDesc())) continue;
                    declaredMethodNodes.add(method2);
                    continue block0;
                }
            }
            declaredMethodNodes.removeIf(method -> {
                boolean isStatic;
                boolean bl = isStatic = (method.access & 8) != 0;
                if (isStatic) {
                    MethodReference ref = new MethodReference((String)declarerName, (MethodNode)method);
                    methodGroups.put(ref, Collections.singleton(ref));
                    return true;
                }
                return false;
            });
            for (MethodNode method3 : declaredMethodNodes) {
                HashSet<MethodReference> group = new HashSet<MethodReference>();
                MethodReference declaredMethodRef = new MethodReference((String)declarerName, method3);
                methodGroups.put(declaredMethodRef, group);
                group.add(declaredMethodRef);
                block3: for (ClassNode node : superNodes) {
                    for (MethodNode superMethod : node.methods) {
                        String overrdingMethodPackage;
                        if (!method3.name.equals(superMethod.name) || !method3.desc.equals(superMethod.desc) || (superMethod.access & 8) != 0) continue;
                        OverrideScope superMethodScope = OverrideScope.fromFlags(superMethod.access);
                        if (superMethodScope == OverrideScope.ALWAYS) {
                            group.add(new MethodReference(node.name, superMethod));
                            this.propagateDownwards(directSubtypes, group, node, declaredMethodRef, name2Node, superMethodScope);
                            continue block3;
                        }
                        if (superMethodScope != OverrideScope.PACKAGE) continue block3;
                        String superMethodPackage = node.name.substring(0, node.name.lastIndexOf(47));
                        if (superMethodPackage.equals(overrdingMethodPackage = declarerName.substring(0, declarerName.lastIndexOf(47)))) {
                            group.add(new MethodReference(node.name, superMethod));
                        }
                        this.propagateDownwards(directSubtypes, group, node, declaredMethodRef, name2Node, superMethodScope);
                        continue block3;
                    }
                }
                this.propagateDownwards(directSubtypes, group, declarerNode, declaredMethodRef, name2Node, OverrideScope.fromFlags(method3.access));
            }
        });
        HashMap refeers = new HashMap();
        existingMappings.forEach((mref, fref) -> {
            MethodReference oldReference = refeers.put(fref, mref);
            if (oldReference != null && !oldReference.equals(mref)) {
                if (oldReference.getOwner().equals(mref.getOwner()) && fref.getOwner().equals(oldReference.getOwner())) {
                    ClassNode node = (ClassNode)name2Node.get(oldReference.getOwner());
                    boolean oldRefSynthetic = false;
                    boolean newRefSynthetic = false;
                    for (MethodNode method : node.methods) {
                        if (method.name.equals(oldReference.getName()) && method.desc.equals(oldReference.getDesc())) {
                            boolean bl = oldRefSynthetic = (method.access & 0x1000) != 0;
                        }
                        if (!method.name.equals(mref.getName()) || !method.desc.equals(mref.getDesc())) continue;
                        newRefSynthetic = (method.access & 0x1000) != 0;
                    }
                    if (oldRefSynthetic == newRefSynthetic) {
                        conflictingMappings.add((MethodReference)mref);
                        conflictingMappings.add(oldReference);
                    } else if (oldRefSynthetic) {
                        conflictingMappings.add(oldReference);
                    } else {
                        refeers.put(fref, oldReference);
                        conflictingMappings.add((MethodReference)mref);
                    }
                } else {
                    conflictingMappings.add((MethodReference)mref);
                    conflictingMappings.add(oldReference);
                }
            }
        });
        StringBuilder sharedBuilder = new StringBuilder();
        HashMap crudeNames = new HashMap();
        existingMappings.forEach((mref, fref) -> {
            sharedBuilder.setLength(0);
            if (fref.getName().length() > 2) {
                sharedBuilder.append("get");
                sharedBuilder.appendCodePoint(Character.toUpperCase(fref.getName().codePointAt(0)));
                sharedBuilder.append(fref.getName().substring(1));
            } else {
                sharedBuilder.append("get_");
                sharedBuilder.append(fref.getName());
            }
            String newName = sharedBuilder.toString();
            Set group = (Set)methodGroups.get(mref);
            boolean invalid = false;
            for (MethodReference groupRef : group) {
                if (conflictingMappings.contains(groupRef)) {
                    invalid = true;
                    break;
                }
                if (!crudeNames.getOrDefault(groupRef, newName).equals(newName)) {
                    invalid = true;
                    break;
                }
                ClassNode node = (ClassNode)name2Node.get(groupRef.getOwner());
                for (MethodNode method : node.methods) {
                    if (!method.name.equals(newName) || !method.desc.startsWith("()")) continue;
                    invalid = true;
                    break;
                }
                if (!invalid) continue;
                break;
            }
            if (invalid) {
                for (MethodReference groupRef : group) {
                    conflictingMappings.add(groupRef);
                    crudeNames.remove(groupRef);
                }
            } else {
                for (MethodReference groupRef : group) {
                    crudeNames.put(groupRef, newName);
                }
            }
        });
        crudeNames.clear();
        HashMap potentialRemaps = new HashMap();
        existingMappings.forEach((mref, fref) -> {
            if (conflictingMappings.contains(mref)) {
                return;
            }
            sharedBuilder.setLength(0);
            if (fref.getName().length() > 2) {
                sharedBuilder.append("get");
                sharedBuilder.appendCodePoint(Character.toUpperCase(fref.getName().codePointAt(0)));
                sharedBuilder.append(fref.getName().substring(1));
            } else {
                sharedBuilder.append("get_");
                sharedBuilder.append(fref.getName());
            }
            String newName = sharedBuilder.toString();
            MethodReference future = new MethodReference(mref.getOwner(), mref.getDesc(), newName);
            MethodReference current = potentialRemaps.getOrDefault(future, mref);
            if (!current.equals(mref) && !((Set)methodGroups.get(mref)).contains(current)) {
                int groupSizeCurrent;
                int groupSizeContender = ((Set)methodGroups.get(mref)).size();
                if (groupSizeContender == (groupSizeCurrent = ((Set)methodGroups.get(current)).size())) {
                    conflictingMappings.add((MethodReference)mref);
                    conflictingMappings.add(current);
                } else if (groupSizeContender > groupSizeCurrent) {
                    conflictingMappings.add(current);
                    potentialRemaps.put(future, current);
                } else {
                    conflictingMappings.add((MethodReference)mref);
                }
                return;
            }
            potentialRemaps.put(future, mref);
            for (MethodReference groupRef : (Set)methodGroups.get(mref)) {
                if (conflictingMappings.contains(groupRef)) continue;
                future = new MethodReference(groupRef.getOwner(), groupRef.getDesc(), newName);
                current = potentialRemaps.getOrDefault(future, mref);
                if (!current.equals(groupRef) && !((Set)methodGroups.get(mref)).contains(current)) {
                    int groupSizeCurrent;
                    int groupSizeContender = ((Set)methodGroups.get(mref)).size();
                    if (groupSizeContender == (groupSizeCurrent = ((Set)methodGroups.get(current)).size())) {
                        conflictingMappings.add((MethodReference)mref);
                        conflictingMappings.add(current);
                        continue;
                    }
                    if (groupSizeContender > groupSizeCurrent) {
                        conflictingMappings.add(current);
                        potentialRemaps.put(future, current);
                        continue;
                    }
                    conflictingMappings.add((MethodReference)mref);
                    continue;
                }
                potentialRemaps.put(future, groupRef);
            }
        });
        HashMap proposedNames = new HashMap();
        existingMappings.forEach((mref, fref) -> {
            sharedBuilder.setLength(0);
            if (fref.getName().length() > 2) {
                sharedBuilder.append("get");
                sharedBuilder.appendCodePoint(Character.toUpperCase(fref.getName().codePointAt(0)));
                sharedBuilder.append(fref.getName().substring(1));
            } else {
                sharedBuilder.append("get_");
                sharedBuilder.append(fref.getName());
            }
            String newName = sharedBuilder.toString();
            Set group = (Set)methodGroups.get(mref);
            boolean invalid = false;
            for (MethodReference groupRef : group) {
                if (conflictingMappings.contains(groupRef)) {
                    invalid = true;
                    break;
                }
                if (!proposedNames.getOrDefault(groupRef, newName).equals(newName)) {
                    invalid = true;
                    break;
                }
                if (!invalid) continue;
                break;
            }
            if (invalid) {
                for (MethodReference groupRef : group) {
                    conflictingMappings.add(groupRef);
                    proposedNames.remove(groupRef);
                }
            } else {
                for (MethodReference groupRef : group) {
                    proposedNames.put(groupRef, newName);
                }
            }
        });
        for (Map.Entry entry : proposedNames.entrySet()) {
            MethodReference method = (MethodReference)entry.getKey();
            String newName = (String)entry.getValue();
            try {
                this.remapper.remapMethod(method.getOwner(), method.getDesc(), method.getName(), newName);
            }
            catch (ConflicitingMappingException e1) {
                throw new IllegalStateException("Conflict filtering was not done throughout enough.", e1);
            }
            if (bw == null) continue;
            try {
                bw.write("METHOD\t");
                bw.write(method.getOwner());
                bw.write(9);
                bw.write(method.getName());
                bw.write(9);
                bw.write(method.getDesc());
                bw.write(9);
                bw.write(newName);
                bw.write(10);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (bw != null) {
            try {
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void remapSet(Map<String, TreeSet<ClassNode>> set, BufferedWriter writer, String prefix, Map<String, String> mappingsOut) {
        prefix = '/' + prefix;
        for (Map.Entry<String, TreeSet<ClassNode>> packageNode : set.entrySet()) {
            String packageName = packageNode.getKey();
            int counter = 0;
            for (ClassNode node : packageNode.getValue()) {
                String newName = packageName + prefix + this.createString(counter++);
                this.remapClass(node.name, newName, writer);
                mappingsOut.put(node.name, newName);
            }
        }
    }

    public void useAlternateClassNaming(boolean toggle) {
        this.alternateClassNaming = toggle;
    }
}

