/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity.villager;

import com.destroystokyo.paper.entity.villager.ReputationType;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Reputation {
    private static final ReputationType[] REPUTATION_TYPES = ReputationType.values();
    @NotNull
    private final int[] reputation;

    public Reputation() {
        this(new int[REPUTATION_TYPES.length]);
    }

    Reputation(@NotNull int[] reputation) {
        this.reputation = reputation;
    }

    public Reputation(@NotNull Map<ReputationType, Integer> reputation) {
        this();
        Preconditions.checkNotNull(reputation, (Object)"reputation cannot be null");
        for (Map.Entry<ReputationType, Integer> entry : reputation.entrySet()) {
            this.setReputation(entry.getKey(), entry.getValue());
        }
    }

    public int getReputation(@NotNull ReputationType type) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"the reputation type cannot be null");
        return this.reputation[type.ordinal()];
    }

    public void setReputation(@NotNull ReputationType type, int value) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"the reputation type cannot be null");
        this.reputation[type.ordinal()] = value;
    }
}

