/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.NotNull;

public class EntityRegainHealthEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled;
    private double amount;
    private final RegainReason regainReason;
    private final boolean isFastRegen;

    public EntityRegainHealthEvent(@NotNull Entity entity, double amount, @NotNull RegainReason regainReason) {
        this(entity, amount, regainReason, false);
    }

    public EntityRegainHealthEvent(@NotNull Entity entity, double amount, @NotNull RegainReason regainReason, boolean isFastRegen) {
        super(entity);
        this.amount = amount;
        this.regainReason = regainReason;
        this.isFastRegen = isFastRegen;
    }

    public boolean isFastRegen() {
        return this.isFastRegen;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @NotNull
    public RegainReason getRegainReason() {
        return this.regainReason;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum RegainReason {
        REGEN,
        SATIATED,
        EATING,
        ENDER_CRYSTAL,
        MAGIC,
        MAGIC_REGEN,
        WITHER_SPAWN,
        WITHER,
        CUSTOM;

    }
}

