/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.utils;

import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

public class PaperPluginLogger
extends Logger {
    @NotNull
    public static Logger getLogger(@NotNull PluginDescriptionFile description) {
        Logger logger = new PaperPluginLogger(description);
        if (!LogManager.getLogManager().addLogger(logger)) {
            logger = LogManager.getLogManager().getLogger(description.getPrefix() != null ? description.getPrefix() : description.getName());
        }
        return logger;
    }

    private PaperPluginLogger(@NotNull PluginDescriptionFile description) {
        super(description.getPrefix() != null ? description.getPrefix() : description.getName(), null);
    }

    @Override
    public void setParent(@NotNull Logger parent) {
        if (this.getParent() != null) {
            this.warning("Ignoring attempt to change parent of plugin logger");
        } else {
            this.log(Level.FINE, "Setting plugin logger parent to {0}", parent);
            super.setParent(parent);
        }
    }
}

