/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public final class GS4QueryEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final QueryType queryType;
    private final InetAddress querierAddress;
    private QueryResponse response;

    public GS4QueryEvent(@NotNull QueryType queryType, @NotNull InetAddress querierAddress, @NotNull QueryResponse response) {
        super(true);
        this.queryType = (QueryType)((Object)Preconditions.checkNotNull((Object)((Object)queryType), (Object)"queryType"));
        this.querierAddress = (InetAddress)Preconditions.checkNotNull((Object)querierAddress, (Object)"querierAddress");
        this.response = (QueryResponse)Preconditions.checkNotNull((Object)response, (Object)"response");
    }

    @NotNull
    public QueryType getQueryType() {
        return this.queryType;
    }

    @NotNull
    public InetAddress getQuerierAddress() {
        return this.querierAddress;
    }

    @NotNull
    public QueryResponse getResponse() {
        return this.response;
    }

    public void setResponse(@NotNull QueryResponse response) {
        this.response = (QueryResponse)Preconditions.checkNotNull((Object)response, (Object)"response");
    }

    public String toString() {
        return "GS4QueryEvent{queryType=" + this.queryType + ", querierAddress=" + this.querierAddress + ", response=" + this.response + "}";
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum QueryType {
        BASIC,
        FULL;

    }

    public static final class QueryResponse {
        private final String motd;
        private final String gameVersion;
        private final String map;
        private final int currentPlayers;
        private final int maxPlayers;
        private final String hostname;
        private final int port;
        private final Collection<String> players;
        private final String serverVersion;
        private final Collection<PluginInformation> plugins;

        private QueryResponse(String motd, String gameVersion, String map, int currentPlayers, int maxPlayers, String hostname, int port, Collection<String> players, String serverVersion, Collection<PluginInformation> plugins) {
            this.motd = motd;
            this.gameVersion = gameVersion;
            this.map = map;
            this.currentPlayers = currentPlayers;
            this.maxPlayers = maxPlayers;
            this.hostname = hostname;
            this.port = port;
            this.players = players;
            this.serverVersion = serverVersion;
            this.plugins = plugins;
        }

        @NotNull
        public String getMotd() {
            return this.motd;
        }

        @NotNull
        public String getGameVersion() {
            return this.gameVersion;
        }

        @NotNull
        public String getMap() {
            return this.map;
        }

        public int getCurrentPlayers() {
            return this.currentPlayers;
        }

        public int getMaxPlayers() {
            return this.maxPlayers;
        }

        @NotNull
        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        @NotNull
        public Collection<String> getPlayers() {
            return this.players;
        }

        @NotNull
        public String getServerVersion() {
            return this.serverVersion;
        }

        @NotNull
        public Collection<PluginInformation> getPlugins() {
            return this.plugins;
        }

        @NotNull
        public Builder toBuilder() {
            return QueryResponse.builder().motd(this.getMotd()).gameVersion(this.getGameVersion()).map(this.getMap()).currentPlayers(this.getCurrentPlayers()).maxPlayers(this.getMaxPlayers()).hostname(this.getHostname()).port(this.getPort()).players(this.getPlayers()).serverVersion(this.getServerVersion()).plugins(this.getPlugins());
        }

        @NotNull
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String motd;
            private String gameVersion;
            private String map;
            private String hostname;
            private String serverVersion;
            private int currentPlayers;
            private int maxPlayers;
            private int port;
            private List<String> players = new ArrayList<String>();
            private List<PluginInformation> plugins = new ArrayList<PluginInformation>();

            private Builder() {
            }

            @NotNull
            public Builder motd(@NotNull String motd) {
                this.motd = (String)Preconditions.checkNotNull((Object)motd, (Object)"motd");
                return this;
            }

            @NotNull
            public Builder gameVersion(@NotNull String gameVersion) {
                this.gameVersion = (String)Preconditions.checkNotNull((Object)gameVersion, (Object)"gameVersion");
                return this;
            }

            @NotNull
            public Builder map(@NotNull String map) {
                this.map = (String)Preconditions.checkNotNull((Object)map, (Object)"map");
                return this;
            }

            @NotNull
            public Builder currentPlayers(int currentPlayers) {
                Preconditions.checkArgument((currentPlayers >= 0 ? 1 : 0) != 0, (Object)"currentPlayers cannot be negative");
                this.currentPlayers = currentPlayers;
                return this;
            }

            @NotNull
            public Builder maxPlayers(int maxPlayers) {
                Preconditions.checkArgument((maxPlayers >= 0 ? 1 : 0) != 0, (Object)"maxPlayers cannot be negative");
                this.maxPlayers = maxPlayers;
                return this;
            }

            @NotNull
            public Builder hostname(@NotNull String hostname) {
                this.hostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname");
                return this;
            }

            @NotNull
            public Builder port(int port) {
                Preconditions.checkArgument((port >= 1 && port <= 65535 ? 1 : 0) != 0, (Object)"port must be between 1-65535");
                this.port = port;
                return this;
            }

            @NotNull
            public Builder players(@NotNull Collection<String> players) {
                this.players.addAll((Collection)Preconditions.checkNotNull(players, (Object)"players"));
                return this;
            }

            @NotNull
            public Builder players(String ... players) {
                this.players.addAll(Arrays.asList((String[])Preconditions.checkNotNull((Object)players, (Object)"players")));
                return this;
            }

            @NotNull
            public Builder clearPlayers() {
                this.players.clear();
                return this;
            }

            @NotNull
            public Builder serverVersion(@NotNull String serverVersion) {
                this.serverVersion = (String)Preconditions.checkNotNull((Object)serverVersion, (Object)"serverVersion");
                return this;
            }

            @NotNull
            public Builder plugins(@NotNull Collection<PluginInformation> plugins) {
                this.plugins.addAll((Collection)Preconditions.checkNotNull(plugins, (Object)"plugins"));
                return this;
            }

            @NotNull
            public Builder plugins(PluginInformation ... plugins) {
                this.plugins.addAll(Arrays.asList((PluginInformation[])Preconditions.checkNotNull((Object)plugins, (Object)"plugins")));
                return this;
            }

            @NotNull
            public Builder clearPlugins() {
                this.plugins.clear();
                return this;
            }

            @NotNull
            public QueryResponse build() {
                return new QueryResponse((String)Preconditions.checkNotNull((Object)this.motd, (Object)"motd"), (String)Preconditions.checkNotNull((Object)this.gameVersion, (Object)"gameVersion"), (String)Preconditions.checkNotNull((Object)this.map, (Object)"map"), this.currentPlayers, this.maxPlayers, (String)Preconditions.checkNotNull((Object)this.hostname, (Object)"hostname"), this.port, (Collection<String>)ImmutableList.copyOf(this.players), (String)Preconditions.checkNotNull((Object)this.serverVersion, (Object)"serverVersion"), (Collection<PluginInformation>)ImmutableList.copyOf(this.plugins));
            }
        }

        public static class PluginInformation {
            private String name;
            private String version;

            public PluginInformation(@NotNull String name, @NotNull String version) {
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
                this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
            }

            @NotNull
            public String getName() {
                return this.name;
            }

            public void setName(@NotNull String name) {
                this.name = name;
            }

            public void setVersion(@NotNull String version) {
                this.version = version;
            }

            @NotNull
            public String getVersion() {
                return this.version;
            }

            @NotNull
            public static PluginInformation of(@NotNull String name, @NotNull String version) {
                return new PluginInformation(name, version);
            }
        }
    }
}

