/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.entity;

import java.util.Collections;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityTransformEvent;
import org.jetbrains.annotations.NotNull;

public class EntityZapEvent
extends EntityTransformEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled;
    @NotNull
    private final LightningStrike bolt;

    public EntityZapEvent(@NotNull Entity entity, @NotNull LightningStrike bolt, @NotNull Entity replacementEntity) {
        super(entity, Collections.singletonList(replacementEntity), EntityTransformEvent.TransformReason.LIGHTNING);
        Validate.notNull((Object)bolt);
        Validate.notNull((Object)replacementEntity);
        this.bolt = bolt;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @NotNull
    public LightningStrike getBolt() {
        return this.bolt;
    }

    @NotNull
    public Entity getReplacementEntity() {
        return this.getTransformedEntity();
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

